/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pms.report.saleshistoricalprice;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.scmc.pms.report.saleshistoricalprice.SalHistPriceTransform;

public class SalHistoricalPriceReportHandle
implements IReportDataHandle {
    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        List<QFilter> filters = SalHistoricalPriceReportHandle.getFilters(ctx.getParams());
        for (SrcBlockConf srcBlockConf : blockCollector) {
            String srcEntity = srcBlockConf.getSrcEntity();
            if (!"sm_salorder".equalsIgnoreCase(srcEntity)) continue;
            QFilter dataFs = srcBlockConf.getDataFs();
            if (dataFs == null) {
                dataFs = QFilter.of((String)"1=1", (Object[])new Object[0]);
            }
            for (QFilter filter : filters) {
                dataFs.and(filter);
            }
            srcBlockConf.setDataFs(dataFs);
        }
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        repoColFilter.add("id");
        repoColFilter.add("entryid");
        repoColFilter.add("amountandtax");
        repoColFilter.add("curamountandtax");
        repoColFilter.add("baseqty");
        repoColFilter.add("currency");
        repoColFilter.add("curhistoryprice");
    }

    public void handleBlockDataSelectCols(Set<String> repoColFilter, SrcBlockConf blockConf, ReportDataCtx ctx) {
        String srcEntity = blockConf.getSrcEntity();
        if ("sm_salorder".equals(srcEntity)) {
            Map repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
            repoColFullSrcColMap.putIfAbsent("id", "id");
            repoColFullSrcColMap.putIfAbsent("entryid", "billentry.id");
            repoColFullSrcColMap.putIfAbsent("rowseq", "billentry.seq");
            repoColFullSrcColMap.putIfAbsent("currency", "currency");
            repoColFullSrcColMap.putIfAbsent("amountandtax", "billentry.amountandtax");
            repoColFullSrcColMap.putIfAbsent("baseunit", "billentry.baseunit");
        }
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new SalHistPriceTransform());
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        LinkedList<AbstractReportColumn> showCols = new LinkedList<AbstractReportColumn>();
        AbstractReportColumn rate = null;
        for (AbstractReportColumn col : cols) {
            ReportColumn column = (ReportColumn)col;
            String fieldKey = column.getFieldKey();
            if ("exchangerate".equalsIgnoreCase(fieldKey)) {
                rate = this.buildColumnStyle("exchangerate", 10, col);
                showCols.add(rate);
                continue;
            }
            if ("priceandtax".equalsIgnoreCase(fieldKey)) {
                rate = this.buildColumnStyle("priceandtax", 2, col);
                showCols.add(rate);
                continue;
            }
            if ("qty".equalsIgnoreCase(fieldKey)) {
                rate = this.buildColumnStyle("qty", 4, col);
                showCols.add(rate);
                continue;
            }
            if ("historyprice".equalsIgnoreCase(fieldKey)) {
                rate = this.buildColumnStyle("historyprice", 2, col);
                showCols.add(rate);
                continue;
            }
            if ("material_ref_name".equals(fieldKey)) {
                column.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0", (String)"SalHistoricalPriceReportHandle_0", (String)"scmc-sm-report", (Object[])new Object[0])));
                showCols.add((AbstractReportColumn)column);
                continue;
            }
            HashSet showAllCols = new HashSet(32);
            showAllCols.addAll(ctx.getShowKeyCols());
            showAllCols.addAll(ctx.getShowQtyCols());
            if (!showAllCols.contains(fieldKey)) continue;
            showCols.add(col);
        }
        return showCols;
    }

    private AbstractReportColumn buildColumnStyle(String key, Integer scale, AbstractReportColumn column) {
        ((ReportColumn)column).setNoDisplayScaleZero(false);
        ((ReportColumn)column).setScale(scale.intValue());
        return column;
    }

    public static List<QFilter> getFilters(Map<String, Object> filterInfo) {
        boolean isvirtual;
        DynamicObjectCollection cusColl;
        DynamicObjectCollection biztypeColl;
        DynamicObjectCollection operators;
        DynamicObjectCollection operatorgroups;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DynamicObjectCollection orgList = (DynamicObjectCollection)filterInfo.get("orgfield");
        if (orgList != null && orgList.size() > 0) {
            Object[] orgIds = SalHistoricalPriceReportHandle.getBaseDataPkIds(orgList);
            filters.add(new QFilter("org", "in", (Object)orgIds));
        }
        Date startDate = (Date)filterInfo.get("startdate");
        filters.add(new QFilter("bizdate", ">=", (Object)SalHistoricalPriceReportHandle.getStartOrEndDate(startDate, false)));
        Date endDate = (Date)filterInfo.get("enddate");
        filters.add(new QFilter("bizdate", "<=", (Object)SalHistoricalPriceReportHandle.getStartOrEndDate(endDate, true)));
        DynamicObjectCollection materials = (DynamicObjectCollection)filterInfo.get("materialfield");
        if (materials != null && materials.size() > 0) {
            Object[] materialIdS = SalHistoricalPriceReportHandle.getBaseDataPkIds(materials);
            filters.add(new QFilter("billentry.material.masterid", "in", (Object)materialIdS));
        } else {
            filters.add(QFilter.isNotNull((String)"billentry.material.masterid"));
        }
        DynamicObjectCollection bizdepts = (DynamicObjectCollection)filterInfo.get("deptfield");
        if (bizdepts != null && bizdepts.size() > 0) {
            Object[] bizdeptsIds = SalHistoricalPriceReportHandle.getBaseDataPkIds(bizdepts);
            filters.add(new QFilter("dept", "in", (Object)bizdeptsIds));
        }
        if ((operatorgroups = (DynamicObjectCollection)filterInfo.get("operatorgroupfield")) != null && operatorgroups.size() > 0) {
            Object[] bizoperatorgroupIds = SalHistoricalPriceReportHandle.getBaseDataPkIds(operatorgroups);
            filters.add(new QFilter("operatorgroup", "in", (Object)bizoperatorgroupIds));
        }
        if ((operators = (DynamicObjectCollection)filterInfo.get("operatorfield")) != null && operators.size() > 0) {
            Object[] bizoperatorgroupIds = SalHistoricalPriceReportHandle.getBaseDataPkIds(operators);
            filters.add(new QFilter("operator", "in", (Object)bizoperatorgroupIds));
        }
        if ((biztypeColl = (DynamicObjectCollection)filterInfo.get("biztypefield")) != null && biztypeColl.size() > 0) {
            Object[] biztypes = SalHistoricalPriceReportHandle.getBaseDataPkIds(biztypeColl);
            filters.add(new QFilter("biztype", "in", (Object)biztypes));
        }
        if ((cusColl = (DynamicObjectCollection)filterInfo.get("customerfield")) != null && cusColl.size() > 0) {
            Object[] customers = SalHistoricalPriceReportHandle.getBaseDataPkIds(cusColl);
            filters.add(new QFilter("customer", "in", (Object)customers));
        }
        if (!(isvirtual = ((Boolean)filterInfo.get("virtualfield")).booleanValue())) {
            filters.add(new QFilter("isvirtualbill", "=", (Object)Boolean.FALSE));
        }
        return filters;
    }

    public static Date getStartOrEndDate(Date date, boolean isEnd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (isEnd) {
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
        } else {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
        }
        return cal.getTime();
    }

    private static Object[] getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return null;
        }
        Object[] pkIds = new Object[col.size()];
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds[i] = baseData.getPkValue();
        }
        return pkIds;
    }
}

