/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pms.report.saleshistoricalprice;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.pms.business.helper.OrgHelper;
import kd.scmc.pms.report.helper.MultiOrgHelper;
import kd.scmc.pms.report.helper.SalesHistoricalPriceRptHelper;

public class SalHistoricalPriceReportPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        FilterInfo filterInfo;
        super.afterCreateNewData(e);
        ReportShowParameter showParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        if (showParameter.getReportQueryParam() != null && "1".equals(showParameter.getReportQueryParam().getCustomParam().get("isFormBill")) && !(filterInfo = showParameter.getReportQueryParam().getFilter()).containProp("showkeycols")) {
            String showkeycols = (String)this.getModel().getValue("showkeycols");
            showParameter.getReportQueryParam().getFilter().addFilterItem("showkeycols", (Object)showkeycols, CompareTypeEnum.MULTICOMBOBOXLIKE.getId());
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getView().getControl("orgfield");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit customer = (BasedataEdit)this.getView().getControl("customerfield");
        customer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit material = (BasedataEdit)this.getView().getControl("materialfield");
        material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bizoperator = (BasedataEdit)this.getView().getControl("operatorfield");
        bizoperator.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bizoperatorgroup = (BasedataEdit)this.getView().getControl("operatorgroupfield");
        bizoperatorgroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bizdept = (BasedataEdit)this.getView().getControl("deptfield");
        bizdept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit biztype = (BasedataEdit)this.getView().getControl("biztypefield");
        biztype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        DynamicObjectCollection operateGroup;
        String formId;
        List orgList;
        super.beforeBindData(e);
        DynamicObjectCollection value = (DynamicObjectCollection)this.getModel().getValue("orgfield");
        if ((value == null || value.size() == 0) && (orgList = OrgHelper.getHasPermissionOrg((String)(formId = this.getView().getFormShowParameter().getFormId()), (String)"03")) != null && orgList.size() > 0) {
            long orgId = RequestContext.get().getOrgId();
            if (orgList.contains(orgId)) {
                this.getModel().setValue("orgfield", (Object)new Object[]{orgId});
            } else {
                this.getModel().setValue("orgfield", (Object)new Object[]{orgList.get(0)});
            }
        }
        Object startdate = this.getModel().getValue("startdate");
        Object enddate = this.getModel().getValue("enddate");
        if (startdate == null || enddate == null) {
            Calendar startMonth = Calendar.getInstance();
            startMonth.add(2, -1);
            startMonth.set(5, startMonth.get(5));
            this.getModel().setValue("startdate", (Object)startMonth.getTime());
            this.getModel().setValue("enddate", (Object)TimeServiceHelper.today());
        }
        if ((operateGroup = (DynamicObjectCollection)this.getModel().getValue("operatorgroupfield")) == null || operateGroup.size() == 0) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"operatorfield"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"operatorfield"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObjectCollection org = (DynamicObjectCollection)this.getModel().getValue("orgfield");
        List<Long> listOrgId = null;
        switch (key) {
            case "orgfield": {
                String formId = this.getView().getFormShowParameter().getFormId();
                List orgList = OrgHelper.getHasPermissionOrg((String)formId, (String)OrgHelper.getFisSaleViewType());
                formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)orgList));
                break;
            }
            case "customerfield": {
                if (org == null || org.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalesHistoricalPriceRptPlugin_0", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                listOrgId = MultiOrgHelper.getBaseDataLongIds(this.getView(), "orgfield");
                QFilter bd_customer = MultiOrgHelper.getBaseDataFilter("bd_customer", listOrgId);
                if (bd_customer != null) {
                    formShowParameter.getListFilterParameter().setFilter(bd_customer);
                }
                formShowParameter.setShowApproved(false);
                break;
            }
            case "materialfield": {
                if (org == null || org.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalesHistoricalPriceRptPlugin_0", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                listOrgId = MultiOrgHelper.getBaseDataLongIds(this.getView(), "orgfield");
                QFilter bd_material = MultiOrgHelper.getBaseDataFilter("bd_material", listOrgId);
                if (bd_material != null) {
                    formShowParameter.getListFilterParameter().setFilter(bd_material);
                }
                formShowParameter.setShowApproved(false);
                break;
            }
            case "operatorgroupfield": {
                if (org == null || org.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalesHistoricalPriceRptPlugin_0", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                long userId = UserServiceHelper.getCurrentUserId();
                Object q = null;
                listOrgId = MultiOrgHelper.getBaseDataLongIds(this.getView(), "orgfield");
                QFilter f = MultiOrgHelper.getOrgGrpQfilter(listOrgId);
                formShowParameter.getListFilterParameter().setFilter(f);
                QFilter bd_operatorgroup = MultiOrgHelper.getBaseDataFilter("bd_operatorgroup", listOrgId);
                if (bd_operatorgroup == null) break;
                formShowParameter.getListFilterParameter().setFilter(bd_operatorgroup);
                formShowParameter.setShowApproved(false);
                break;
            }
            case "operatorfield": {
                DynamicObjectCollection operateGroup = (DynamicObjectCollection)this.getModel().getValue("operatorgroupfield");
                if (operateGroup == null || operateGroup.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u3002", (String)"SalesHistoricalPriceRptPlugin_2", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                List<Long> groups = SalHistoricalPriceReportPlugin.getBaseDataPkIds(operateGroup);
                SalHistoricalPriceReportPlugin.getOperatorGroupByUser(groups, formShowParameter);
                break;
            }
            case "deptfield": {
                if (org != null && !org.isEmpty()) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalesHistoricalPriceRptPlugin_0", (String)"scmc-sm-report", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            case "biztypefield": {
                Object value = this.getModel().getValue("pricesourceentityfield");
                if (value != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u4ef7\u683c\u6765\u6e90\u5355\u636e\u201d\u3002", (String)"SalesHistoricalPriceRptPlugin_3", (String)"scmc-sm-report", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        switch (key) {
            case "orgfield": {
                this.getModel().setValue("materialfield", null);
                this.getModel().setValue("customerfield", null);
                this.getModel().setValue("operatorfield", null);
                this.getModel().setValue("operatorgroupfield", null);
                this.getModel().setValue("deptfield", null);
                break;
            }
            case "operatorgroupfield": {
                this.changeOperatorGroup((DynamicObjectCollection)newValue);
                break;
            }
            case "pricesourceentityfield": {
                if (newValue != null) break;
                this.getModel().setValue("biztypefield", null);
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filter = queryParam.getFilter();
        DynamicObjectCollection org = filter.getDynamicObjectCollection("orgfield");
        DynamicObject priceEntity = filter.getDynamicObject("pricesourceentityfield");
        if (org == null || org.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalesHistoricalPriceRptPlugin_0", (String)"scmc-sm-report", (Object[])new Object[0]));
            return false;
        }
        Date startdate = filter.getDate("startdate");
        Date enddate = filter.getDate("enddate");
        if (startdate == null && enddate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u3002", (String)"SalesHistoricalPriceRptPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]));
            return false;
        }
        if (startdate != null && enddate != null && !SalesHistoricalPriceRptHelper.getTimeRange(startdate, enddate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u5e74\u5185\u7684\u65e5\u671f\u8303\u56f4\u3002", (String)"SalesHistoricalPriceRptPlugin_4", (String)"scmc-sm-report", (Object[])new Object[0]));
            return false;
        }
        if (priceEntity == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u4ef7\u683c\u6765\u6e90\u5355\u636e\u201d\u3002", (String)"SalesHistoricalPriceRptPlugin_3", (String)"scmc-sm-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        queryParam.getCustomParam().put("orgfield", filterInfo.getDynamicObjectCollection("orgfield"));
        queryParam.getCustomParam().put("startdate", filterInfo.getDate("startdate"));
        queryParam.getCustomParam().put("enddate", filterInfo.getDate("enddate"));
        queryParam.getCustomParam().put("materialfield", filterInfo.getDynamicObjectCollection("materialfield"));
        queryParam.getCustomParam().put("deptfield", filterInfo.getDynamicObjectCollection("deptfield"));
        queryParam.getCustomParam().put("operatorgroupfield", filterInfo.getDynamicObjectCollection("operatorgroupfield"));
        queryParam.getCustomParam().put("pricesourceentityfield", filterInfo.getDynamicObject("pricesourceentityfield"));
        queryParam.getCustomParam().put("biztypefield", filterInfo.getDynamicObjectCollection("biztypefield"));
        queryParam.getCustomParam().put("operatorfield", filterInfo.getDynamicObjectCollection("operatorfield"));
        queryParam.getCustomParam().put("customerfield", filterInfo.getDynamicObjectCollection("customerfield"));
        queryParam.getCustomParam().put("virtualfield", filterInfo.getBoolean("virtualfield"));
    }

    private void changeOperatorGroup(DynamicObjectCollection operatorGroup) {
        if (operatorGroup == null || operatorGroup.size() == 0) {
            this.getModel().setValue("operatorfield", null);
            this.getView().setEnable(Boolean.FALSE, new String[]{"operatorfield"});
        } else {
            this.getModel().setValue("operatorfield", null);
            this.getView().setEnable(Boolean.TRUE, new String[]{"operatorfield"});
        }
    }

    private static List<Long> getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return null;
        }
        ArrayList<Long> pkIds = new ArrayList<Long>(col.size());
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds.add((Long)baseData.get("fbasedataid_id"));
        }
        return pkIds;
    }

    private static void getOperatorGroupByUser(List<Long> list, ListShowParameter showParameter) {
        if (list != null && list.size() > 0) {
            QFilter filter = new QFilter("operatorgrpid", "in", list);
            filter.and(new QFilter("invalid", "=", (Object)Boolean.FALSE));
            showParameter.getListFilterParameter().setFilter(filter);
        } else {
            QFilter filter = QFilter.of((String)"1!=1", (Object[])new Object[0]);
            showParameter.getListFilterParameter().setFilter(filter);
        }
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowDatas, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowDatas, queryParam);
        if (rowDatas.isEmpty()) {
            return;
        }
        HashSet<Long> currencyIds = new HashSet<Long>(10);
        for (DynamicObject row : rowDatas) {
            Object settlecurrency = row.get("settlecurrency");
            if (settlecurrency == null) continue;
            currencyIds.add(((DynamicObject)settlecurrency).getLong("id"));
        }
        QFilter pkFilter = new QFilter("id", "in", currencyIds);
        Map load = BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (String)"id,priceprecision", (QFilter[])new QFilter[]{pkFilter});
        HashMap currencyAndPricePrecision = new HashMap(10);
        if (load != null && !load.isEmpty()) {
            load.values().forEach(baseData -> currencyAndPricePrecision.put(baseData.getLong("id"), baseData.getInt("priceprecision")));
        }
        for (DynamicObject row : rowDatas) {
            Long currencyId;
            Integer integer;
            int precision = 4;
            Object settlecurrency = row.get("settlecurrency");
            Object discountrate = row.get("discountrate");
            if (discountrate == null || BigDecimal.ZERO.compareTo((BigDecimal)discountrate) == 0) continue;
            if (settlecurrency instanceof DynamicObject && (integer = (Integer)currencyAndPricePrecision.get(currencyId = Long.valueOf(((DynamicObject)settlecurrency).getLong("id")))) != null) {
                precision = integer;
            }
            row.set("discountrate", (Object)((BigDecimal)discountrate).setScale(precision, RoundingMode.HALF_UP));
        }
    }
}

