/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report;

import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.sm.business.helper.OrgHelper;

public class SalCustomerSynRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit customer;
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getView().getControl("orgfield");
        if (org != null) {
            org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((customer = (BasedataEdit)this.getView().getControl("customerfield")) != null) {
            customer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        List orgList;
        super.beforeBindData(e);
        if (this.getModel().getValue("orgfield") == null && (orgList = OrgHelper.getHasPermissionOrg((String)"sm_customersynrpt", (String)"03")) != null && orgList.size() > 0) {
            long orgId = RequestContext.get().getOrgId();
            if (orgList.contains(orgId)) {
                this.getModel().setValue("orgfield", (Object)orgId);
            } else {
                this.getModel().setValue("orgfield", orgList.get(0));
            }
        }
        Object startdate = this.getModel().getValue("startdate");
        Object enddate = this.getModel().getValue("enddate");
        if (startdate == null && enddate == null) {
            this.setdefaultDate();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
        switch (key) {
            case "orgfield": {
                List orgList = OrgHelper.getHasPermissionOrg((String)"sm_customersynrpt", (String)OrgHelper.getFisSaleViewType());
                formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)orgList));
                break;
            }
            case "customerfield": {
                DynamicObject value = (DynamicObject)this.getModel().getValue("orgfield");
                if (value == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalCustomerSynRptPlugin_0", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                QFilter customerFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
                QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_customer", (Long)((Long)value.getPkValue()));
                customerFilter.and(filter);
                formShowParameter.getListFilterParameter().setFilter(customerFilter);
                formShowParameter.setShowApproved(false);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        switch (key) {
            case "orgfield": {
                if (newValue == oldValue) break;
                this.getModel().setValue("customerfield", null);
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        Date startdate = filter.getDate("startdate");
        Date enddate = filter.getDate("enddate");
        DynamicObject org = filter.getDynamicObject("orgfield");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalOrderBillRptPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]));
            return false;
        }
        if (startdate != null && enddate != null) {
            return true;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u3002", (String)"SalOrderBillRptPlugin_3", (String)"scmc-sm-report", (Object[])new Object[0]));
        return false;
    }

    private void setdefaultDate() {
        IDataModel model = this.getModel();
        Calendar cal = Calendar.getInstance();
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        model.setValue("startdate", (Object)cal.getTime());
        model.setValue("enddate", (Object)cal.getTime());
    }
}

