/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.sm.report.helper.AbstractSalCrossProfitLogic;
import kd.scmc.sm.report.helper.CommonLogic;
import kd.scmc.sm.report.helper.DeductLogic;
import kd.scmc.sm.report.helper.SalGrossProfitRptHelper;

public class SalGrossProfitRptQuery
extends AbstractReportListDataPlugin {
    private static final Log log = LogFactory.getLog(SalGrossProfitRptQuery.class);

    public DataSet query(ReportQueryParam queryParam, Object arg1) throws Throwable {
        AbstractSalCrossProfitLogic logic;
        FilterInfo filterInfo = queryParam.getFilter();
        DataSet matDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_materialgroupdetail", (String)this.getMatSelectors(), (QFilter[])new QFilter[]{this.getMatFilters(filterInfo)}, null);
        DataSet invDataSet = this.queryInvDataSet(filterInfo);
        if (invDataSet == null) {
            return null;
        }
        HashSet<Long> imEntryIds = new HashSet<Long>();
        try (DataSet invDataSetCopy = invDataSet.copy();){
            for (Row row : invDataSetCopy) {
                Long imEntryId = row.getLong("inventryid");
                imEntryIds.add(imEntryId);
            }
        }
        log.info("\u53d6\u5f97\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5f00\u59cb");
        QFilter filter = new QFilter("entry.bizbillentryid", "in", imEntryIds);
        filter.and(new QFilter("costaccount.ismainaccount", "=", (Object)Boolean.TRUE));
        filter.and(new QFilter("issplitcreate", "=", (Object)Boolean.FALSE));
        DataSet costDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord_subentity", (String)this.getCostSelectors(), (QFilter[])new QFilter[]{filter}, null);
        log.info("\u53d6\u5f97\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u7ed3\u675f");
        JoinDataSet join0 = invDataSet.join(matDataSet, JoinType.INNER);
        DataSet result0 = join0.on("material", "material").select(SalGrossProfitRptHelper.getSelectFieldAdd(new String[0]), new String[]{"group"}).finish();
        log.info("\u51fa\u5e93\u5173\u8054\u6210\u672c\u8bb0\u5f55\u5f00\u59cb");
        JoinDataSet join = result0.join(costDataSet, JoinType.LEFT);
        DataSet result = join.on("inventryid", "costentryid").select(SalGrossProfitRptHelper.getSelectFieldAdd("group"), new String[]{"unitcost", "actualcost"}).finish();
        log.info("\u51fa\u5e93\u5173\u8054\u6210\u672c\u8bb0\u5f55\u7ed3\u675f");
        boolean flag = filterInfo.getBoolean("isinclude");
        if (flag) {
            logic = new DeductLogic();
            result = logic.handleDataSet(result, filterInfo);
        } else {
            logic = new CommonLogic();
            result = logic.handleDataSet(result, filterInfo);
        }
        result = result.select(this.getShowSelectors());
        List<String> props = this.getGroupByProps(filterInfo);
        GroupbyDataSet groupby = result.groupBy(props.toArray(new String[props.size()]));
        groupby.sum("baseqty");
        groupby.sum("salamount");
        groupby.sum("taxsalamount");
        groupby.sum("actualcost");
        groupby.sum("salgrossprofit");
        groupby.sum("amount");
        groupby.sum("localverifyamt");
        groupby.sum("busamount");
        result = groupby.finish();
        props.add("baseqty");
        props.add("salamount");
        props.add("taxsalamount");
        props.add("actualcost");
        props.add("salgrossprofit");
        props.add("(CASE baseqty WHEN Cast(0 as BigDecimal) THEN 0 ELSE salamount / baseqty  END)price");
        props.add("(CASE baseqty WHEN Cast(0 as BigDecimal) THEN 0 ELSE taxsalamount / baseqty END) taxprice");
        props.add("(CASE baseqty WHEN Cast(0 as BigDecimal) THEN 0 ELSE actualcost/baseqty END) unitcost");
        props.add("(CASE baseqty WHEN Cast(0 as BigDecimal) THEN 0 ELSE salgrossprofit/baseqty END) unitgrossprofit");
        props.add("amount");
        props.add("localverifyamt");
        props.add("busamount");
        result = result.select(props.toArray(new String[props.size()]));
        result = result.where("salamount <> 0 or actualcost <> 0");
        if (queryParam.getFilter() != null && queryParam.getFilter().getValue("groupby") != null && queryParam.getFilter().getValue("groupby").toString().contains("material")) {
            return result.orderBy(new String[]{"material"});
        }
        return result;
    }

    private List<String> getGroupByProps(FilterInfo filterInfo) {
        String[] values;
        ArrayList<String> groupList = new ArrayList<String>();
        groupList.add("org");
        groupList.add("baseunit");
        groupList.add("currency");
        String value = filterInfo.getString("groupby");
        for (String string : values = value.split(",")) {
            if (!StringUtils.isNotEmpty((String)string) || string.equals("acc")) continue;
            groupList.add(string);
        }
        return groupList;
    }

    private String getInvSelectors() {
        List<String> selectors = Arrays.asList("bizorg salorg", "biztime", "exchangerate", "customer", "bizoperator", "currency", "billentry.id inventryid", "billentry.entrysettleorg org", "billentry.material.masterid material", "billentry.auxpty auxpty", "billentry.baseunit baseunit", "billentry.baseqty baseqty", "billentry.amount amount", "billentry.taxrate taxrate");
        return String.join((CharSequence)",", selectors);
    }

    private String getMatSelectors() {
        return "group,material";
    }

    private String getCostSelectors() {
        List<String> selectors = Arrays.asList("entry.bizbillentryid costentryid", "entry.unitactualcost unitcost", "entry.actualcost actualcost");
        return String.join((CharSequence)",", selectors);
    }

    private DataSet queryInvDataSet(FilterInfo filterInfo) {
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_saloutbill", (String)this.getInvSelectors(), (QFilter[])this.getInvFilters(filterInfo), null);
    }

    private String[] getShowSelectors() {
        return new String[]{"org", "salorg", "customer", "bizoperator", "group", "material", "auxpty", "baseunit", "currency", "baseqty", "price", "price*(1 + taxrate/100) taxprice", "amount+localverifyamt+busamount salamount", "amount amount", "localverifyamt localverifyamt", "busamount busamount", "(amount+ localverifyamt + busamount)*(1 + taxrate/100) taxsalamount", "unitcost", "actualcost", "price - unitcost unitgrossprofit", "(price - unitcost) * baseqty salgrossprofit"};
    }

    private QFilter[] getInvFilters(FilterInfo filterInfo) {
        QFilter filter = SalGrossProfitRptHelper.getDateFilter(filterInfo, "biztime", "invdate_startdate", "invdate_enddate");
        String value = filterInfo.getString("radiogroup");
        if ("1".equals(value)) {
            this.setFilter(filterInfo, filter, "billentry.entrysettleorg_f");
        } else {
            this.setFilter(filterInfo, filter, "bizorg_f");
        }
        for (String prop : this.getCommonProp()) {
            this.setFilter(filterInfo, filter, prop);
        }
        DynamicObjectCollection datas = filterInfo.getDynamicObjectCollection("material_f");
        if (datas != null && datas.size() > 0) {
            ArrayList<Object> pks = new ArrayList<Object>();
            for (DynamicObject data : datas) {
                pks.add(data.get("id"));
            }
            filter.and(new QFilter("billentry.material.masterid", "in", (Object)pks.toArray()));
        }
        filter.and(new QFilter("billstatus", "=", (Object)"C"));
        filter.and(new QFilter("billentry.logisticsbill", "=", (Object)Boolean.FALSE));
        filter.and(new QFilter("invscheme.number", "not in", (Object)new String[]{"211", "2111"}));
        return new QFilter[]{filter};
    }

    private QFilter setFilter(FilterInfo filterInfo, QFilter filter, String prop) {
        DynamicObjectCollection values = filterInfo.getDynamicObjectCollection(prop.substring(prop.indexOf(46) + 1));
        if (values != null && values.size() > 0) {
            ArrayList<Object> pks = new ArrayList<Object>();
            for (DynamicObject data : values) {
                pks.add(data.get("id"));
            }
            return filter.and(new QFilter(prop.substring(0, prop.lastIndexOf(95)), "in", (Object)pks.toArray()));
        }
        return filter;
    }

    private QFilter getMatFilters(FilterInfo filterInfo) {
        QFilter filter = new QFilter("standard", "=", filterInfo.getDynamicObject("matstandard").getPkValue());
        DynamicObjectCollection matGroup = filterInfo.getDynamicObjectCollection("matroup");
        if (matGroup != null && matGroup.size() > 0) {
            ArrayList<Object> pks = new ArrayList<Object>();
            for (DynamicObject data : matGroup) {
                pks.add(data.get("id"));
            }
            filter.and(new QFilter("group", "in", pks));
        }
        return filter;
    }

    private String[] getCommonProp() {
        return new String[]{"customer_f", "bizoperator_f", "biztype_f"};
    }
}

