/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report;

import java.math.BigDecimal;
import java.sql.Date;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.input.OrmInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.Grouper;
import kd.bos.algox.JobSession;
import kd.bos.algox.JoinDataSetX;
import kd.bos.algox.MapFunction;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.sm.consts.SalGrossProfitRptConst;
import kd.scmc.sm.report.consts.SalProfitKeyConst;
import kd.scmc.sm.report.consts.SalProfitMidResultConst;
import kd.scmc.sm.report.function.SumReduceGroupFunction;
import kd.scmc.sm.report.helper.CommonLogicX;
import kd.scmc.sm.report.helper.DeductLogicX;
import kd.scmc.sm.report.helper.SalGrossProfitRptHelper;
import kd.scmc.sm.report.helper.SalGrossProfitXQueryHelper;
import kd.scmc.sm.report.pojo.DivideBatchInfo;
import kd.scmc.sm.report.salgrossprofit.SalGrossProfitCalUnitFunction;
import kd.scmc.sm.report.salgrossprofit.SalGrossProfitCalcAmountFunction;
import kd.scmc.sm.report.salgrossprofit.SalGrossProfitSumRowFunction;
import kd.scmc.sm.report.salgrossprofit.SalRowSumPlan;
import kd.scmc.sm.report.salgrossprofit.SalRptAddSumRowFunc;
import kd.scmc.sm.report.thread.SalGrossProfitRptTaskRunnable;
import kd.scmc.sm.report.tpl.AbstractSalRptTaskQuery;

public class SalGrossProfitRptXQuery
extends AbstractSalRptTaskQuery {
    private static final Log log = LogFactory.getLog(SalGrossProfitRptXQuery.class);

    @Override
    public String getMidResultEntity() {
        return "sm_salprofitmidresult";
    }

    @Override
    public String getReportView() {
        return "sm_salgrossprofitrpt";
    }

    @Override
    public String getResultSelector() {
        return SalGrossProfitRptHelper.getResultSelector();
    }

    @Override
    public String getResultSort(ReportQueryParam queryParam) {
        String orderBy = "";
        if (queryParam.getFilter() != null && queryParam.getFilter().getValue("groupby") != null && queryParam.getFilter().getValue("groupby").toString().contains("material")) {
            orderBy = "material";
        }
        return orderBy;
    }

    @Override
    protected List<String> getConditionKey(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        ArrayList<String> conditionKeys = new ArrayList<String>(16);
        if ("1".equals(filterInfo.getString("radiogroup"))) {
            conditionKeys.add("entrysettleorg_f");
        } else {
            conditionKeys.add("bizorg_f");
        }
        conditionKeys.add("invdate_startdate");
        conditionKeys.add("invdate_enddate");
        conditionKeys.add("ardate_startdate");
        conditionKeys.add("ardate_enddate");
        conditionKeys.add("biztype_f");
        conditionKeys.add("material_f");
        conditionKeys.add("customer_f");
        conditionKeys.add("bizoperator_f");
        conditionKeys.add("matstandard");
        conditionKeys.add("matroup");
        conditionKeys.add("isinclude");
        conditionKeys.add("groupby");
        return conditionKeys;
    }

    @Override
    public String getTaskRunningClass() {
        return "kd.scmc.sm.report.thread.SalGrossProfitRptTaskRunnable";
    }

    @Override
    public SalGrossProfitRptTaskRunnable initRunnable(ReportQueryParam queryParam, DynamicObject reportTask, Object argObj) {
        SalGrossProfitRptTaskRunnable taskRunnable = (SalGrossProfitRptTaskRunnable)super.initRunnable(queryParam, reportTask, argObj);
        Object isUseSQL = queryParam.getCustomParam().get("isUseSQL");
        if (isUseSQL != null && "true".equals(isUseSQL)) {
            taskRunnable.setUseSQL(true);
        }
        if (argObj != null) {
            taskRunnable.setSaloutIdList((List)argObj);
        }
        return taskRunnable;
    }

    @Override
    public DataSet queryResult(ReportQueryParam queryParam, Object arg1) throws Throwable {
        FilterInfo filterInfo = queryParam.getFilter();
        Long batchNum = filterInfo.getLong("batchnum");
        if (batchNum == null || Long.valueOf("0").equals(batchNum)) {
            batchNum = Long.valueOf("9999999999999");
        }
        log.info("batchNumber init ==" + batchNum);
        java.util.Date startDate = filterInfo.getDate("invdate_startdate");
        java.util.Date endDate = filterInfo.getDate("invdate_enddate");
        Instant instant = endDate.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        LocalDate compareDate = localDateTime.toLocalDate().minusMonths(1L);
        if (startDate.before(Date.valueOf(compareDate))) {
            log.info("SalGrossProfitRptXQuery search has more periods");
            this.calibraBatchNum(queryParam, batchNum);
            this.excuteTask(queryParam, null);
            return this.getEmptyResult();
        }
        QFilter[] dateFilters = SalGrossProfitRptHelper.getDateFilters(filterInfo, "biztime", "invdate_startdate", "invdate_enddate");
        QFilter dateAllFilter = dateFilters[0];
        for (int i = 1; i < dateFilters.length; ++i) {
            dateAllFilter.or(dateFilters[i]);
        }
        List<Long> saloutIdList = SalGrossProfitRptXQuery.searchSaloutList(queryParam, dateAllFilter);
        log.info("SalGrossProfitRptXQuery search saloutIdList estimate size=" + saloutIdList.size());
        log.info("go batchNumber==" + batchNum);
        if (saloutIdList.size() == 0) {
            log.info("saloutIdList has not records");
            return this.getEmptyResult();
        }
        if ((long)saloutIdList.size() <= batchNum) {
            log.info("goto direct search");
            log.info("saloutIdList.size =" + saloutIdList.size());
            boolean returnForecast = this.analysisData(queryParam, saloutIdList);
            if (returnForecast) {
                log.info("goto forecast result");
                this.calibraBatchNum(queryParam, batchNum);
                this.excuteTask(queryParam, null);
                return this.getEmptyResult();
            }
            log.info("saloutIdList has only one batch");
            DataSet result = SalGrossProfitRptXQuery.searchTotolProfit(queryParam, saloutIdList, false);
            return result;
        }
        log.info("saloutIdList has only > one batch");
        this.calibraBatchNum(queryParam, batchNum);
        this.excuteTask(queryParam, saloutIdList);
        return this.getEmptyResult();
    }

    public static List<Long> searchSaloutList(ReportQueryParam queryParam, QFilter dateFilter) {
        JobSession salOutBillSession = AlgoX.createSession((String)"SalGrossProfitSalOutQuery");
        SalGrossProfitXQueryHelper querysalOutExec = new SalGrossProfitXQueryHelper(salOutBillSession);
        DataSetX saloutDataSetX = querysalOutExec.querySalOutDataSet(queryParam, dateFilter);
        DataSetOutput saloutBillOutPut = new DataSetOutput(saloutDataSetX.getRowMeta());
        String saloutBillOutPutID = saloutBillOutPut.getId();
        saloutDataSetX.output((Output)saloutBillOutPut);
        salOutBillSession.commit(3600, TimeUnit.SECONDS);
        ArrayList<Long> saloutIdList = new ArrayList<Long>();
        try (DataSet saloutDataSet = salOutBillSession.readDataSet(saloutBillOutPutID).orderBy(new String[]{"org", "biztime"});){
            for (Row row : saloutDataSet) {
                Long saloutBillID = row.getLong("id");
                if (saloutIdList.contains(saloutBillID)) continue;
                saloutIdList.add(saloutBillID);
            }
        }
        return saloutIdList;
    }

    public static DataSet searchTotolProfit(ReportQueryParam queryParam, List<Long> saloutIdList, boolean isPart) throws Exception {
        log.info("saloutbill estimate size ===" + saloutIdList.size());
        JobSession materialSession = AlgoX.createSession((String)"SalGrossProfitRptXQuery");
        SalGrossProfitXQueryHelper queryMaterialExec = new SalGrossProfitXQueryHelper(materialSession);
        DataSetX materialGroupX = queryMaterialExec.queryMaterialGroup(queryParam);
        DataSetX saloutEntryDataSetX = queryMaterialExec.querySalOutEntryDataSet(queryParam, saloutIdList);
        JoinDataSetX saloutJoinMaterialDataSetX = saloutEntryDataSetX.join(materialGroupX).on("material", "material").select(SalGrossProfitRptHelper.getSelectFieldAdd(new String[0]), new String[]{"group"});
        DataSetOutput output = new DataSetOutput(saloutJoinMaterialDataSetX.getRowMeta());
        String outPutId = output.getId();
        saloutJoinMaterialDataSetX.output((Output)output);
        materialSession.commit(3600, TimeUnit.SECONDS);
        ArrayList<Long> imEntryIds = new ArrayList<Long>();
        HashSet<Long> imIds = new HashSet<Long>();
        try (DataSet saloutJoinMaterialDataSet = materialSession.readDataSet(outPutId);){
            Iterator iterator;
            DivideBatchInfo singleBatchInfo = new DivideBatchInfo(saloutJoinMaterialDataSet.getRowMeta());
            for (Row row : saloutJoinMaterialDataSet) {
                Long imEntryId = row.getLong("inventryid");
                singleBatchInfo.getImEntryIds().add(imEntryId);
                Long imId = row.getLong("id");
                singleBatchInfo.getImIds().add(imId);
                imIds.add(imId);
                imEntryIds.add(imEntryId);
                Long settleOrg = row.getLong("org");
                Set idInOrgs = singleBatchInfo.getOrgToIDs().computeIfAbsent(settleOrg, key -> new HashSet());
                idInOrgs.add(imId);
                int size = row.size();
                Object[] rowResult = new Object[size];
                for (int i = 0; i < size; ++i) {
                    rowResult[i] = row.get(i);
                }
                singleBatchInfo.getRowList().add(rowResult);
            }
            if (imEntryIds.size() == 0) {
                log.info("searchTotolProfit search saloutJoinMaterial has not records");
                iterator = QueryServiceHelper.queryDataSet((String)"AbstractSalReportXQuery", (String)"sm_salprofitmidresult", (String)SalGrossProfitRptHelper.getResultSelector(), (QFilter[])new QFilter[]{QFilter.of((String)"1=-1", (Object[])new Object[0])}, null);
                return iterator;
            }
            log.info("searchTotolProfit saloutJoinMaterial size ===" + imEntryIds.size());
            log.info("searchTotolProfit saloutbill size ===" + imIds.size());
            iterator = SalGrossProfitRptXQuery.searchProfitRecs(queryParam, singleBatchInfo, isPart);
            return iterator;
        }
    }

    public static DataSet searchProfitRecs(ReportQueryParam queryParam, DivideBatchInfo singleBatchInfo, boolean isPart) throws Exception {
        Algo algo = Algo.create((String)"SalGrossProfitRptXQuery");
        DataSet saloutJoinMaterialDataSet = algo.createDataSet(singleBatchInfo.getRowList().iterator(), singleBatchInfo.getRowMeta());
        List<Long> imEntryIds = singleBatchInfo.getImEntryIds();
        Set<Long> imIds = singleBatchInfo.getImIds();
        Map<Long, Set<Long>> orgToIDs = singleBatchInfo.getOrgToIDs();
        log.info("\u53d6\u5f97\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5f00\u59cb");
        JobSession costSession = AlgoX.createSession((String)"SalGrossProfitRptXQuery");
        SalGrossProfitXQueryHelper queryCostExec = new SalGrossProfitXQueryHelper(costSession);
        DataSetX costDataSetX = queryCostExec.queryCostDataSet(imEntryIds, imIds);
        DataSetOutput costOutput = new DataSetOutput(costDataSetX.getRowMeta());
        String costOutPutId = costOutput.getId();
        costDataSetX.output((Output)costOutput);
        costSession.commit(3600, TimeUnit.SECONDS);
        DataSet costDataSet = costSession.readDataSet(costOutPutId);
        log.info("\u53d6\u5f97\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u7ed3\u675f");
        log.info("\u9500\u552e\u51fa\u5e93\u5173\u8054\u6210\u672c\u8bb0\u5f55\u5f00\u59cb");
        JoinDataSet join = saloutJoinMaterialDataSet.join(costDataSet, JoinType.LEFT);
        DataSet result = join.on("inventryid", "costentryid").select(SalGrossProfitRptHelper.getSelectFieldAdd("group"), new String[]{"unitcost", "actualcost"}).finish();
        log.info("\u9500\u552e\u51fa\u5e93\u5173\u8054\u6210\u672c\u8bb0\u5f55\u7ed3\u675f");
        boolean flag = queryParam.getFilter().getBoolean("isinclude");
        if (flag) {
            DeductLogicX logicX = new DeductLogicX();
            result = logicX.handleDataSet(imEntryIds, imIds, orgToIDs, result, queryParam.getFilter());
        } else {
            CommonLogicX logicX = new CommonLogicX();
            result = logicX.handleDataSet(imEntryIds, imIds, orgToIDs, result, queryParam.getFilter());
        }
        if (queryParam.getCustomParam().get(SalProfitKeyConst.ISGROUP) != null && !((Boolean)queryParam.getCustomParam().get(SalProfitKeyConst.ISGROUP)).booleanValue()) {
            return result;
        }
        return SalGrossProfitRptXQuery.buildResult(queryParam, result, isPart);
    }

    private static DataSet buildResult(ReportQueryParam queryParam, DataSet result, boolean isPart) {
        log.info("\u6784\u5efa\u5c55\u793a\u5b57\u6bb5\u5f00\u59cb");
        DataSetInput dataSetInput = new DataSetInput(result);
        JobSession buildSession = AlgoX.createSession((String)"SalGrossProfitRptXQFinal");
        DataSetX resultX = buildSession.fromInput((Input)dataSetInput);
        resultX = resultX.select(SalGrossProfitRptXQuery.getShowSelectors(""));
        ArrayList union_Fields = new ArrayList();
        ArrayList union_values = new ArrayList();
        SalGrossProfitRptConst.CALC_FIELDS.forEach(s -> {
            Field newField = new Field(s, (DataType)DataType.BigDecimalType);
            union_Fields.add(newField);
            union_values.add(BigDecimal.ZERO);
        });
        resultX = resultX.addFields(union_Fields.toArray(new Field[union_Fields.size()]), union_values.toArray());
        Map currencyMap = BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (String)"id, priceprecision, amtprecision", (QFilter[])new QFilter[]{QFilter.of((String)"1=1", (Object[])new Object[0])});
        resultX = resultX.map((MapFunction)new SalGrossProfitCalcAmountFunction(currencyMap));
        log.info("\u67e5\u8be2\u5c55\u793a\u5b57\u6bb50");
        List<String> props = SalGrossProfitRptXQuery.getGroupByProps(queryParam.getFilter(), false);
        Grouper groupby = resultX.groupBy(props.toArray(new String[props.size()]));
        Field[] allFields = resultX.getRowMeta().getFields();
        List<String> sumFields = SalGrossProfitRptHelper.getSumFields();
        int[] indexKeyTarget = new int[props.size()];
        for (int i = 0; i < indexKeyTarget.length; ++i) {
            indexKeyTarget[i] = i;
        }
        int[] indexSumTarget = new int[sumFields.size()];
        for (int i = 0; i < indexSumTarget.length; ++i) {
            indexSumTarget[i] = i + indexKeyTarget.length;
        }
        int[] indexKeySource = new int[props.size()];
        block4: for (int i = 0; i < props.size(); ++i) {
            for (int j = 0; j < allFields.length; ++j) {
                if (!props.get(i).equals(allFields[j].getName())) continue;
                indexKeySource[i] = j;
                continue block4;
            }
        }
        int[] indexSumSource = new int[sumFields.size()];
        block6: for (int i = 0; i < sumFields.size(); ++i) {
            for (int j = 0; j < allFields.length; ++j) {
                if (!sumFields.get(i).equals(allFields[j].getName())) continue;
                indexSumSource[i] = j;
                continue block6;
            }
        }
        ArrayList<String> sumAllFieldNames = new ArrayList<String>();
        sumAllFieldNames.addAll(props);
        sumAllFieldNames.addAll(sumFields);
        ArrayList<Field> sumAllFields = new ArrayList<Field>();
        block8: for (int i = 0; i < sumAllFieldNames.size(); ++i) {
            for (int j = 0; j < allFields.length; ++j) {
                if (!((String)sumAllFieldNames.get(i)).equals(allFields[j].getName())) continue;
                sumAllFields.add(allFields[j]);
                continue block8;
            }
        }
        RowMeta sumRowMeta = new RowMeta(sumAllFields.toArray(new Field[sumAllFields.size()]));
        resultX = groupby.reduceGroup((GroupReduceFunction)new SumReduceGroupFunction(sumRowMeta, indexKeyTarget, indexSumTarget, indexKeySource, indexSumSource));
        if (!isPart) {
            RowMeta rowMeta = resultX.getRowMeta();
            ArrayList replenish_fields = new ArrayList();
            ArrayList replenish_values = new ArrayList();
            SalProfitMidResultConst.REPLENISH_FIELDS.forEach(f -> {
                if (!SalGrossProfitXQueryHelper.isExistField(f, rowMeta)) {
                    Field field = new Field(f, (DataType)DataType.BigDecimalType, false);
                    replenish_fields.add(field);
                    replenish_values.add(BigDecimal.ZERO);
                }
            });
            if (replenish_fields.size() > 0) {
                resultX = resultX.addFields(replenish_fields.toArray(new Field[replenish_values.size()]), replenish_values.toArray());
            }
            resultX = resultX.map((MapFunction)new SalGrossProfitCalUnitFunction());
            if (queryParam.getFilter() != null && queryParam.getFilter().getValue("groupby") != null && queryParam.getFilter().getValue("groupby").toString().contains("material")) {
                log.info("\u67e5\u8be2\u5c55\u793a\u5b57\u6bb5");
                resultX = resultX.orderBy(new String[]{"material"});
            }
            resultX = resultX.addFields(new Field[]{new Field("linetype", (DataType)DataType.StringType)}, new Object[]{""});
            String text = ResManager.loadKDString((String)"\u603b\u8ba1\u884c", (String)"AbstractSalRptTaskQuery_0", (String)"scmc-sm-report", (Object[])new Object[0]);
            SalRowSumPlan rowSumPlan = new SalRowSumPlan(text, null, sumFields);
            SalRptAddSumRowFunc sumFunc = new SalRptAddSumRowFunc(resultX.getRowMeta(), rowSumPlan);
            resultX = resultX.reduceGroup((GroupReduceFunction)sumFunc);
            int typeIdx = resultX.getRowMeta().getFieldIndex("linetype", false);
            resultX = resultX.map((MapFunction)new SalGrossProfitSumRowFunction(typeIdx));
        }
        DataSetOutput resultOutput = new DataSetOutput(resultX.getRowMeta());
        String resultOutputId = resultOutput.getId();
        resultX.output((Output)resultOutput);
        buildSession.commit(3600, TimeUnit.SECONDS);
        result = buildSession.readDataSet(resultOutputId);
        return result;
    }

    public static DataSet buildTotalResult4Task(Long reportTaskID, ReportQueryParam queryParam) {
        JobSession midResultSession = AlgoX.createSession((String)"SalGrossProfitRptXQuery");
        OrmInput midResultInput = new OrmInput("SalGrossProfitRptXQuery", "sm_salprofitmidresult", SalGrossProfitRptHelper.getResultSelector(), new QFilter[]{new QFilter("reporttask", "=", (Object)reportTaskID)});
        DataSetX midResultX = midResultSession.fromInput((Input)midResultInput);
        List<String> props = SalGrossProfitRptXQuery.getGroupByProps(queryParam.getFilter(), false);
        Grouper groupby = midResultX.groupBy(props.toArray(new String[props.size()]));
        Field[] allFields = midResultX.getRowMeta().getFields();
        List<String> sumFields = SalGrossProfitRptHelper.getSumFields();
        int[] indexKeyTarget = new int[props.size()];
        for (int i = 0; i < indexKeyTarget.length; ++i) {
            indexKeyTarget[i] = i;
        }
        int[] indexSumTarget = new int[sumFields.size()];
        for (int i = 0; i < indexSumTarget.length; ++i) {
            indexSumTarget[i] = i + indexKeyTarget.length;
        }
        int[] indexKeySource = new int[props.size()];
        block4: for (int i = 0; i < props.size(); ++i) {
            for (int j = 0; j < allFields.length; ++j) {
                if (!props.get(i).equals(allFields[j].getName())) continue;
                indexKeySource[i] = j;
                continue block4;
            }
        }
        int[] indexSumSource = new int[sumFields.size()];
        block6: for (int i = 0; i < sumFields.size(); ++i) {
            for (int j = 0; j < allFields.length; ++j) {
                if (!sumFields.get(i).equals(allFields[j].getName())) continue;
                indexSumSource[i] = j;
                continue block6;
            }
        }
        ArrayList<String> sumAllFieldNames = new ArrayList<String>();
        sumAllFieldNames.addAll(props);
        sumAllFieldNames.addAll(sumFields);
        ArrayList<Field> sumAllFields = new ArrayList<Field>();
        block8: for (int i = 0; i < sumAllFieldNames.size(); ++i) {
            for (int j = 0; j < allFields.length; ++j) {
                if (!((String)sumAllFieldNames.get(i)).equals(allFields[j].getName())) continue;
                sumAllFields.add(allFields[j]);
                continue block8;
            }
        }
        RowMeta sumRowMeta = new RowMeta(sumAllFields.toArray(new Field[sumAllFields.size()]));
        midResultX = groupby.reduceGroup((GroupReduceFunction)new SumReduceGroupFunction(sumRowMeta, indexKeyTarget, indexSumTarget, indexKeySource, indexSumSource));
        RowMeta rowMeta = midResultX.getRowMeta();
        ArrayList replenish_fields = new ArrayList();
        ArrayList replenish_values = new ArrayList();
        SalProfitMidResultConst.REPLENISH_FIELDS.forEach(f -> {
            if (!SalGrossProfitXQueryHelper.isExistField(f, rowMeta)) {
                Field field = new Field(f, (DataType)DataType.BigDecimalType, false);
                replenish_fields.add(field);
                replenish_values.add(BigDecimal.ZERO);
            }
        });
        if (replenish_fields.size() > 0) {
            midResultX = midResultX.addFields(replenish_fields.toArray(new Field[replenish_values.size()]), replenish_values.toArray());
        }
        midResultX = midResultX.map((MapFunction)new SalGrossProfitCalUnitFunction());
        if (queryParam.getFilter() != null && queryParam.getFilter().getValue("groupby") != null && queryParam.getFilter().getValue("groupby").toString().contains("material")) {
            log.info("\u67e5\u8be2\u5c55\u793a\u5b57\u6bb5");
            midResultX = midResultX.orderBy(new String[]{"material"});
        }
        DataSetOutput resultOutput = new DataSetOutput(midResultX.getRowMeta());
        String resultOutputId = resultOutput.getId();
        midResultX.output((Output)resultOutput);
        midResultSession.commit(3600, TimeUnit.SECONDS);
        DataSet result = midResultSession.readDataSet(resultOutputId);
        log.info("\u6784\u5efa\u5c55\u793a\u5b57\u6bb5\u7ed3\u675f");
        return result;
    }

    public static List<String> getGroupByProps(FilterInfo filterInfo, boolean isCanExpand) {
        String[] values;
        ArrayList<String> groupList = new ArrayList<String>();
        if (!isCanExpand) {
            groupList.add("org");
            groupList.add("baseunit");
            groupList.add("currency");
        }
        String value = filterInfo.getString("groupby");
        for (String string : values = value.split(",")) {
            if (!StringUtils.isNotEmpty((String)string)) continue;
            if (!string.equals("acc")) {
                groupList.add(string);
                continue;
            }
            if (!isCanExpand) continue;
            groupList.add("org");
        }
        return groupList;
    }

    public static String[] getShowSelectors(String rightAligs) {
        String[] selectors = new String[SalGrossProfitRptConst.BASE_FIELDS.size()];
        for (int i = 0; i < selectors.length; ++i) {
            String field = (String)SalGrossProfitRptConst.BASE_FIELDS.get(i);
            selectors[i] = SalGrossProfitRptXQuery.getSelectFieldByAlias(field, field, rightAligs);
        }
        return selectors;
    }

    public static String getSelectFieldByAlias(String field, String aliasName, String aliasFlag) {
        if (StringUtils.isNotEmpty((String)aliasFlag)) {
            return field + " " + aliasFlag + aliasName;
        }
        return field + " " + aliasName;
    }

    private boolean forecast(List<Long> saloutIdList, int times) {
        ArrayList<Long> countIDConditonSet = new ArrayList<Long>(16);
        for (int i = 0; i < saloutIdList.size(); ++i) {
            if (i % 500 != 0) continue;
            countIDConditonSet.add(saloutIdList.get(i));
        }
        int countEntry = 0;
        try (DataSet entryCountSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_saloutbill", (String)"billentry.id", (QFilter[])new QFilter[]{new QFilter("id", "in", countIDConditonSet)}, null);){
            for (Row entry : entryCountSet) {
                ++countEntry;
            }
        }
        return countEntry / countIDConditonSet.size() > times;
    }

    private void calibraBatchNum(ReportQueryParam queryParam, Long batchNum) {
        batchNum = this.forecastBatchNumber(batchNum);
        log.info("forecastBatchNumber=" + batchNum);
        if (queryParam.getFilter() != null && queryParam.getFilter().getFilterItem("batchnum") != null) {
            queryParam.getFilter().getFilterItem("batchnum").setValue((Object)batchNum);
        }
    }

    private Long forecastBatchNumber(Long batchNum) {
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long maxMemory = Runtime.getRuntime().maxMemory();
        double xms = totalMemory / 1024L / 1024L;
        double xmx = maxMemory / 1024L / 1024L;
        double free = freeMemory / 1024L / 1024L;
        Long adviseBatchNum = 1000L;
        log.info("xms=" + xms);
        log.info("xmx=" + xmx);
        log.info("free=" + free);
        adviseBatchNum = xmx > 24000.0 ? Long.valueOf(10000L) : (xmx > 16000.0 ? Long.valueOf(5000L) : (xmx > 8000.0 ? Long.valueOf(2000L) : (xmx > 4000.0 ? Long.valueOf(1000L) : Long.valueOf(500L))));
        if (Long.valueOf("9999999999999").equals(batchNum)) {
            return adviseBatchNum;
        }
        if (batchNum.compareTo(adviseBatchNum) <= 0) {
            return adviseBatchNum;
        }
        return batchNum;
    }

    private boolean analysisData(ReportQueryParam queryParam, List<Long> saloutIdList) {
        boolean returnForecast = false;
        if (saloutIdList.size() > 10000) {
            log.info("Forecast1");
            returnForecast = true;
        } else if (saloutIdList.size() > 5000) {
            log.info("Forecast2");
            returnForecast = this.forecast(saloutIdList, 5);
        } else if (saloutIdList.size() > 3000) {
            log.info("Forecast3");
            returnForecast = this.forecast(saloutIdList, 10);
        } else if (saloutIdList.size() > 1000) {
            log.info("Forecast4");
            returnForecast = this.forecast(saloutIdList, 20);
        } else if (saloutIdList.size() > 500) {
            log.info("Forecast5");
            returnForecast = this.forecast(saloutIdList, 50);
        }
        return returnForecast;
    }
}

