/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillTypeApHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.sm.business.helper.AppParameterHelper;
import kd.scmc.sm.business.helper.OperGrpHelper;
import kd.scmc.sm.business.helper.OrgHelper;
import kd.scmc.sm.business.helper.SaleReportHelper;
import kd.scmc.sm.enums.CloseStatusEnum;
import kd.scmc.sm.enums.RowCloseStatusEnum;
import kd.scmc.sm.enums.StatusEnum;
import kd.scmc.sm.report.helper.SalRankRptHelper;
import kd.scmc.sm.util.CommonUtils;

public class SalOrderBillRptPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener,
ItemClickListener {
    private static final String HAS_PERMISSION_SAL_ORG = "hasPermissionPurOrg";
    protected static final String ORGF7 = "ischange";

    public void registerListener(EventObject e) {
        BasedataEdit selectbill;
        BasedataEdit bizdept;
        BasedataEdit bizoperatorgroup;
        BasedataEdit bizoperator;
        BasedataEdit material;
        BasedataEdit supplier;
        super.registerListener(e);
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit org = (BasedataEdit)this.getView().getControl("orgfield");
        if (org != null) {
            org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((supplier = (BasedataEdit)this.getView().getControl("customerfield")) != null) {
            supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((material = (BasedataEdit)this.getView().getControl("materialfield")) != null) {
            material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((bizoperator = (BasedataEdit)this.getView().getControl("bizoperatorfield")) != null) {
            bizoperator.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((bizoperatorgroup = (BasedataEdit)this.getView().getControl("bizoperatorgroupfield")) != null) {
            bizoperatorgroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((bizdept = (BasedataEdit)this.getView().getControl("bizdeptfield")) != null) {
            bizdept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((selectbill = (BasedataEdit)this.getView().getControl("selectbill")) != null) {
            selectbill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        IDataModel model = this.getModel();
        String formId = this.getView().getFormShowParameter().getFormId();
        if (model.getValue("orgfield") == null) {
            List orgList;
            String pkSet = this.getPageCache().get(HAS_PERMISSION_SAL_ORG);
            if (pkSet == null || pkSet.length() < 1) {
                orgList = OrgHelper.getHasPermissionOrg((String)formId, (String)OrgHelper.getFisSaleViewType());
                this.getPageCache().put(HAS_PERMISSION_SAL_ORG, SerializationUtils.toJsonString((Object)orgList));
            } else {
                orgList = (List)SerializationUtils.fromJsonString((String)pkSet, List.class);
            }
            if (orgList != null && orgList.size() > 0) {
                Long orgId = RequestContext.get().getOrgId();
                if (orgList.contains(orgId)) {
                    model.setValue("orgfield", (Object)orgId);
                } else {
                    model.setValue("orgfield", orgList.get(0));
                }
            }
        }
        Object startdate = this.getModel().getValue("startdate");
        Object enddate = this.getModel().getValue("enddate");
        if (startdate == null && enddate == null) {
            this.setdefaultDate();
        }
        this.controlBillStatusEnable(model);
        DynamicObjectCollection operateGroup = (DynamicObjectCollection)this.getModel().getValue("bizoperatorgroupfield");
        if (operateGroup == null || operateGroup.size() == 0) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"bizoperatorfield"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"bizoperatorfield"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        Long billtype = BillTypeApHelper.getDefaultBillTypeId((String)"sm_salorder");
        this.getModel().setValue("billtypefield", (Object)billtype);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject org = (DynamicObject)this.getModel().getValue("orgfield");
        switch (fieldKey) {
            case "orgfield": {
                String pkSet = this.getPageCache().get(HAS_PERMISSION_SAL_ORG);
                if (pkSet == null || pkSet.length() < 1) {
                    List orgList = OrgHelper.getHasPermissionOrg((String)showParameter.getFormId(), (String)OrgHelper.getFisSaleViewType());
                    this.getPageCache().put(HAS_PERMISSION_SAL_ORG, SerializationUtils.toJsonString((Object)orgList));
                    showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)orgList));
                } else {
                    showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", SerializationUtils.fromJsonString((String)pkSet, List.class)));
                }
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ORGF7);
                showParameter.setCloseCallBack(closeCallBack);
                break;
            }
            case "bizoperatorfield": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalOrderBillRptPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                DynamicObjectCollection operateGroup = (DynamicObjectCollection)this.getModel().getValue("bizoperatorgroupfield");
                if (operateGroup == null || operateGroup.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u3002", (String)"SalRankRptPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                List<Long> groups = this.getBaseDataPkIds(operateGroup);
                SalOrderBillRptPlugin.getOperatorGroupByUser(groups, showParameter);
                break;
            }
            case "bizoperatorgroupfield": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalOrderBillRptPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                long userId = UserServiceHelper.getCurrentUserId();
                List<Long> orgGrpList = SalRankRptHelper.getOperatorGroupByOrg(Long.parseLong(org.getPkValue().toString()));
                Object operatorGroupIsolate = AppParameterHelper.getSmAppParameter((Long)Long.parseLong(org.getPkValue().toString()), (String)"foperatorgroupisolate");
                if (operatorGroupIsolate instanceof Boolean && ((Boolean)operatorGroupIsolate).booleanValue()) {
                    HashSet<Long> userIDs = new HashSet<Long>();
                    userIDs.add(userId);
                    QFilter f = new QFilter("id", "in", (Object)OperGrpHelper.getOperatorGroupByUser((Long)((Long)org.getPkValue()), userIDs));
                    showParameter.getListFilterParameter().setFilter(f);
                    break;
                }
                QFilter f = new QFilter("id", "in", orgGrpList);
                showParameter.getListFilterParameter().setFilter(f);
                break;
            }
            case "materialfield": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalOrderBillRptPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                List materialFilter = SaleReportHelper.getMaterialFilter((Long)((Long)org.getPkValue()));
                showParameter.getListFilterParameter().setQFilters(materialFilter);
                showParameter.setCustomParam("useOrg", (Object)org.getPkValue().toString());
                showParameter.setShowApproved(false);
                break;
            }
            case "selectbill": {
                DynamicObject billtype;
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalOrderBillRptPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                QFilter orderFilter = new QFilter("1", "=", (Object)1);
                QFilter filterF7 = new QFilter("1", "=", (Object)1);
                Date startdate = (Date)this.getModel().getValue("startdate");
                Date enddate = (Date)this.getModel().getValue("enddate");
                if (startdate != null && enddate != null && org != null) {
                    QFilter qFilterOrgId = new QFilter("org.id", "=", org.getPkValue());
                    QFilter qFilterStartDate = new QFilter("bizdate", ">=", (Object)this.getStartOrEndDate(startdate, false));
                    QFilter qFilterEndDate = new QFilter("bizdate", "<=", (Object)this.getStartOrEndDate(enddate, true));
                    orderFilter.and(qFilterOrgId).and(qFilterStartDate).and(qFilterEndDate);
                    filterF7.and(qFilterOrgId).and(qFilterStartDate).and(qFilterEndDate);
                }
                if ((billtype = (DynamicObject)this.getModel().getValue("billtypefield")) != null) {
                    QFilter qFilterbilltype = new QFilter("billtype.id", "=", billtype.getPkValue());
                    orderFilter.and(qFilterbilltype);
                    filterF7.and(qFilterbilltype);
                }
                DynamicObjectCollection customer = (DynamicObjectCollection)this.getModel().getValue("customerfield");
                List<Object> customerIds = new ArrayList();
                if (customer != null && customer.size() > 0) {
                    customerIds = this.getBaseDataPkIds(customer);
                }
                if (customerIds != null && customerIds.size() > 0) {
                    QFilter qFilterCustomer = new QFilter("customer.id", "in", customerIds);
                    QFilter qFilterCustomerF7 = new QFilter("customerid.id", "in", customerIds);
                    orderFilter.and(qFilterCustomer);
                    filterF7.and(qFilterCustomerF7);
                }
                QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.SAVE.getValue());
                DynamicObject[] dynamicObject = BusinessDataServiceHelper.load((String)"sm_salorder", (String)"id,billentry.material", (QFilter[])new QFilter[]{statusFilter, orderFilter});
                ArrayList<Long> ids = new ArrayList<Long>(16);
                for (DynamicObject d : dynamicObject) {
                    boolean hasEntry = false;
                    DynamicObjectCollection entrys = d.getDynamicObjectCollection("billentry");
                    for (DynamicObject entry : entrys) {
                        if (entry.getDynamicObject("material") == null) continue;
                        hasEntry = true;
                        break;
                    }
                    if (hasEntry) continue;
                    ids.add((Long)d.getPkValue());
                }
                if (ids.size() > 0) {
                    QFilter idFilter = new QFilter("id", "not in", ids);
                    orderFilter.and(idFilter);
                    filterF7.and(idFilter);
                }
                showParameter.getListFilterParameter().setFilter(filterF7);
                showParameter.setFormId("bos_listf7_sal");
                break;
            }
            case "bizdeptfield": 
            case "customerfield": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalOrderBillRptPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                showParameter.setShowApproved(false);
                break;
            }
        }
    }

    private void setdefaultDate() {
        IDataModel model = this.getModel();
        Calendar cal = Calendar.getInstance();
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        model.setValue("startdate", (Object)cal.getTime());
        model.setValue("enddate", (Object)cal.getTime());
    }

    public Date getStartOrEndDate(Date date, boolean isEnd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (isEnd) {
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
        } else {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
        }
        return cal.getTime();
    }

    private List<Long> getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return new ArrayList<Long>(1);
        }
        ArrayList<Long> pkIds = new ArrayList<Long>(col.size());
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds.add((Long)baseData.get("fbasedataid_id"));
        }
        return pkIds;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        switch (key) {
            case "orgfield": {
                if (newValue != null && newValue.equals(oldValue)) {
                    return;
                }
                if (newValue != null && newValue.equals(oldValue) && !"1".equals(this.getPageCache().get(ORGF7))) break;
                model.setValue("materialfield", null);
                model.setValue("customerfield", null);
                model.setValue("bizoperatorfield", null);
                model.setValue("bizoperatorgroupfield", null);
                model.setValue("bizdeptfield", null);
                model.setValue("selectbill", null);
                this.getPageCache().put(ORGF7, "0");
                break;
            }
            case "billstatusfield": {
                this.controlBillStatusEnable(model);
                break;
            }
            case "bizoperatorgroupfield": {
                this.changeOperatorGroup((DynamicObjectCollection)newValue);
                break;
            }
            case "billtypefield": {
                if (newValue == null || newValue == oldValue) break;
                model.setValue("selectbill", null);
                break;
            }
        }
    }

    private void changeOperatorGroup(DynamicObjectCollection operatorGroup) {
        if (operatorGroup == null || operatorGroup.size() == 0) {
            this.getModel().setValue("bizoperatorfield", null);
            this.getView().setEnable(Boolean.FALSE, new String[]{"bizoperatorfield"});
        } else {
            this.getModel().setValue("bizoperatorfield", null);
            this.getView().setEnable(Boolean.TRUE, new String[]{"bizoperatorfield"});
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "ischange": {
                if (closedCallBackEvent.getReturnData() == null) break;
                ListSelectedRowCollection returnValue = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                this.getPageCache().put(ORGF7, "1");
                this.getModel().setValue("orgfield", returnValue.getPrimaryKeyValues()[0]);
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filter = queryParam.getFilter();
        DynamicObject org = filter.getDynamicObject("orgfield");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalOrderBillRptPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]));
            return false;
        }
        Date startdate = filter.getDate("startdate");
        Date enddate = filter.getDate("enddate");
        if (startdate != null && enddate != null) {
            return true;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u3002", (String)"SalOrderBillRptPlugin_3", (String)"scmc-sm-report", (Object[])new Object[0]));
        return false;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        ReportList reportList = (ReportList)evt.getSource();
        int rowIndex = evt.getRowIndex();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        if ("billno".equals(evt.getFieldName())) {
            Object data = rowData.get("id");
            if (CommonUtils.isNull((Object)data.toString().trim())) {
                return;
            }
            Long billid = Long.valueOf(data.toString());
            this.showOneBillInfo("sm_salorder", billid);
        }
    }

    private void showOneBillInfo(String entityid, Long billTypeID) {
        BillShowParameter fsp = new BillShowParameter();
        fsp.setFormId(entityid);
        fsp.setStatus(OperationStatus.EDIT);
        fsp.setPkId((Object)billTypeID);
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)fsp);
    }

    private void controlBillStatusEnable(IDataModel model) {
        String value = (String)this.getModel().getValue("billstatusfield");
        if (StringUtils.isBlank((CharSequence)value)) {
            this.getModel().setValue("billstatusfield", (Object)"A");
        }
        if (!StatusEnum.AUDIT.getValue().equals(value) && !"A".equals(value)) {
            model.setValue("closestatusfield", (Object)CloseStatusEnum.UNCLOSED.getValue());
            model.setValue("rowstatusfield", (Object)RowCloseStatusEnum.UNROWCLOSE.getValue());
            this.getView().setEnable(Boolean.FALSE, new String[]{"closestatusfield"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"rowstatusfield"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"closestatusfield"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"rowstatusfield"});
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        ReportList list = (ReportList)this.getView().getControl("reportlistap");
        list.clearEntryState();
    }

    private static void getOperatorGroupByUser(List<Long> list, ListShowParameter showParameter) {
        if (list.size() > 0) {
            QFilter filter1 = new QFilter("operatorgrpid", "in", list);
            showParameter.getListFilterParameter().setFilter(filter1);
        }
    }
}

