/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.sm.business.helper.AppParameterHelper;
import kd.scmc.sm.business.helper.OperGrpHelper;
import kd.scmc.sm.business.helper.OrgHelper;
import kd.scmc.sm.business.helper.SaleReportHelper;
import kd.scmc.sm.report.helper.SalRankRptHelper;

public class SalRankRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static final String[] getInvisibleCustomer = new String[]{"material", "materialname", "modelnum", "qty", "unit", "materialamount", "dept", "deptname", "operatorgroup", "operatorgroupname", "operator", "operatorname"};
    private static final String[] getInvisibleMaterial = new String[]{"customer", "customername", "dept", "curtotalallamount", "dept", "deptname", "operatorgroup", "operatorgroupname", "operator", "operatorname"};
    private static final String[] getInvisibleDept = new String[]{"material", "materialname", "modelnum", "qty", "unit", "customer", "customername", "operatorgroup", "operatorgroupname", "operator", "operatorname", "materialamount"};
    private static final String[] getInvisibleOperateGroup = new String[]{"material", "materialname", "modelnum", "qty", "unit", "materialamount", "customername", "customer", "dept", "deptname", "operator", "operatorname"};
    private static final String[] getInvisibleOperator = new String[]{"material", "materialname", "modelnum", "qty", "unit", "materialamount", "customername", "customer", "dept", "deptname", "operatorgroup"};

    public void registerListener(EventObject e) {
        BasedataEdit bizdept;
        BasedataEdit bizoperatorgroup;
        BasedataEdit bizoperator;
        BasedataEdit material;
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getView().getControl("orgfield");
        if (org != null) {
            org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((material = (BasedataEdit)this.getView().getControl("materialfield")) != null) {
            material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((bizoperator = (BasedataEdit)this.getView().getControl("bizoperatorfield")) != null) {
            bizoperator.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((bizoperatorgroup = (BasedataEdit)this.getView().getControl("bizoperatorgroupfield")) != null) {
            bizoperatorgroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((bizdept = (BasedataEdit)this.getView().getControl("bizdeptfield")) != null) {
            bizdept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        DynamicObjectCollection operateGroup;
        List orgList;
        IDataModel model = this.getModel();
        if (model.getValue("orgfield") == null && (orgList = OrgHelper.getHasPermissionOrg((String)"sm_salrankrpt", (String)"03")) != null && orgList.size() > 0) {
            long orgId = RequestContext.get().getOrgId();
            if (orgList.contains(orgId)) {
                this.getModel().setValue("orgfield", (Object)orgId);
            } else {
                this.getModel().setValue("orgfield", orgList.get(0));
            }
        }
        Object startdate = this.getModel().getValue("startdate");
        Object enddate = this.getModel().getValue("enddate");
        if (startdate == null && enddate == null) {
            this.setdefaultDate();
        }
        if ((operateGroup = (DynamicObjectCollection)this.getModel().getValue("bizoperatorgroupfield")) == null || operateGroup.size() == 0) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"bizoperatorfield"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"bizoperatorfield"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject salOrgs = (DynamicObject)this.getModel().getValue("orgfield");
        switch (key) {
            case "orgfield": {
                List orgList = OrgHelper.getHasPermissionOrg((String)"sm_salrankrpt", (String)OrgHelper.getFisSaleViewType());
                formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)orgList));
                break;
            }
            case "materialfield": {
                if (salOrgs == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalOrderBillRptPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                formShowParameter.getListFilterParameter().setQFilters(SaleReportHelper.getMaterialFilter((Long)((Long)salOrgs.getPkValue())));
                formShowParameter.setCustomParam("useOrg", (Object)salOrgs.getPkValue().toString());
                formShowParameter.setShowApproved(false);
                break;
            }
            case "bizoperatorgroupfield": {
                if (salOrgs == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalOrderBillRptPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                long userId = UserServiceHelper.getCurrentUserId();
                List<Long> orgGrpList = SalRankRptHelper.getOperatorGroupByOrg(Long.parseLong(salOrgs.getPkValue().toString()));
                Object operatorGroupIsolate = AppParameterHelper.getSmAppParameter((Long)Long.parseLong(salOrgs.getPkValue().toString()), (String)"foperatorgroupisolate");
                if (operatorGroupIsolate instanceof Boolean && ((Boolean)operatorGroupIsolate).booleanValue()) {
                    HashSet<Long> userIDs = new HashSet<Long>();
                    userIDs.add(userId);
                    QFilter f = new QFilter("id", "in", (Object)OperGrpHelper.getOperatorGroupByUser((Long)((Long)salOrgs.getPkValue()), userIDs));
                    formShowParameter.getListFilterParameter().setFilter(f);
                    break;
                }
                QFilter f = new QFilter("id", "in", orgGrpList);
                formShowParameter.getListFilterParameter().setFilter(f);
                break;
            }
            case "bizoperatorfield": {
                if (salOrgs == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalOrderBillRptPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                DynamicObjectCollection operateGroup = (DynamicObjectCollection)this.getModel().getValue("bizoperatorgroupfield");
                if (operateGroup == null || operateGroup.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u3002", (String)"SalRankRptPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                List<Long> groups = SalRankRptPlugin.getBaseDataPkIds(operateGroup);
                SalRankRptPlugin.getOperatorGroupByUser(groups, formShowParameter);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        switch (key) {
            case "bizoperatorgroupfield": {
                this.changeOperatorGroup((DynamicObjectCollection)newValue);
                break;
            }
            case "orgfield": {
                this.getModel().setValue("materialfield", null);
                this.getModel().setValue("bizdeptfield", null);
                this.getModel().setValue("bizoperatorgroupfield", null);
                this.getModel().setValue("bizoperatorfield", null);
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filter = queryParam.getFilter();
        DynamicObject org = filter.getDynamicObject("orgfield");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalOrderBillRptPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]));
            return false;
        }
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        List rptColumns = reportList.getColumns();
        Object sign = filter.getFilterItem("statisticfield").getValue();
        if ("".equals(sign) || sign == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7edf\u8ba1\u4f9d\u636e\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"SalRankRptPlugin_2", (String)"scmc-sm-report", (Object[])new Object[0]));
            return false;
        }
        if ("A".equals(sign)) {
            SalRankRptHelper.setHiddenColsForRpt((List<AbstractReportColumn>)rptColumns, getInvisibleMaterial);
        } else if ("B".equals(sign)) {
            SalRankRptHelper.setHiddenColsForRpt((List<AbstractReportColumn>)rptColumns, getInvisibleCustomer);
        } else if ("C".equals(sign)) {
            SalRankRptHelper.setHiddenColsForRpt((List<AbstractReportColumn>)rptColumns, getInvisibleDept);
        } else if ("D".equals(sign)) {
            SalRankRptHelper.setHiddenColsForRpt((List<AbstractReportColumn>)rptColumns, getInvisibleOperateGroup);
        } else {
            SalRankRptHelper.setHiddenColsForRpt((List<AbstractReportColumn>)rptColumns, getInvisibleOperator);
        }
        Date startdate = filter.getDate("startdate");
        Date enddate = filter.getDate("enddate");
        if (startdate != null && enddate != null) {
            return true;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u3002", (String)"SalOrderBillRptPlugin_3", (String)"scmc-sm-report", (Object[])new Object[0]));
        return false;
    }

    private void setdefaultDate() {
        IDataModel model = this.getModel();
        Calendar cal = Calendar.getInstance();
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        model.setValue("startdate", (Object)cal.getTime());
        model.setValue("enddate", (Object)cal.getTime());
    }

    private static void getOperatorGroupByUser(List<Long> list, ListShowParameter showParameter) {
        if (list.size() > 0) {
            QFilter filter1 = new QFilter("operatorgrpid", "in", list);
            showParameter.getListFilterParameter().setFilter(filter1);
        }
    }

    private static List<Long> getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return new ArrayList<Long>(1);
        }
        ArrayList<Long> pkIds = new ArrayList<Long>(col.size());
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds.add((Long)baseData.get("fbasedataid_id"));
        }
        return pkIds;
    }

    private void changeOperatorGroup(DynamicObjectCollection operatorGroup) {
        if (operatorGroup == null || operatorGroup.size() == 0) {
            this.getModel().setValue("bizoperatorfield", null);
            this.getView().setEnable(Boolean.FALSE, new String[]{"bizoperatorfield"});
        } else {
            this.getModel().setValue("bizoperatorfield", null);
            this.getView().setEnable(Boolean.TRUE, new String[]{"bizoperatorfield"});
        }
    }
}

