/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report;

import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.sm.business.helper.AppParameterHelper;
import kd.scmc.sm.report.SalRankRptQuery;
import kd.scmc.sm.report.helper.SalRankRptHelper;
import kd.scmc.sm.report.helper.SmDeliverPlanRptHelper;

public class SmDeliverPlanRptQuery
extends AbstractReportListDataPlugin {
    private static final Log log = LogFactory.getLog(SalRankRptQuery.class);

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        QFilter billStatus = new QFilter("billstatus", "=", (Object)"C");
        List<QFilter> filters = SmDeliverPlanRptHelper.getFilters(filterInfo);
        filters.add(billStatus);
        DynamicObject org = filterInfo.getDynamicObject("orgfield");
        QFilter q = null;
        List<Long> orgGrpList = SalRankRptHelper.getOperatorGroupByOrg(Long.parseLong(org.getPkValue().toString()));
        Object operatorGroupIsolate = AppParameterHelper.getSmAppParameter((Long)Long.parseLong(org.getPkValue().toString()), (String)"foperatorgroupisolate");
        DynamicObjectCollection operatorgroups = filterInfo.getDynamicObjectCollection("operategroupfield");
        if (operatorgroups == null || operatorgroups.size() == 0) {
            if (operatorGroupIsolate instanceof Boolean && ((Boolean)operatorGroupIsolate).booleanValue()) {
                QFilter q3;
                QFilter q2;
                long userId = UserServiceHelper.getCurrentUserId();
                List<Long> userGrpList = SalRankRptHelper.getOperatorGroupByUser(userId);
                List<Long> grpList = SalRankRptHelper.getValidOperatorGroup(orgGrpList, userGrpList);
                q = grpList != null && grpList.size() > 0 ? (q2 = new QFilter("operatorgroup", "in", grpList)) : (q3 = new QFilter("operatorgroup", "=", (Object)0));
            } else if (orgGrpList != null && orgGrpList.size() > 0) {
                QFilter q4;
                orgGrpList.add(0L);
                q = q4 = new QFilter("operatorgroup", "in", orgGrpList);
            } else {
                QFilter q5;
                q = q5 = new QFilter("operatorgroup", "=", (Object)0);
            }
        }
        filters.add(q);
        String selectField = SmDeliverPlanRptHelper.getSelectField();
        DataSet smSalorder = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"sm_salorder", (String)selectField, (QFilter[])filters.toArray(new QFilter[filters.size()]), null);
        DataSet finish1 = smSalorder.groupBy(new String[]{"customer", "customername", "material", "operator", "materialname", "operatorgroup"}).count().finish();
        DataSet select = smSalorder.select(new String[]{"ontimenum", "customer", "customername", "material", "operator", "overduenum", "unfinishnum", "materialname", "operatorgroup"});
        DataSet finish = select.groupBy(new String[]{"customer", "customername", "material", "operator", "materialname", "operatorgroup"}).sum("ontimenum").sum("overduenum").sum("unfinishnum").finish();
        finish = finish.join(finish1, JoinType.LEFT).on("customer", "customer").on("customername", "customername").on("material", "material").on("materialname", "materialname").on("operator", "operator").on("operatorgroup", "operatorgroup").select(new String[]{"count as plantodelivernum", "customer", "customername", "material", "materialname", "operator", "ontimenum", "overduenum", "unfinishnum", "operatorgroup"}).finish();
        return finish.select(this.getShowFields());
    }

    private String getShowFields() {
        return "customer,customername,material,materialname,operator,operatorgroup,ontimenum,plantodelivernum,overduenum,unfinishnum,(ontimenum + overduenum) * 100.0 / plantodelivernum * 1.0  as finnishrate";
    }
}

