/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.scmc.sm.report.helper.SmDeliveryTimeRateRptHelper;

public class SmDeliveryTimeRateRptPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final Log LOGGER = LogFactory.getLog(SmDeliveryTimeRateRptPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportlistap = (ReportList)this.getView().getControl("reportlistap");
        reportlistap.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setEnable(Boolean.FALSE, new String[]{"daterangefield"});
        Date[] weekDate = SmDeliveryTimeRateRptHelper.getWeekDate();
        this.getModel().setValue("startdate", (Object)weekDate[0]);
        this.getModel().setValue("enddate", (Object)weekDate[1]);
        ReportQueryParam rqp = this.buildReportQueryParam(weekDate);
        ReportCacheManager.getInstance().getCache().setReportQueryParam(this.getView().getPageId(), rqp);
        this.reFresh();
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        BigDecimal todaynum = BigDecimal.ZERO;
        BigDecimal overduenum = BigDecimal.ZERO;
        BigDecimal overnum = BigDecimal.ZERO;
        BigDecimal ontimenum = BigDecimal.ZERO;
        BigDecimal expireordernum = BigDecimal.ZERO;
        for (DynamicObject rowDatum : rowData) {
            todaynum = todaynum.add(rowDatum.getBigDecimal("todaynum").setScale(0, 4));
            overduenum = overduenum.add(rowDatum.getBigDecimal("overduenum").setScale(0, 4));
            overnum = overnum.add(rowDatum.getBigDecimal("overnum").setScale(0, 4));
            ontimenum = ontimenum.add(rowDatum.getBigDecimal("ontimenum").setScale(2, 4));
            expireordernum = expireordernum.add(rowDatum.getBigDecimal("expireordernum").setScale(0, 4));
        }
        Label labelap5 = (Label)this.getControl("labelap5");
        labelap5.setText(todaynum.toString());
        Label labelap6 = (Label)this.getControl("labelap6");
        labelap6.setText(overduenum.toString());
        Label labelap8 = (Label)this.getControl("labelap8");
        labelap8.setText(overnum.toString());
        Label labelap13 = (Label)this.getControl("labelap13");
        labelap13.setText(expireordernum.toString());
        Label labelap10 = (Label)this.getControl("labelap10");
        if (ontimenum != BigDecimal.ZERO && expireordernum != BigDecimal.ZERO) {
            BigDecimal delivertimerate = ontimenum.multiply(new BigDecimal(100)).divide(expireordernum, 2, 4);
            labelap10.setText(delivertimerate.toString() + "%");
        } else {
            labelap10.setText(BigDecimal.ZERO.toString() + ".00%");
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        if ("startdate".equals(key) || "enddate".equals(key)) {
            this.changeDate(key, e);
        }
        if ("daterange".equals(key)) {
            if ("A".equals(newValue)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"daterangefield"});
                Date[] weekDate = SmDeliveryTimeRateRptHelper.getWeekDate();
                this.getModel().setValue("startdate", (Object)weekDate[0]);
                this.getModel().setValue("enddate", (Object)weekDate[1]);
            } else if ("B".equals(newValue)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"daterangefield"});
                Date[] thisMonth = SmDeliveryTimeRateRptHelper.getThisMonth();
                this.getModel().setValue("startdate", (Object)thisMonth[0]);
                this.getModel().setValue("enddate", (Object)thisMonth[1]);
            } else if ("C".equals(newValue)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"daterangefield"});
                Date[] recentThreeMonths = SmDeliveryTimeRateRptHelper.getRecentThreeMonths();
                this.getModel().setValue("startdate", (Object)recentThreeMonths[0]);
                this.getModel().setValue("enddate", (Object)recentThreeMonths[1]);
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"daterangefield"});
                this.getModel().setValue("startdate", null);
                this.getModel().setValue("enddate", null);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        if ("refresh".equals(op.getOperateKey())) {
            Object startdate = this.getModel().getValue("startdate");
            Object enddate = this.getModel().getValue("enddate");
            if (startdate == null && enddate == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u8303\u56f4\u3002", (String)"SmDeliveryTimeRateRptPlugin_0", (String)"scmc-sm-report", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    private void changeDate(String key, PropertyChangedArgs e) {
        String format;
        Date startdate = null;
        Date enddate = null;
        Date[] dates = new Date[2];
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if ("startdate".equals(key)) {
            dates[0] = startdate = (Date)e.getChangeSet()[0].getNewValue();
            enddate = (Date)this.getModel().getValue("enddate");
            if (enddate != null) {
                try {
                    format = sdf.format(enddate) + " 23:59:59";
                    dates[1] = sdf1.parse(format);
                }
                catch (ParseException e1) {
                    LOGGER.error(e1.getMessage());
                }
            }
        } else {
            dates[0] = startdate = (Date)this.getModel().getValue("startdate");
            enddate = (Date)e.getChangeSet()[0].getNewValue();
            if (enddate != null) {
                try {
                    format = sdf.format(enddate) + " 23:59:59";
                    dates[1] = sdf1.parse(format);
                }
                catch (ParseException e1) {
                    LOGGER.error(e1.getMessage());
                }
            }
        }
        if (startdate != null && enddate != null) {
            ReportQueryParam rqp = this.buildReportQueryParam(dates);
            ReportCacheManager.getInstance().getCache().setReportQueryParam(this.getView().getPageId(), rqp);
            this.reFresh();
        }
    }

    protected ReportQueryParam getQueryParam() {
        return super.getQueryParam();
    }

    private ReportQueryParam buildReportQueryParam(Date[] dates) {
        ReportQueryParam rqp = this.getQueryParam();
        FilterInfo filterInfo = new FilterInfo();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (dates != null) {
            QFilter startdate = new QFilter("startdate", "=", (Object)dates[0]);
            QFilter enddate = new QFilter("enddate", "=", (Object)dates[1]);
            filters.add(startdate);
            filters.add(enddate);
            filterInfo.setQFilters(filters);
            filterInfo.addFilterItem("startdate", (Object)dates[0]);
            filterInfo.addFilterItem("enddate", (Object)dates[1]);
            rqp.setFilter(filterInfo);
        }
        return rqp;
    }

    private void reFresh() {
        ReportView view = (ReportView)this.getView();
        view.refresh();
    }
}

