/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.sm.business.helper.OrgHelper;
import kd.scmc.sm.report.helper.SmDeliveryTimeRateRptHelper;

public class SmDeliveryTimeRateRptQuery
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        QFilter billStatus = new QFilter("billstatus", "=", (Object)"C");
        Long userId = UserServiceHelper.getCurrentUserId();
        QFilter operator = new QFilter("operator.operatorid", "=", (Object)userId);
        QFilter biztype = new QFilter("biztype.number", "=", (Object)"210");
        List orgs = OrgHelper.getHasPermissionOrg((String)"sm_salorder");
        QFilter org = new QFilter("org", "in", (Object)orgs);
        QFilter feature = new QFilter("billentry.deliverydate", "<=", (Object)TimeServiceHelper.today());
        QFilter isvirtualbill = new QFilter("isvirtualbill", "=", (Object)Boolean.FALSE);
        ArrayList<QFilter> filter = new ArrayList<QFilter>();
        filter.addAll(Arrays.asList(billStatus, operator, biztype, org, feature, isvirtualbill));
        String selectField = SmDeliveryTimeRateRptHelper.getSelectField(reportQueryParam);
        List<QFilter> qFilters = SmDeliveryTimeRateRptHelper.expireFilter(reportQueryParam);
        qFilters.addAll(filter);
        DataSet expire = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"sm_salorder", (String)selectField, (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]), null);
        DataSet expireSelect = expire.groupBy(new String[]{"customer", "org"}).sum("expireordernum").finish();
        List<QFilter> qFilters1 = SmDeliveryTimeRateRptHelper.todayFilter();
        qFilters1.addAll(filter);
        DataSet today = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"sm_salorder", (String)selectField, (QFilter[])qFilters1.toArray(new QFilter[qFilters1.size()]), null);
        DataSet todaySelect = today.groupBy(new String[]{"customer", "org"}).sum("todaynum").finish();
        List<QFilter> qFilters2 = SmDeliveryTimeRateRptHelper.expireFilter(reportQueryParam);
        qFilters2.addAll(filter);
        DataSet smCopy = expire.copy();
        smCopy = smCopy.orderBy(new String[]{"auditdate asc"}).filter("auditdate <> null");
        QFilter auditDateQFilter = null;
        if (smCopy.hasNext()) {
            DataSet dataSetSmCopy = smCopy.copy();
            Date auditdate = dataSetSmCopy.next().getDate("auditdate");
            auditDateQFilter = new QFilter("auditdate", ">=", (Object)auditdate);
            dataSetSmCopy.close();
        }
        smCopy.close();
        String imSalOutSelectField = SmDeliveryTimeRateRptHelper.getImSalOutSelectField();
        DataSet im_saloutbill = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_saloutbill", (String)imSalOutSelectField, (QFilter[])new QFilter[]{billStatus.and(biztype).and(auditDateQFilter)}, null);
        DataSet sm_salorder = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"sm_salorder", (String)"id,billentry.id as entryid,billentry.deliverydate as deliverydate,billentry.invqty as invqty,billentry.qty as qty,billentry.rowclosestatus as rowclosestatus,billentry.rowterminatestatus as rowterminatestatus,customer,org,closestatus", (QFilter[])qFilters2.toArray(new QFilter[qFilters2.size()]), null);
        DataSet finish1 = sm_salorder.join(im_saloutbill, JoinType.LEFT).on("id", "srcbillid").on("entryid", "srcbillentryid").select(new String[]{"biztime", "entryid", "srcbillentryid", "customer", "org"}).finish();
        DataSet biztime = finish1.groupBy(new String[]{"srcbillentryid"}).max("biztime").finish();
        finish1 = sm_salorder.join(biztime, JoinType.LEFT).on("entryid", "srcbillentryid").select(new String[]{"customer", "org", "deliverydate", "invqty", "qty", "rowclosestatus", "rowterminatestatus", "biztime", "closestatus", "entryid", "srcbillentryid"}).finish();
        DataSet overdue = finish1.copy().executeSql("select case when rowclosestatus = 'A' and rowterminatestatus = 'A' and invqty < qty and closestatus = 'A' then 1 else 0 end as overduenum,customer,org");
        overdue = overdue.groupBy(new String[]{"customer", "org"}).sum("overduenum").finish();
        DataSet finish = expireSelect.join(overdue, JoinType.LEFT).on("customer", "customer").on("org", "org").select(new String[]{"customer", "org", "expireordernum", "overduenum"}).finish();
        DataSet select = finish1.copy().executeSql("select case when (deliverydate >= biztime and invqty >= qty) or (deliverydate >= biztime and invqty < qty and rowclosestatus = 'B') or (deliverydate >= biztime and invqty < qty and rowterminatestatus = 'B') or (closestatus = 'B' and invqty = 0) or (closestatus = 'B' and rowclosestatus = 'A' and rowterminatestatus = 'A' and invqty < qty and deliverydate >= biztime) then 1 else 0 end as ontimenum,customer,org,srcbillentryid");
        select = select.groupBy(new String[]{"customer", "org"}).sum("ontimenum").finish();
        DataSet select1 = finish1.executeSql("select case when (deliverydate < biztime and invqty >= qty) or (deliverydate < biztime and invqty < qty and rowclosestatus = 'B') or (deliverydate < biztime and invqty < qty and rowterminatestatus = 'B') or (closestatus = 'B' and rowclosestatus = 'A' and rowterminatestatus = 'A' and invqty < qty and deliverydate < biztime) then 1 else 0 end as overnum,customer,org,srcbillentryid");
        select1 = select1.groupBy(new String[]{"customer", "org"}).sum("overnum").finish();
        DataSet finish2 = select.join(select1, JoinType.LEFT).on("customer", "customer").on("org", "org").select(new String[]{"ontimenum", "overnum", "customer", "org"}).finish();
        DataSet finish3 = finish.join(finish2, JoinType.LEFT).on("customer", "customer").on("org", "org").select(new String[]{"customer", "org", "expireordernum", "overduenum", "ontimenum", "overnum"}).finish();
        DataSet bothSet = finish3.copy().join(todaySelect.copy(), JoinType.INNER).on("customer", "customer").on("org", "org").select(new String[]{"customer", "org", "expireordernum", "overduenum", "ontimenum", "overnum"}, new String[]{"todaynum"}).finish();
        bothSet = bothSet.addField("'1'", "both");
        DataSet leftSet = finish3.join(bothSet, JoinType.LEFT).on("customer", "customer").on("org", "org").select(new String[]{"customer", "org", "expireordernum", "overduenum", "ontimenum", "overnum"}, new String[]{"both", "todaynum"}).finish().where("both is null");
        leftSet = leftSet.where("expireordernum > 0 or overduenum > 0 or ontimenum > 0 or overnum > 0");
        DataSet rightSet = todaySelect.join(bothSet, JoinType.LEFT).on("customer", "customer").on("org", "org").select(new String[]{"customer", "org", "todaynum"}, new String[]{"both"}).finish().where("both is null and todaynum > 0");
        leftSet = leftSet.select(new String[]{"customer", "org", "expireordernum", "overduenum", "ontimenum", "overnum", "0 as todaynum", "'0' as both"});
        rightSet = rightSet.select(new String[]{"customer", "org", "0 as expireordernum", "0 as overduenum", "0 as ontimenum", "0 as overnum", "todaynum", "'0' as both"});
        DataSet totalSet = leftSet.union(bothSet).union(rightSet);
        return totalSet.select(this.getShowFields()).orderBy(new String[]{"customer"});
    }

    private String getShowFields() {
        return "customer,org,expireordernum,todaynum, overduenum,ontimenum,overnum,case when expireordernum != 0 then ontimenum * 1.0 / expireordernum * 100.0 end as delivertimerate";
    }
}

