/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report.bcm;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.business.helper.BaseDataHelper;
import kd.scmc.sm.report.helper.SmBcmFormulaParserHelper;

public class BcmFormulaFormTplPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.showFormula();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_confirm"});
        BasedataEdit biztype = (BasedataEdit)this.getControl("biztype");
        MulBasedataEdit customer = (MulBasedataEdit)this.getControl("customer");
        MulBasedataEdit operator = (MulBasedataEdit)this.getControl("operator");
        biztype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        customer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        operator.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btn_confirm".equals(key) && this.validQueryParam()) {
            this.callBackFormula();
        }
    }

    private boolean validQueryParam() {
        IDataModel model = this.getModel();
        Date beginDate = (Date)model.getValue("begindate");
        Date endDate = (Date)model.getValue("enddate");
        if (beginDate != null && endDate != null && beginDate.compareTo(endDate) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5e94\u5927\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"BcmFormulaFormTplPlugin_0", (String)"scmc-sm-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("org");
        switch (key) {
            case "customer": {
                if (orgs == null) break;
                ArrayList<Long> orgIds = new ArrayList<Long>();
                for (DynamicObject org : orgs) {
                    Object pkValue = org.getDynamicObject("fbasedataid").getPkValue();
                    orgIds.add((Long)pkValue);
                }
                if (orgIds.size() <= 0) break;
                QFilter qFilter = BaseDataHelper.getBaseDataFilterByOrgs((String)"bd_customer", orgIds, (boolean)true);
                List<QFilter> qfList = Collections.singletonList(qFilter);
                showParameter.getListFilterParameter().setQFilters(qfList);
                break;
            }
            case "operator": {
                if (orgs == null) break;
                ArrayList<Long> orgIds = new ArrayList<Long>();
                for (DynamicObject org : orgs) {
                    Object pkValue = org.getDynamicObject("fbasedataid").getPkValue();
                    orgIds.add((Long)pkValue);
                }
                if (orgIds.size() <= 0) break;
                ArrayList<Long> operatorGroupIds = new ArrayList<Long>();
                QFilter qFilter = BaseDataHelper.getBaseDataFilterByOrgs((String)"bd_operatorgroup", orgIds, (boolean)true);
                Map operatorGroups = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"operator", (QFilter[])(qFilter = qFilter.and(new QFilter("operatorgrouptype", "=", (Object)"XSZ"))).toArray());
                if (operatorGroups != null && !operatorGroups.isEmpty()) {
                    for (DynamicObject group : operatorGroups.values()) {
                        operatorGroupIds.add((Long)group.getPkValue());
                    }
                }
                if (operatorGroupIds.isEmpty()) break;
                List<QFilter> qfList = Collections.singletonList(new QFilter("operatorgrpid", "in", operatorGroupIds));
                showParameter.getListFilterParameter().setQFilters(qfList);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        IDataEntityProperty property = e.getProperty();
        switch (name = property.getName()) {
            case "billtype": {
                this.getModel().setValue("biztype", null);
                this.getModel().setValue("customer", null);
            }
        }
    }

    protected IDataEntityProperty getPropByConfigField(DataEntityPropertyCollection properties, String field) {
        return (IDataEntityProperty)properties.get((Object)field);
    }

    private String getFieldValueByType(IDataEntityProperty property) {
        String value = null;
        Object fieldValue = this.getModel().getValue(property.getName());
        if (fieldValue == null) {
            value = "";
        } else if (property instanceof DateTimeProp) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            value = sdf.format(fieldValue);
        } else if (property instanceof BasedataProp) {
            String numberProp = ((BasedataProp)property).getNumberProp();
            DynamicObject baseDyc = (DynamicObject)fieldValue;
            if (baseDyc != null) {
                value = baseDyc.getString(numberProp);
            }
        } else if (property instanceof MulBasedataProp) {
            DynamicObjectCollection dycs = (DynamicObjectCollection)fieldValue;
            StringBuilder sb = new StringBuilder();
            for (DynamicObject item : dycs) {
                String baseDataEntity = item.getDynamicObject("fbasedataid").getDataEntityType().getName();
                if (baseDataEntity.equals("bd_operator")) {
                    sb.append(item.getDynamicObject("fbasedataid").getString("operatornumber"));
                } else {
                    sb.append(item.getDynamicObject("fbasedataid").getString("number"));
                }
                sb.append(',');
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            value = sb.toString();
        } else {
            value = property instanceof IntegerProp ? ((Integer)fieldValue).toString() : (String)fieldValue;
        }
        value = "\"" + value + "\"";
        return value;
    }

    private List<Object> getBaseDataIds(String paramValue, String baseEntityId) {
        if ("bd_operator".equals(baseEntityId)) {
            return this.getOperatorIds(paramValue, baseEntityId);
        }
        return QueryServiceHelper.queryPrimaryKeys((String)baseEntityId, (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)paramValue.split(","))}, null, (int)-1);
    }

    private List<Object> getOperatorIds(String paramValue, String baseEntityId) {
        String[] numbers;
        HashSet<String> numberList = new HashSet<String>(16);
        for (String number : numbers = paramValue.split(",")) {
            numberList.add(number);
        }
        DynamicObjectCollection operators = QueryServiceHelper.query((String)baseEntityId, (String)"id,operatornumber", (QFilter[])new QFilter[]{new QFilter("operatornumber", "in", numberList)}, null);
        HashMap<String, Long> operatorMap = new HashMap<String, Long>();
        ListIterator iterator = operators.listIterator();
        while (iterator.hasNext()) {
            DynamicObject operator = (DynamicObject)iterator.next();
            String operatorNumber = operator.getString("operatornumber");
            if (operatorMap.containsKey(operatorNumber)) continue;
            operatorMap.put(operatorNumber, operator.getLong("id"));
        }
        return new ArrayList<Object>(operatorMap.values());
    }

    private void callBackFormula() {
        String formulaNumber = (String)this.getView().getFormShowParameter().getCustomParam("accttype");
        List<String> paramNameList = SmBcmFormulaParserHelper.getFormulaParamNameList(formulaNumber);
        DataEntityPropertyCollection properties = this.getModel().getDataEntityType().getProperties();
        ArrayList<String> valueList = new ArrayList<String>(16);
        for (String field : paramNameList) {
            IDataEntityProperty property = this.getPropByConfigField(properties, field);
            String value = this.getFieldValueByType(property);
            valueList.add(value);
        }
        String format = "=%s(%s)";
        String result = String.format(format, formulaNumber, String.join((CharSequence)",", valueList));
        this.getView().returnDataToParent((Object)result);
        this.getView().close();
    }

    private void showFormula() {
        String formulaNumber = (String)this.getView().getFormShowParameter().getCustomParam("accttype");
        if (formulaNumber == null) {
            return;
        }
        String formulaStr = (String)this.getView().getFormShowParameter().getCustomParam("formula");
        Map<String, String> fieldValueMap = SmBcmFormulaParserHelper.explainFormulaValue(formulaNumber, formulaStr);
        List<String> paramNameList = SmBcmFormulaParserHelper.getFormulaParamNameList(formulaNumber);
        DataEntityPropertyCollection properties = this.getModel().getDataEntityType().getProperties();
        if (formulaStr != null) {
            String[] paramValues = formulaStr.split("\",\"");
            int minLength = Math.min(paramValues.length, paramNameList.size());
            for (int i = 0; i < minLength; ++i) {
                List<Object> ids;
                String baseEntityId;
                String fieldKey = paramNameList.get(i);
                IDataEntityProperty property = this.getPropByConfigField(properties, fieldKey);
                if (property == null) continue;
                String formFieldKey = property.getName();
                String paramValue = fieldValueMap.get(fieldKey);
                if (!StringUtils.isNotEmpty((String)paramValue)) continue;
                if (property instanceof BasedataProp) {
                    baseEntityId = ((BasedataProp)property).getBaseEntityId();
                    ids = this.getBaseDataIds(paramValue, baseEntityId);
                    if (ids.size() <= 0) continue;
                    this.getModel().setValue(formFieldKey, ids.get(0));
                    continue;
                }
                if (property instanceof MulBasedataProp) {
                    baseEntityId = ((MulBasedataProp)property).getBaseEntityId();
                    ids = this.getBaseDataIds(paramValue, baseEntityId);
                    if (ids.size() <= 0) continue;
                    this.getModel().setValue(formFieldKey, (Object)ids.toArray());
                    continue;
                }
                this.getModel().setValue(formFieldKey, (Object)paramValue);
            }
        }
    }
}

