/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report.customersyn;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.scmc.sm.report.customersyn.SalCustomerTransform;
import kd.scmc.sm.report.helper.MultiOrganHelper;

public class SalCustomerSynRptHandle
implements IReportDataHandle {
    private static final String HEAD_ORG = "head_org";

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        List<QFilter> filters = SalCustomerSynRptHandle.getFilters(ctx.getParams());
        DynamicObjectCollection org = (DynamicObjectCollection)ctx.getParam(HEAD_ORG);
        List<Long> listOrgId = MultiOrganHelper.getAllOrg(org, true);
        long userId = UserServiceHelper.getCurrentUserId();
        QFilter q = MultiOrganHelper.getOrgGrpIsolationQfilter(listOrgId);
        filters.add(q);
        for (SrcBlockConf srcBlockConf : blockCollector) {
            String srcEntity = srcBlockConf.getSrcEntity();
            if (!"sm_salorder".equalsIgnoreCase(srcEntity)) continue;
            QFilter dataFs = srcBlockConf.getDataFs();
            if (dataFs == null) {
                dataFs = QFilter.of((String)"1=1", (Object[])new Object[0]);
            }
            for (QFilter filter : filters) {
                dataFs.and(filter);
            }
            srcBlockConf.setDataFs(dataFs);
        }
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        repoColFilter.add("exchangerate");
        repoColFilter.add("aramount");
        repoColFilter.add("receiptamount");
        repoColFilter.add("invqty");
        repoColFilter.add("qty");
        repoColFilter.add("curamountandtax");
        repoColFilter.add("id");
    }

    public void handleBlockDataSelectCols(Set<String> repoColFilter, SrcBlockConf blockConf, ReportDataCtx ctx) {
        String srcEntity = blockConf.getSrcEntity();
        if ("sm_salorder".equals(srcEntity)) {
            Map repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
            repoColFullSrcColMap.putIfAbsent("exchangerate", "exchangerate");
            repoColFullSrcColMap.putIfAbsent("aramount", "billentry.aramount");
            repoColFullSrcColMap.putIfAbsent("receiptamount", "receiptamount");
            repoColFullSrcColMap.putIfAbsent("invqty", "billentry.invqty");
            repoColFullSrcColMap.putIfAbsent("qty", "billentry.qty");
            repoColFullSrcColMap.putIfAbsent("curamountandtax", "billentry.curamountandtax");
            repoColFullSrcColMap.putIfAbsent("id", "id");
        }
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new SalCustomerTransform());
    }

    public static List<QFilter> getFilters(Map<String, Object> filterInfo) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DynamicObjectCollection orgList = (DynamicObjectCollection)filterInfo.get(HEAD_ORG);
        if (orgList != null && orgList.size() > 0) {
            List<Long> orgIds = SalCustomerSynRptHandle.getBaseDataPkIds(orgList);
            filters.add(new QFilter("org", "in", orgIds));
        }
        Date startDate = (Date)filterInfo.get("startdate");
        filters.add(new QFilter("bizdate", ">=", (Object)SalCustomerSynRptHandle.getStartOrEndDate(startDate, false)));
        Date endDate = (Date)filterInfo.get("enddate");
        filters.add(new QFilter("bizdate", "<=", (Object)SalCustomerSynRptHandle.getStartOrEndDate(endDate, true)));
        DynamicObjectCollection cusColl = (DynamicObjectCollection)filterInfo.get("customerfield");
        if (cusColl != null && cusColl.size() > 0) {
            List ids = MultiOrganHelper.getMasterIds(cusColl);
            filters.add(new QFilter("customer.masterid", "in", ids));
        }
        return filters;
    }

    public static Date getStartOrEndDate(Date date, boolean isEnd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (isEnd) {
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
        } else {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
        }
        return cal.getTime();
    }

    public static List<Long> getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> pkIds = new ArrayList<Long>(col.size());
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds.add(Long.parseLong(baseData.getPkValue().toString()));
        }
        return pkIds;
    }
}

