/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report.customersyn;

import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.scmc.sm.report.customersyn.SalCusLDGroupFunction;
import kd.scmc.sm.report.customersyn.SalCustomerAmountFunction;

public class SalCustomerTransform
implements IDataXTransform {
    public DataSetX doTransform(DataSetX srcData) {
        if (this.hasField(srcData.getRowMeta(), new String[]{"currency", "customer", "customername", "payeeamount", "deliveramount", "receiveamount", "salamount", "lastsaldate"})) {
            DataSetX amount = srcData.reduceGroup((GroupReduceFunction)new SalCustomerAmountFunction());
            DataSetX result = amount.groupBy(new String[]{"currency", "customer", "customername"}).sum("payeeamount").sum("deliveramount").sum("receiveamount").sum("salamount").max("lastsaldate", "newlastsaldate");
            DataSetX finish = result.leftJoin(amount).on("customer", "customer").on("currency", "currency").select(new String[]{"newlastsaldate"}, srcData.getRowMeta().getFieldNames()).reduceGroup((GroupReduceFunction)new SalCusLDGroupFunction());
            return finish;
        }
        return srcData;
    }

    private boolean hasField(RowMeta rowMeta, String[] fields) {
        for (String field : fields) {
            Field metaField = rowMeta.getField(field, false);
            if (metaField != null) continue;
            return false;
        }
        return true;
    }
}

