/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report.deliverplan;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.scmc.sm.report.deliverplan.SmDeliverTransform;
import kd.scmc.sm.report.deliverplan.SmPlanGroupTransform;
import kd.scmc.sm.report.helper.MultiOrganHelper;

public class SalDeliverplanHandle
implements IReportDataHandle {
    private static final String HEAD_ORG = "head_org";

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        List<QFilter> filters = SalDeliverplanHandle.getFilters(ctx.getParams());
        DynamicObjectCollection orgList = (DynamicObjectCollection)ctx.getParam(HEAD_ORG);
        List<Long> listOrgId = MultiOrganHelper.getAllOrg(orgList, true);
        long userId = UserServiceHelper.getCurrentUserId();
        QFilter q = null;
        DynamicObjectCollection operatorgroups = (DynamicObjectCollection)ctx.getParam("operategroupfield");
        if (null == operatorgroups || operatorgroups.size() == 0) {
            q = MultiOrganHelper.getOrgGrpIsolationQfilter(listOrgId);
        }
        filters.add(q);
        for (SrcBlockConf srcBlockConf : blockCollector) {
            String srcEntity = srcBlockConf.getSrcEntity();
            if (!"sm_salorder".equalsIgnoreCase(srcEntity)) continue;
            QFilter dataFs = srcBlockConf.getDataFs();
            if (dataFs == null) {
                dataFs = QFilter.of((String)"1=1", (Object[])new Object[0]);
            }
            for (QFilter filter : filters) {
                dataFs.and(filter);
            }
            srcBlockConf.setDataFs(dataFs);
        }
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        repoColFilter.add("plantodelivernum");
        repoColFilter.add("actualtodelivernum");
        repoColFilter.add("closestatus");
        repoColFilter.add("rowclosestatus");
        repoColFilter.add("rowterminatestatus");
        repoColFilter.add("billstatus");
        repoColFilter.add("changestatus");
        repoColFilter.add("plandeliverydate");
        repoColFilter.add("actdeliverydate");
        repoColFilter.add("customername");
        repoColFilter.add("materialname");
    }

    public void handleBlockDataSelectCols(Set<String> repoColFilter, SrcBlockConf blockConf, ReportDataCtx ctx) {
        String srcEntity = blockConf.getSrcEntity();
        if ("sm_salorder".equals(srcEntity)) {
            Map repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
            repoColFullSrcColMap.putIfAbsent("actualtodelivernum", "billentry.orderdeliverentry.d_actqty");
            repoColFullSrcColMap.putIfAbsent("plantodelivernum", "billentry.orderdeliverentry.d_planqty");
            repoColFullSrcColMap.putIfAbsent("closestatus", "closestatus");
            repoColFullSrcColMap.putIfAbsent("rowclosestatus", "billentry.rowclosestatus");
            repoColFullSrcColMap.putIfAbsent("rowterminatestatus", "billentry.rowterminatestatus");
            repoColFullSrcColMap.putIfAbsent("billstatus", "billstatus");
            repoColFullSrcColMap.putIfAbsent("changestatus", "changestatus");
            repoColFullSrcColMap.putIfAbsent("plandeliverydate", "billentry.orderdeliverentry.d_plandeliverydate");
            repoColFullSrcColMap.putIfAbsent("actdeliverydate", "billentry.orderdeliverentry.d_actdeliverydate");
            repoColFullSrcColMap.putIfAbsent("unit", "billentry.unit");
            repoColFullSrcColMap.putIfAbsent("customername", "customer.name");
            repoColFullSrcColMap.putIfAbsent("materialname", "billentry.material.masterid.name");
        }
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new SmDeliverTransform());
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new SmPlanGroupTransform());
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        ArrayList<AbstractReportColumn> columnList = new ArrayList<AbstractReportColumn>(cols.size());
        ReportColumnGroup efg = new ReportColumnGroup();
        efg.setCaption(ResManager.getLocaleString((String)"\u5b9e\u9645\u5b8c\u6210", (String)"DeliverPlanHandle_11", (String)"scmc-sm-report"));
        efg.setFieldKey("actfinnish");
        for (AbstractReportColumn col : cols) {
            if (col instanceof ReportColumn) {
                ReportColumn column = (ReportColumn)col;
                switch (column.getFieldKey()) {
                    case "customer": {
                        column.setCaption(ResManager.getLocaleString((String)"\u8ba2\u8d27\u5ba2\u6237\u7f16\u7801", (String)"DeliverPlanHandle_0", (String)"scmc-sm-report"));
                        break;
                    }
                    case "customer_ref_name": {
                        column.setCaption(ResManager.getLocaleString((String)"\u8ba2\u8d27\u5ba2\u6237\u540d\u79f0", (String)"DeliverPlanHandle_1", (String)"scmc-sm-report"));
                        break;
                    }
                    case "material": {
                        column.setCaption(ResManager.getLocaleString((String)"\u7269\u6599\u7f16\u7801", (String)"DeliverPlanHandle_2", (String)"scmc-sm-report"));
                        break;
                    }
                    case "material_ref_name": {
                        column.setCaption(ResManager.getLocaleString((String)"\u7269\u6599\u540d\u79f0", (String)"DeliverPlanHandle_3", (String)"scmc-sm-report"));
                        break;
                    }
                    case "operatorgroup": {
                        column.setCaption(ResManager.getLocaleString((String)"\u9500\u552e\u7ec4", (String)"DeliverPlanHandle_4", (String)"scmc-sm-report"));
                        break;
                    }
                    case "operator": {
                        column.setCaption(ResManager.getLocaleString((String)"\u9500\u552e\u5458", (String)"DeliverPlanHandle_5", (String)"scmc-sm-report"));
                        break;
                    }
                    case "ontimenum": 
                    case "overduenum": {
                        efg.getChildren().add(column);
                        column = null;
                        break;
                    }
                    case "finnishrate": {
                        column.setNoDisplayScaleZero(false);
                        column.setScale(2);
                    }
                }
                columnList.add((AbstractReportColumn)column);
                continue;
            }
            columnList.add(col);
        }
        if (!efg.getChildren().isEmpty()) {
            int insertIndex = this.getInsertIndex(columnList);
            if (insertIndex == -1) {
                columnList.add((AbstractReportColumn)efg);
            } else {
                columnList.set(insertIndex, (AbstractReportColumn)efg);
            }
        }
        return columnList.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    private int getInsertIndex(List<AbstractReportColumn> columnList) {
        for (int i = 0; i < columnList.size(); ++i) {
            if (columnList.get(i) != null) continue;
            return i;
        }
        return -1;
    }

    public static List<QFilter> getFilters(Map<String, Object> filterInfo) {
        DynamicObjectCollection cusColl;
        DynamicObjectCollection operators;
        DynamicObjectCollection operatorgroups;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DynamicObjectCollection orgList = (DynamicObjectCollection)filterInfo.get(HEAD_ORG);
        if (orgList != null && orgList.size() > 0) {
            Object[] orgIds = SalDeliverplanHandle.getBaseDataPkIds(orgList);
            filters.add(new QFilter("org", "in", (Object)orgIds));
        }
        Date startDate = (Date)filterInfo.get("startdate");
        filters.add(new QFilter("billentry.orderdeliverentry.d_plandeliverydate", ">=", (Object)SalDeliverplanHandle.getStartOrEndDate(startDate, false)));
        Date endDate = (Date)filterInfo.get("enddate");
        filters.add(new QFilter("billentry.orderdeliverentry.d_plandeliverydate", "<=", (Object)SalDeliverplanHandle.getStartOrEndDate(endDate, true)));
        DynamicObjectCollection materials = (DynamicObjectCollection)filterInfo.get("materialfield");
        if (materials != null && materials.size() > 0) {
            Object[] materialIdS = SalDeliverplanHandle.getBaseDataPkIds(materials);
            filters.add(new QFilter("billentry.material.masterid", "in", (Object)materialIdS));
        } else {
            filters.add(QFilter.isNotNull((String)"billentry.material.masterid"));
        }
        DynamicObjectCollection bizdepts = (DynamicObjectCollection)filterInfo.get("deptfield");
        if (bizdepts != null && bizdepts.size() > 0) {
            Object[] bizdeptsIds = SalDeliverplanHandle.getBaseDataPkIds(bizdepts);
            filters.add(new QFilter("dept", "in", (Object)bizdeptsIds));
        }
        if ((operatorgroups = (DynamicObjectCollection)filterInfo.get("operategroupfield")) != null && operatorgroups.size() > 0) {
            Object[] bizoperatorgroupIds = SalDeliverplanHandle.getBaseDataPkIds(operatorgroups);
            filters.add(new QFilter("operatorgroup", "in", (Object)bizoperatorgroupIds));
        }
        if ((operators = (DynamicObjectCollection)filterInfo.get("operatorfield")) != null && operators.size() > 0) {
            Object[] bizoperatorgroupIds = SalDeliverplanHandle.getBaseDataPkIds(operators);
            filters.add(new QFilter("operator", "in", (Object)bizoperatorgroupIds));
        }
        if ((cusColl = (DynamicObjectCollection)filterInfo.get("customerfield")) != null && cusColl.size() > 0) {
            List ids = MultiOrganHelper.getMasterIds(cusColl);
            filters.add(new QFilter("customer.masterid", "in", ids));
        }
        return filters;
    }

    public static Date getStartOrEndDate(Date date, boolean isEnd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (isEnd) {
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
        } else {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
        }
        return cal.getTime();
    }

    private static Object[] getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return null;
        }
        Object[] pkIds = new Object[col.size()];
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds[i] = baseData.getPkValue();
        }
        return pkIds;
    }
}

