/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report.deliveryrate;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;

public class DeliverNumberFunction
extends GroupReduceFunction {
    private Date startDate;
    private Date endDate;

    public DeliverNumberFunction(Date startDate, Date endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        RowMeta rowMeta = this.getSourceRowMeta();
        int deliveryDateIndex = rowMeta.getFieldIndex("deliverydate");
        int expireOrderNumIndex = rowMeta.getFieldIndex("expireordernum");
        int todayNumIndex = rowMeta.getFieldIndex("todaynum");
        int overdueNumIndex = rowMeta.getFieldIndex("overduenum");
        int onTimeNumIndex = rowMeta.getFieldIndex("ontimenum");
        int overNumIndex = rowMeta.getFieldIndex("overnum");
        int bizTimeIndex = rowMeta.getFieldIndex("biztime");
        int invQtyIndex = rowMeta.getFieldIndex("invqty");
        int qtyIndex = rowMeta.getFieldIndex("qty");
        int rowCloseStatusIndex = rowMeta.getFieldIndex("rowclosestatus");
        int rowTerminateStatusIndex = rowMeta.getFieldIndex("rowterminatestatus");
        int closeStatusIndex = rowMeta.getFieldIndex("closestatus");
        for (RowX rowX : iterable) {
            Date deliveryDate = rowX.getDate(deliveryDateIndex);
            if (deliveryDate == null) continue;
            if (deliveryDate.compareTo(this.startDate) >= 0 && deliveryDate.compareTo(this.endDate) <= 0) {
                rowX.set(expireOrderNumIndex, (Object)1);
            } else {
                rowX.set(expireOrderNumIndex, (Object)0);
            }
            BigDecimal invQty = rowX.getBigDecimal(invQtyIndex);
            BigDecimal qty = rowX.getBigDecimal(qtyIndex);
            String rowCloseStatus = rowX.getString(rowCloseStatusIndex);
            String rowTerminateStatus = rowX.getString(rowTerminateStatusIndex);
            String closeStatus = rowX.getString(closeStatusIndex);
            if (invQty.compareTo(qty) < 0 && "A".equalsIgnoreCase(rowCloseStatus) && "A".equalsIgnoreCase(rowTerminateStatus) && "A".equalsIgnoreCase(closeStatus)) {
                rowX.set(todayNumIndex, (Object)1);
            } else {
                rowX.set(todayNumIndex, (Object)0);
            }
            if (deliveryDate.compareTo(this.startDate) >= 0 && deliveryDate.compareTo(this.endDate) <= 0 && invQty.compareTo(qty) < 0 && "A".equalsIgnoreCase(rowCloseStatus) && "A".equalsIgnoreCase(rowTerminateStatus) && "A".equals(closeStatus)) {
                rowX.set(overdueNumIndex, (Object)1);
            } else {
                rowX.set(overdueNumIndex, (Object)0);
            }
            int onTimeNum = 0;
            Date bizDate = rowX.getDate(bizTimeIndex);
            if (deliveryDate.compareTo(this.startDate) >= 0 && deliveryDate.compareTo(this.endDate) <= 0) {
                if (bizDate == null || bizDate != null && deliveryDate.compareTo(bizDate) >= 0) {
                    if (invQty.compareTo(qty) < 0) {
                        if ("B".equalsIgnoreCase(rowCloseStatus) || "B".equalsIgnoreCase(rowTerminateStatus) || "A".equalsIgnoreCase(rowTerminateStatus) && "B".equalsIgnoreCase(closeStatus) && "A".equalsIgnoreCase(rowCloseStatus)) {
                            onTimeNum = 1;
                        }
                    } else if (invQty.compareTo(qty) >= 0) {
                        onTimeNum = 1;
                    }
                } else if ("B".equalsIgnoreCase(closeStatus) && invQty.compareTo(BigDecimal.ZERO) == 0) {
                    onTimeNum = 1;
                }
            }
            rowX.set(onTimeNumIndex, (Object)onTimeNum);
            if (deliveryDate.compareTo(this.startDate) >= 0 && deliveryDate.compareTo(this.endDate) <= 0 && bizDate != null && (deliveryDate.compareTo(bizDate) < 0 && invQty.compareTo(qty) >= 0 || deliveryDate.compareTo(bizDate) < 0 && invQty.compareTo(qty) < 0 && "B".equals(rowCloseStatus) || deliveryDate.compareTo(bizDate) < 0 && invQty.compareTo(qty) < 0 && "B".equals(rowTerminateStatus) || deliveryDate.compareTo(bizDate) < 0 && invQty.compareTo(qty) < 0 && "B".equals(closeStatus) && "A".equals(rowTerminateStatus))) {
                rowX.set(overNumIndex, (Object)1);
            } else {
                rowX.set(overNumIndex, (Object)0);
            }
            collector.collect(rowX);
        }
    }

    public RowMeta getResultRowMeta() {
        return this.getSourceRowMeta();
    }
}

