/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report.deliveryrate;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.scmc.sm.report.deliveryrate.DeliveryTimeRateTransform;
import kd.scmc.sm.report.helper.MultiOrganHelper;

public class DeliveryTimeRateRptHandle
implements IReportDataHandle {
    private static final String BIZOPTERATOR = "bizoperator";
    private static final String BIZOPERATORGROUP = "bizoperatorgroup";
    private static final String BIZCUSTOMERS = "bizcustomers";
    private static final String HEAD_ORG = "head_org";

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        for (SrcBlockConf srcBlockConf : blockCollector) {
            DynamicObjectCollection customers;
            DynamicObjectCollection bizoperatorgroups;
            DynamicObjectCollection operators;
            DynamicObjectCollection orgList;
            String srcEntity = srcBlockConf.getSrcEntity();
            if (!"sm_salorder".equalsIgnoreCase(srcEntity)) continue;
            QFilter dataFs = srcBlockConf.getDataFs();
            if (dataFs == null) {
                dataFs = QFilter.of((String)"1=1", (Object[])new Object[0]);
            }
            if ((orgList = (DynamicObjectCollection)ctx.getParam(HEAD_ORG)) != null && orgList.size() > 0) {
                List orgIds = MultiOrganHelper.getBaseDataIds(orgList);
                dataFs.and(new QFilter("org", "in", orgIds));
            }
            if ((operators = (DynamicObjectCollection)ctx.getParam(BIZOPTERATOR)) != null && operators.size() > 0) {
                List bizoperatorIds = MultiOrganHelper.getBaseDataIds(operators);
                dataFs.and(new QFilter("operator", "in", bizoperatorIds));
            }
            if ((bizoperatorgroups = (DynamicObjectCollection)ctx.getParam(BIZOPERATORGROUP)) != null && bizoperatorgroups.size() > 0) {
                List bizoperatorgroupIds = MultiOrganHelper.getBaseDataIds(bizoperatorgroups);
                dataFs.and(new QFilter("operatorgroup", "in", bizoperatorgroupIds));
            }
            if ((customers = (DynamicObjectCollection)ctx.getParam(BIZCUSTOMERS)) != null && customers.size() > 0) {
                Set<Object> customersIds = this.getMasterIDs(customers);
                dataFs.and(new QFilter("customer.masterid", "in", customersIds));
            }
            Date startDate = this.getStartDate((Date)ctx.getParam("startdate"));
            Date endDate = this.getEndDate((Date)ctx.getParam("enddate"));
            QFilter deliveryRangeFilter = new QFilter("billentry.deliverydate", "<=", (Object)endDate).and(new QFilter("billentry.deliverydate", ">=", (Object)startDate));
            QFilter deliveryTodayFilter = new QFilter("billentry.deliverydate", "=", (Object)DeliveryTimeRateRptHandle.getDate(TimeServiceHelper.today()));
            dataFs.and(deliveryRangeFilter.or(deliveryTodayFilter));
        }
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        repoColFilter.add("id");
        repoColFilter.add("entryid");
        repoColFilter.add("auditdate");
        repoColFilter.add("closestatus");
        repoColFilter.add("unit");
        repoColFilter.add("qty");
        repoColFilter.add("invqty");
        repoColFilter.add("deliverydate");
        repoColFilter.add("rowclosestatus");
        repoColFilter.add("rowterminatestatus");
        repoColFilter.add("expireordernum");
        repoColFilter.add("todaynum");
        repoColFilter.add("overduenum");
        repoColFilter.add("ontimenum");
        repoColFilter.add("overnum");
        repoColFilter.add("delivertimerate");
        repoColFilter.add("operatorgroup");
        repoColFilter.add("operator");
    }

    public void handleBlockDataSelectCols(Set<String> repoColFilter, SrcBlockConf blockConf, ReportDataCtx ctx) {
        String srcEntity = blockConf.getSrcEntity();
        if ("sm_salorder".equals(srcEntity)) {
            Map repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
            repoColFullSrcColMap.putIfAbsent("id", "id");
            repoColFullSrcColMap.putIfAbsent("entryid", "billentry.id");
            Map repoColSrcColMap = blockConf.getRepoColSrcColMap();
            repoColSrcColMap.putIfAbsent("id", "id");
            repoColSrcColMap.putIfAbsent("entryid", "entryid");
        }
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new DeliveryTimeRateTransform(ctx));
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        LinkedList<AbstractReportColumn> showCols = new LinkedList<AbstractReportColumn>();
        LinkedList<AbstractReportColumn> shippingColumns = new LinkedList<AbstractReportColumn>();
        LinkedList<AbstractReportColumn> deliveredColumns = new LinkedList<AbstractReportColumn>();
        AbstractReportColumn rate = null;
        for (AbstractReportColumn col : cols) {
            ReportColumn column = (ReportColumn)col;
            String fieldKey = column.getFieldKey();
            if ("todaynum".equals(fieldKey) || "overduenum".equals(fieldKey)) {
                shippingColumns.add(col);
                continue;
            }
            if ("ontimenum".equals(fieldKey) || "overnum".equals(fieldKey)) {
                deliveredColumns.add(col);
                continue;
            }
            if ("delivertimerate".equals(fieldKey)) {
                ((ReportColumn)col).setNoDisplayScaleZero(false);
                ((ReportColumn)col).setScale(2);
                rate = col;
                continue;
            }
            showCols.add(col);
        }
        LocaleString shipCaption = ResManager.getLocaleString((String)"\u5f85\u53d1\u8d27", (String)"DeliveryTimeRateRptHandle_0", (String)"scmc-sm-report");
        ReportColumnGroup dropShipping = this.createColumnGroup("dropshipping", shipCaption, shippingColumns);
        showCols.add((AbstractReportColumn)dropShipping);
        LocaleString deliveredCaption = ResManager.getLocaleString((String)"\u5df2\u53d1\u8d27", (String)"DeliveryTimeRateRptHandle_1", (String)"scmc-sm-report");
        ReportColumnGroup delivered = this.createColumnGroup("delivered", deliveredCaption, deliveredColumns);
        showCols.add((AbstractReportColumn)delivered);
        showCols.add(rate);
        return showCols;
    }

    private ReportColumnGroup createColumnGroup(String groupKey, LocaleString caption, List<AbstractReportColumn> columns) {
        ReportColumnGroup columnGroup = new ReportColumnGroup();
        columnGroup.setCaption(caption);
        columnGroup.setFieldKey(groupKey);
        columnGroup.getChildren().addAll(columns);
        return columnGroup;
    }

    private Date getStartDate(Date date) {
        return DeliveryTimeRateRptHandle.getDate(date);
    }

    public static Date getDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(10, 0);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private Date getEndDate(Date date) {
        Date endDate = new Date();
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String format = sdf.format(date) + " 23:59:59";
        try {
            endDate = sdf1.parse(format);
        }
        catch (ParseException e) {
            throw new KDBizException(e.getMessage());
        }
        return endDate;
    }

    private Set<Object> getMasterIDs(DynamicObjectCollection col) {
        return col.stream().map(a -> a.getLong("fbasedataid.masterid")).collect(Collectors.toSet());
    }
}

