/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report.deliveryrate;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.scmc.sm.business.helper.OrgHelper;
import kd.scmc.sm.report.helper.MultiOrganHelper;
import kd.scmc.sm.report.helper.SmDeliveryTimeRateRptHelper;

public class DeliveryTimeRateRptPlugin
extends AbstractReportFormPlugin
implements ClickListener,
BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(DeliveryTimeRateRptPlugin.class);
    private static final String BIZOPTERATOR = "bizoperator";
    private static final String BIZOPERATORGROUP = "bizoperatorgroup";
    private static final String BIZCUSTOMERS = "bizcustomers";
    private static final String HEAD_ORG = "head_org";

    public void registerListener(EventObject e) {
        BasedataEdit bizoperatorgroup;
        BasedataEdit bizoperator;
        BasedataEdit customer;
        super.registerListener(e);
        Button fresh = (Button)this.getView().getControl("fresh");
        fresh.addClickListener((ClickListener)this);
        BasedataEdit org = (BasedataEdit)this.getView().getControl(HEAD_ORG);
        if (org != null) {
            org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((customer = (BasedataEdit)this.getView().getControl(BIZCUSTOMERS)) != null) {
            customer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((bizoperator = (BasedataEdit)this.getView().getControl(BIZOPTERATOR)) != null) {
            bizoperator.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((bizoperatorgroup = (BasedataEdit)this.getView().getControl(BIZOPERATORGROUP)) != null) {
            bizoperatorgroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObjectCollection operateGroup;
        this.getView().setEnable(Boolean.FALSE, new String[]{"daterangefield"});
        Date[] weekDate = SmDeliveryTimeRateRptHelper.getWeekDate();
        this.getModel().setValue("startdate", (Object)weekDate[0]);
        this.getModel().setValue("enddate", (Object)weekDate[1]);
        this.init(weekDate);
        String formId = this.getView().getFormShowParameter().getFormId();
        List orgList = OrgHelper.getHasPermissionOrg((String)formId, (String)"03");
        if (orgList != null && orgList.size() > 0) {
            long orgId = RequestContext.get().getOrgId();
            if (orgList.contains(orgId)) {
                this.getModel().setValue(HEAD_ORG, (Object)new Object[]{orgId});
            } else {
                this.getModel().setValue(HEAD_ORG, (Object)new Object[]{orgList.get(0)});
            }
        }
        if ((operateGroup = (DynamicObjectCollection)this.getModel().getValue(BIZOPERATORGROUP)) == null || operateGroup.size() == 0) {
            this.getView().setEnable(Boolean.FALSE, new String[]{BIZOPTERATOR});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{BIZOPTERATOR});
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        queryParam.getCustomParam().put("startdate", this.getModel().getValue("startdate"));
        queryParam.getCustomParam().put("enddate", this.getModel().getValue("enddate"));
        queryParam.getCustomParam().put(HEAD_ORG, this.getModel().getValue(HEAD_ORG));
        queryParam.getCustomParam().put(BIZCUSTOMERS, this.getModel().getValue(BIZCUSTOMERS));
        queryParam.getCustomParam().put(BIZOPTERATOR, this.getModel().getValue(BIZOPTERATOR));
        queryParam.getCustomParam().put(BIZOPERATORGROUP, this.getModel().getValue(BIZOPERATORGROUP));
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
        Object org = this.getView().getModel().getValue(HEAD_ORG);
        String formId = this.getView().getFormShowParameter().getFormId();
        List<Long> listOrgId = null;
        switch (key) {
            case "head_org": {
                List orgList = OrgHelper.getHasPermissionOrg((String)formId, (String)OrgViewTypeEnum.IS_SALE.getViewType());
                formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)orgList));
                break;
            }
            case "bizcustomers": {
                if (org == null || ((DynamicObjectCollection)org).isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SmDeliveryTimeRateRptPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                listOrgId = MultiOrganHelper.getBaseDataLongIds(this.getView(), HEAD_ORG);
                QFilter bd_customer = MultiOrganHelper.getBaseDataFilter("bd_customer", listOrgId);
                if (bd_customer == null) break;
                formShowParameter.getListFilterParameter().setFilter(bd_customer);
                formShowParameter.setShowApproved(false);
                break;
            }
            case "bizoperatorgroup": {
                if (org == null || ((DynamicObjectCollection)org).isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SmDeliveryTimeRateRptPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                listOrgId = MultiOrganHelper.getAllOrg(org, false);
                QFilter f = MultiOrganHelper.getOrgGrpQfilter(listOrgId);
                formShowParameter.getListFilterParameter().setFilter(f);
                QFilter bd_operatorgroup = MultiOrganHelper.getBaseDataFilter("bd_operatorgroup", listOrgId);
                if (bd_operatorgroup == null) break;
                formShowParameter.getListFilterParameter().setFilter(bd_operatorgroup);
                formShowParameter.setShowApproved(false);
                break;
            }
            case "bizoperator": {
                if (org == null || ((DynamicObjectCollection)org).isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SmDeliveryTimeRateRptPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                DynamicObjectCollection operateGroup = (DynamicObjectCollection)this.getModel().getValue(BIZOPERATORGROUP);
                if (operateGroup == null || operateGroup.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u3002", (String)"SmDeliveryTimeRateRptPlugin_2", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                List<Long> groups = MultiOrganHelper.getBaseDataIds(operateGroup);
                DeliveryTimeRateRptPlugin.getOperatorGroupByUser(groups, formShowParameter);
                break;
            }
        }
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        BigDecimal todaynum = BigDecimal.ZERO;
        BigDecimal overduenum = BigDecimal.ZERO;
        BigDecimal overnum = BigDecimal.ZERO;
        BigDecimal ontimenum = BigDecimal.ZERO;
        BigDecimal expireordernum = BigDecimal.ZERO;
        for (DynamicObject rowDatum : rowData) {
            todaynum = todaynum.add(rowDatum.getBigDecimal("todaynum").setScale(0, 4));
            overduenum = overduenum.add(rowDatum.getBigDecimal("overduenum").setScale(0, 4));
            overnum = overnum.add(rowDatum.getBigDecimal("overnum").setScale(0, 4));
            ontimenum = ontimenum.add(rowDatum.getBigDecimal("ontimenum").setScale(2, 4));
            expireordernum = expireordernum.add(rowDatum.getBigDecimal("expireordernum").setScale(0, 4));
        }
        Label labelap5 = (Label)this.getControl("labelap5");
        labelap5.setText(todaynum.toString());
        Label labelap6 = (Label)this.getControl("labelap6");
        labelap6.setText(overduenum.toString());
        Label labelap8 = (Label)this.getControl("labelap8");
        labelap8.setText(overnum.toString());
        Label labelap13 = (Label)this.getControl("labelap13");
        labelap13.setText(expireordernum.toString());
        Label labelap10 = (Label)this.getControl("labelap10");
        if (ontimenum != BigDecimal.ZERO && expireordernum != BigDecimal.ZERO) {
            BigDecimal delivertimerate = ontimenum.multiply(new BigDecimal(100)).divide(expireordernum, 2, 4);
            labelap10.setText(delivertimerate.toString() + "%");
        } else {
            labelap10.setText(BigDecimal.ZERO.toString() + ".00%");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        switch (key) {
            case "startdate": 
            case "enddate": {
                this.changeDate(key, e);
                break;
            }
            case "daterange": {
                if ("A".equals(newValue)) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"daterangefield"});
                    Date[] weekDate = SmDeliveryTimeRateRptHelper.getWeekDate();
                    this.getModel().setValue("startdate", (Object)weekDate[0]);
                    this.getModel().setValue("enddate", (Object)weekDate[1]);
                    break;
                }
                if ("B".equals(newValue)) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"daterangefield"});
                    Date[] thisMonth = SmDeliveryTimeRateRptHelper.getThisMonth();
                    this.getModel().setValue("startdate", (Object)thisMonth[0]);
                    this.getModel().setValue("enddate", (Object)thisMonth[1]);
                    break;
                }
                if ("C".equals(newValue)) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"daterangefield"});
                    Date[] recentThreeMonths = SmDeliveryTimeRateRptHelper.getRecentThreeMonths();
                    this.getModel().setValue("startdate", (Object)recentThreeMonths[0]);
                    this.getModel().setValue("enddate", (Object)recentThreeMonths[1]);
                    break;
                }
                this.getView().setEnable(Boolean.TRUE, new String[]{"daterangefield"});
                this.getModel().setValue("startdate", null);
                this.getModel().setValue("enddate", null);
                break;
            }
            case "bizoperatorgroup": {
                this.changeOperatorGroup((DynamicObjectCollection)newValue);
                break;
            }
            case "head_org": {
                this.getModel().setValue(BIZCUSTOMERS, (Object)"");
                this.getModel().setValue(BIZOPTERATOR, (Object)"");
                this.getModel().setValue(BIZOPERATORGROUP, (Object)"");
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        if ("refresh".equals(op.getOperateKey())) {
            Object org;
            Object startdate = this.getModel().getValue("startdate");
            Object enddate = this.getModel().getValue("enddate");
            if (startdate == null && enddate == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u8303\u56f4\u3002", (String)"SmDeliveryTimeRateRptPlugin_0", (String)"scmc-sm-report", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if ((org = this.getView().getModel().getValue(HEAD_ORG)) == null || ((DynamicObjectCollection)org).isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SmDeliveryTimeRateRptPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    private void changeDate(String key, PropertyChangedArgs e) {
        Date startdate = null;
        Date enddate = null;
        Date[] dates = new Date[2];
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if ("startdate".equals(key)) {
            dates[0] = startdate = (Date)e.getChangeSet()[0].getNewValue();
            enddate = (Date)this.getModel().getValue("enddate");
            if (enddate != null) {
                try {
                    String format = sdf.format(enddate) + " 23:59:59";
                    dates[1] = sdf1.parse(format);
                }
                catch (ParseException e1) {
                    log.error(e1.getMessage());
                }
            }
        } else {
            dates[0] = startdate = (Date)this.getModel().getValue("startdate");
            enddate = (Date)e.getChangeSet()[0].getNewValue();
            if (enddate != null) {
                try {
                    String format = sdf.format(enddate) + " 23:59:59";
                    dates[1] = sdf1.parse(format);
                }
                catch (ParseException e1) {
                    log.error(e1.getMessage());
                }
            }
        }
        if (startdate != null && enddate != null) {
            this.init(dates);
        }
    }

    private void init(Date[] dates) {
        ReportQueryParam rqp = this.getQueryParam();
        FilterInfo filter = new FilterInfo();
        ArrayList<FieldEdit> fieldList = new ArrayList<FieldEdit>();
        ArrayList<FilterGrid> filterGridList = new ArrayList<FilterGrid>();
        Container reportfilterap = (Container)this.getControl("reportfilterap");
        this.findFilterField(reportfilterap, fieldList, filterGridList);
        for (FieldEdit fieldEdit : fieldList) {
            filter.addDefaultFilters(fieldEdit.getDefaultFilters());
        }
        ITimeService timeService = (ITimeService)this.getView().getService(ITimeService.class);
        IUserService userService = (IUserService)this.getView().getService(IUserService.class);
        for (FilterGrid f : filterGridList) {
            if (f.getEntityNumber() == null) continue;
            filter.addCommFilter(f.getEntityNumber(), f.getFilterGridState().getFilterCondition(), timeService, userService);
        }
        rqp.getCustomParam().put("startdate", dates[0]);
        rqp.getCustomParam().put("enddate", dates[1]);
        rqp.setFilter(filter);
        ReportCacheManager.getInstance().getCache().setReportQueryParam(this.getView().getPageId(), rqp);
    }

    private static void getOperatorGroupByUser(List<Long> list, ListShowParameter showParameter) {
        if (list.size() > 0) {
            QFilter filter1 = new QFilter("operatorgrpid", "in", list);
            showParameter.getListFilterParameter().setFilter(filter1);
        }
    }

    private void changeOperatorGroup(DynamicObjectCollection operatorGroup) {
        if (operatorGroup == null || operatorGroup.size() == 0) {
            this.getModel().setValue(BIZOPTERATOR, null);
            this.getView().setEnable(Boolean.FALSE, new String[]{BIZOPTERATOR});
        } else {
            this.getModel().setValue(BIZOPTERATOR, null);
            this.getView().setEnable(Boolean.TRUE, new String[]{BIZOPTERATOR});
        }
    }

    private void findFilterField(Container cont, List<FieldEdit> fieldList, List<FilterGrid> filterGridList) {
        for (Control ctrl : cont.getItems()) {
            if (ctrl instanceof FieldEdit) {
                fieldList.add((FieldEdit)ctrl);
                continue;
            }
            if (ctrl instanceof FilterGrid) {
                filterGridList.add((FilterGrid)ctrl);
                continue;
            }
            if (!(ctrl instanceof Container) || ctrl instanceof EntryGrid) continue;
            this.findFilterField((Container)ctrl, fieldList, filterGridList);
        }
    }
}

