/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report.formplugin;

import java.math.BigDecimal;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.sm.report.consts.SalReportTaskConst;
import kd.scmc.sm.report.enums.SalReportTaskStatusEnum;

public class SalReportTaskListPlugin
extends AbstractListPlugin {
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        boolean success;
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult != null && (success = operationResult.isSuccess())) {
            if ("taskdetail".equals(args.getOperateKey())) {
                BillList billList = (BillList)this.getView().getControl("billlistap");
                ListSelectedRow selectedRow = billList.getCurrentSelectedRowInfo();
                if (selectedRow != null) {
                    Object srcBillId = null;
                    DynamicObject reportTask = null;
                    if (selectedRow != null && selectedRow.getPrimaryKeyValue() != null) {
                        srcBillId = selectedRow.getPrimaryKeyValue();
                        String selectProperties = SalReportTaskConst.generateSelector("ID", "middlereport", "middlereport", "taskstatus", "progress", "report", "conditionjson", "conditionjson_tag", "reportname");
                        reportTask = BusinessDataServiceHelper.loadSingle((Object)srcBillId, (String)"sm_reporttask", (String)selectProperties);
                    }
                    if (reportTask != null) {
                        String reportStatus = reportTask.getString("taskstatus");
                        BigDecimal progress = reportTask.getBigDecimal("progress");
                        if (!SalReportTaskStatusEnum.COMPLETED.getValue().equals(reportStatus) || BigDecimal.ONE.compareTo(progress) != 0) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u4efb\u52a1\u672a\u5b8c\u6210\u6267\u884c\uff0c\u65e0\u6cd5\u67e5\u770b\u7ed3\u679c\u3002", (String)"ReportTaskListPlugin_0", (String)"scmc-sm-report", (Object[])new Object[0]));
                            this.getView().invokeOperation("refresh");
                            return;
                        }
                        ReportShowParameter showParam = new ReportShowParameter();
                        String reportUI = reportTask.getString("report");
                        String reportName = reportTask.getString("reportname");
                        String conditionjson = reportTask.getString("conditionjson_tag");
                        FilterInfo filterInfo = (FilterInfo)SerializationUtils.deSerializeFromBase64((String)conditionjson);
                        ReportQueryParam param = new ReportQueryParam();
                        param.setFilter(filterInfo);
                        StringBuilder captionBuilder = new StringBuilder(reportName);
                        captionBuilder.append(ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c", (String)"ReportTaskListPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]));
                        showParam.setCaption(captionBuilder.toString());
                        showParam.setFormId(reportUI);
                        showParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                        showParam.setCustomParam("srcbillid", srcBillId);
                        String pageID = reportUI + "_" + srcBillId;
                        showParam.setPageId(pageID);
                        if (reportTask.getDynamicObject("middlereport") == null) {
                            this.getView().showMessage(ResManager.loadKDString((String)"\u62a5\u8868\u4efb\u52a1\u4e2d\u95f4\u8868\u5b9e\u4f53\u4e0d\u5b58\u5728\u3002", (String)"ReportTaskListPlugin_2", (String)"scmc-sm-report", (Object[])new Object[0]));
                            return;
                        }
                        showParam.setCustomParam("middlereport", (Object)reportTask.getDynamicObject("middlereport").getString("number"));
                        showParam.setQueryParam(param);
                        this.getView().showForm((FormShowParameter)showParam);
                        this.getView().invokeOperation("refresh");
                        return;
                    }
                    this.getView().showMessage(ResManager.loadKDString((String)"\u62a5\u8868\u4efb\u52a1\u5df2\u88ab\u5220\u9664\u3002", (String)"ReportTaskListPlugin_3", (String)"scmc-sm-report", (Object[])new Object[0]));
                    this.getView().invokeOperation("refresh");
                    return;
                }
            } else if ("starttask".equals(args.getOperateKey())) {
                this.getView().invokeOperation("refresh");
                return;
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "taskdetail": {
                Long userID = RequestContext.get().getCurrUserId();
                BillList billList = (BillList)this.getControl("billlistap");
                ListSelectedRow listSelectedRow = billList.getCurrentSelectedRowInfo();
                DynamicObject currRowData = BusinessDataServiceHelper.loadSingle((Object)listSelectedRow.getPrimaryKeyValue(), (String)"sm_reporttask");
                Long user = (Long)currRowData.getDynamicObject("user").getPkValue();
                if (user.equals(userID)) break;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u67e5\u770b\u672c\u4eba\u67e5\u8be2\u4efb\u52a1\u7ed3\u679c\u3002", (String)"SalTaskDelValidator_3", (String)"scmc-sm-report", (Object[])new Object[0]), new Object[0]));
                args.setCancel(true);
            }
        }
    }
}

