/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.algox.MapFunction;
import kd.bos.entity.report.FilterInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.sm.report.helper.AbstractSalCrossProfitLogicX;
import kd.scmc.sm.report.helper.SalGrossProfitRptHelper;
import kd.scmc.sm.report.helper.SalGrossProfitXQueryHelper;
import kd.scmc.sm.report.pojo.MidResultInfo;
import kd.scmc.sm.report.salgrossprofit.SalGrossProfitCalVerifyFunction;

public class DeductLogicX
extends AbstractSalCrossProfitLogicX {
    private static final Log log = LogFactory.getLog(DeductLogicX.class);

    @Override
    protected DataSet[] getBusAndVerifyDataSet(List<Long> imEntryIds, Set<Long> imIds, Map<Long, Set<Long>> orgToIDs, FilterInfo filterInfo) {
        log.info("\u6838\u5fc3\u7684\u4e00\u6bb5\u62b5\u6263\u903b\u8f91\u5f00\u59cb");
        log.info("\u4ee5\u9500\u552e\u51fa\u5e93\u4e3a\u57fa\u51c6\u67e5\u8be2\u6838\u9500\u8bb0\u5f55\u5f00\u59cb");
        JobSession verifyAndBusSession = AlgoX.createSession((String)"DeductLogicX");
        SalGrossProfitXQueryHelper queryVerifyAndBusExec = new SalGrossProfitXQueryHelper(verifyAndBusSession);
        DataSetX verifyDataSetX = queryVerifyAndBusExec.queryVerifyDataSet(imEntryIds, orgToIDs, filterInfo);
        verifyDataSetX = verifyDataSetX.map((MapFunction)new SalGrossProfitCalVerifyFunction());
        verifyDataSetX = verifyDataSetX.orderBy(SalGrossProfitRptHelper.getVerifySortFields());
        DataSetOutput verifyOutput = new DataSetOutput(verifyDataSetX.getRowMeta());
        String verifyOutPutId = verifyOutput.getId();
        verifyDataSetX.output((Output)verifyOutput);
        log.info("\u4ee5\u9500\u552e\u51fa\u5e93\u67e5\u8be2\u6682\u4f30\u5e94\u6536\u5355\u8bb0\u5f55\u5f00\u59cb");
        DataSetX busDataSetX = queryVerifyAndBusExec.queryBusDataSet(imEntryIds, imIds, filterInfo);
        busDataSetX = busDataSetX.orderBy(SalGrossProfitRptHelper.getBusSortFields());
        DataSetOutput busOutput = new DataSetOutput(busDataSetX.getRowMeta());
        String busOutputId = busOutput.getId();
        busDataSetX.output((Output)busOutput);
        verifyAndBusSession.commit(7200, TimeUnit.SECONDS);
        DataSet result4Verify = verifyAndBusSession.readDataSet(verifyOutPutId);
        result4Verify = result4Verify.select(SalGrossProfitRptHelper.getVerifyAlisFields());
        log.info("\u4ee5\u9500\u552e\u51fa\u5e93\u4e3a\u57fa\u51c6\u67e5\u8be2\u6838\u9500\u8bb0\u5f55\u7ed3\u675f");
        DataSet result4Bus = verifyAndBusSession.readDataSet(busOutputId);
        result4Bus = result4Bus.select(SalGrossProfitRptHelper.getBusAlisFields());
        log.info("\u4ee5\u9500\u552e\u51fa\u5e93\u4e3a\u57fa\u51c6\u67e5\u8be2\u6682\u4f30\u5e94\u6536\u7ed3\u675f");
        MidResultInfo midResult = new MidResultInfo(result4Bus.getRowMeta(), result4Verify.getRowMeta());
        Field[] fields4Bus = result4Bus.getRowMeta().getFields();
        log.info("\u5f00\u59cb\u6574\u7406\u6682\u4f30\u5e94\u6536\u8bb0\u5f55");
        int busnum = 0;
        HashSet<Long> bus4inventEntryIDSet = new HashSet<Long>();
        try (DataSet result4BusCopy = result4Bus.copy();){
            for (Row busRow : result4BusCopy) {
                ++busnum;
                Long inventEntryID = busRow.getLong("bussrcentryid");
                HashMap<String, Object> busRowMap = new HashMap<String, Object>(fields4Bus.length);
                for (Field field : fields4Bus) {
                    busRowMap.put(field.getName(), busRow.get(field.getName()));
                }
                List s = midResult.getBusRecords().computeIfAbsent(inventEntryID, key -> new ArrayList());
                s.add(busRowMap);
                bus4inventEntryIDSet.add(inventEntryID);
            }
        }
        log.info("\u7ed3\u675f\u6574\u7406\u6682\u4f30\u5e94\u6536\u8bb0\u5f55" + busnum);
        if (midResult.getBusRecords().size() == 0) {
            log.info("\u672a\u68c0\u7d22\u6682\u4f30\u5e94\u6536\uff0c\u6838\u5fc3\u62b5\u6263\u903b\u8f91\u63d0\u524d\u8fd4\u56de\u4e86");
            return new DataSet[]{result4Bus, result4Verify};
        }
        log.info("\u5f00\u59cb\u6574\u7406\u5e94\u6536\u6838\u7b97\u8bb0\u5f55");
        Field[] fields4Verify = result4Verify.getRowMeta().getFields();
        int verifynum = 0;
        if (bus4inventEntryIDSet.size() <= 100000) {
            log.info("\u6682\u4f30\u5e94\u6536\u8bb0\u5f55\u5c11\u4e8e\u7b49\u4e8e100000\u6761");
            HashMap<String, HashSet<Long>> entryIDMap = new HashMap<String, HashSet<Long>>();
            entryIDMap.put("entryids", bus4inventEntryIDSet);
            try (DataSet result4Verify4Bus = result4Verify.copy().filter("billentryid in entryids", entryIDMap);){
                verifynum = this.buildMidResult4Verify(midResult, fields4Verify, verifynum, result4Verify4Bus);
            }
        }
        log.info("\u6682\u4f30\u5e94\u6536\u8bb0\u5f55\u5927\u4e8e100000\u6761");
        try (DataSet result4VerifyCopy = result4Verify.copy();){
            verifynum = this.buildMidResult4Verify(midResult, fields4Verify, verifynum, result4VerifyCopy);
        }
        log.info("\u7ed3\u675f\u6574\u7406\u5e94\u6536\u6838\u7b97\u8bb0\u5f55" + verifynum);
        if (midResult.getVerifyRecords().size() == 0) {
            log.info("\u672a\u68c0\u7d22\u6838\u9500\u8bb0\u5f55\uff0c\u6838\u5fc3\u62b5\u6263\u903b\u8f91\u63d0\u524d\u8fd4\u56de\u4e86");
            return new DataSet[]{result4Bus, result4Verify};
        }
        result4Bus = midResult.match(result4Bus);
        log.info("\u6838\u5fc3\u7684\u4e00\u6bb5\u62b5\u6263\u903b\u8f91\u7ed3\u675f");
        return new DataSet[]{result4Bus, result4Verify};
    }

    @Override
    protected DataSet handldBusDataSet(DataSet totalResult, DataSet busDataSet) {
        GroupbyDataSet groupby = busDataSet.groupBy(new String[]{"bussrcentryid"});
        groupby.sum("busqty");
        groupby.sum("busamount");
        groupby.sum("busamountandtax");
        busDataSet = groupby.finish();
        JoinDataSet join4Bus = totalResult.join(busDataSet, JoinType.LEFT);
        totalResult = join4Bus.on("billentryid", "bussrcentryid").select(SalGrossProfitRptHelper.getSelectField_rightSet("verbaseqty", "localverifyamt", "localverifyamtandtax"), new String[]{"busqty", "busamount", "busamountandtax"}).finish();
        return totalResult;
    }

    @Override
    protected DataSet handldAmount(DataSet amountDataSet) {
        String[] selector = SalGrossProfitRptHelper.getSelectFieldAddExclude(new String[]{"group", "unitcost", "actualcost", "(exchangerate * amount / baseqty * ( baseqty - verbaseqty - busqty ) + localverifyamt + busamount) / baseqty price", "(exchangerate * amountandtax / baseqty * ( baseqty - verbaseqty - busqty ) + localverifyamtandtax + busamountandtax) / baseqty taxprice", "amount*exchangerate*(baseqty - verbaseqty - busqty)/baseqty  amount", "amountandtax*exchangerate*(baseqty - verbaseqty - busqty)/baseqty  amountandtax", "localverifyamt", "busamount", "localverifyamtandtax", "busamountandtax"}, "amount" + "," + "amountandtax");
        amountDataSet = amountDataSet.select(selector);
        return amountDataSet;
    }

    private int buildMidResult4Verify(MidResultInfo midResult, Field[] fields4Verify, int verifynum, DataSet result4VerifyCopy) {
        for (Row verifyRow : result4VerifyCopy) {
            ++verifynum;
            Long inventEntryID = verifyRow.getLong("billentryid");
            HashMap<String, Object> verifyRowMap = new HashMap<String, Object>(fields4Verify.length);
            for (Field field : fields4Verify) {
                verifyRowMap.put(field.getName(), verifyRow.get(field.getName()));
            }
            List s = midResult.getVerifyRecords().computeIfAbsent(inventEntryID, key -> new ArrayList());
            s.add(verifyRowMap);
        }
        return verifynum;
    }
}

