/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report.helper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bd.sbd.enums.OperatorGrpTypeEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.IReportListModel;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.sm.business.helper.AppParameterHelper;
import kd.scmc.sm.business.helper.OperGrpHelper;
import kd.scmc.sm.report.helper.SalRankRptHelper;

public class MultiOrganHelper {
    public static final String F_BASEDATAID = "fbasedataid";

    public static QFilter getBaseDataFilter(String entityID, List<Long> orgIdList) {
        return BaseDataServiceHelper.getBaseDataFilter((String)entityID, orgIdList, (boolean)true);
    }

    public static List<Long> getAllOrg(Object org, boolean isQuery) {
        ArrayList<Long> listOrgId = new ArrayList<Long>();
        if (org instanceof DynamicObject) {
            DynamicObject orgObj = (DynamicObject)org;
            listOrgId.add((Long)orgObj.getPkValue());
        } else if (org instanceof DynamicObjectCollection) {
            for (DynamicObject dynamicObject : (DynamicObjectCollection)org) {
                listOrgId.add(dynamicObject.getLong(isQuery ? "id" : "fbasedataid_id"));
            }
        }
        return listOrgId;
    }

    public static List<Long> getBaseDataLongIds(IReportView view, String col) {
        return MultiOrganHelper.getBaseDataIds(view, col);
    }

    private static <T> List<T> getBaseDataIds(IReportView view, String col) {
        DynamicObjectCollection dys = view.getModel().getDataEntity(true).getDynamicObjectCollection(col);
        return MultiOrganHelper.getBaseDataIds(dys);
    }

    public static <T> List<T> getBaseDataIds(DynamicObjectCollection dys) {
        ArrayList<Object> ids = new ArrayList<Object>(20);
        if (dys != null) {
            for (DynamicObject dy : dys) {
                ids.add(dy.getDynamicObject(F_BASEDATAID).getPkValue());
            }
        }
        return ids;
    }

    public static <T> List<T> getMasterIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return null;
        }
        ArrayList<Object> pks = new ArrayList<Object>();
        for (DynamicObject data : col) {
            pks.add(data.get("masterid"));
        }
        return pks;
    }

    public static DynamicObject getRptRowData(HyperLinkClickEvent e) {
        ReportList reportList = (ReportList)e.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        return reportModel.getRowData(e.getRowIndex());
    }

    public static QFilter getOrgGrpQfilter(List<Long> listOrgId) {
        List<Long> orgGrpList = MultiOrganHelper.getOperatorGroupByOrg(listOrgId);
        QFilter q = new QFilter("id", "in", orgGrpList);
        return q;
    }

    public static QFilter getOrgGrpQfilter(List<Long> listOrgId, Long userId) {
        ArrayList<Long> orgGrpList = new ArrayList<Long>();
        QFilter q = null;
        for (Long orgID : listOrgId) {
            Object operatorGroupIsolate = AppParameterHelper.getSmAppParameter((Long)orgID, (String)"foperatorgroupisolate");
            if (operatorGroupIsolate instanceof Boolean && ((Boolean)operatorGroupIsolate).booleanValue()) {
                HashSet<Long> userIDs = new HashSet<Long>();
                userIDs.add(userId);
                orgGrpList.addAll(OperGrpHelper.getOperatorGroupByUser((Long)orgID, userIDs));
                continue;
            }
            orgGrpList.addAll(SalRankRptHelper.getOperatorGroupByOrg(orgID));
        }
        q = new QFilter("id", "in", orgGrpList);
        return q;
    }

    public static List<Long> getOperatorGroupByOrg(List<Long> allOrg) {
        QFilter q2;
        ArrayList<Long> operatorGroupList = null;
        QFilter q1 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", allOrg, (boolean)true);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id,createorg,operatorgrouptype,enable", (QFilter[])new QFilter[]{q1, q2 = new QFilter("operatorgrouptype", "=", (Object)OperatorGrpTypeEnum.SALEGRP.getValue())});
        if (map != null && map.size() > 0) {
            operatorGroupList = new ArrayList<Long>(map.size());
            for (DynamicObject dyn : map.values()) {
                if (dyn == null) continue;
                operatorGroupList.add((Long)dyn.getPkValue());
            }
        }
        return operatorGroupList;
    }

    public static QFilter getOrgGrpIsolationQfilter(List<Long> listOrgId) {
        QFilter q = null;
        List<Long> orgGrpList = MultiOrganHelper.getOperatorGroupByOrg(listOrgId);
        if (orgGrpList != null && orgGrpList.size() > 0) {
            orgGrpList.add(0L);
            q = new QFilter("operatorgroup", "in", orgGrpList);
        } else {
            q = new QFilter("operatorgroup", "=", (Object)0);
        }
        return q;
    }

    public static QFilter getOrgGrpIsolationQfilter(List<Long> listOrgId, Long userId) {
        QFilter q = null;
        List<Long> userGrpList = SalRankRptHelper.getOperatorGroupByUser(userId);
        QFilter temp = null;
        for (Long orgID : listOrgId) {
            List<Long> orgGrpList = SalRankRptHelper.getOperatorGroupByOrg(orgID);
            Object operatorGroupIsolate = AppParameterHelper.getSmAppParameter((Long)orgID, (String)"foperatorgroupisolate");
            if (operatorGroupIsolate instanceof Boolean && ((Boolean)operatorGroupIsolate).booleanValue()) {
                QFilter q3;
                QFilter q2;
                List<Long> grpList = SalRankRptHelper.getValidOperatorGroup(orgGrpList, userGrpList);
                temp = grpList != null && grpList.size() > 0 ? (q2 = new QFilter("operatorgroup", "in", grpList)) : (q3 = new QFilter("operatorgroup", "=", (Object)0));
            } else if (orgGrpList != null && orgGrpList.size() > 0) {
                QFilter q4;
                orgGrpList.add(0L);
                temp = q4 = new QFilter("operatorgroup", "in", orgGrpList);
            } else {
                QFilter q5;
                temp = q5 = new QFilter("operatorgroup", "=", (Object)0);
            }
            if (q == null) {
                q = temp;
                continue;
            }
            q.or(temp);
        }
        return q;
    }
}

