/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report.helper;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.orm.query.QFilter;

public class SalCustomerSynRptHelper {
    private SalCustomerSynRptHelper() {
    }

    public static String getSelectField() {
        ArrayList<String> selectorSet = new ArrayList<String>();
        selectorSet.add("org");
        selectorSet.add("bizdate as lastsaldate");
        selectorSet.add("customer");
        selectorSet.add("customer.name as customername");
        selectorSet.add("currency");
        selectorSet.add("billentry.curamountandtax as salamount");
        selectorSet.add("case when (billentry.qty = 0) then 0 else (billentry.invqty / billentry.qty) * billentry.curamountandtax end as deliveramount");
        selectorSet.add("exchangerate");
        selectorSet.add("billentry.aramount * exchangerate as receiveamount");
        return String.join((CharSequence)",", selectorSet);
    }

    public static List<QFilter> getFilters(FilterInfo filterInfo) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DynamicObject org = filterInfo.getDynamicObject("orgfield");
        filters.add(new QFilter("org", "=", org.getPkValue()));
        Date startDate = filterInfo.getDate("startdate");
        filters.add(new QFilter("bizdate", ">=", (Object)SalCustomerSynRptHelper.getStartOrEndDate(startDate, false)));
        Date endDate = filterInfo.getDate("enddate");
        filters.add(new QFilter("bizdate", "<=", (Object)SalCustomerSynRptHelper.getStartOrEndDate(endDate, true)));
        DynamicObjectCollection cusColl = filterInfo.getDynamicObjectCollection("customerfield");
        if (cusColl != null && cusColl.size() > 0) {
            ArrayList<Long> cusList = new ArrayList<Long>(16);
            List<String> cuss = SalCustomerSynRptHelper.getBaseDataPkIds(cusColl);
            for (int i = 0; i < cuss.size(); ++i) {
                cusList.add(Long.parseLong(cuss.get(i)));
            }
            filters.add(new QFilter("customer", "in", cusList));
        }
        return filters;
    }

    public static Date getStartOrEndDate(Date date, boolean isEnd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (isEnd) {
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
        } else {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
        }
        return cal.getTime();
    }

    public static List<String> getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return new ArrayList<String>();
        }
        ArrayList<String> pkIds = new ArrayList<String>(col.size());
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds.add(baseData.getPkValue().toString());
        }
        return pkIds;
    }
}

