/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report.helper;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.entity.report.FilterInfo;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;

public class SalGrossProfitRptHelper {
    public static final String verifyDateField = "entry.e_billdate";
    private static List<String> fileds = Arrays.asList("id", "amount", "amountandtax", "auxpty", "salorg", "bizoperator", "customer", "taxrate", "exchangerate", "org", "material", "inventryid", "baseunit", "baseqty", "currency");

    public static List<String> getSumFields() {
        ArrayList<String> sumFields = new ArrayList<String>();
        sumFields.add("baseqty");
        sumFields.add("salamount");
        sumFields.add("taxsalamount");
        sumFields.add("actualcost");
        sumFields.add("salgrossprofit");
        sumFields.add("amount");
        sumFields.add("localverifyamt");
        sumFields.add("busamount");
        return sumFields;
    }

    public static String[] getVerGroupFields() {
        return SalGrossProfitRptHelper.getSelectFieldAdd("group", "unitcost", "actualcost");
    }

    public static String[] getBusGroupFields() {
        return SalGrossProfitRptHelper.getSelectFieldAdd("group", "unitcost", "actualcost", "verbaseqty", "localverifyamt");
    }

    public static String[] getIncludeSelectFields() {
        ArrayList<String> list = new ArrayList<String>(fileds);
        list.remove("baseqty");
        list.remove("amount");
        list.remove("amountandtax");
        list.add("verbaseqty baseqty");
        list.add("group");
        list.add("unitcost");
        list.add("verbaseqty * unitcost actualcost");
        list.add("(CASE verbaseqty WHEN Cast(0 as BigDecimal) THEN 0 ELSE localverifyamt / verbaseqty  END) price");
        list.add("(CASE verbaseqty WHEN Cast(0 as BigDecimal) THEN 0 ELSE localverifyamtandtax / verbaseqty  END) taxprice");
        list.add("localverifyamt");
        list.add("localverifyamtandtax");
        list.add("Cast(0 as BigDecimal) amount");
        list.add("Cast(0 as BigDecimal) amountandtax");
        list.add("Cast(0 as BigDecimal) busamount");
        list.add("Cast(0 as BigDecimal) busamountandtax");
        return list.toArray(new String[list.size()]);
    }

    public static String[] getIncludeSelectFields(boolean isEqualsQty) {
        if (!isEqualsQty) {
            return SalGrossProfitRptHelper.getIncludeSelectFields();
        }
        ArrayList<String> list = new ArrayList<String>(fileds);
        list.remove("baseqty");
        list.remove("amount");
        list.remove("amountandtax");
        list.add("verbaseqty baseqty");
        list.add("group");
        list.add("unitcost");
        list.add("actualcost");
        list.add("(CASE verbaseqty WHEN Cast(0 as BigDecimal) THEN 0 ELSE localverifyamt / verbaseqty  END) price");
        list.add("(CASE verbaseqty WHEN Cast(0 as BigDecimal) THEN 0 ELSE localverifyamtandtax / verbaseqty  END) taxprice");
        list.add("localverifyamt");
        list.add("localverifyamtandtax");
        list.add("Cast(0 as BigDecimal) amount");
        list.add("Cast(0 as BigDecimal) amountandtax");
        list.add("Cast(0 as BigDecimal) busamount");
        list.add("Cast(0 as BigDecimal) busamountandtax");
        return list.toArray(new String[list.size()]);
    }

    public static String getVerifySelectors() {
        List<String> selectors = Arrays.asList("entry.e_billdate createtime", "billentryid", "entry.e_billentryid verifyentryid", "entry.e_verifybaseqty verbaseqty", "entry.e_localverifyamt localverifyamt", "entry.e_verifyamount verifyamount", "entry.e_verifytaxamount localverifyamtandtax");
        return String.join((CharSequence)",", selectors);
    }

    public static String[] getVerifySortFields() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("billentryid");
        list.add("createtime");
        return list.toArray(new String[list.size()]);
    }

    public static String getVerifySort() {
        return "billentryid,entry.e_billdate";
    }

    public static String[] getBusSortFields() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("bussrcentryid");
        list.add("bizdate");
        return list.toArray(new String[list.size()]);
    }

    public static String getBusSort() {
        return "entry.e_srcentryid,bizdate";
    }

    public static String[] getVerifyAlisFields() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("TO_CHAR(createtime, 'yyyy-MM-dd') createtime");
        list.add("billentryid");
        list.add("verifyentryid");
        list.add("verbaseqty");
        list.add("localverifyamt");
        list.add("localverifyamtandtax");
        return list.toArray(new String[list.size()]);
    }

    public static String getBusSelectors() {
        List<String> selectors = Arrays.asList("exchangerate", "quotation", "bizdate", "basecurrency.amtprecision amtprecision", "entry.e_actunitprice busprice", "entry.e_acttaxunitprice buspriceandtax", "entry.e_localamt busamount", "entry.e_reclocalamt busamountandtax", "entry.e_baseunitqty baseqty", "entry.e_quantity qty", "entry.e_baseunitqty busqty", "entry.e_unitcoefficient busrate", "entry.e_srcentryid bussrcentryid");
        return String.join((CharSequence)",", selectors);
    }

    public static String[] getBusAlisFields() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("exchangerate");
        list.add("quotation");
        list.add("TO_CHAR(bizdate, 'yyyy-MM-dd') bizdate");
        list.add("amtprecision");
        list.add("busprice");
        list.add("buspriceandtax");
        list.add("busamount");
        list.add("busamountandtax");
        list.add("baseqty");
        list.add("qty");
        list.add("busqty");
        list.add("busrate");
        list.add("bussrcentryid");
        return list.toArray(new String[list.size()]);
    }

    public static String[] getSelectFieldAdd(String ... Field2) {
        ArrayList<String> list = new ArrayList<String>(fileds);
        if (Field2 != null && Field2.length > 0) {
            for (String string : Field2) {
                list.add(string);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] getSelectField_rightSet(String ... field) {
        if (field == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(1 + field.length);
        list.add("billentryid");
        if (field.length > 0) {
            for (String string : field) {
                list.add(string);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] getSelectFieldAddExclude(String[] Field2, String excludeField) {
        String[] removeFields;
        ArrayList<String> list = new ArrayList<String>(fileds);
        if (Field2 != null && Field2.length > 0) {
            for (String string : Field2) {
                list.add(string);
            }
        }
        for (String removeField : removeFields = excludeField.split(",")) {
            list.remove(removeField);
        }
        return list.toArray(new String[list.size()]);
    }

    public static QFilter getDateFilter(FilterInfo filterInfo, String prop, String startDateProp, String endDateProp) {
        Date startDate = filterInfo.getDate(startDateProp);
        Date endDate = filterInfo.getDate(endDateProp);
        if (startDate != null) {
            QFilter filter = new QFilter(prop, ">=", (Object)SalGrossProfitRptHelper.getStartOrEndDate(startDate, Boolean.FALSE));
            filter.and(new QFilter(prop, "<=", (Object)SalGrossProfitRptHelper.getStartOrEndDate(endDate, Boolean.TRUE)));
            return filter;
        }
        return QFilter.of((String)"1=1", (Object[])new Object[0]);
    }

    public static QFilter[] getDateFilters(FilterInfo filterInfo, String prop, String startDateProp, String endDateProp) {
        ArrayList<QFilter> resultFilter = new ArrayList<QFilter>(16);
        Date startDate = filterInfo.getDate(startDateProp);
        Date endDate = filterInfo.getDate(endDateProp);
        if (startDate != null) {
            startDate = SalGrossProfitRptHelper.getStartOrEndDate(startDate, Boolean.FALSE);
            endDate = SalGrossProfitRptHelper.getStartOrEndDate(endDate, Boolean.TRUE);
            Instant instantStart = startDate.toInstant();
            ZoneId zone = ZoneId.systemDefault();
            LocalDateTime localDateTimeStart = LocalDateTime.ofInstant(instantStart, zone);
            LocalDate startLocalDate = localDateTimeStart.toLocalDate();
            int startMonth = startLocalDate.getMonth().getValue();
            int startYear = startLocalDate.getYear();
            Instant instantEnd = endDate.toInstant();
            LocalDateTime localDateTimeEnd = LocalDateTime.ofInstant(instantEnd, zone);
            LocalDate endlocalDate = localDateTimeEnd.toLocalDate();
            int endMonth = endlocalDate.getMonth().getValue();
            int endYear = endlocalDate.getYear();
            if (startYear == endYear) {
                if (startMonth == endMonth) {
                    QFilter filter = new QFilter(prop, ">=", (Object)SalGrossProfitRptHelper.getStartOrEndDate(startDate, Boolean.FALSE));
                    filter.and(new QFilter(prop, "<=", (Object)SalGrossProfitRptHelper.getStartOrEndDate(endDate, Boolean.TRUE)));
                    resultFilter.add(filter);
                } else {
                    LocalDate midDivideDate = null;
                    for (int i = startMonth; i <= endMonth; ++i) {
                        QFilter filter;
                        if (i == startMonth) {
                            QFilter filter2 = new QFilter(prop, ">=", (Object)SalGrossProfitRptHelper.getStartOrEndDate(startDate, Boolean.FALSE));
                            midDivideDate = startLocalDate.with(TemporalAdjusters.lastDayOfMonth());
                            filter2.and(new QFilter(prop, "<=", (Object)SalGrossProfitRptHelper.getStartOrEndDate(Date.from(midDivideDate.atStartOfDay().toInstant(ZoneOffset.ofHours(8))), Boolean.TRUE)));
                            resultFilter.add(filter2);
                            midDivideDate = midDivideDate.plusDays(1L);
                            continue;
                        }
                        if (i == endMonth) {
                            LocalDate startDayOfStartMonth = endlocalDate.with(TemporalAdjusters.firstDayOfMonth());
                            filter = new QFilter(prop, ">=", (Object)SalGrossProfitRptHelper.getStartOrEndDate(Date.from(startDayOfStartMonth.atStartOfDay().toInstant(ZoneOffset.ofHours(8))), Boolean.FALSE));
                            filter.and(new QFilter(prop, "<=", (Object)SalGrossProfitRptHelper.getStartOrEndDate(endDate, Boolean.TRUE)));
                            resultFilter.add(filter);
                            continue;
                        }
                        if (midDivideDate != null) {
                            QFilter filterX = SalGrossProfitRptHelper.getMidFilterX(prop, midDivideDate);
                            resultFilter.add(filterX);
                            midDivideDate = midDivideDate.plusMonths(1L);
                            continue;
                        }
                        Calendar midYearAndMonth = Calendar.getInstance();
                        midYearAndMonth.set(1, startYear);
                        midYearAndMonth.set(2, i - 1);
                        midYearAndMonth.set(5, 1);
                        filter = SalGrossProfitRptHelper.getMidFilter(prop, zone, midYearAndMonth);
                        resultFilter.add(filter);
                    }
                }
            } else {
                int dividePeriod = 3;
                while (startLocalDate.isBefore(endlocalDate) || startLocalDate.isEqual(endlocalDate)) {
                    startDate = Date.from(startLocalDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
                    QFilter filter = new QFilter(prop, ">=", (Object)SalGrossProfitRptHelper.getStartOrEndDate(startDate, Boolean.FALSE));
                    LocalDate periodEndDate = startLocalDate.plusMonths(dividePeriod);
                    if ((periodEndDate = periodEndDate.with(TemporalAdjusters.lastDayOfMonth())).isBefore(endlocalDate)) {
                        filter.and(new QFilter(prop, "<=", (Object)SalGrossProfitRptHelper.getStartOrEndDate(Date.from(periodEndDate.atStartOfDay().toInstant(ZoneOffset.ofHours(8))), Boolean.TRUE)));
                        resultFilter.add(filter);
                        startLocalDate = periodEndDate.plusDays(1L);
                        continue;
                    }
                    filter.and(new QFilter(prop, "<=", (Object)SalGrossProfitRptHelper.getStartOrEndDate(Date.from(endlocalDate.atStartOfDay().toInstant(ZoneOffset.ofHours(8))), Boolean.TRUE)));
                    resultFilter.add(filter);
                    break;
                }
            }
            return resultFilter.toArray(new QFilter[resultFilter.size()]);
        }
        return new QFilter[]{QFilter.of((String)"1=1", (Object[])new Object[0])};
    }

    private static QFilter getMidFilter(String prop, ZoneId zone, Calendar midYearAndMonth) {
        Date midDate = midYearAndMonth.getTime();
        Instant instantMid = midDate.toInstant();
        LocalDateTime localDateTimeMid = LocalDateTime.ofInstant(instantMid, zone);
        LocalDate midLocalDate = localDateTimeMid.toLocalDate();
        LocalDate startDayOfMidMonth = midLocalDate.with(TemporalAdjusters.firstDayOfMonth());
        QFilter filter = new QFilter(prop, ">=", (Object)SalGrossProfitRptHelper.getStartOrEndDate(Date.from(startDayOfMidMonth.atStartOfDay().toInstant(ZoneOffset.ofHours(8))), Boolean.FALSE));
        LocalDate lastDayOfMidMonth = midLocalDate.with(TemporalAdjusters.lastDayOfMonth());
        filter.and(new QFilter(prop, "<=", (Object)SalGrossProfitRptHelper.getStartOrEndDate(Date.from(lastDayOfMidMonth.atStartOfDay().toInstant(ZoneOffset.ofHours(8))), Boolean.TRUE)));
        return filter;
    }

    private static QFilter getMidFilterX(String prop, LocalDate midLocalDate) {
        LocalDate startDayOfMidMonth = midLocalDate.with(TemporalAdjusters.firstDayOfMonth());
        QFilter filter = new QFilter(prop, ">=", (Object)SalGrossProfitRptHelper.getStartOrEndDate(Date.from(startDayOfMidMonth.atStartOfDay().toInstant(ZoneOffset.ofHours(8))), Boolean.FALSE));
        LocalDate lastDayOfMidMonth = midLocalDate.with(TemporalAdjusters.lastDayOfMonth());
        filter.and(new QFilter(prop, "<=", (Object)SalGrossProfitRptHelper.getStartOrEndDate(Date.from(lastDayOfMidMonth.atStartOfDay().toInstant(ZoneOffset.ofHours(8))), Boolean.TRUE)));
        return filter;
    }

    public static Date getStartOrEndDate(Date date, Boolean isEnd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (isEnd.booleanValue()) {
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
        } else {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateStr = formatter.format(cal.getTime());
        try {
            Date dateNew = formatter.parse(dateStr);
            return dateNew;
        }
        catch (ParseException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static String getResultSelector() {
        List<String> selectors = Arrays.asList("org", "salorg", "customer", "bizoperator", "group", "material", "auxpty", "baseunit", "baseqty", "currency", "price", "taxprice", "salamount", "taxsalamount", "unitcost", "actualcost", "unitgrossprofit", "salgrossprofit", "localverifyamt", "busamount", "amount", "salgrossprofitrate");
        return String.join((CharSequence)",", selectors);
    }
}

