/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.scmc.sm.report.helper.SalGrossProfitRptHelper;

public class SalGrossProfitXQueryHelper {
    private static final Log log = LogFactory.getLog(SalGrossProfitXQueryHelper.class);
    private JobSession session;

    public SalGrossProfitXQueryHelper(JobSession session) {
        this.session = session;
    }

    public DataSetX queryMaterialGroup(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        OrmInput mateialGroupInput = new OrmInput(" kd.scmc.sm.report.helper.SalGrossProfitBaseXQuery.queryMaterialGroup", "bd_materialgroupdetail", this.getMatSelectors(), new QFilter[]{this.getMatFilters(filterInfo)});
        RowMeta rowMeta = mateialGroupInput.getRowMeta();
        Field group = rowMeta.getField("group");
        group.setDataType((DataType)DataType.LongType);
        Field material = rowMeta.getField("material");
        material.setDataType((DataType)DataType.LongType);
        DataSetX detailDataSetX = this.session.fromInput((Input)mateialGroupInput);
        return detailDataSetX;
    }

    public DataSetX querySalOutDataSet(ReportQueryParam queryParam, QFilter dateFilter) {
        FilterInfo filterInfo = queryParam.getFilter();
        QFilter salOutFilter = SalGrossProfitXQueryHelper.getSalOutFilters(filterInfo);
        salOutFilter.and(dateFilter);
        OrmInput saloutDataSetInput = new OrmInput(" kd.scmc.sm.report.helper.SalGrossProfitBaseXQuery.querySalOutDataSet", "im_saloutbill", "id,org,biztime", new QFilter[]{salOutFilter});
        DataSetX saloutDataSet = this.session.fromInput((Input)saloutDataSetInput);
        return saloutDataSet;
    }

    public DataSetX querySalOutEntryDataSet(ReportQueryParam queryParam, List<Long> saloutIds) {
        FilterInfo filterInfo = queryParam.getFilter();
        QFilter saloutEntryFilter = SalGrossProfitXQueryHelper.getSalOutTotalFilters(filterInfo);
        QFilter idQFilter = new QFilter("id", "in", saloutIds);
        OrmInput salOutDataSetInput = new OrmInput(" kd.scmc.sm.report.helper.SalGrossProfitBaseXQuery.querySalOutDataSet", "im_saloutbill", this.getSalOutSelectors(), new QFilter[]{idQFilter, saloutEntryFilter});
        DataSetX SalOutDataSet = this.session.fromInput((Input)salOutDataSetInput);
        return SalOutDataSet;
    }

    public DataSetX queryCostDataSet(List<Long> imEntryIds, Set<Long> imIds) {
        ArrayList<Set<Long>> idSets = new ArrayList<Set<Long>>();
        log.info("saloutJoinMaterial size ===" + imEntryIds.size());
        if (imIds.size() <= 500) {
            idSets.add(imIds);
        } else if (imIds.size() <= 5000) {
            this.batch(imIds, idSets, 8);
        } else {
            this.batch(imIds, idSets, 16);
        }
        ArrayList<OrmInput> retValue = new ArrayList<OrmInput>(idSets.size());
        for (int i = 0; i < idSets.size(); ++i) {
            QFilter filter = new QFilter("bizbillid", "in", idSets.get(i));
            filter.and(new QFilter("costaccount.ismainaccount", "=", (Object)Boolean.TRUE));
            filter.and(new QFilter("issplitcreate", "=", (Object)Boolean.FALSE));
            OrmInput costInput = new OrmInput("kd.scmc.sm.report.helper.SalGrossProfitBaseXQuery.queryMaterialGroup", "cal_costrecord_subentity", this.getCostSelectors(), new QFilter[]{filter});
            retValue.add(costInput);
        }
        DataSetX costDataSetX = this.session.fromInput((Input[])retValue.toArray(new OrmInput[0]));
        return costDataSetX;
    }

    public DataSetX queryVerifyDataSet(List<Long> imEntryIds, Map<Long, Set<Long>> orgToIDs, FilterInfo filterInfo) {
        ArrayList idSets = new ArrayList();
        log.info("saloutJoinMaterial size ===" + imEntryIds.size());
        ArrayList retValue = new ArrayList();
        HashSet<String> verifyRelation = new HashSet<String>();
        verifyRelation.add("arsalout");
        verifyRelation.add("arsalreturn");
        orgToIDs.forEach((key, value) -> {
            if (value.size() <= 500) {
                idSets.add(value);
            } else if (value.size() <= 5000) {
                this.batch((Set<Long>)value, idSets, 8);
            } else {
                this.batch((Set<Long>)value, idSets, 16);
            }
            StringBuilder saloutBillsMsg = new StringBuilder();
            saloutBillsMsg.append("orgID:").append(key).append(" has ").append(value.size()).append(" saloutBills");
            log.info(saloutBillsMsg.toString());
            for (int i = 0; i < idSets.size(); ++i) {
                QFilter filter = new QFilter("org", "=", key);
                filter.and(new QFilter("billid", "in", idSets.get(i)));
                QFilter filter4Verify = SalGrossProfitRptHelper.getDateFilter(filterInfo, "entry.e_billdate", "ardate_startdate", "ardate_enddate").and(new QFilter("verifyrelation", "in", (Object)verifyRelation));
                filter.and(filter4Verify);
                OrmInput verifyInput = new OrmInput("kd.scmc.sm.report.helper.SalGrossProfitBaseXQuery.queryVerifyDataSet", "ar_verifyrecord", SalGrossProfitRptHelper.getVerifySelectors(), new QFilter[]{filter});
                retValue.add(verifyInput);
            }
        });
        DataSetX verifyDataSetX = this.session.fromInput((Input[])retValue.toArray(new OrmInput[0]));
        if (imEntryIds.size() <= 5000) {
            log.info("imEntryIds.size() ===" + imEntryIds.size());
            HashMap<String, List<Long>> entryIDMap = new HashMap<String, List<Long>>();
            entryIDMap.put("entryids", imEntryIds);
            verifyDataSetX = verifyDataSetX.filter("billentryid in entryids", entryIDMap);
        }
        return verifyDataSetX;
    }

    public DataSetX queryBusDataSet(List<Long> imEntryIds, Set<Long> imIds, FilterInfo filterInfo) {
        ArrayList<Set<Long>> idSets = new ArrayList<Set<Long>>();
        Object idSet = null;
        log.info("saloutJoinMaterial size ===" + imEntryIds.size());
        StringBuilder saloutBillsMsg = new StringBuilder();
        saloutBillsMsg.append("all has ").append(imIds.size()).append(" saloutBills");
        log.info(saloutBillsMsg.toString());
        if (imIds.size() <= 500) {
            idSets.add(imIds);
        } else if (imIds.size() <= 5000) {
            this.batch(imIds, idSets, 8);
        } else {
            this.batch(imIds, idSets, 16);
        }
        ArrayList<OrmInput> retValue = new ArrayList<OrmInput>(idSets.size());
        for (int i = 0; i < idSets.size(); ++i) {
            QFilter filter = new QFilter("entry.e_srcbillid", "in", idSets.get(i));
            QFilter filter4Bus = SalGrossProfitRptHelper.getDateFilter(filterInfo, "bizdate", "ardate_startdate", "ardate_enddate");
            filter4Bus.and(new QFilter("billstatus", "=", (Object)"C"));
            filter4Bus.and(new QFilter("isfullinvoice", "=", (Object)Boolean.FALSE));
            filter.and(filter4Bus);
            OrmInput busInput = new OrmInput("kd.scmc.sm.report.helper.SalGrossProfitBaseXQuery.queryBusDataSet", "ar_busbill", SalGrossProfitRptHelper.getBusSelectors(), new QFilter[]{filter});
            retValue.add(busInput);
        }
        DataSetX busDataSetX = this.session.fromInput((Input[])retValue.toArray(new OrmInput[0]));
        if (imEntryIds.size() <= 5000) {
            HashMap<String, List<Long>> entryIDMap = new HashMap<String, List<Long>>();
            entryIDMap.put("entryids", imEntryIds);
            busDataSetX = busDataSetX.filter("bussrcentryid in entryids", entryIDMap);
        }
        return busDataSetX;
    }

    private String getMatSelectors() {
        return "group,material";
    }

    private QFilter getMatFilters(FilterInfo filterInfo) {
        QFilter filter = new QFilter("standard", "=", filterInfo.getDynamicObject("matstandard").getPkValue());
        DynamicObjectCollection matGroup = filterInfo.getDynamicObjectCollection("matroup");
        if (matGroup != null && matGroup.size() > 0) {
            ArrayList<Object> pks = new ArrayList<Object>();
            for (DynamicObject data : matGroup) {
                pks.add(data.get("id"));
            }
            filter.and(new QFilter("group", "in", pks));
        }
        return filter;
    }

    private String getSalOutSelectors() {
        List<String> selectors = Arrays.asList("id", "bizorg salorg", "biztime", "exchangerate", "customer.masterid customer", "bizoperator", "currency", "billentry.id inventryid", "billentry.entrysettleorg org", "billentry.material.masterid material", "billentry.auxpty auxpty", "billentry.baseunit baseunit", "billentry.baseqty baseqty", "billentry.amount amount", "billentry.amountandtax amountandtax", "billentry.taxrate taxrate");
        return String.join((CharSequence)",", selectors);
    }

    public static QFilter getSalOutFilters(FilterInfo filterInfo) {
        QFilter saloutFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        String value = filterInfo.getString("radiogroup");
        if (!"1".equals(value)) {
            SalGrossProfitXQueryHelper.setFilter(filterInfo, saloutFilter, "bizorg_f");
        }
        for (String prop : SalGrossProfitXQueryHelper.getCommonProp()) {
            SalGrossProfitXQueryHelper.setFilter(filterInfo, saloutFilter, prop);
        }
        saloutFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        saloutFilter.and(new QFilter("invscheme.number", "not in", (Object)new String[]{"211", "2111", "240", "2401"}));
        DynamicObjectCollection datas = filterInfo.getDynamicObjectCollection("material_f");
        if (datas != null && datas.size() > 0) {
            ArrayList<Object> pks = new ArrayList<Object>();
            for (DynamicObject data : datas) {
                pks.add(data.get("id"));
            }
            saloutFilter.and(new QFilter("billentry.material.masterid", "in", (Object)pks.toArray()));
        }
        return saloutFilter;
    }

    public static QFilter getSalOutTotalFilters(FilterInfo filterInfo) {
        DynamicObjectCollection datas;
        QFilter saloutEntryFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        String value = filterInfo.getString("radiogroup");
        if ("1".equals(value)) {
            SalGrossProfitXQueryHelper.setFilter(filterInfo, saloutEntryFilter, "billentry.entrysettleorg_f");
        }
        if ((datas = filterInfo.getDynamicObjectCollection("material_f")) != null && datas.size() > 0) {
            ArrayList<Object> pks = new ArrayList<Object>();
            for (DynamicObject data : datas) {
                pks.add(data.get("id"));
            }
            saloutEntryFilter.and(new QFilter("billentry.material.masterid", "in", (Object)pks.toArray()));
        }
        saloutEntryFilter.and(new QFilter("billentry.logisticsbill", "=", (Object)Boolean.FALSE));
        return saloutEntryFilter;
    }

    public static boolean isExistField(String field, RowMeta rowMeta) {
        String[] fieldNameExists;
        for (String fieldExist : fieldNameExists = rowMeta.getFieldNames()) {
            if (!fieldExist.equals(field)) continue;
            return true;
        }
        return false;
    }

    private String getCostSelectors() {
        List<String> selectors = Arrays.asList("entry.bizbillentryid costentryid", "entry.unitactualcost unitcost", "entry.actualcost actualcost");
        return String.join((CharSequence)",", selectors);
    }

    private static QFilter setFilter(FilterInfo filterInfo, QFilter filter, String prop) {
        DynamicObjectCollection values = filterInfo.getDynamicObjectCollection(prop.substring(prop.indexOf(46) + 1));
        if ("customer_f".equals(prop)) {
            if (values != null && values.size() > 0) {
                ArrayList<Object> pks = new ArrayList<Object>();
                for (DynamicObject data : values) {
                    pks.add(data.get("masterid"));
                }
                return filter.and(new QFilter("customer.masterid", "in", (Object)pks.toArray()));
            }
        } else if (values != null && values.size() > 0) {
            ArrayList<Object> pks = new ArrayList<Object>();
            for (DynamicObject data : values) {
                pks.add(data.get("id"));
            }
            return filter.and(new QFilter(prop.substring(0, prop.lastIndexOf(95)), "in", (Object)pks.toArray()));
        }
        return filter;
    }

    private static String[] getCommonProp() {
        return new String[]{"customer_f", "bizoperator_f", "biztype_f"};
    }

    private Set<Long> batch(Set<Long> imIds, List<Set<Long>> idSets, int batchNum) {
        int batch = imIds.size() / batchNum;
        HashSet<Long> idSet = new HashSet<Long>();
        Iterator<Long> imIdSet = imIds.iterator();
        for (int i = 0; i < batchNum; ++i) {
            int count;
            idSet = new HashSet();
            idSets.add(idSet);
            if (i != batchNum - 1) {
                for (count = 1; imIdSet.hasNext() && count <= batch; ++count) {
                    idSet.add(imIdSet.next());
                }
                continue;
            }
            while (imIdSet.hasNext()) {
                idSet.add(imIdSet.next());
                ++count;
            }
        }
        return idSet;
    }
}

