/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report.helper;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.bos.orm.query.QFilter;
import kd.scmc.sm.enums.CloseStatusEnum;
import kd.scmc.sm.enums.RowCloseStatusEnum;
import kd.scmc.sm.enums.RowStatusRptEnum;
import kd.scmc.sm.enums.RowTerminateStatusEnum;
import kd.scmc.sm.enums.StatusEnum;

public class SalOrderRptHelper {
    public static String getSelectField() {
        ArrayList<String> selectorSet = new ArrayList<String>(32);
        selectorSet.add("id");
        selectorSet.add("org");
        selectorSet.add("billtype");
        selectorSet.add("dept");
        selectorSet.add("operatorgroup");
        selectorSet.add("operator");
        selectorSet.add("billno");
        selectorSet.add("bizdate");
        selectorSet.add("customer");
        selectorSet.add("customer.name as customername");
        selectorSet.add("billentry.seq as rowseq");
        selectorSet.add("billentry.material.masterid.id as material");
        selectorSet.add("billentry.material.masterid.name as materialname");
        selectorSet.add("billentry.material.masterid.modelnum as modelnum");
        String changgui = ResManager.loadKDString((String)".material.masterid.materialtype='1' then '\u5e38\u89c4'  ", (String)"SalOrderRptHelper_0", (String)"scmc-sm-report", (Object[])new Object[0]);
        String xuni = ResManager.loadKDString((String)".material.masterid.materialtype='2' then '\u865a\u62df'  ", (String)"SalOrderRptHelper_1", (String)"scmc-sm-report", (Object[])new Object[0]);
        String taojian = ResManager.loadKDString((String)".material.masterid.materialtype='3' then '\u5957\u4ef6'  ", (String)"SalOrderRptHelper_2", (String)"scmc-sm-report", (Object[])new Object[0]);
        String kepeizhijian = ResManager.loadKDString((String)".material.masterid.materialtype='4' then '\u53ef\u914d\u7f6e\u4ef6'  ", (String)"SalOrderRptHelper_3", (String)"scmc-sm-report", (Object[])new Object[0]);
        String tezhengjian = ResManager.loadKDString((String)".material.masterid.materialtype='5' then '\u7279\u5f81\u4ef6'  ", (String)"SalOrderRptHelper_4", (String)"scmc-sm-report", (Object[])new Object[0]);
        String zichan = ResManager.loadKDString((String)".material.masterid.materialtype='6' then '\u8d44\u4ea7'  ", (String)"SalOrderRptHelper_5", (String)"scmc-sm-report", (Object[])new Object[0]);
        String feiyong = ResManager.loadKDString((String)".material.masterid.materialtype='7' then '\u8d39\u7528'  ", (String)"SalOrderRptHelper_6", (String)"scmc-sm-report", (Object[])new Object[0]);
        String zichan1 = ResManager.loadKDString((String)".material.masterid.materialtype='8' then '\u8d44\u4ea7'  ", (String)"SalOrderRptHelper_7", (String)"scmc-sm-report", (Object[])new Object[0]);
        String fuwu = ResManager.loadKDString((String)".material.masterid.materialtype='9' then '\u670d\u52a1'  end as materialtype ", (String)"SalOrderRptHelper_8", (String)"scmc-sm-report", (Object[])new Object[0]);
        selectorSet.add("case when billentry" + changgui + " when  " + "billentry" + xuni + " when  " + "billentry" + taojian + " when  " + "billentry" + kepeizhijian + " when  " + "billentry" + tezhengjian + " when  " + "billentry" + zichan + " when  " + "billentry" + feiyong + " when  " + "billentry" + zichan1 + " when  " + "billentry" + fuwu);
        selectorSet.add("billentry.auxpty as auxpty");
        selectorSet.add("billentry.unit as unit");
        selectorSet.add("billentry.qty as qty");
        selectorSet.add("billentry.auxunit as auxunit");
        selectorSet.add("billentry.auxqty as auxqty");
        selectorSet.add("billentry.deliverydate as deliverydate");
        selectorSet.add("billentry.e_stockorg as e_stockorg");
        selectorSet.add("settlecurrency");
        selectorSet.add("billentry.priceandtax as priceandtax");
        selectorSet.add("billentry.amount as amount");
        selectorSet.add("billentry.amountandtax as amountandtax");
        selectorSet.add("billentry.deliqty as deliqty");
        selectorSet.add("billentry.invqty as invqty");
        selectorSet.add("billentry.backqty as backqty");
        selectorSet.add("billentry.remark as remark");
        selectorSet.add("case when billentry.rowclosestatus = '" + RowCloseStatusEnum.UNROWCLOSE.getValue() + "' then '" + RowCloseStatusEnum.UNROWCLOSE.getName() + "' when " + "billentry" + ".rowclosestatus = '" + RowCloseStatusEnum.ROWCLOSE.getValue() + "' then '" + RowCloseStatusEnum.ROWCLOSE.getName() + "'  end as rowclosestatus");
        selectorSet.add("case when billentry.rowterminatestatus = '" + RowTerminateStatusEnum.UNROWTERMINATE.getValue() + "' then '" + RowTerminateStatusEnum.UNROWTERMINATE.getName() + "'  when " + "billentry" + ".rowterminatestatus = '" + RowTerminateStatusEnum.ROWTERMINATE.getValue() + "' then '" + RowTerminateStatusEnum.ROWTERMINATE.getName() + "' end as rowterminatestatus");
        selectorSet.add("'0' as summarytype");
        return String.join((CharSequence)",", selectorSet);
    }

    public static List<QFilter> getFilters(FilterInfo filterInfo) {
        DynamicObject billtype;
        DynamicObjectCollection bizdepts;
        DynamicObjectCollection bizoperatorgroups;
        DynamicObjectCollection materials;
        DynamicObjectCollection salOrderBillNo;
        DynamicObjectCollection customers;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        Date startDate = filterInfo.getDate("startdate");
        filters.add(new QFilter("bizdate", ">=", (Object)SalOrderRptHelper.getStartOrEndDate(startDate, false)));
        Date endDate = filterInfo.getDate("enddate");
        filters.add(new QFilter("bizdate", "<=", (Object)SalOrderRptHelper.getStartOrEndDate(endDate, true)));
        DynamicObject org = filterInfo.getDynamicObject("orgfield");
        if (org != null) {
            filters.add(new QFilter("org", "=", org.getPkValue()));
        }
        if ((customers = filterInfo.getDynamicObjectCollection("customerfield")) != null && customers.size() > 0) {
            Object[] customersids = SalOrderRptHelper.getBaseDataPkIds(customers);
            filters.add(new QFilter("customer", "in", (Object)customersids));
        }
        if ((salOrderBillNo = filterInfo.getDynamicObjectCollection("selectbill")) != null && salOrderBillNo.size() > 0) {
            Object[] billNo = SalOrderRptHelper.getBaseDataPkIds(salOrderBillNo);
            filters.add(new QFilter("id", "in", (Object)billNo));
        }
        if ((materials = filterInfo.getDynamicObjectCollection("materialfield")) != null && materials.size() > 0) {
            Object[] materialIds = SalOrderRptHelper.getBaseDataPkIds(materials);
            filters.add(new QFilter("billentry.material.masterid", "in", (Object)materialIds));
        } else {
            filters.add(QFilter.isNotNull((String)"billentry.material.masterid"));
            filters.add(QFilter.isNotNull((String)"billentry.material"));
        }
        DynamicObjectCollection bizoperators = filterInfo.getDynamicObjectCollection("bizoperatorfield");
        if (bizoperators != null && bizoperators.size() > 0) {
            Object[] bizoperatorIds = SalOrderRptHelper.getBaseDataPkIds(bizoperators);
            filters.add(new QFilter("operator", "in", (Object)bizoperatorIds));
        }
        if ((bizoperatorgroups = filterInfo.getDynamicObjectCollection("bizoperatorgroupfield")) != null && bizoperatorgroups.size() > 0) {
            Object[] bizoperatorgroupIds = SalOrderRptHelper.getBaseDataPkIds(bizoperatorgroups);
            filters.add(new QFilter("operatorgroup", "in", (Object)bizoperatorgroupIds));
        }
        if ((bizdepts = filterInfo.getDynamicObjectCollection("bizdeptfield")) != null && bizdepts.size() > 0) {
            Object[] bizdeptsIds = SalOrderRptHelper.getBaseDataPkIds(bizdepts);
            filters.add(new QFilter("dept", "in", (Object)bizdeptsIds));
        }
        if ((billtype = filterInfo.getDynamicObject("billtypefield")) != null) {
            filters.add(new QFilter("billtype", "=", billtype.getPkValue()));
        }
        List<QFilter> statusfilters = SalOrderRptHelper.getStatusFilter(filterInfo);
        filters.addAll(statusfilters);
        return filters;
    }

    private static List<QFilter> getStatusFilter(FilterInfo filterInfo) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        String billstatus = filterInfo.getString("billstatusfield");
        if (!StatusEnum.AUDIT.getValue().equals(billstatus) && !"A".equals(billstatus)) {
            filters.add(new QFilter("billstatus", "!=", (Object)StatusEnum.AUDIT.getValue()));
            return filters;
        }
        if (StatusEnum.AUDIT.getValue().equals(billstatus)) {
            filters.add(new QFilter("billstatus", "=", (Object)StatusEnum.AUDIT.getValue()));
        }
        String closestatus = filterInfo.getString("closestatusfield");
        if (CloseStatusEnum.CLOSED.getValue().equals(closestatus) || CloseStatusEnum.UNCLOSED.getValue().equals(closestatus)) {
            filters.add(new QFilter("closestatus", "=", (Object)closestatus));
        }
        String rowstatus = filterInfo.getString("rowstatusfield");
        if (RowStatusRptEnum.FINISH.getValue().equals(rowstatus)) {
            QFilter qFilter = new QFilter("billentry.rowclosestatus", "=", (Object)RowCloseStatusEnum.ROWCLOSE.getValue());
            qFilter.or(new QFilter("billentry.rowterminatestatus", "=", (Object)RowTerminateStatusEnum.ROWTERMINATE.getValue()));
            filters.add(qFilter);
        } else if (RowStatusRptEnum.UNFINISH.getValue().equals(rowstatus)) {
            QFilter qFilter = new QFilter("billentry.rowclosestatus", "=", (Object)RowCloseStatusEnum.UNROWCLOSE.getValue());
            qFilter.and(new QFilter("billentry.rowterminatestatus", "=", (Object)RowTerminateStatusEnum.UNROWTERMINATE.getValue()));
            filters.add(qFilter);
        }
        return filters;
    }

    private static Object[] getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return null;
        }
        Object[] pkIds = new Object[col.size()];
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds[i] = baseData.getPkValue();
        }
        return pkIds;
    }

    public static Date getStartOrEndDate(Date date, boolean isEnd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (isEnd) {
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
        } else {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
        }
        return cal.getTime();
    }
}

