/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bd.sbd.enums.OperatorGrpTypeEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class SalRankRptHelper {
    public static String getSelectField() {
        ArrayList<String> selectorSet = new ArrayList<String>();
        selectorSet.add("billentry.material.masterid.id as material");
        selectorSet.add("billentry.material.masterid.name as materialname");
        selectorSet.add("billentry.material.masterid.modelnum as modelnum");
        selectorSet.add("billentry.baseqty as qty");
        selectorSet.add("curtotalallamount");
        selectorSet.add("billentry.curamountandtax as materialamount");
        selectorSet.add("currency");
        selectorSet.add("billentry.baseunit as unit");
        return String.join((CharSequence)",", selectorSet);
    }

    public static String getCustomerField() {
        ArrayList<String> selectorSet = new ArrayList<String>();
        selectorSet.add("customer");
        selectorSet.add("customer.name as customername");
        selectorSet.add("billentry.curamountandtax as curtotalallamount");
        selectorSet.add("currency");
        return String.join((CharSequence)",", selectorSet);
    }

    public static String getOperatorGroupField() {
        ArrayList<String> selectorSet = new ArrayList<String>();
        selectorSet.add("operatorgroup");
        selectorSet.add("operatorgroup.name as operatorgroupname");
        selectorSet.add("billentry.curamountandtax as curtotalallamount");
        selectorSet.add("currency");
        return String.join((CharSequence)",", selectorSet);
    }

    public static String getDeptField() {
        ArrayList<String> selectorSet = new ArrayList<String>();
        selectorSet.add("dept");
        selectorSet.add("dept.name as deptname");
        selectorSet.add("billentry.curamountandtax as curtotalallamount");
        selectorSet.add("currency");
        return String.join((CharSequence)",", selectorSet);
    }

    public static String getOperatorField() {
        ArrayList<String> selectorSet = new ArrayList<String>();
        selectorSet.add("operator");
        selectorSet.add("operatorgroup.name as operatorgroupname");
        selectorSet.add("operator.operatorname as operatorname");
        selectorSet.add("billentry.curamountandtax as curtotalallamount");
        selectorSet.add("currency");
        return String.join((CharSequence)",", selectorSet);
    }

    public static List<QFilter> getFilters(FilterInfo filterInfo) {
        DynamicObjectCollection operators;
        DynamicObjectCollection operatorgroups;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DynamicObject org = filterInfo.getDynamicObject("orgfield");
        filters.add(new QFilter("org", "=", org.getPkValue()));
        Date startDate = filterInfo.getDate("startdate");
        filters.add(new QFilter("bizdate", ">=", (Object)SalRankRptHelper.getStartOrEndDate(startDate, false)));
        Date endDate = filterInfo.getDate("enddate");
        filters.add(new QFilter("bizdate", "<=", (Object)SalRankRptHelper.getStartOrEndDate(endDate, true)));
        DynamicObjectCollection materials = filterInfo.getDynamicObjectCollection("materialfield");
        if (materials != null && materials.size() > 0) {
            Object[] materialIdS = SalRankRptHelper.getBaseDataPkIds(materials);
            filters.add(new QFilter("billentry.material.masterid", "in", (Object)materialIdS));
        } else {
            filters.add(QFilter.isNotNull((String)"billentry.material.masterid"));
        }
        DynamicObjectCollection bizdepts = filterInfo.getDynamicObjectCollection("bizdeptfield");
        if (bizdepts != null && bizdepts.size() > 0) {
            Object[] bizdeptsIds = SalRankRptHelper.getBaseDataPkIds(bizdepts);
            filters.add(new QFilter("dept", "in", (Object)bizdeptsIds));
        }
        if ((operatorgroups = filterInfo.getDynamicObjectCollection("bizoperatorgroupfield")) != null && operatorgroups.size() > 0) {
            Object[] bizoperatorgroupIds = SalRankRptHelper.getBaseDataPkIds(operatorgroups);
            filters.add(new QFilter("operatorgroup", "in", (Object)bizoperatorgroupIds));
        }
        if ((operators = filterInfo.getDynamicObjectCollection("bizoperatorfield")) != null && operators.size() > 0) {
            Object[] bizoperatorgroupIds = SalRankRptHelper.getBaseDataPkIds(operators);
            filters.add(new QFilter("operator", "in", (Object)bizoperatorgroupIds));
        }
        return filters;
    }

    public static Date getStartOrEndDate(Date date, boolean isEnd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (isEnd) {
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
        } else {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
        }
        return cal.getTime();
    }

    private static Object[] getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return null;
        }
        Object[] pkIds = new Object[col.size()];
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds[i] = baseData.getPkValue();
        }
        return pkIds;
    }

    public static void setHiddenColsForRpt(List<AbstractReportColumn> rptColumns, String ... needHideCols) {
        List<String> colArrToList = Arrays.asList(needHideCols);
        SalRankRptHelper.setHiddenColsForRpt(rptColumns, colArrToList);
    }

    public static List<ReportColumn> setHiddenColsForRpt(List<AbstractReportColumn> rptColumns, List<String> needHideCols) {
        LinkedList<ReportColumn> needHiddenColumn = new LinkedList<ReportColumn>();
        for (AbstractReportColumn abstractReportColumn : rptColumns) {
            ReportColumn rptColumn;
            if (abstractReportColumn instanceof ReportColumn) {
                rptColumn = (ReportColumn)abstractReportColumn;
                if (!needHideCols.contains(rptColumn.getFieldKey())) continue;
                rptColumn.setHide(true);
                needHiddenColumn.add(rptColumn);
                continue;
            }
            if (!(abstractReportColumn instanceof ReportColumnGroup)) continue;
            rptColumn = (ReportColumnGroup)abstractReportColumn;
            List groupColumns = rptColumn.getChildren();
            needHiddenColumn.addAll(SalRankRptHelper.setHiddenColsForRpt((List<AbstractReportColumn>)groupColumns, needHideCols));
        }
        return needHiddenColumn;
    }

    public static List<Long> getValidOperatorGroup(List<Long> orgGrpList, List<Long> userGrpList) {
        ArrayList<Long> grpList = new ArrayList<Long>();
        if (orgGrpList == null || orgGrpList.size() == 0) {
            return userGrpList;
        }
        if (userGrpList == null || userGrpList.size() == 0) {
            return null;
        }
        for (Long orgGrp : orgGrpList) {
            if (!userGrpList.contains(orgGrp)) continue;
            grpList.add(orgGrp);
        }
        return grpList;
    }

    public static List<Long> getOperatorGroupByUser(long userID) {
        QFilter q3;
        QFilter q2;
        ArrayList<Long> operatorGroupList = null;
        QFilter q1 = new QFilter("operatorid", "=", (Object)userID);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operator", (String)"id,operatorid,opergrptype,operatorgrpid", (QFilter[])new QFilter[]{q1, q2 = new QFilter("opergrptype", "=", (Object)OperatorGrpTypeEnum.SALEGRP.getValue()), q3 = new QFilter("invalid", "=", (Object)Boolean.FALSE)});
        if (map != null && map.size() > 0) {
            operatorGroupList = new ArrayList<Long>(map.size());
            for (DynamicObject dyn : map.values()) {
                if (dyn == null) continue;
                operatorGroupList.add(dyn.getLong("operatorgrpid"));
            }
        }
        return operatorGroupList;
    }

    public static List<Long> getOperatorGroupByOrg(long orgId) {
        QFilter q2;
        ArrayList<Long> operatorGroupList = null;
        QFilter q1 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)orgId);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id,createorg,operatorgrouptype,enable", (QFilter[])new QFilter[]{q1, q2 = new QFilter("operatorgrouptype", "=", (Object)OperatorGrpTypeEnum.SALEGRP.getValue())});
        if (map != null && map.size() > 0) {
            operatorGroupList = new ArrayList<Long>(map.size());
            for (DynamicObject dyn : map.values()) {
                if (dyn == null) continue;
                operatorGroupList.add((Long)dyn.getPkValue());
            }
        }
        return operatorGroupList;
    }
}

