/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report.helper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.context.OperationContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.scmc.sm.report.consts.SalReportTaskConst;
import kd.scmc.sm.report.enums.SalReportTaskStatusEnum;
import kd.scmc.sm.report.pojo.SalReportTaskRunningInfo;
import kd.scmc.sm.report.thread.SalReportTaskRunnable;

public class SalRptTaskHelper {
    public static void runTask(Long reportTaskID) {
        String selectFields = SalReportTaskConst.generateSelector("ID", "billno", "taskstatus", "report", "conditionjson", "conditionjson_tag", "taskclass");
        DynamicObject reportTask = BusinessDataServiceHelper.loadSingle((Object)reportTaskID, (String)"sm_reporttask", (String)selectFields);
        if (reportTask != null) {
            SalRptTaskHelper.start(reportTask);
        }
    }

    public static void runTaskQueue() {
        String selectFields;
        DynamicObjectCollection waitingTasks;
        boolean isExistRunningTask = SalRptTaskHelper.isExistsRunningTask().isRunning();
        if (!isExistRunningTask && (waitingTasks = QueryServiceHelper.query((String)"sm_reporttask", (String)(selectFields = SalReportTaskConst.generateSelector("ID", "billno", "taskclass", "taskstatus", "report", "conditionjson", "conditionjson_tag")), (QFilter[])new QFilter[]{new QFilter("taskstatus", "=", (Object)SalReportTaskStatusEnum.WAITING.getValue())}, (String)"starttime", (int)1)) != null && waitingTasks.size() > 0) {
            DynamicObject reportTask = (DynamicObject)waitingTasks.get(0);
            SalRptTaskHelper.start(reportTask);
        }
    }

    public static SalReportTaskRunningInfo isExistsRunningTask() {
        DynamicObject user;
        DynamicObject reportTask;
        Long userID;
        SalReportTaskRunningInfo info = new SalReportTaskRunningInfo();
        boolean isRunning = QueryServiceHelper.exists((String)"sm_reporttask", (QFilter[])new QFilter[]{new QFilter("taskstatus", "=", (Object)SalReportTaskStatusEnum.RUNNING.getValue())});
        if (isRunning && (userID = Long.valueOf((reportTask = QueryServiceHelper.queryOne((String)"sm_reporttask", (String)"user", (QFilter[])new QFilter[]{new QFilter("taskstatus", "=", (Object)SalReportTaskStatusEnum.RUNNING.getValue())})).getLong("user"))) != null && (user = QueryServiceHelper.queryOne((String)"bos_user", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)userID)})) != null) {
            info.setUserName(user.getString("name"));
            info.setUserID(userID);
        }
        info.setRunning(isRunning);
        return info;
    }

    public static boolean isExistWaitingTask() {
        return QueryServiceHelper.exists((String)"sm_reporttask", (QFilter[])new QFilter[]{new QFilter("taskstatus", "=", (Object)SalReportTaskStatusEnum.WAITING.getValue())});
    }

    public static void deleteMiddleResult(DynamicObject[] tasks) {
        HashMap<String, Set> reportMidMap = new HashMap<String, Set>();
        for (DynamicObject task : tasks) {
            DynamicObject middlereport = task.getDynamicObject("middlereport");
            if (middlereport == null) continue;
            String middlereportEntity = middlereport.getString("id");
            Long taskID = (Long)task.getPkValue();
            Set taskIDSet = reportMidMap.computeIfAbsent(middlereportEntity, key -> new HashSet());
            taskIDSet.add(taskID);
        }
        reportMidMap.forEach((key, value) -> DeleteServiceHelper.delete((String)key, (QFilter[])new QFilter[]{new QFilter("reporttask", "in", value)}));
    }

    private static void start(DynamicObject reportTask) {
        String conditionjson = reportTask.getString("conditionjson_tag");
        FilterInfo filterInfo = (FilterInfo)SerializationUtils.deSerializeFromBase64((String)conditionjson);
        ReportQueryParam queryParam = new ReportQueryParam();
        queryParam.setFilter(filterInfo);
        try {
            if (!StringUtils.isNotEmpty((String)reportTask.getString("taskclass"))) {
                String taskNum = reportTask.getString("billno") == null ? "" : reportTask.getString("billno");
                String message = ResManager.loadKDString((String)"\u62a5\u8868\u4efb\u52a1\u201c%s\u201d\u7684\u6267\u884c\u7c7b\u672a\u5b9a\u4e49\u3002", (String)"SalRptTaskHelper_0", (String)"scmc-sm-report", (Object[])new Object[0]);
                message = String.format(message, taskNum);
                throw new KDBizException(message);
            }
            SalReportTaskRunnable taskRunnable = (SalReportTaskRunnable)TypesContainer.getOrRegisterSingletonInstance((String)reportTask.getString("taskclass"));
            taskRunnable.setReportTaskID(reportTask.getLong("ID"));
            taskRunnable.setQueryParam(queryParam);
            ThreadPools.executeOnce((String)"SalRptTaskHelper", (Runnable)taskRunnable, (OperationContext)new OperationContext());
        }
        catch (Exception e) {
            String taskNum = reportTask.getString("billno") == null ? "" : reportTask.getString("billno");
            String message = ResManager.loadKDString((String)"\u521b\u5efa\u62a5\u8868\u4efb\u52a1\u201c%s\u201d\u7684\u6267\u884c\u7c7b\u5931\u8d25\u3002", (String)"SalRptTaskHelper_1", (String)"scmc-sm-report", (Object[])new Object[0]);
            message = String.format(message, taskNum);
            throw new KDBizException(message);
        }
    }
}

