/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report.helper;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.orm.query.QFilter;

public class SmDeliverPlanRptHelper {
    public static String getSelectField() {
        ArrayList<String> selectorSet = new ArrayList<String>();
        selectorSet.add("customer");
        selectorSet.add("customer.name as customername");
        selectorSet.add("billentry.material.masterid.id as material");
        selectorSet.add("billentry.material.masterid.name as materialname");
        selectorSet.add("operator");
        selectorSet.add("operatorgroup");
        selectorSet.add("case when (closestatus = 'A' and (billentry.rowclosestatus = 'B' or billentry.rowterminatestatus = 'B') and billentry.orderdeliverentry.d_actdeliverydate is null and billentry.orderdeliverentry.d_actqty = 0)  or (closestatus = 'B' and billentry.orderdeliverentry.d_actqty = 0 and billentry.orderdeliverentry.d_actdeliverydate is null) or (closestatus = 'A' and (billentry.rowclosestatus = 'B' or billentry.rowterminatestatus = 'B') and billentry.orderdeliverentry.d_actdeliverydate <= billentry.orderdeliverentry.d_plandeliverydate)  or (closestatus = 'B' and billentry.orderdeliverentry.d_actdeliverydate <= billentry.orderdeliverentry.d_plandeliverydate) or (closestatus = 'A' and billentry.rowclosestatus = 'A' and billentry.rowterminatestatus = 'A' and billentry.orderdeliverentry.d_actdeliverydate <= billentry.orderdeliverentry.d_plandeliverydate and billentry.orderdeliverentry.d_actqty >= billentry.orderdeliverentry.d_planqty ) then 1 else 0 end as ontimenum");
        selectorSet.add("case when (closestatus = 'B' and billentry.orderdeliverentry.d_actdeliverydate > billentry.orderdeliverentry.d_plandeliverydate) or (closestatus = 'A' and (billentry.rowclosestatus = 'B' or billentry.rowterminatestatus = 'B') and billentry.orderdeliverentry.d_actdeliverydate > billentry.orderdeliverentry.d_plandeliverydate) or (closestatus = 'A' and billentry.rowclosestatus = 'A' and billentry.rowterminatestatus = 'A' and billentry.orderdeliverentry.d_actdeliverydate > billentry.orderdeliverentry.d_plandeliverydate and billentry.orderdeliverentry.d_actqty >= billentry.orderdeliverentry.d_planqty) then 1 else 0 end as overduenum");
        selectorSet.add("case when closestatus = 'A' and billentry.rowclosestatus = 'A' and billentry.rowterminatestatus = 'A' and billentry.orderdeliverentry.d_actqty < billentry.orderdeliverentry.d_planqty then 1 else 0 end as unfinishnum");
        return String.join((CharSequence)",", selectorSet);
    }

    public static List<QFilter> getFilters(FilterInfo filterInfo) {
        DynamicObjectCollection operators;
        DynamicObjectCollection operatorgroups;
        DynamicObjectCollection bizdepts;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DynamicObject org = filterInfo.getDynamicObject("orgfield");
        filters.add(new QFilter("org", "=", org.getPkValue()));
        DynamicObjectCollection materials = filterInfo.getDynamicObjectCollection("materialfield");
        if (materials != null && materials.size() > 0) {
            List<Long> materialIdS = SmDeliverPlanRptHelper.getBaseDataPkIds(materials);
            filters.add(new QFilter("billentry.material.masterid", "in", materialIdS));
        } else {
            filters.add(QFilter.isNotNull((String)"billentry.material.masterid"));
        }
        Date startDate = filterInfo.getDate("startdate");
        filters.add(new QFilter("billentry.orderdeliverentry.d_plandeliverydate", ">=", (Object)SmDeliverPlanRptHelper.getStartOrEndDate(startDate, false)));
        Date endDate = filterInfo.getDate("enddate");
        filters.add(new QFilter("billentry.orderdeliverentry.d_plandeliverydate", "<=", (Object)SmDeliverPlanRptHelper.getStartOrEndDate(endDate, true)));
        DynamicObjectCollection cusColl = filterInfo.getDynamicObjectCollection("customerfield");
        if (cusColl != null && cusColl.size() > 0) {
            ArrayList<Long> cusList = new ArrayList<Long>(16);
            List<Long> cuss = SmDeliverPlanRptHelper.getBaseDataPkIds(cusColl);
            for (int i = 0; i < cuss.size(); ++i) {
                cusList.add(cuss.get(i));
            }
            filters.add(new QFilter("customer", "in", cusList));
        }
        if ((bizdepts = filterInfo.getDynamicObjectCollection("deptfield")) != null && bizdepts.size() > 0) {
            List<Long> bizdeptsIds = SmDeliverPlanRptHelper.getBaseDataPkIds(bizdepts);
            filters.add(new QFilter("dept", "in", bizdeptsIds));
        }
        if ((operatorgroups = filterInfo.getDynamicObjectCollection("operategroupfield")) != null && operatorgroups.size() > 0) {
            List<Long> bizoperatorgroupIds = SmDeliverPlanRptHelper.getBaseDataPkIds(operatorgroups);
            filters.add(new QFilter("operatorgroup", "in", bizoperatorgroupIds));
        }
        if ((operators = filterInfo.getDynamicObjectCollection("operatorfield")) != null && operators.size() > 0) {
            List<Long> bizoperatorgroupIds = SmDeliverPlanRptHelper.getBaseDataPkIds(operators);
            filters.add(new QFilter("operator", "in", bizoperatorgroupIds));
        }
        return filters;
    }

    public static Date getStartOrEndDate(Date date, boolean isEnd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (isEnd) {
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
        } else {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
        }
        return cal.getTime();
    }

    public static List<Long> getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return new ArrayList<Long>(1);
        }
        ArrayList<Long> pkIds = new ArrayList<Long>(col.size());
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds.add((Long)baseData.getPkValue());
        }
        return pkIds;
    }
}

