/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report.helper;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;

public class SmDeliveryTimeRateRptHelper {
    private static final Log LOGGER = LogFactory.getLog(SmDeliveryTimeRateRptHelper.class);

    public static String getSelectField(ReportQueryParam param) {
        ArrayList<String> select = new ArrayList<String>();
        select.add("id");
        select.add("closestatus");
        select.add("billentry.id as entryid");
        select.add("billentry.deliverydate as deliverydate");
        select.add("billentry.invqty as invqty");
        select.add("billentry.qty as qty");
        select.add("billentry.rowclosestatus as rowclosestatus");
        select.add("billentry.rowterminatestatus as rowterminatestatus");
        select.add("auditdate");
        select.add("customer");
        select.add("org");
        List<Date> searchDate = SmDeliveryTimeRateRptHelper.getSearchDate(param);
        Date startDate = null;
        Date endDate = null;
        if (searchDate.size() > 0) {
            startDate = searchDate.get(0);
            endDate = searchDate.get(1);
            if (startDate != null && endDate != null) {
                startDate = SmDeliveryTimeRateRptHelper.getStartOrEndDate(startDate, false);
                endDate = SmDeliveryTimeRateRptHelper.getStartOrEndDate(endDate, true);
            }
        }
        select.add("case when to_char(billentry.deliverydate,'yyyy-MM-dd') >= '" + SmDeliveryTimeRateRptHelper.getStringDate(startDate) + "' and to_char(billentry.deliverydate,'yyyy-MM-dd') <= '" + SmDeliveryTimeRateRptHelper.getStringDate(endDate) + "' then 1 else 0 end as expireordernum");
        select.add("case when billentry.invqty < billentry.qty and billentry.rowclosestatus = 'A' and billentry.rowterminatestatus = 'A' and closestatus = 'A' then 1 else 0 end as todaynum");
        select.add("case when billentry.rowclosestatus = 'A' and billentry.rowterminatestatus = 'A' and billentry.invqty < billentry.qty then 1 else 0 end as overduenum");
        return String.join((CharSequence)",", select);
    }

    public static String getImSalOutSelectField() {
        ArrayList<String> select = new ArrayList<String>();
        select.add("biztime");
        select.add("billentry.mainbillid as srcbillid");
        select.add("billentry.mainbillentryid as srcbillentryid");
        return String.join((CharSequence)",", select);
    }

    public static List<QFilter> expireFilter(ReportQueryParam reportQueryParam) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        List<Date> searchDate = SmDeliveryTimeRateRptHelper.getSearchDate(reportQueryParam);
        if (searchDate.size() > 1) {
            QFilter dates = new QFilter("billentry.deliverydate", ">=", (Object)searchDate.get(0));
            QFilter datee = new QFilter("billentry.deliverydate", "<=", (Object)searchDate.get(1));
            filters.add(dates);
            filters.add(datee);
        }
        return filters;
    }

    public static List<QFilter> todayFilter() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter date = new QFilter("billentry.deliverydate", "=", (Object)SmDeliveryTimeRateRptHelper.getDate(TimeServiceHelper.today()));
        filters.add(date);
        return filters;
    }

    public static List<Date> getSearchDate(ReportQueryParam param) {
        ArrayList<Date> dateList = new ArrayList<Date>();
        Date date = null;
        FilterInfo filter = param.getFilter();
        List filterItems = filter.getFilterItems();
        for (FilterItemInfo itemInfo : filterItems) {
            String propName = itemInfo.getPropName();
            if ("startdate".equals(propName) || "enddate".equals(propName)) {
                date = (Date)itemInfo.getValue();
            }
            if (date == null) continue;
            dateList.add(date);
        }
        return dateList;
    }

    public static Date getStartOrEndDate(Date date, boolean isEnd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (isEnd) {
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
        } else {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
        }
        return cal.getTime();
    }

    public static Date getDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(10, 0);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static String getStringDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    public static Date[] getRecentThreeMonths() {
        Date[] dates = new Date[2];
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat format1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar startMonth = Calendar.getInstance();
        startMonth.add(2, -3);
        startMonth.set(5, startMonth.get(5));
        String start = format.format(startMonth.getTime()) + " 00:00:00";
        Calendar endMonth = Calendar.getInstance();
        endMonth.add(2, 0);
        endMonth.set(5, endMonth.get(5));
        String end = format.format(endMonth.getTime()) + " 23:59:59";
        try {
            Date parse = format1.parse(start);
            Date parse1 = format1.parse(end);
            dates[0] = parse;
            dates[1] = parse1;
        }
        catch (ParseException e) {
            LOGGER.error(e.getMessage());
        }
        return dates;
    }

    public static Date[] getThisMonth() {
        Date[] dates = new Date[2];
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(5, 1);
        SimpleDateFormat simpleFormate = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat simpleFormate1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String fd = simpleFormate.format(calendar.getTime()) + " 00:00:00";
        calendar.set(5, 1);
        ((Calendar)calendar).roll(5, -1);
        String ld = simpleFormate.format(calendar.getTime()) + " 23:59:59";
        try {
            Date firstDay = simpleFormate1.parse(fd);
            Date lastDay = simpleFormate1.parse(ld);
            dates[0] = firstDay;
            dates[1] = lastDay;
        }
        catch (ParseException e) {
            LOGGER.error(e.getMessage());
        }
        return dates;
    }

    public static Date[] getWeekDate() {
        Date[] dates = new Date[2];
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(1);
        int dayWeek = cal.get(7);
        if (dayWeek == 1) {
            dayWeek = 1;
        }
        cal.add(5, cal.getFirstDayOfWeek() - dayWeek);
        Date mondayDate = cal.getTime();
        String weekBegin = sdf.format(mondayDate) + " 00:00:00";
        cal.add(5, 5 + cal.getFirstDayOfWeek());
        Date sundayDate = cal.getTime();
        String weekEnd = sdf.format(sundayDate) + " 23:59:59";
        try {
            Date begin = sdf1.parse(weekBegin);
            Date end = sdf1.parse(weekEnd);
            dates[0] = begin;
            dates[1] = end;
        }
        catch (ParseException e) {
            LOGGER.error(e.getMessage());
        }
        return dates;
    }
}

