/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report.opplugin.validator;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.sm.report.enums.SalReportTaskStatusEnum;
import kd.scmc.sm.report.helper.SalRptTaskHelper;
import kd.scmc.sm.report.pojo.SalReportTaskRunningInfo;

public class SalTaskStartValidator
extends AbstractValidator {
    public void validate() {
        String lockIDs = (String)AppCache.get((String)"REPORT_APPCACHE").get("REPORT_ID", String.class);
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            if (bill == null) continue;
            if (SalReportTaskStatusEnum.RUNNING.getValue().equals(bill.getString("taskstatus"))) {
                this.addMessage(data, ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u4e2d\uff0c\u65e0\u6cd5\u91cd\u65b0\u542f\u52a8\u3002", (String)"SalTaskStartValidator_0", (String)"scmc-sm-report", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (SalReportTaskStatusEnum.WAITING.getValue().equals(bill.getString("taskstatus"))) {
                if (!this.checkExist(data)) continue;
                continue;
            }
            if (SalReportTaskStatusEnum.EXCEPTION.getValue().equals(bill.getString("taskstatus")) || SalReportTaskStatusEnum.SHUTDOWN.getValue().equals(bill.getString("taskstatus"))) {
                if (!this.checkExist(data)) continue;
                continue;
            }
            if (!SalReportTaskStatusEnum.COMPLETED.getValue().equals(bill.getString("taskstatus"))) continue;
            Object srcbillid = bill.getPkValue();
            String IDKey = String.valueOf(srcbillid) + ",";
            if (StringUtils.isNotEmpty((String)lockIDs) && lockIDs.contains(IDKey)) {
                this.addMessage(data, ResManager.loadKDString((String)"\u6b63\u5728\u67e5\u770b\u4efb\u52a1\u67e5\u8be2\u7ed3\u679c\uff0c\u8bf7\u5173\u95ed\u67e5\u8be2\u7ed3\u679c\u754c\u9762\u540e\u518d\u5c1d\u8bd5\u3002", (String)"SalTaskDelValidator_1", (String)"scmc-sm-report", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (this.checkExist(data)) continue;
            this.addWarningMessage(data, ResManager.loadKDString((String)"\u62a5\u8868\u4efb\u52a1\u5df2\u5b8c\u6210\uff0c\u91cd\u65b0\u542f\u52a8\u5c06\u6e05\u9664\u67e5\u8be2\u7ed3\u679c\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SalTaskStartValidator_2", (String)"scmc-sm-report", (Object[])new Object[0]));
        }
    }

    private boolean checkExist(ExtendedDataEntity data) {
        SalReportTaskRunningInfo salReportTaskRunningInfo = SalRptTaskHelper.isExistsRunningTask();
        boolean isExistRunningTask = salReportTaskRunningInfo.isRunning();
        if (isExistRunningTask) {
            if (salReportTaskRunningInfo.getUserID().equals(UserServiceHelper.getCurrentUserId())) {
                this.addMessage(data, ResManager.loadKDString((String)"\u5b58\u5728\u6b63\u5728\u6267\u884c\u7684\u4efb\u52a1\uff0c\u65e0\u6cd5\u91cd\u65b0\u542f\u52a8\u3002", (String)"SalTaskStartValidator_1", (String)"scmc-sm-report", (Object[])new Object[0]), ErrorLevel.Error);
            } else {
                String msg = ResManager.loadKDString((String)"\u7528\u6237%s\u7684\u4efb\u52a1\u4e2d\u5b58\u5728\u6267\u884c\u4e2d\u7684\u4efb\u52a1\uff0c\u4e0d\u5141\u8bb8\u91cd\u65b0\u542f\u52a8\u8be5\u4efb\u52a1\u3002", (String)"SalTaskStartValidator_3", (String)"scmc-sm-report", (Object[])new Object[0]);
                msg = String.format(msg, salReportTaskRunningInfo.getUserName());
                this.addMessage(data, msg, ErrorLevel.Error);
            }
            return true;
        }
        return false;
    }
}

