/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report.pojo;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;

public class MidResultInfo {
    private Map<Long, List<Map<String, Object>>> busRecords = new HashMap<Long, List<Map<String, Object>>>();
    private Map<Long, List<Map<String, Object>>> verifyRecords = new HashMap<Long, List<Map<String, Object>>>();
    private RowMeta busRowMeta;
    private RowMeta verifyRowMeta;

    public MidResultInfo(RowMeta busRowMeta, RowMeta verifyRowMetap) {
        this.busRowMeta = busRowMeta;
        this.verifyRowMeta = verifyRowMetap;
    }

    public RowMeta getVerifyRowMeta() {
        return this.verifyRowMeta;
    }

    public DataSet match(DataSet sourceBusDataSet) {
        HashMap isMatch = new HashMap();
        this.verifyRecords.forEach((k, v) -> {
            List<Map<String, Object>> busRecs = this.busRecords.get(k);
            if (busRecs != null) {
                block0: for (Map verifyInfo : v) {
                    String verfyDate = (String)verifyInfo.get("createtime");
                    BigDecimal verbaseqty = (BigDecimal)verifyInfo.get("verbaseqty");
                    for (Map<String, Object> busInfo : busRecs) {
                        BigDecimal subAmountAndTax;
                        BigDecimal subAmount;
                        String busDate = (String)busInfo.get("bizdate");
                        if (busDate.compareTo(verfyDate) > 0) continue;
                        isMatch.put("isMatch", Boolean.TRUE);
                        BigDecimal rate = (BigDecimal)busInfo.get("busrate");
                        BigDecimal baseQty = (BigDecimal)busInfo.get("baseqty");
                        if (verbaseqty.multiply(baseQty).compareTo(BigDecimal.ZERO) < 0) continue;
                        if (verbaseqty.abs().compareTo(baseQty.abs()) > 0) {
                            busInfo.put("busqty", BigDecimal.ZERO);
                            busInfo.put("qty", BigDecimal.ZERO);
                            busInfo.put("baseqty", BigDecimal.ZERO);
                            busInfo.put("busamount", BigDecimal.ZERO);
                            busInfo.put("busamountandtax", BigDecimal.ZERO);
                            verbaseqty = verbaseqty.subtract(baseQty);
                            continue;
                        }
                        if (verbaseqty.compareTo(baseQty) == 0) {
                            busInfo.put("busqty", BigDecimal.ZERO);
                            busInfo.put("qty", BigDecimal.ZERO);
                            busInfo.put("baseqty", BigDecimal.ZERO);
                            busInfo.put("busamount", BigDecimal.ZERO);
                            busInfo.put("busamountandtax", BigDecimal.ZERO);
                            continue block0;
                        }
                        BigDecimal surplusQty = baseQty.subtract(verbaseqty);
                        busInfo.put("busqty", surplusQty);
                        busInfo.put("qty", surplusQty.divide(rate, 10, 4));
                        busInfo.put("baseqty", surplusQty);
                        BigDecimal busAmount = (BigDecimal)busInfo.get("busamount");
                        BigDecimal busAmountAndTax = (BigDecimal)busInfo.get("busamountandtax");
                        int amtprecision = (Integer)busInfo.get("amtprecision");
                        BigDecimal price = (BigDecimal)busInfo.get("busprice");
                        BigDecimal priceAndTax = (BigDecimal)busInfo.get("buspriceandtax");
                        BigDecimal exchangerate = (BigDecimal)busInfo.get("exchangerate");
                        busAmount = busAmount.setScale(amtprecision, 4);
                        busAmountAndTax = busAmountAndTax.setScale(amtprecision, 4);
                        if (busInfo.get("quotation") != null && "1".equals(busInfo.get("quotation"))) {
                            subAmount = verbaseqty.divide(rate, 10, 4).multiply(price).divide(exchangerate, amtprecision, 4);
                            subAmountAndTax = verbaseqty.divide(rate, 10, 4).multiply(priceAndTax).divide(exchangerate, amtprecision, 4);
                        } else {
                            subAmount = verbaseqty.divide(rate, 10, 4).multiply(price).multiply(exchangerate).setScale(amtprecision, 4);
                            subAmountAndTax = verbaseqty.divide(rate, 10, 4).multiply(priceAndTax).multiply(exchangerate).setScale(amtprecision, 4);
                        }
                        busInfo.put("busamount", busAmount.subtract(subAmount));
                        busInfo.put("busamountandtax", busAmountAndTax.subtract(subAmountAndTax));
                        continue block0;
                    }
                }
            }
        });
        if (Boolean.TRUE.equals(isMatch.get("isMatch"))) {
            Algo algo = Algo.create((String)this.getClass().getName());
            ArrayList busRowList = new ArrayList();
            this.busRecords.forEach((k, v) -> {
                for (Map busMap : v) {
                    Object[] busInfo = new Object[this.busRowMeta.getFieldCount()];
                    Field[] fields4Bus = this.busRowMeta.getFields();
                    for (int i = 0; i < fields4Bus.length; ++i) {
                        busInfo[i] = busMap.get(fields4Bus[i].getName());
                    }
                    busRowList.add(busInfo);
                }
            });
            DataSet busDataSet = algo.createDataSet(busRowList.iterator(), this.busRowMeta);
            if (sourceBusDataSet != null) {
                try {
                    sourceBusDataSet.close();
                }
                catch (Throwable e) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5173\u95ed\u6682\u4f30\u6838\u9500\u6570\u636e\u6e90\u5931\u8d25\u3002", (String)"MidResultInfo_0", (String)"scmc-sm-report", (Object[])new Object[0]));
                }
            }
            return busDataSet;
        }
        return sourceBusDataSet;
    }

    public Map<Long, List<Map<String, Object>>> getBusRecords() {
        return this.busRecords;
    }

    public Map<Long, List<Map<String, Object>>> getVerifyRecords() {
        return this.verifyRecords;
    }
}

