/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report.salgrossprofit;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.sm.consts.SalGrossProfitRptConst;

public class SalGrossProfitCalcAmountFunction
extends MapFunction {
    Map<Object, DynamicObject> currencyMap;
    public static final BigDecimal HUNDRED = new BigDecimal("100");

    public SalGrossProfitCalcAmountFunction(Map<Object, DynamicObject> currencyMap) {
        this.currencyMap = currencyMap;
    }

    public RowX map(RowX rowX) {
        DynamicObject currency;
        RowMeta sourceRowMeta = super.getSourceRowMeta();
        int count = sourceRowMeta.getFieldCount();
        BigDecimal price = rowX.getBigDecimal(SalGrossProfitRptConst.PRICE_INDEX);
        BigDecimal taxRate = rowX.getBigDecimal(SalGrossProfitRptConst.TAXRATE_INDEX);
        BigDecimal actualCost = rowX.getBigDecimal(SalGrossProfitRptConst.ACTUALCOST_INDEX);
        BigDecimal amount = rowX.getBigDecimal(SalGrossProfitRptConst.AMOUNT_INDEX);
        BigDecimal localVerifyamt = rowX.getBigDecimal(SalGrossProfitRptConst.LOCALVERIFYAMT_INDEX);
        BigDecimal busAmount = rowX.getBigDecimal(SalGrossProfitRptConst.BUSAMOUNT_INDEX);
        BigDecimal amountAndTax = rowX.getBigDecimal(SalGrossProfitRptConst.AMOUNTANDTAX_INDEX);
        BigDecimal localVerifyamtAndTax = rowX.getBigDecimal(SalGrossProfitRptConst.LOCALVERIFYAMTANDTAX_INDEX);
        BigDecimal busAmountAndTax = rowX.getBigDecimal(SalGrossProfitRptConst.BUSAMOUNTANDTAX_INDEX);
        BigDecimal unitCost = rowX.getBigDecimal(SalGrossProfitRptConst.UNITCOST_INDEX);
        Long currencyID = rowX.getLong(SalGrossProfitRptConst.CURRENCY_INDEX);
        int amtprecision = 2;
        if (this.currencyMap != null && (currency = this.currencyMap.get(currencyID)) != null) {
            amtprecision = currency.getInt("amtprecision");
        }
        BigDecimal salAmount = amount.add(localVerifyamt).add(busAmount);
        salAmount = salAmount.setScale(amtprecision, 4);
        BigDecimal taxsalamount = amountAndTax.add(localVerifyamtAndTax).add(busAmountAndTax);
        taxsalamount = taxsalamount.setScale(amtprecision, 4);
        actualCost = actualCost.setScale(amtprecision, 4);
        rowX.set(SalGrossProfitRptConst.ACTUALCOST_INDEX, (Object)actualCost);
        BigDecimal unitgrossprofit = price.subtract(unitCost);
        BigDecimal salgrossprofit = salAmount.subtract(actualCost);
        BigDecimal[] newValues = new BigDecimal[SalGrossProfitRptConst.CALC_FIELDS.size()];
        newValues[0] = salAmount;
        newValues[1] = taxsalamount;
        newValues[2] = unitgrossprofit;
        newValues[3] = salgrossprofit;
        int index = 0;
        for (int i = count - newValues.length; i < count; ++i) {
            rowX.set(i, (Object)newValues[index]);
            ++index;
        }
        return rowX;
    }

    public RowMeta getResultRowMeta() {
        return super.getSourceRowMeta();
    }
}

