/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report.salgrossprofit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.conf.JoinBlockConf;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.scmc.sm.report.SalGrossProfitRptXQuery;
import kd.scmc.sm.report.consts.SalProfitKeyConst;
import kd.scmc.sm.report.helper.SalGrossProfitRptHelper;
import kd.scmc.sm.report.helper.SalGrossProfitXQueryHelper;
import kd.scmc.sm.report.salgrossprofit.SalGrossProfitCalUnitTansform;
import kd.scmc.sm.report.salgrossprofit.SalGrossProfitSumRowTansform;
import kd.scmc.sm.report.salgrossprofit.SalGrossProfitTransform;

public class SalGrossProfitHandle
implements IReportDataHandle {
    public void setupCtx(ReportDataCtx ctx) {
        super.setupCtx(ctx);
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        QFilter pageQF = SalGrossProfitHandle.getFilters(ctx);
        for (SrcBlockConf srcBlockConf : blockCollector) {
            String srcEntity = srcBlockConf.getSrcEntity();
            if (!SalProfitKeyConst.MAINENTITY.equalsIgnoreCase(srcEntity)) continue;
            QFilter dataFs = srcBlockConf.getDataFs();
            if (dataFs == null) {
                dataFs = QFilter.of((String)"1=1", (Object[])new Object[0]);
            }
            dataFs.and(pageQF);
            srcBlockConf.setDataFs(dataFs);
            HashSet<Long> billIDs = new HashSet<Long>();
            DataSet saloutBill = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)SalProfitKeyConst.MAINENTITY, (String)"id", (QFilter[])new QFilter[]{dataFs}, null);
            Throwable throwable = null;
            try {
                for (Row row : saloutBill) {
                    billIDs.add(row.getLong("id"));
                }
                ctx.getParams().put(SalProfitKeyConst.BILLIDS, new ArrayList(billIDs));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (saloutBill == null) continue;
                if (throwable != null) {
                    try {
                        saloutBill.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                saloutBill.close();
            }
        }
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        ReportQueryParam queryParam = new ReportQueryParam();
        Map param = ctx.getParams();
        if (param != null && param.get(SalProfitKeyConst.PAGEFILTER) != null) {
            FilterInfo pageFilter = (FilterInfo)param.get(SalProfitKeyConst.PAGEFILTER);
            queryParam.setFilter(pageFilter);
        }
        queryParam.getCustomParam().put(SalProfitKeyConst.ISGROUP, Boolean.FALSE);
        if (param != null && param.get(SalProfitKeyConst.BILLIDS) != null) {
            transCollector.add(new SalGrossProfitTransform(queryParam, (List)param.get(SalProfitKeyConst.BILLIDS)));
        } else {
            transCollector.add(new SalGrossProfitTransform(queryParam, new ArrayList<Long>()));
        }
    }

    public void beforeGroupData(ReportDataCtx ctx) {
        Collection keyCols = ctx.getGroupPlan().getKeyCols();
        Map param = ctx.getParams();
        if (param != null && param.get(SalProfitKeyConst.PAGEFILTER) != null) {
            FilterInfo pageFilter = (FilterInfo)param.get(SalProfitKeyConst.PAGEFILTER);
            List<String> pageGroup = SalGrossProfitRptXQuery.getGroupByProps(pageFilter, true);
            pageGroup.forEach(g -> {
                if (!keyCols.contains(g)) {
                    keyCols.add(g);
                }
            });
        }
        if (!keyCols.contains("currency")) {
            keyCols.add("currency");
        }
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        Collection keyCols = ctx.getGroupPlan().getQtyCols();
        if (keyCols.size() > 0) {
            transCollector.add(new SalGrossProfitCalUnitTansform());
        }
    }

    public void beforeAddSumRow(ReportDataCtx ctx) {
        super.beforeAddSumRow(ctx);
    }

    public void transFormAfterAddSumRow(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        super.transFormAfterAddSumRow(transCollector, ctx);
        if (this.isSumAgain(ctx)) {
            transCollector.add(new SalGrossProfitSumRowTansform());
        }
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        super.transformResult(transCollector, ctx);
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        for (int i = cols.size() - 1; i >= 0; --i) {
            String caption;
            if ("inventryid".equals(((ReportColumn)cols.get(i)).getFieldKey())) {
                cols.remove(i);
            }
            if (!this.isSumAgain(ctx) && SalProfitKeyConst.SUMFIELD.equals(((ReportColumn)cols.get(i)).getFieldKey())) {
                cols.remove(i);
            }
            if ("amount".equals(((ReportColumn)cols.get(i)).getFieldKey()) || "busamount".equals(((ReportColumn)cols.get(i)).getFieldKey()) || "localverifyamt".equals(((ReportColumn)cols.get(i)).getFieldKey())) {
                ((ReportColumn)cols.get(i)).setHide(true);
                continue;
            }
            if ("material_ref_name".equals(((ReportColumn)cols.get(i)).getFieldKey())) {
                caption = ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0", (String)"SalGrossProfitHandle_0", (String)"scmc-sm-report", (Object[])new Object[0]);
                cols.get(i).setCaption(new LocaleString(caption));
                continue;
            }
            if (!"material_ref_modelnum".equals(((ReportColumn)cols.get(i)).getFieldKey())) continue;
            caption = ResManager.loadKDString((String)"\u89c4\u683c\u578b\u53f7", (String)"SalGrossProfitHandle_1", (String)"scmc-sm-report", (Object[])new Object[0]);
            cols.get(i).setCaption(new LocaleString(caption));
        }
        return cols;
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        repoColFilter.add("inventryid");
        repoColFilter.add("price");
        repoColFilter.add("taxprice");
        repoColFilter.add("unitcost");
        repoColFilter.add("unitgrossprofit");
        repoColFilter.add("salgrossprofitrate");
        Map param = ctx.getParams();
        if (param != null && param.get(SalProfitKeyConst.PAGEFILTER) != null) {
            FilterInfo pageFilter = (FilterInfo)param.get(SalProfitKeyConst.PAGEFILTER);
            List<String> pageGroup = SalGrossProfitRptXQuery.getGroupByProps(pageFilter, true);
            pageGroup.forEach(g -> repoColFilter.add((String)g));
        }
        repoColFilter.add("currency");
    }

    public void handleBlockDataSelectCols(Set<String> repoColFilter, SrcBlockConf blockConf, ReportDataCtx ctx) {
        String srcEntity = blockConf.getSrcEntity();
        if (SalProfitKeyConst.MAINENTITY.equals(srcEntity)) {
            Map repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
            repoColFullSrcColMap.putIfAbsent("inventryid", "billentry.id");
            repoColFullSrcColMap.computeIfPresent("customer", (key, oldvalue) -> "customer.masterid");
        }
    }

    public static QFilter getFilters(ReportDataCtx ctx) {
        Map param = ctx.getParams();
        if (param != null && param.get(SalProfitKeyConst.PAGEFILTER) != null) {
            FilterInfo pageFilter = (FilterInfo)param.get(SalProfitKeyConst.PAGEFILTER);
            QFilter[] dateFilters = SalGrossProfitRptHelper.getDateFilters(pageFilter, "biztime", "invdate_startdate", "invdate_enddate");
            QFilter dateAllFilter = dateFilters[0];
            for (int i = 1; i < dateFilters.length; ++i) {
                dateAllFilter.or(dateFilters[i]);
            }
            QFilter pageQF = SalGrossProfitXQueryHelper.getSalOutFilters(pageFilter);
            QFilter pageEntryQF = SalGrossProfitXQueryHelper.getSalOutTotalFilters(pageFilter);
            pageQF.and(dateAllFilter).and(pageEntryQF);
            return pageQF;
        }
        return QFilter.of((String)"1=1", (Object[])new Object[0]);
    }

    public void modifyJoinBlocks(List<JoinBlockConf> joinBlockConfs, ReportDataCtx ctx) {
        super.modifyJoinBlocks(joinBlockConfs, ctx);
    }

    public void handleBlockDataSelectCols(Set<String> repoColFilter, JoinBlockConf blockConf, ReportDataCtx ctx) {
        super.handleBlockDataSelectCols(repoColFilter, blockConf, ctx);
    }

    private boolean isSumAgain(ReportDataCtx ctx) {
        Map param = ctx.getParams() != null ? ctx.getParams() : new HashMap();
        return Boolean.TRUE.equals(param.get("showtotalqty"));
    }
}

