/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report.salgrossprofit;

import java.sql.Date;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bd.sbd.enums.OperatorGrpTypeEnum;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.sm.business.helper.OrgHelper;
import kd.scmc.sm.report.consts.SalProfitKeyConst;
import kd.scmc.sm.report.helper.SalGrossProfitRptHelper;

public class SalGrossProfitRptXSPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(SalGrossProfitRptXSPlugin.class);
    private static final Set<String> DEFAULT_EXPAND_GROUPBY = new HashSet<String>(){
        {
            this.add("currency");
            this.add("baseunit");
        }
    };
    private static final String HAS_PERMISSION_SAL_ORG = "hasPermissionPurOrg";

    public void registerListener(EventObject e) {
        BasedataEdit customer_f;
        BasedataEdit material_f;
        BasedataEdit operator;
        BasedataEdit mat;
        BasedataEdit salorg;
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getView().getControl("entrysettleorg_f");
        if (org != null) {
            org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((salorg = (BasedataEdit)this.getView().getControl("bizorg_f")) != null) {
            salorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((mat = (BasedataEdit)this.getView().getControl("matstandard")) != null) {
            mat.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((operator = (BasedataEdit)this.getView().getControl("bizoperator_f")) != null) {
            operator.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((material_f = (BasedataEdit)this.getView().getControl("material_f")) != null) {
            material_f.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((customer_f = (BasedataEdit)this.getView().getControl("customer_f")) != null) {
            customer_f.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit matroup = (BasedataEdit)this.getView().getControl("matroup");
        if (customer_f != null) {
            matroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void afterCreateNewData(EventObject e) {
        String[] values;
        List salOrgList;
        super.afterCreateNewData(e);
        Long orgId = RequestContext.get().getOrgId();
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org");
        List orgList = OrgHelper.getHasPermissionOrg((String)"sm_salgrossprofitrptx", (String)OrgHelper.getFisAccountViewType());
        if (orgList != null && orgList.size() > 0) {
            if (org.getBoolean("fisaccounting") && orgList.contains(orgId)) {
                this.getModel().setValue("entrysettleorg_f", (Object)new Object[]{orgId});
            } else {
                this.getModel().setValue("entrysettleorg_f", (Object)new Object[]{orgList.get(0)});
            }
        }
        String formId = this.getView().getFormShowParameter().getFormId();
        String pkSet = this.getPageCache().get(HAS_PERMISSION_SAL_ORG);
        if (pkSet == null || pkSet.length() < 1) {
            salOrgList = OrgHelper.getHasPermissionOrg((String)formId, (String)OrgHelper.getFisSaleViewType());
            this.getPageCache().put(HAS_PERMISSION_SAL_ORG, SerializationUtils.toJsonString((Object)salOrgList));
        } else {
            salOrgList = (List)SerializationUtils.fromJsonString((String)pkSet, List.class);
        }
        if (salOrgList != null && salOrgList.size() > 0) {
            if (org.getBoolean("fissale") && salOrgList.contains(orgId)) {
                this.getModel().setValue("bizorg_f", (Object)new Object[]{orgId});
            } else {
                this.getModel().setValue("bizorg_f", (Object)new Object[]{salOrgList.get(0)});
            }
        }
        Calendar now = Calendar.getInstance();
        this.getModel().setValue("invdate_enddate", (Object)SalGrossProfitRptHelper.getStartOrEndDate(now.getTime(), Boolean.TRUE));
        now.add(2, -1);
        this.getModel().setValue("invdate_startdate", (Object)SalGrossProfitRptHelper.getStartOrEndDate(now.getTime(), Boolean.FALSE));
        QFilter filter = new QFilter("ispreset", "=", (Object)Boolean.TRUE);
        DynamicObject one = BusinessDataServiceHelper.loadSingle((String)"bd_materialgroupstandard", (String)"id", (QFilter[])new QFilter[]{filter});
        this.getModel().setValue("matstandard", one.get("id"));
        String showkeycols = (String)this.getModel().getValue("showkeycols");
        ArrayList<String> groupList = new ArrayList<String>();
        for (String string : values = showkeycols.split(",")) {
            if (!StringUtils.isNotEmpty((String)string) || string.equals("acc") || !DEFAULT_EXPAND_GROUPBY.contains(string)) continue;
            groupList.add(string);
        }
        this.getModel().setValue("showkeycols", (Object)String.join((CharSequence)",", groupList));
        this.getModel().setValue("showtotalqty", (Object)Boolean.TRUE);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object oldValue = changeSet[0].getOldValue();
        switch (key) {
            case "bizorg_f": 
            case "entrysettleorg_f": {
                if (oldValue == null) break;
                this.getModel().setValue("bizoperator_f", null);
                this.getModel().setValue("material_f", null);
                this.getModel().setValue("customer_f", null);
                Object newValue = changeSet[0].getNewValue();
                if (null == newValue || ((MulBasedataDynamicObjectCollection)newValue).isEmpty()) {
                    this.getModel().setValue("matstandard", null);
                    break;
                }
                QFilter filter = new QFilter("ispreset", "=", (Object)Boolean.TRUE);
                DynamicObject one = BusinessDataServiceHelper.loadSingle((String)"bd_materialgroupstandard", (String)"id", (QFilter[])new QFilter[]{filter});
                this.getModel().setValue("matstandard", one.get("id"));
                this.getModel().setValue("matroup", null);
                break;
            }
            case "matstandard": {
                if (oldValue == null) break;
                this.getModel().setValue("matroup", null);
                this.getModel().setValue("material_f", null);
                break;
            }
            case "radiogroup": {
                this.getModel().setValue("material_f", null);
                this.getModel().setValue("customer_f", null);
                this.getModel().setValue("bizoperator_f", null);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (fieldKey) {
            case "entrysettleorg_f": {
                String pkSet = this.getPageCache().get("org");
                if (StringUtils.isEmpty((String)pkSet) || "null".equals(pkSet)) {
                    List orgList = OrgHelper.getHasPermissionOrg((String)"sm_salgrossprofitrptx", (String)OrgHelper.getFisAccountViewType());
                    this.getPageCache().put("org", SerializationUtils.toJsonString((Object)orgList));
                    showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)orgList));
                    break;
                }
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", SerializationUtils.fromJsonString((String)pkSet, List.class)));
                break;
            }
            case "bizorg_f": {
                String salpkSet = this.getPageCache().get("bizorg_f");
                if (StringUtils.isEmpty((String)salpkSet) || "null".equals(salpkSet)) {
                    List orgList = OrgHelper.getHasPermissionOrg((String)"sm_salgrossprofitrptx", (String)OrgHelper.getFisSaleViewType());
                    this.getPageCache().put("bizorg_f", SerializationUtils.toJsonString((Object)orgList));
                    showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)orgList));
                    break;
                }
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", SerializationUtils.fromJsonString((String)salpkSet, List.class)));
                break;
            }
            case "bizoperator_f": {
                Object bizOperators = null;
                if (!"1".equals(this.getModel().getValue("radiogroup"))) {
                    DynamicObjectCollection salorg = (DynamicObjectCollection)this.getModel().getValue("bizorg_f");
                    if (salorg == null || salorg.size() == 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalOrderBillRptPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    String formId = this.getView().getFormShowParameter().getFormId();
                    SalGrossProfitRptXSPlugin.getOperatorGroupByUser((DynamicObjectCollection)this.getModel().getValue("bizorg_f"), formId, showParameter);
                    break;
                }
                DynamicObjectCollection accorg = (DynamicObjectCollection)this.getModel().getValue("entrysettleorg_f");
                if (accorg == null || accorg.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"SalGrossProfitRptPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                QFilter typeFilter = new QFilter("opergrptype", "=", (Object)OperatorGrpTypeEnum.SALEGRP.getValue());
                showParameter.getListFilterParameter().setFilter(typeFilter);
                break;
            }
            case "matstandard": {
                if ("1".equals(this.getModel().getValue("radiogroup"))) {
                    DynamicObjectCollection accorg = (DynamicObjectCollection)this.getModel().getValue("entrysettleorg_f");
                    if (accorg != null && accorg.size() != 0) break;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"SalGrossProfitRptPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                DynamicObjectCollection salorg = (DynamicObjectCollection)this.getModel().getValue("bizorg_f");
                if (salorg != null && salorg.size() != 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalOrderBillRptPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            case "matroup": {
                DynamicObject org;
                DynamicObject matstandardX = (DynamicObject)this.getModel().getValue("matstandard");
                if (matstandardX == null) {
                    e.setCancel(true);
                    return;
                }
                DynamicObjectCollection salOrgsX = (DynamicObjectCollection)this.getModel().getValue("bizorg_f");
                DynamicObjectCollection accountOrgsX = (DynamicObjectCollection)this.getModel().getValue("entrysettleorg_f");
                if (salOrgsX != null && salOrgsX.size() > 0) {
                    org = (DynamicObject)((DynamicObject)salOrgsX.get(0)).get(1);
                    showParameter.setCustomParam("useOrg", (Object)org.getPkValue().toString());
                }
                if (accountOrgsX != null && accountOrgsX.size() > 0) {
                    org = (DynamicObject)((DynamicObject)accountOrgsX.get(0)).get(1);
                    showParameter.setCustomParam("useOrg", (Object)org.getPkValue().toString());
                }
                showParameter.setCustomParam("groupStandard", matstandardX.getPkValue());
                break;
            }
            case "material_f": {
                DynamicObject matstandard;
                DynamicObject org;
                List<Long> materiaOrgIds;
                if ("1".equals(this.getModel().getValue("radiogroup"))) {
                    DynamicObjectCollection accorg = (DynamicObjectCollection)this.getModel().getValue("entrysettleorg_f");
                    if (accorg == null || accorg.size() == 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"SalGrossProfitRptPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                } else {
                    DynamicObjectCollection salorg = (DynamicObjectCollection)this.getModel().getValue("bizorg_f");
                    if (salorg == null || salorg.size() == 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalOrderBillRptPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                }
                if ((materiaOrgIds = this.getCurrentOrgIds()) == null) {
                    return;
                }
                QFilter materialFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", materiaOrgIds, (boolean)true);
                showParameter.getListFilterParameter().setFilter(materialFilter);
                DynamicObjectCollection salOrgs = (DynamicObjectCollection)this.getModel().getValue("bizorg_f");
                DynamicObjectCollection accountOrgs = (DynamicObjectCollection)this.getModel().getValue("entrysettleorg_f");
                if (salOrgs != null && salOrgs.size() > 0) {
                    org = (DynamicObject)((DynamicObject)salOrgs.get(0)).get(1);
                    showParameter.setCustomParam("useOrg", (Object)org.getPkValue().toString());
                }
                if (accountOrgs != null && accountOrgs.size() > 0) {
                    org = (DynamicObject)((DynamicObject)accountOrgs.get(0)).get(1);
                    showParameter.setCustomParam("useOrg", (Object)org.getPkValue().toString());
                }
                if ((matstandard = (DynamicObject)this.getModel().getValue("matstandard")) == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"SalGrossProfitRptPlugin_2", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                showParameter.setCustomParam("groupStandard", (Object)String.valueOf(matstandard.getPkValue()));
                showParameter.setShowApproved(false);
                break;
            }
            case "customer_f": {
                List<Long> cusOrgIds;
                if ("1".equals(this.getModel().getValue("radiogroup"))) {
                    DynamicObjectCollection accorg = (DynamicObjectCollection)this.getModel().getValue("entrysettleorg_f");
                    if (accorg == null || accorg.size() == 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"SalGrossProfitRptPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                } else {
                    DynamicObjectCollection salorg = (DynamicObjectCollection)this.getModel().getValue("bizorg_f");
                    if (salorg == null || salorg.size() == 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalOrderBillRptPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                }
                if ((cusOrgIds = this.getCurrentOrgIds()) == null || cusOrgIds.size() == 0) {
                    return;
                }
                QFilter customerFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_customer", cusOrgIds, (boolean)true);
                showParameter.getListFilterParameter().setFilter(customerFilter);
                showParameter.setShowApproved(false);
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        LocalDate compareDate;
        java.util.Date date;
        FilterInfo filter = queryParam.getFilter();
        if (filter == null) {
            return false;
        }
        if (filter != null && filter.getFilterItems() != null && filter.getFilterItems().size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u5237\u65b0\uff0c\u8bf7\u5148\u8fdb\u884c\u67e5\u8be2\u3002", (String)"SalGrossProfitRptPlugin_6", (String)"scmc-sm-report", (Object[])new Object[0]));
            return false;
        }
        String value = filter.getString("radiogroup");
        if ("1".equals(value)) {
            DynamicObjectCollection org = filter.getDynamicObjectCollection("entrysettleorg_f");
            if (org == null || org.size() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"SalGrossProfitRptPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]));
                return false;
            }
        } else {
            DynamicObjectCollection salorg = filter.getDynamicObjectCollection("bizorg_f");
            if (salorg == null || salorg.size() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalOrderBillRptPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]));
                return false;
            }
        }
        if ((date = filter.getDate("invdate_startdate")) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u51fa\u5e93\u5355\u65e5\u671f\u8303\u56f4\u3002", (String)"SalGrossProfitRptPlugin_3", (String)"scmc-sm-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject mat = filter.getDynamicObject("matstandard");
        if (mat == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"SalGrossProfitRptPlugin_2", (String)"scmc-sm-report", (Object[])new Object[0]));
            return false;
        }
        String dynamicObject = filter.getString("groupby");
        if (dynamicObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u7ea7\u6c47\u603b\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u79cd\u3002", (String)"SalGrossProfitRptPlugin_4", (String)"scmc-sm-report", (Object[])new Object[0]));
            return false;
        }
        java.util.Date startDate = filter.getDate("invdate_startdate");
        java.util.Date endDate = filter.getDate("invdate_enddate");
        Instant instant = endDate.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        int diffMonth = 999999999;
        try {
            diffMonth = filter.getInt("periodlimit");
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        if (diffMonth == 0) {
            diffMonth = 999999999;
        }
        if (startDate.before(Date.valueOf(compareDate = localDateTime.toLocalDate().minusMonths(diffMonth)))) {
            String message = ResManager.loadKDString((String)"\u9500\u552e\u51fa\u5e93\u5355\u65e5\u671f\u8303\u56f4\u4e0d\u5141\u8bb8\u8d85\u8fc7%s\u4e2a\u6708\u3002", (String)"SalGrossProfitRptPlugin_5", (String)"scmc-sm-report", (Object[])new Object[0]);
            message = String.format(message, diffMonth);
            this.getView().showTipNotification(message);
            return false;
        }
        LocalDate compareDateX = localDateTime.toLocalDate().minusYears(3L);
        if (startDate.before(Date.valueOf(compareDateX))) {
            String message = ResManager.loadKDString((String)"\u9500\u552e\u51fa\u5e93\u5355\u65e5\u671f\u8303\u56f4\u4e0d\u5141\u8bb8\u8d85\u8fc73\u5e74\u3002", (String)"SalGrossProfitRptPlugin_7", (String)"scmc-sm-report", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return false;
        }
        FormShowParameter showParam = this.getView().getFormShowParameter();
        Object isUseSQL = showParam.getCustomParam("isUseSQL");
        if (isUseSQL != null) {
            queryParam.getCustomParam().put("isUseSQL", String.valueOf(isUseSQL));
        }
        return true;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        queryParam.getCustomParam().put(SalProfitKeyConst.PAGEFILTER, filterInfo);
        queryParam.getCustomParam().put(SalProfitKeyConst.SHOWTOTALQTY, this.getModel().getValue(SalProfitKeyConst.SHOWTOTALQTY));
    }

    private List<Long> getCurrentOrgIds() {
        DynamicObjectCollection bizOrgs = null;
        if ("2".equals(this.getModel().getValue("radiogroup"))) {
            bizOrgs = (DynamicObjectCollection)this.getModel().getValue("bizorg_f");
        } else if ("1".equals(this.getModel().getValue("radiogroup"))) {
            bizOrgs = (DynamicObjectCollection)this.getModel().getValue("entrysettleorg_f");
        }
        List<Long> bizOrgIds = SalGrossProfitRptXSPlugin.getBaseDataPkIds(bizOrgs);
        return bizOrgIds;
    }

    private static List<Long> getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return null;
        }
        ArrayList<Long> pkIds = new ArrayList<Long>(col.size());
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds.add((Long)baseData.get("fbasedataid_id"));
        }
        return pkIds;
    }

    private static void getOperatorGroupByUser(DynamicObjectCollection sals, String formId, ListShowParameter showParameter) {
        if (sals != null) {
            ArrayList<Long> operatorGroupList = new ArrayList<Long>();
            List<Long> orgid = SalGrossProfitRptXSPlugin.getBaseDataPkIds(sals);
            QFilter typeFilter = new QFilter("operatorgrouptype", "=", (Object)OperatorGrpTypeEnum.SALEGRP.getValue());
            QFilter qFilter = new QFilter("ctrlstrategy", "in", (Object)Character.valueOf('5')).or(new QFilter("createorg", "in", orgid));
            DynamicObject[] operatorGroups = BusinessDataServiceHelper.load((String)"bd_operatorgroup", (String)"masterid", (QFilter[])new QFilter[]{typeFilter, qFilter});
            for (int i = 0; i < operatorGroups.length; ++i) {
                operatorGroupList.add(operatorGroups[i].getLong("masterid"));
            }
            QFilter filter1 = new QFilter("operatorgrpid", "in", operatorGroupList);
            showParameter.getListFilterParameter().setFilter(filter1);
        }
    }
}

