/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report.salgrossprofit;

import java.math.BigDecimal;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.util.StringUtils;

public class SalGrossProfitSumRowFunction
extends MapFunction {
    private static final long serialVersionUID = -663520203019637568L;
    private int lineTypeIdx;

    public SalGrossProfitSumRowFunction(int lineTypeIdx) {
        this.lineTypeIdx = lineTypeIdx;
    }

    public RowX map(RowX rowX) {
        RowMeta rowMeta = this.getResultRowMeta();
        int salAmountIndex = rowMeta.getFieldIndex("salamount");
        int costIndex = rowMeta.getFieldIndex("actualcost");
        int salGrossProfitIndex = rowMeta.getFieldIndex("salgrossprofit");
        int salgrossprofitRateIndex = rowMeta.getFieldIndex("salgrossprofitrate");
        String lineType = rowX.getString(this.lineTypeIdx);
        if (StringUtils.isNotEmpty((String)lineType) && !"0".equals(lineType)) {
            BigDecimal cost = rowX.getBigDecimal(costIndex) != null ? rowX.getBigDecimal(costIndex) : BigDecimal.ZERO;
            BigDecimal salAmount = rowX.getBigDecimal(salAmountIndex) != null ? rowX.getBigDecimal(salAmountIndex) : BigDecimal.ZERO;
            BigDecimal salGrossProfit = salAmount.subtract(cost);
            rowX.set(salGrossProfitIndex, (Object)salGrossProfit);
            if (BigDecimal.ZERO.compareTo(salAmount) == 0) {
                rowX.set(salgrossprofitRateIndex, (Object)BigDecimal.ZERO);
            } else {
                rowX.set(salgrossprofitRateIndex, (Object)salGrossProfit.multiply(new BigDecimal("100")).divide(salAmount, 2, 4));
            }
        }
        return rowX;
    }

    public RowMeta getResultRowMeta() {
        return super.getSourceRowMeta();
    }
}

