/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report.salgrossprofit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.algox.JoinDataSetX;
import kd.bos.algox.MapFunction;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.scmc.sm.consts.SalGrossProfitRptConst;
import kd.scmc.sm.report.SalGrossProfitRptXQuery;
import kd.scmc.sm.report.consts.SalProfitKeyConst;
import kd.scmc.sm.report.helper.SalGrossProfitXQueryHelper;
import kd.scmc.sm.report.salgrossprofit.SalGrossProfitCalcAmountFunction;
import kd.scmc.sm.report.salgrossprofit.SalGrossProfitSetFunction;

public class SalGrossProfitTransform
implements IDataXTransform {
    private ReportQueryParam queryParam;
    private List<Long> billIDs;

    public SalGrossProfitTransform(ReportQueryParam queryParam, List<Long> billIDs) {
        this.queryParam = queryParam;
        this.billIDs = billIDs;
    }

    public DataSetX doTransform(DataSetX srcData) {
        DataSet profitDatas = null;
        try {
            DataSetX profitDataX;
            if (this.billIDs.size() > 0) {
                List<List<Long>> subLists = this.divide(this.billIDs, 1000);
                for (int i = 0; i < subLists.size(); ++i) {
                    DataSet subProfitDatas = SalGrossProfitRptXQuery.searchTotolProfit(this.queryParam, subLists.get(i), false);
                    profitDatas = i == 0 ? subProfitDatas : (profitDatas != null ? profitDatas.union(subProfitDatas) : subProfitDatas);
                }
            } else {
                profitDatas = SalGrossProfitRptXQuery.searchTotolProfit(this.queryParam, this.billIDs, false);
            }
            if (profitDatas == null) {
                profitDatas = SalGrossProfitRptXQuery.searchTotolProfit(this.queryParam, this.billIDs, false);
            }
            if (!SalGrossProfitXQueryHelper.isExistField("inventryid", profitDatas.getRowMeta())) {
                profitDatas = profitDatas.addField("cast(0 as Long)", "inventryid");
                String[] profitDataFieldNames = profitDatas.getRowMeta().getFieldNames();
                String[] selectFields = new String[profitDataFieldNames.length];
                int index = -1;
                for (String profitFieldName : profitDataFieldNames) {
                    selectFields[++index] = SalGrossProfitRptXQuery.getSelectFieldByAlias(profitFieldName, profitFieldName, SalProfitKeyConst.RIGHTALIGS);
                }
                profitDatas = profitDatas.select(selectFields);
                DataSetInput profitDatasInput = new DataSetInput(profitDatas);
                JobSession buildSession = AlgoX.createSession((String)"SalGrossProfitTransform");
                profitDataX = buildSession.fromInput((Input)profitDatasInput);
            } else {
                DataSetInput profitDatasInput = new DataSetInput(profitDatas);
                JobSession buildSession = AlgoX.createSession((String)"SalGrossProfitTransform");
                profitDataX = buildSession.fromInput((Input)profitDatasInput);
                String invertoryIDField = SalGrossProfitRptXQuery.getSelectFieldByAlias("inventryid", "inventryid", SalProfitKeyConst.RIGHTALIGS);
                String[] baseSelector = SalGrossProfitRptXQuery.getShowSelectors(SalProfitKeyConst.RIGHTALIGS);
                String[] totalBaseSelector = new String[baseSelector.length + 1];
                System.arraycopy(baseSelector, 0, totalBaseSelector, 0, baseSelector.length);
                totalBaseSelector[baseSelector.length] = invertoryIDField;
                profitDataX = profitDataX.select(totalBaseSelector);
                ArrayList union_Fields = new ArrayList();
                ArrayList union_values = new ArrayList();
                SalGrossProfitRptConst.CALC_FIELDS.forEach(s -> {
                    Field newField = new Field(SalProfitKeyConst.RIGHTALIGS + s, (DataType)DataType.BigDecimalType);
                    union_Fields.add(newField);
                    union_values.add(BigDecimal.ZERO);
                });
                profitDataX = profitDataX.addFields(union_Fields.toArray(new Field[union_Fields.size()]), union_values.toArray());
                Map currencyMap = BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (String)"id, priceprecision, amtprecision", (QFilter[])new QFilter[]{QFilter.of((String)"1=1", (Object[])new Object[0])});
                profitDataX = profitDataX.map((MapFunction)new SalGrossProfitCalcAmountFunction(currencyMap));
            }
            String[] sraDataFields = srcData.getRowMeta().getFieldNames();
            String[] profitDataFields = profitDataX.getRowMeta().getFieldNames();
            String rightAlias = SalProfitKeyConst.RIGHTALIGS + "inventryid";
            JoinDataSetX saloutJoinProfitDataSetX = srcData.join(profitDataX).on("inventryid", rightAlias).select(sraDataFields, profitDataFields);
            srcData = saloutJoinProfitDataSetX.map((MapFunction)new SalGrossProfitSetFunction());
            srcData = srcData.select(sraDataFields);
        }
        catch (Exception e) {
            if (profitDatas != null) {
                profitDatas.close();
            }
            throw new KDBizException(e.getMessage());
        }
        return srcData;
    }

    private List<List<Long>> divide(List<Long> billIDs, int batchNum) {
        ArrayList newSubList;
        List<Long> subList;
        int batch = billIDs.size() / batchNum;
        ArrayList<List<Long>> divideLists = new ArrayList<List<Long>>(batch);
        for (int i = 0; i < batch; ++i) {
            subList = billIDs.subList(i * batchNum, (i + 1) * batchNum);
            newSubList = new ArrayList(subList.size());
            subList.forEach(e -> newSubList.add(e));
            divideLists.add(newSubList);
        }
        int modnum = billIDs.size() % batchNum;
        if (modnum > 0) {
            subList = billIDs.subList(batch * batchNum, batch * batchNum + modnum);
            newSubList = new ArrayList(subList.size());
            subList.forEach(e -> newSubList.add(e));
            divideLists.add(newSubList);
        }
        return divideLists;
    }
}

