/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report.salgrossprofit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bplat.scmc.report.util.TransformUtil;
import kd.scmc.sm.report.salgrossprofit.SalRowSumPlan;

public class SalRptAddSumRowFunc
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private Collection<String> keyCols;
    private Collection<String> qtyCols;
    private RowMeta rowMeta;
    private final Map<String, Integer> indexs;
    private final String sumColumnName;
    private int countTypeColIndex;

    public SalRptAddSumRowFunc(RowMeta rowMeta, SalRowSumPlan rowSumPlan) {
        this.rowMeta = rowMeta;
        this.keyCols = rowSumPlan.getSumKeyCols() == null ? Collections.emptySet() : rowSumPlan.getSumKeyCols();
        this.qtyCols = rowSumPlan.getSumQtyCols() == null ? Collections.emptySet() : rowSumPlan.getSumQtyCols();
        ArrayList<String> cols = new ArrayList<String>(this.keyCols.size() + this.qtyCols.size() + 1);
        cols.add("linetype");
        cols.addAll(this.keyCols);
        cols.addAll(this.qtyCols);
        this.indexs = TransformUtil.buildIndexs((RowMeta)rowMeta, cols);
        this.countTypeColIndex = this.indexs.get("linetype");
        this.sumColumnName = rowSumPlan.getSumColumnName();
    }

    public void reduce(Iterable<RowX> rows, Collector collector) {
        BigDecimal[] qtys = null;
        Object[] rowVals = null;
        int index = -1;
        for (RowX row : rows) {
            if (rowVals == null || qtys == null) {
                rowVals = new Object[row.size()];
                qtys = new BigDecimal[row.size()];
                for (String keyCol : this.keyCols) {
                    index = this.indexs.get(keyCol);
                    rowVals[index] = row.get(index);
                }
                for (String qtyCol : this.qtyCols) {
                    index = this.indexs.get(qtyCol);
                    qtys[index] = row.getBigDecimal(index);
                }
            } else {
                BigDecimal val = null;
                for (String qtyCol : this.qtyCols) {
                    index = this.indexs.get(qtyCol);
                    val = row.getBigDecimal(index);
                    if (val == null) continue;
                    qtys[index] = qtys[index].add(val);
                }
            }
            collector.collect(row);
        }
        if (rowVals != null && qtys != null) {
            int len = qtys.length;
            for (int i = 0; i < len; ++i) {
                if (qtys[i] == null) continue;
                rowVals[i] = qtys[i];
            }
            rowVals[this.countTypeColIndex] = this.sumColumnName;
            collector.collect(new RowX(rowVals));
        }
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

