/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report.salorder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.DataSetX;
import kd.bos.entity.plugin.support.util.ObjectUtils;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.mpscmm.msbd.business.helper.DataSetXHelper;
import kd.scmc.sm.report.salorder.AbstractDataXTransform;

public class OrderByTransform
extends AbstractDataXTransform {
    private static String[] mustFields = new String[]{"bizdate", "billno", "rowseq"};
    private static String[] orderByFields = new String[]{"bizdate desc", "billno desc", "rowseq asc"};

    public OrderByTransform(ReportDataCtx ctx) {
        super(ctx);
    }

    @Override
    boolean validFields(List<String> fields) {
        return true;
    }

    @Override
    DataSetX transform(DataSetX srcData) {
        Set sumKeyCols = this.ctx.getSumKeyCols();
        Object[] orderByFlds = OrderByTransform.removeUnOrderField(srcData.getRowMeta(), orderByFields);
        Object[] groupDimensions = sumKeyCols.toArray(new String[0]);
        if (!ObjectUtils.isEmpty((Object[])orderByFlds) && !ObjectUtils.isEmpty((Object[])groupDimensions)) {
            srcData = DataSetXHelper.orderByWithSubtotal((DataSetX)srcData, (String[])orderByFlds, (String[])groupDimensions);
        }
        if (!ObjectUtils.isEmpty((Object[])orderByFlds) && ObjectUtils.isEmpty((Object[])groupDimensions)) {
            srcData = srcData.orderBy((String[])orderByFlds);
        }
        return srcData;
    }

    public static String[] removeUnOrderField(RowMeta rowMeta, String[] orderByFields) {
        if (orderByFields == null) {
            return new String[0];
        }
        String[] rowMetaFields = rowMeta.getFieldNames();
        List<String> rowMetaList = Arrays.asList(rowMetaFields);
        ArrayList<String> orderByField = new ArrayList<String>();
        for (String fieldStr : orderByFields) {
            String[] fields = fieldStr.split(" ");
            String field = fields[0];
            if (!rowMetaList.contains(field)) continue;
            orderByField.add(fieldStr);
        }
        return orderByField.toArray(new String[0]);
    }
}

