/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report.salorder;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algox.DataSetX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.scmc.sm.enums.CloseStatusEnum;
import kd.scmc.sm.enums.RowCloseStatusEnum;
import kd.scmc.sm.enums.RowStatusRptEnum;
import kd.scmc.sm.enums.RowTerminateStatusEnum;
import kd.scmc.sm.enums.StatusEnum;
import kd.scmc.sm.report.helper.MultiOrganHelper;
import kd.scmc.sm.report.salorder.JoinFinArBillTransform;
import kd.scmc.sm.report.salorder.OrderByTransform;

public class SalOrderBillReportHandle
implements IReportDataHandle {
    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        Map params = ctx.getParams();
        List<QFilter> filters = this.getFilters(params);
        for (SrcBlockConf srcBlockConf : blockCollector) {
            String srcEntity = srcBlockConf.getSrcEntity();
            if (!"sm_salorder".equalsIgnoreCase(srcEntity)) continue;
            QFilter dataFs = srcBlockConf.getDataFs();
            if (dataFs == null) {
                dataFs = QFilter.of((String)"1=1", (Object[])new Object[0]);
            }
            for (QFilter filter : filters) {
                dataFs.and(filter);
            }
            srcBlockConf.setDataFs(dataFs);
        }
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new OrderByTransform(ctx));
    }

    public void beforeGroupData(ReportDataCtx ctx) {
        Collection keyCols = ctx.getGroupPlan().getKeyCols();
        if (!keyCols.contains("settlecurrency")) {
            keyCols.add("settlecurrency");
        }
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        repoColFilter.add("id");
        repoColFilter.add("billentryid");
        repoColFilter.add("entrysettleorg");
        repoColFilter.add("settlecustomer");
        repoColFilter.add("auditdate");
        repoColFilter.add("settlecurrency");
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new JoinFinArBillTransform(ctx));
        transCollector.add(new IDataXTransform(){

            public DataSetX doTransform(DataSetX srcData) {
                return srcData.removeFields(new String[]{"billentryid", "entrysettleorg", "settlecustomer", "id"});
            }
        });
    }

    public void transFormAfterAddSumRow(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new OrderByTransform(ctx));
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        for (int i = cols.size() - 1; i >= 0; --i) {
            if (!"auditdate".equals(((ReportColumn)cols.get(i)).getFieldKey())) continue;
            cols.remove(i);
        }
        return cols;
    }

    public void handleBlockDataSelectCols(Set<String> repoColFilter, SrcBlockConf blockConf, ReportDataCtx ctx) {
        String srcEntity = blockConf.getSrcEntity();
        if ("sm_salorder".equals(srcEntity)) {
            Map repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
            repoColFullSrcColMap.putIfAbsent("id", "id");
            repoColFullSrcColMap.putIfAbsent("billentryid", "billentry.id");
            repoColFullSrcColMap.putIfAbsent("rowseq", "billentry.seq");
        }
    }

    private List<QFilter> getFilters(Map<String, Object> filterInfo) {
        DynamicObject billtype;
        DynamicObjectCollection salOrderBillNo;
        DynamicObjectCollection bizoperators;
        DynamicObjectCollection bizoperatorgroups;
        DynamicObjectCollection materials;
        String HEAD_ORG = "head_org";
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DynamicObjectCollection org = (DynamicObjectCollection)filterInfo.get(HEAD_ORG);
        if (org != null && !org.isEmpty()) {
            Object[] pkIds = SalOrderBillReportHandle.getBaseDataPkIds(org);
            filters.add(new QFilter("org", "in", (Object)pkIds));
        }
        Date startDate = (Date)filterInfo.get("startdate");
        filters.add(new QFilter("bizdate", ">=", (Object)SalOrderBillReportHandle.getStartOrEndDate(startDate, false)));
        Date endDate = (Date)filterInfo.get("enddate");
        filters.add(new QFilter("bizdate", "<=", (Object)SalOrderBillReportHandle.getStartOrEndDate(endDate, true)));
        DynamicObjectCollection customers = (DynamicObjectCollection)filterInfo.get("customerfield");
        if (customers != null && customers.size() > 0) {
            List ids = MultiOrganHelper.getMasterIds(customers);
            filters.add(new QFilter("customer.masterid", "in", ids));
        }
        if ((materials = (DynamicObjectCollection)filterInfo.get("materialfield")) != null && materials.size() > 0) {
            Object[] materialIds = SalOrderBillReportHandle.getBaseDataPkIds(materials);
            filters.add(new QFilter("billentry.material.masterid", "in", (Object)materialIds));
        } else {
            filters.add(QFilter.isNotNull((String)"billentry.material.masterid"));
            filters.add(QFilter.isNotNull((String)"billentry.material"));
        }
        DynamicObjectCollection bizdepts = (DynamicObjectCollection)filterInfo.get("bizdeptfield");
        if (bizdepts != null && bizdepts.size() > 0) {
            Object[] bizdeptsIds = SalOrderBillReportHandle.getBaseDataPkIds(bizdepts);
            filters.add(new QFilter("dept", "in", (Object)bizdeptsIds));
        }
        if ((bizoperatorgroups = (DynamicObjectCollection)filterInfo.get("bizoperatorgroupfield")) != null && bizoperatorgroups.size() > 0) {
            Object[] bizoperatorgroupIds = SalOrderBillReportHandle.getBaseDataPkIds(bizoperatorgroups);
            filters.add(new QFilter("operatorgroup", "in", (Object)bizoperatorgroupIds));
        }
        if ((bizoperators = (DynamicObjectCollection)filterInfo.get("bizoperatorfield")) != null && bizoperators.size() > 0) {
            Object[] bizoperatorIds = SalOrderBillReportHandle.getBaseDataPkIds(bizoperators);
            filters.add(new QFilter("operator", "in", (Object)bizoperatorIds));
        }
        if ((salOrderBillNo = (DynamicObjectCollection)filterInfo.get("selectbill")) != null && salOrderBillNo.size() > 0) {
            Object[] billNo = SalOrderBillReportHandle.getBaseDataPkIds(salOrderBillNo);
            filters.add(new QFilter("id", "in", (Object)billNo));
        }
        if ((billtype = (DynamicObject)filterInfo.get("billtypefield")) != null) {
            filters.add(new QFilter("billtype", "=", billtype.getPkValue()));
        }
        List<QFilter> statusfilters = SalOrderBillReportHandle.getStatusFilter(filterInfo);
        filters.addAll(statusfilters);
        return filters;
    }

    private static List<QFilter> getStatusFilter(Map<String, Object> filterInfo) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        String billstatus = (String)filterInfo.get("billstatusfield");
        if (!StatusEnum.AUDIT.getValue().equals(billstatus) && !"A".equals(billstatus)) {
            filters.add(new QFilter("billstatus", "!=", (Object)StatusEnum.AUDIT.getValue()));
            return filters;
        }
        if (StatusEnum.AUDIT.getValue().equals(billstatus)) {
            filters.add(new QFilter("billstatus", "=", (Object)StatusEnum.AUDIT.getValue()));
        }
        String closestatus = (String)filterInfo.get("closestatusfield");
        if (CloseStatusEnum.CLOSED.getValue().equals(closestatus) || CloseStatusEnum.UNCLOSED.getValue().equals(closestatus)) {
            filters.add(new QFilter("closestatus", "=", (Object)closestatus));
        }
        String rowstatus = (String)filterInfo.get("rowstatusfield");
        if (RowStatusRptEnum.FINISH.getValue().equals(rowstatus)) {
            QFilter qFilter = new QFilter("billentry.rowclosestatus", "=", (Object)RowCloseStatusEnum.ROWCLOSE.getValue());
            qFilter.or(new QFilter("billentry.rowterminatestatus", "=", (Object)RowTerminateStatusEnum.ROWTERMINATE.getValue()));
            filters.add(qFilter);
        } else if (RowStatusRptEnum.UNFINISH.getValue().equals(rowstatus)) {
            QFilter qFilter = new QFilter("billentry.rowclosestatus", "=", (Object)RowCloseStatusEnum.UNROWCLOSE.getValue());
            qFilter.and(new QFilter("billentry.rowterminatestatus", "=", (Object)RowTerminateStatusEnum.UNROWTERMINATE.getValue()));
            filters.add(qFilter);
        }
        return filters;
    }

    public static Date getStartOrEndDate(Date date, boolean isEnd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (isEnd) {
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
        } else {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
        }
        return cal.getTime();
    }

    private static Object[] getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return null;
        }
        Object[] pkIds = new Object[col.size()];
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds[i] = baseData.getPkValue();
        }
        return pkIds;
    }
}

