/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report.salrank;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.scmc.sm.report.helper.MultiOrganHelper;

public class SalRankRptHandle
implements IReportDataHandle {
    private static final String HEAD_ORG = "head_org";

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        List<QFilter> filters = SalRankRptHandle.getFilters(ctx.getParams());
        DynamicObjectCollection org = (DynamicObjectCollection)ctx.getParam(HEAD_ORG);
        QFilter q = null;
        List<Long> listOrgId = MultiOrganHelper.getAllOrg(org, true);
        long userId = UserServiceHelper.getCurrentUserId();
        DynamicObjectCollection operatorgroups = (DynamicObjectCollection)ctx.getParam("bizoperatorgroupfield");
        if (operatorgroups == null || operatorgroups.size() == 0) {
            q = MultiOrganHelper.getOrgGrpIsolationQfilter(listOrgId);
        }
        filters.add(q);
        for (SrcBlockConf srcBlockConf : blockCollector) {
            String srcEntity = srcBlockConf.getSrcEntity();
            if (!"sm_salorder".equalsIgnoreCase(srcEntity)) continue;
            QFilter dataFs = srcBlockConf.getDataFs();
            if (dataFs == null) {
                dataFs = QFilter.of((String)"1=1", (Object[])new Object[0]);
            }
            for (QFilter filter : filters) {
                dataFs.and(filter);
            }
            srcBlockConf.setDataFs(dataFs);
        }
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        repoColFilter.add("id");
    }

    public void handleBlockDataSelectCols(Set<String> repoColFilter, SrcBlockConf blockConf, ReportDataCtx ctx) {
        String srcEntity = blockConf.getSrcEntity();
        if ("sm_salorder".equals(srcEntity)) {
            Map repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
            repoColFullSrcColMap.putIfAbsent("id", "id");
        }
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new IDataTransform(){

            public DataSet doTransform(DataSet srcData) {
                RowMeta rowMeta = srcData.getRowMeta();
                int fieldIndex = rowMeta.getFieldIndex("amount", false);
                if (fieldIndex != -1) {
                    return srcData.orderBy(new String[]{"amount desc"});
                }
                return srcData;
            }
        });
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        for (AbstractReportColumn col : cols) {
            String fieldKey;
            ReportColumn column = (ReportColumn)col;
            switch (fieldKey = column.getFieldKey()) {
                case "customer": {
                    col.setCaption(ResManager.getLocaleString((String)"\u8ba2\u8d27\u5ba2\u6237\u7f16\u7801", (String)"SalRankRptHandle_0", (String)"scmc-sm-report"));
                    break;
                }
                case "customer_ref_name": {
                    col.setCaption(ResManager.getLocaleString((String)"\u8ba2\u8d27\u5ba2\u6237\u540d\u79f0", (String)"SalRankRptHandle_1", (String)"scmc-sm-report"));
                    break;
                }
                case "material": {
                    col.setCaption(ResManager.getLocaleString((String)"\u7269\u6599\u7f16\u7801", (String)"SalRankRptHandle_2", (String)"scmc-sm-report"));
                    break;
                }
                case "material_ref_name": {
                    col.setCaption(ResManager.getLocaleString((String)"\u7269\u6599\u540d\u79f0", (String)"SalRankRptHandle_3", (String)"scmc-sm-report"));
                    break;
                }
                case "dept": {
                    col.setCaption(ResManager.getLocaleString((String)"\u9500\u552e\u90e8\u95e8\u7f16\u7801", (String)"SalRankRptHandle_4", (String)"scmc-sm-report"));
                    break;
                }
                case "dept_ref_name": {
                    col.setCaption(ResManager.getLocaleString((String)"\u9500\u552e\u90e8\u95e8\u540d\u79f0", (String)"SalRankRptHandle_5", (String)"scmc-sm-report"));
                    break;
                }
                case "operatorgroup": {
                    col.setCaption(ResManager.getLocaleString((String)"\u9500\u552e\u7ec4\u7f16\u7801", (String)"SalRankRptHandle_6", (String)"scmc-sm-report"));
                    break;
                }
                case "operatorgroup_ref_name": {
                    col.setCaption(ResManager.getLocaleString((String)"\u9500\u552e\u7ec4\u540d\u79f0", (String)"SalRankRptHandle_7", (String)"scmc-sm-report"));
                    break;
                }
                case "operator": {
                    col.setCaption(ResManager.getLocaleString((String)"\u9500\u552e\u5458\u7f16\u7801", (String)"SalRankRptHandle_8", (String)"scmc-sm-report"));
                    break;
                }
                case "operator_ref_operatorname": {
                    col.setCaption(ResManager.getLocaleString((String)"\u9500\u552e\u5458\u540d\u79f0", (String)"SalRankRptHandle_9", (String)"scmc-sm-report"));
                    break;
                }
                case "modelnum": {
                    col.setCaption(ResManager.getLocaleString((String)"\u89c4\u683c\u578b\u53f7", (String)"SalRankRptHandle_10", (String)"scmc-sm-report"));
                    break;
                }
                case "unit": {
                    col.setCaption(ResManager.getLocaleString((String)"\u57fa\u672c\u5355\u4f4d", (String)"SalRankRptHandle_11", (String)"scmc-sm-report"));
                    break;
                }
                case "qty": {
                    col.setCaption(ResManager.getLocaleString((String)"\u9500\u552e\u6570\u91cf", (String)"SalRankRptHandle_12", (String)"scmc-sm-report"));
                    break;
                }
                case "currency": {
                    col.setCaption(ResManager.getLocaleString((String)"\u672c\u4f4d\u5e01", (String)"SalRankRptHandle_13", (String)"scmc-sm-report"));
                    break;
                }
                case "amount": {
                    col.setCaption(ResManager.getLocaleString((String)"\u9500\u552e\u91d1\u989d", (String)"SalRankRptHandle_14", (String)"scmc-sm-report"));
                    break;
                }
            }
        }
        return cols;
    }

    public static List<QFilter> getFilters(Map<String, Object> filterInfo) {
        DynamicObjectCollection operators;
        DynamicObjectCollection operatorgroups;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DynamicObjectCollection orgList = (DynamicObjectCollection)filterInfo.get(HEAD_ORG);
        if (orgList != null && orgList.size() > 0) {
            Object[] orgIds = SalRankRptHandle.getBaseDataPkIds(orgList);
            filters.add(new QFilter("org", "in", (Object)orgIds));
        }
        Date startDate = (Date)filterInfo.get("startdate");
        filters.add(new QFilter("bizdate", ">=", (Object)SalRankRptHandle.getStartOrEndDate(startDate, false)));
        Date endDate = (Date)filterInfo.get("enddate");
        filters.add(new QFilter("bizdate", "<=", (Object)SalRankRptHandle.getStartOrEndDate(endDate, true)));
        DynamicObjectCollection materials = (DynamicObjectCollection)filterInfo.get("materialfield");
        if (materials != null && materials.size() > 0) {
            Object[] materialIdS = SalRankRptHandle.getBaseDataPkIds(materials);
            filters.add(new QFilter("billentry.material.masterid", "in", (Object)materialIdS));
        } else {
            filters.add(QFilter.isNotNull((String)"billentry.material.masterid"));
        }
        DynamicObjectCollection bizdepts = (DynamicObjectCollection)filterInfo.get("bizdeptfield");
        if (bizdepts != null && bizdepts.size() > 0) {
            Object[] bizdeptsIds = SalRankRptHandle.getBaseDataPkIds(bizdepts);
            filters.add(new QFilter("dept", "in", (Object)bizdeptsIds));
        }
        if ((operatorgroups = (DynamicObjectCollection)filterInfo.get("bizoperatorgroupfield")) != null && operatorgroups.size() > 0) {
            Object[] bizoperatorgroupIds = SalRankRptHandle.getBaseDataPkIds(operatorgroups);
            filters.add(new QFilter("operatorgroup", "in", (Object)bizoperatorgroupIds));
        }
        if ((operators = (DynamicObjectCollection)filterInfo.get("bizoperatorfield")) != null && operators.size() > 0) {
            Object[] bizoperatorgroupIds = SalRankRptHandle.getBaseDataPkIds(operators);
            filters.add(new QFilter("operator", "in", (Object)bizoperatorgroupIds));
        }
        return filters;
    }

    public static Date getStartOrEndDate(Date date, boolean isEnd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (isEnd) {
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
        } else {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
        }
        return cal.getTime();
    }

    private static Object[] getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return null;
        }
        Object[] pkIds = new Object[col.size()];
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds[i] = baseData.getPkValue();
        }
        return pkIds;
    }
}

