/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report.salrank;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.sm.business.helper.OrgHelper;
import kd.scmc.sm.report.helper.MultiOrganHelper;

public class SalRankRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static final String HEAD_ORG = "head_org";

    public void registerListener(EventObject e) {
        BasedataEdit bizdept;
        BasedataEdit bizoperatorgroup;
        BasedataEdit bizoperator;
        BasedataEdit material;
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getView().getControl(HEAD_ORG);
        if (org != null) {
            org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((material = (BasedataEdit)this.getView().getControl("materialfield")) != null) {
            material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((bizoperator = (BasedataEdit)this.getView().getControl("bizoperatorfield")) != null) {
            bizoperator.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((bizoperatorgroup = (BasedataEdit)this.getView().getControl("bizoperatorgroupfield")) != null) {
            bizoperatorgroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((bizdept = (BasedataEdit)this.getView().getControl("bizdeptfield")) != null) {
            bizdept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Object statisticfield = this.getModel().getValue("statisticfield");
        this.setGroupKeys(statisticfield);
    }

    public void beforeBindData(EventObject e) {
        DynamicObjectCollection operateGroup;
        List orgList;
        IDataModel model = this.getModel();
        DynamicObjectCollection org = (DynamicObjectCollection)model.getValue(HEAD_ORG);
        if ((org == null || org.isEmpty()) && (orgList = OrgHelper.getHasPermissionOrg((String)"sm_salrankrpt_new", (String)"03")) != null && orgList.size() > 0) {
            long orgId = RequestContext.get().getOrgId();
            if (orgList.contains(orgId)) {
                this.getModel().setValue(HEAD_ORG, (Object)new Object[]{orgId});
            } else {
                this.getModel().setValue(HEAD_ORG, (Object)new Object[]{orgList.get(0)});
            }
        }
        Object startdate = this.getModel().getValue("startdate");
        Object enddate = this.getModel().getValue("enddate");
        if (startdate == null && enddate == null) {
            this.setdefaultDate();
        }
        if ((operateGroup = (DynamicObjectCollection)this.getModel().getValue("bizoperatorgroupfield")) == null || operateGroup.size() == 0) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"bizoperatorfield"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"bizoperatorfield"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObjectCollection salOrgs = (DynamicObjectCollection)this.getModel().getValue(HEAD_ORG);
        List<Long> listOrgId = null;
        switch (key) {
            case "head_org": {
                List orgList = OrgHelper.getHasPermissionOrg((String)"sm_salrankrpt_new", (String)OrgHelper.getFisSaleViewType());
                formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)orgList));
                break;
            }
            case "materialfield": {
                if (salOrgs == null || salOrgs.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalOrderBillRptPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                listOrgId = MultiOrganHelper.getBaseDataLongIds(this.getView(), HEAD_ORG);
                QFilter bd_material = MultiOrganHelper.getBaseDataFilter("bd_material", listOrgId);
                if (bd_material == null) break;
                formShowParameter.getListFilterParameter().setFilter(bd_material);
                formShowParameter.setShowApproved(false);
                break;
            }
            case "bizoperatorgroupfield": {
                if (salOrgs == null || salOrgs.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalOrderBillRptPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                long userId = UserServiceHelper.getCurrentUserId();
                listOrgId = MultiOrganHelper.getBaseDataIds(salOrgs);
                QFilter f = MultiOrganHelper.getOrgGrpQfilter(listOrgId);
                formShowParameter.getListFilterParameter().setFilter(f);
                QFilter bd_operatorgroup = MultiOrganHelper.getBaseDataFilter("bd_operatorgroup", listOrgId);
                if (bd_operatorgroup == null) break;
                formShowParameter.getListFilterParameter().setFilter(bd_operatorgroup);
                formShowParameter.setShowApproved(false);
                break;
            }
            case "bizoperatorfield": {
                if (salOrgs == null || salOrgs.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalOrderBillRptPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                DynamicObjectCollection operateGroup = (DynamicObjectCollection)this.getModel().getValue("bizoperatorgroupfield");
                if (operateGroup == null || operateGroup.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u3002", (String)"SalRankRptPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                List<Long> groups = SalRankRptPlugin.getBaseDataPkIds(operateGroup);
                SalRankRptPlugin.getOperatorGroupByUser(groups, formShowParameter);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        switch (key) {
            case "bizoperatorgroupfield": {
                this.changeOperatorGroup((DynamicObjectCollection)newValue);
                break;
            }
            case "head_org": {
                this.getModel().setValue("materialfield", null);
                this.getModel().setValue("bizdeptfield", null);
                this.getModel().setValue("bizoperatorgroupfield", null);
                this.getModel().setValue("bizoperatorfield", null);
                break;
            }
            case "statisticfield": {
                this.setGroupKeys(newValue);
                break;
            }
        }
    }

    private void setGroupKeys(Object value) {
        if (value != null) {
            String groupKeys = "";
            String sumKeys = "amount";
            switch ((String)value) {
                case "A": {
                    groupKeys = "material,modelnum,unit,qty,currency,amount";
                    sumKeys = "qty,amount";
                    break;
                }
                case "B": {
                    groupKeys = "customer,currency,amount";
                    break;
                }
                case "C": {
                    groupKeys = "dept,currency,amount";
                    break;
                }
                case "D": {
                    groupKeys = "operatorgroup,currency,amount";
                    break;
                }
                case "E": {
                    groupKeys = "operatorgroup,operator,currency,amount";
                }
            }
            if (StringUtils.isNotEmpty((String)groupKeys)) {
                this.getModel().setValue("showkeycols", (Object)groupKeys);
                this.getModel().setValue("showqtycols", (Object)sumKeys);
            } else {
                this.getModel().setValue("showkeycols", null);
                this.getModel().setValue("showqtycols", null);
            }
        } else {
            this.getModel().setValue("showkeycols", null);
            this.getModel().setValue("showqtycols", null);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filter = queryParam.getFilter();
        DynamicObjectCollection org = filter.getDynamicObjectCollection(HEAD_ORG);
        if (org == null || org.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalOrderBillRptPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]));
            return false;
        }
        Object sign = filter.getFilterItem("statisticfield").getValue();
        if ("".equals(sign) || sign == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7edf\u8ba1\u4f9d\u636e\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"SalRankRptPlugin_2", (String)"scmc-sm-report", (Object[])new Object[0]));
            return false;
        }
        Date startdate = filter.getDate("startdate");
        Date enddate = filter.getDate("enddate");
        if (startdate != null && enddate != null) {
            return true;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u3002", (String)"SalOrderBillRptPlugin_3", (String)"scmc-sm-report", (Object[])new Object[0]));
        return false;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        queryParam.getCustomParam().put(HEAD_ORG, filterInfo.getDynamicObjectCollection(HEAD_ORG));
        queryParam.getCustomParam().put("startdate", filterInfo.getDate("startdate"));
        queryParam.getCustomParam().put("enddate", filterInfo.getDate("enddate"));
        queryParam.getCustomParam().put("materialfield", filterInfo.getDynamicObjectCollection("materialfield"));
        queryParam.getCustomParam().put("bizdeptfield", filterInfo.getDynamicObjectCollection("bizdeptfield"));
        queryParam.getCustomParam().put("bizoperatorgroupfield", filterInfo.getDynamicObjectCollection("bizoperatorgroupfield"));
        queryParam.getCustomParam().put("bizoperatorfield", filterInfo.getDynamicObjectCollection("bizoperatorfield"));
        queryParam.getCustomParam().put("statisticfield", filterInfo.getString("statisticfield"));
    }

    private void setdefaultDate() {
        IDataModel model = this.getModel();
        Calendar cal = Calendar.getInstance();
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        model.setValue("startdate", (Object)cal.getTime());
        model.setValue("enddate", (Object)cal.getTime());
    }

    private static void getOperatorGroupByUser(List<Long> list, ListShowParameter showParameter) {
        if (list.size() > 0) {
            QFilter filter1 = new QFilter("operatorgrpid", "in", list);
            showParameter.getListFilterParameter().setFilter(filter1);
        }
    }

    private static List<Long> getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return new ArrayList<Long>(1);
        }
        ArrayList<Long> pkIds = new ArrayList<Long>(col.size());
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds.add((Long)baseData.get("fbasedataid_id"));
        }
        return pkIds;
    }

    private void changeOperatorGroup(DynamicObjectCollection operatorGroup) {
        if (operatorGroup == null || operatorGroup.size() == 0) {
            this.getModel().setValue("bizoperatorfield", null);
            this.getView().setEnable(Boolean.FALSE, new String[]{"bizoperatorfield"});
        } else {
            this.getModel().setValue("bizoperatorfield", null);
            this.getView().setEnable(Boolean.TRUE, new String[]{"bizoperatorfield"});
        }
    }
}

