/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report.thread;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.sm.report.SalGrossProfitRptXQuery;
import kd.scmc.sm.report.enums.SalReportTaskStatusEnum;
import kd.scmc.sm.report.helper.SalGrossProfitRptHelper;
import kd.scmc.sm.report.thread.SalReportTaskRunnable;

public class SalGrossProfitRptTaskRunnable
extends SalReportTaskRunnable {
    private List<Long> saloutIdList;
    private boolean isUseSQL = false;
    private static final Log LOGGER = LogFactory.getLog(SalGrossProfitRptTaskRunnable.class);
    private static final BigDecimal midProcess = new BigDecimal("0.9");
    private static final BigDecimal midProcessLimit = new BigDecimal("0.95");

    public SalGrossProfitRptTaskRunnable(ReportQueryParam param, Long reportTaskID) {
        super(param, reportTaskID);
    }

    public SalGrossProfitRptTaskRunnable() {
    }

    @Override
    public boolean runTask(DynamicObject reportTask) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"sm_salprofitmidresult");
        FilterInfo filterInfo = this.queryParam.getFilter();
        Long batchNum = filterInfo.getLong("batchnum");
        LOGGER.info(new StringBuffer("thread actualbatchNum=").append(batchNum).toString());
        if (this.saloutIdList == null) {
            LOGGER.info("thread saloutIdList is null enter here");
            QFilter[] dateFilters = SalGrossProfitRptHelper.getDateFilters(filterInfo, "biztime", "invdate_startdate", "invdate_enddate");
            LOGGER.info("thread dateFilters'size=" + dateFilters.length);
            boolean isOK = true;
            for (int i = 0; i < dateFilters.length; ++i) {
                List<Long> saloutIdListLoop = SalGrossProfitRptXQuery.searchSaloutList(this.queryParam, dateFilters[i]);
                if (this.batchProcess(reportTask, batchNum, dateFilters.length, saloutIdListLoop)) continue;
                isOK = false;
                break;
            }
            if (isOK) {
                LOGGER.info("thread terminate total");
                if (this.terminate(type, reportTask)) {
                    return true;
                }
            }
        } else {
            LOGGER.info("thread saloutIdList is not null enter here");
            LOGGER.info("thread single saloutIdList'size=" + this.saloutIdList.size());
            if (this.batchProcess(reportTask, batchNum, 1, this.saloutIdList)) {
                LOGGER.info("thread terminate one");
                if (this.terminate(type, reportTask)) {
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean batchProcess(DynamicObject reportTask, Long batchNum, int periodNum, List<Long> saloutIdListParam) {
        ArrayList saloutIdBatch = new ArrayList();
        ArrayList<Long> singleBatch = null;
        for (int i = 0; i < saloutIdListParam.size(); ++i) {
            if ((long)i % batchNum == 0L) {
                singleBatch = new ArrayList<Long>();
                saloutIdBatch.add(singleBatch);
            }
            if (singleBatch == null) continue;
            singleBatch.add(saloutIdListParam.get(i));
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"sm_salprofitmidresult");
        BigDecimal progress = reportTask.getBigDecimal("progress");
        int i = 0;
        while (i < saloutIdBatch.size()) {
            singleBatch = (List)saloutIdBatch.get(i);
            try (DataSet midResult = SalGrossProfitRptXQuery.searchTotolProfit(this.queryParam, singleBatch, true);){
                if (this.isUseSQL) {
                    this.insertMidResult(midResult, false, reportTask);
                } else {
                    this.insertMidResult4ORM(type, midResult, false, reportTask);
                }
                progress = progress.add(midProcess.divide(new BigDecimal(saloutIdBatch.size() * periodNum), 4, 4));
                if (progress.compareTo(midProcessLimit) > 0) {
                    progress = midProcessLimit;
                }
                reportTask.set("progress", (Object)progress);
                reportTask.set("taskstatus", (Object)SalReportTaskStatusEnum.RUNNING.getValue());
                if (!this.checkTaskStatus(reportTask)) {
                    boolean bl = false;
                    return bl;
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{reportTask});
            }
            catch (Exception e) {
                this.recordExp(reportTask, e);
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean terminate(MainEntityType type, DynamicObject reportTask) {
        try (DataSet finalResult = SalGrossProfitRptXQuery.buildTotalResult4Task(this.reportTaskID, this.queryParam);){
            if (this.isUseSQL) {
                this.insertMidResult(finalResult, true, reportTask);
            } else {
                this.insertMidResult4ORM(type, finalResult, true, reportTask);
            }
        }
        catch (Exception e) {
            this.recordExp(reportTask, e);
            return false;
        }
        return true;
    }

    private void insertMidResult(DataSet midResult, boolean isNeedDeleteMidResult, DynamicObject reportTask) {
        if (midResult == null) {
            return;
        }
        LinkedList<Object[]> insertParamsList = new LinkedList<Object[]>();
        for (Row row : midResult) {
            Object[] param = new Object[midResult.getRowMeta().getFieldCount() + 2];
            for (int j = 0; j < midResult.getRowMeta().getFieldCount(); ++j) {
                Object value = row.get(j);
                param[j] = BigDecimal.class == value.getClass() ? ((BigDecimal)value).setScale(10, 4) : value;
            }
            param[midResult.getRowMeta().getFieldCount()] = this.reportTaskID;
            param[midResult.getRowMeta().getFieldCount() + 1] = this.getDB();
            insertParamsList.add(param);
        }
        if (isNeedDeleteMidResult) {
            this.clearMidResult(reportTask);
        }
        if (insertParamsList.size() > 0) {
            String[] fieldNames = midResult.getRowMeta().getFieldNames();
            CharSequence[] dbFieldNames = new String[fieldNames.length + 2];
            CharSequence[] valueSet = new String[fieldNames.length + 2];
            for (int s = 0; s < fieldNames.length; ++s) {
                dbFieldNames[s] = "f" + fieldNames[s];
                valueSet[s] = "?";
            }
            dbFieldNames[fieldNames.length] = "freporttask";
            dbFieldNames[fieldNames.length + 1] = "fid";
            valueSet[fieldNames.length] = "?";
            valueSet[fieldNames.length + 1] = "?";
            String insertFields = String.join((CharSequence)",", dbFieldNames);
            String valueFields = String.join((CharSequence)",", valueSet);
            StringBuilder inserSql = new StringBuilder("insert into t_sm_salprofitmidresult(");
            inserSql.append(insertFields);
            inserSql.append(") ");
            inserSql.append("values (");
            inserSql.append(valueFields);
            inserSql.append(')');
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)inserSql.toString(), insertParamsList);
        }
    }

    private void insertMidResult4ORM(MainEntityType type, DataSet finalResult, boolean isNeedDeleteMidResult, DynamicObject reportTask) {
        if (finalResult == null) {
            return;
        }
        Field[] fields = finalResult.getRowMeta().getFields();
        ArrayList<DynamicObject> reportMidResults = new ArrayList<DynamicObject>();
        for (Row row : finalResult) {
            DynamicObject reportMid = new DynamicObject((DynamicObjectType)type);
            reportMid.set("reporttask", (Object)this.reportTaskID);
            for (Field field : fields) {
                reportMid.set(field.getName(), row.get(field.getName()));
            }
            reportMidResults.add(reportMid);
        }
        if (isNeedDeleteMidResult) {
            this.clearMidResult(reportTask);
        }
        if (reportMidResults.size() > 0) {
            List<List<DynamicObject>> divideLists = this.divide(reportMidResults, 100000);
            for (List<DynamicObject> subList : divideLists) {
                SaveServiceHelper.save((DynamicObject[])subList.toArray(new DynamicObject[subList.size()]));
            }
        }
    }

    public void setUseSQL(boolean useSQL) {
        this.isUseSQL = useSQL;
    }

    public void setSaloutIdList(List<Long> saloutIdList) {
        this.saloutIdList = saloutIdList;
    }

    @Override
    public void clearMidResult(DynamicObject reportTask) {
        if (this.isUseSQL) {
            DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)"delete from t_sm_salprofitmidresult where freporttask=?", (Object[])new Object[]{this.reportTaskID});
        } else {
            super.clearMidResult(reportTask);
        }
    }

    private Object getDB() {
        return DB.genGlobalLongId();
    }

    private List<List<DynamicObject>> divide(List<DynamicObject> reportMidResults, int batchNum) {
        List<DynamicObject> subList;
        int batch = reportMidResults.size() / batchNum;
        ArrayList<List<DynamicObject>> divideLists = new ArrayList<List<DynamicObject>>(batch);
        for (int i = 0; i < batch; ++i) {
            subList = reportMidResults.subList(i * batchNum, (i + 1) * batchNum);
            divideLists.add(subList);
        }
        int modnum = reportMidResults.size() % batchNum;
        if (modnum > 0) {
            subList = reportMidResults.subList(batch * batchNum, batch * batchNum + modnum);
            divideLists.add(subList);
        }
        return divideLists;
    }
}

