/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report.thread;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.sm.report.consts.SalReportTaskConst;
import kd.scmc.sm.report.enums.SalReportTaskStatusEnum;
import kd.scmc.sm.report.helper.SalRptTaskHelper;

public abstract class SalReportTaskRunnable
implements Runnable {
    protected ReportQueryParam queryParam;
    protected Long reportTaskID;
    private static final Log LOGGER = LogFactory.getLog(SalReportTaskRunnable.class);

    public abstract boolean runTask(DynamicObject var1);

    protected void clearMidResult(DynamicObject reportTask) {
        if (reportTask != null) {
            SalRptTaskHelper.deleteMiddleResult(new DynamicObject[]{reportTask});
        }
    }

    public SalReportTaskRunnable(ReportQueryParam param, Long reportTaskID) {
        this.queryParam = param;
        this.reportTaskID = reportTaskID;
    }

    public void setQueryParam(ReportQueryParam queryParam) {
        this.queryParam = queryParam;
    }

    public void setReportTaskID(Long reportTaskID) {
        this.reportTaskID = reportTaskID;
    }

    public SalReportTaskRunnable() {
    }

    @Override
    public void run() {
        String selectProperties = SalReportTaskConst.generateSelector("ID", "billno", "middlereport", "starttime", "progress", "taskstatus", "taskexp", "taskexp_tag", "endtime");
        DynamicObject reportTask = BusinessDataServiceHelper.loadSingle((Object)this.reportTaskID, (String)"sm_reporttask", (String)selectProperties);
        if (!this.startTask(reportTask)) {
            return;
        }
        try {
            if (this.runTask(reportTask)) {
                this.completeTask(reportTask);
            }
        }
        catch (Exception e) {
            this.recordExp(reportTask, e);
        }
        SalRptTaskHelper.runTaskQueue();
    }

    protected void completeTask(DynamicObject reportTask) {
        if (this.checkTaskStatus(reportTask)) {
            reportTask.set("progress", (Object)BigDecimal.ONE);
            reportTask.set("taskstatus", (Object)SalReportTaskStatusEnum.COMPLETED.getValue());
            reportTask.set("taskexp_tag", (Object)"");
            reportTask.set("taskexp", (Object)"");
            reportTask.set("endtime", (Object)TimeServiceHelper.now());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{reportTask});
        }
    }

    protected boolean checkTaskStatus(DynamicObject reportTask) {
        DynamicObject reportTaskCheck = BusinessDataServiceHelper.loadSingle((Object)this.reportTaskID, (String)"sm_reporttask", (String)"taskstatus");
        if (reportTaskCheck == null || SalReportTaskStatusEnum.SHUTDOWN.getValue().equals(reportTaskCheck.getString("taskstatus"))) {
            this.clearMidResult(reportTask);
            return false;
        }
        return true;
    }

    protected void recordExp(DynamicObject reportTask, Exception e) {
        LOGGER.info("\u9500\u552e\u62a5\u8868\u4efb\u52a1\u53d1\u751f\u5f02\u5e38");
        String exp = "";
        exp = StringUtils.isNotEmpty((String)e.getMessage()) ? e.getMessage() : e.toString();
        reportTask.set("taskexp_tag", (Object)exp);
        if (StringUtils.isNotEmpty((String)exp)) {
            if (exp.length() > 511) {
                String expAbb = exp.substring(0, 511);
                reportTask.set("taskexp", (Object)expAbb);
            } else {
                reportTask.set("taskexp", (Object)exp);
            }
        }
        reportTask.set("taskstatus", (Object)SalReportTaskStatusEnum.EXCEPTION.getValue());
        String selectProperties = SalReportTaskConst.generateSelector("ID", "taskstatus");
        DynamicObject reportTaskCheck = BusinessDataServiceHelper.loadSingle((Object)reportTask.getPkValue(), (String)"sm_reporttask", (String)selectProperties);
        if (!SalReportTaskStatusEnum.SHUTDOWN.getValue().equals(reportTaskCheck.getString("taskstatus"))) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{reportTask});
        }
        this.clearMidResult(reportTask);
    }

    private boolean startTask(DynamicObject reportTask) {
        if (reportTask == null) {
            LOGGER.info("task has deleted");
            return false;
        }
        if (SalReportTaskStatusEnum.RUNNING.getValue().equals(reportTask.getString("taskstatus"))) {
            LOGGER.info("task is running already");
            return false;
        }
        boolean isExistRunningTask = SalRptTaskHelper.isExistsRunningTask().isRunning();
        if (!isExistRunningTask) {
            reportTask.set("progress", (Object)BigDecimal.ZERO);
            reportTask.set("taskstatus", (Object)SalReportTaskStatusEnum.RUNNING.getValue());
            reportTask.set("taskexp_tag", (Object)"");
            reportTask.set("taskexp", (Object)"");
            reportTask.set("starttime", (Object)TimeServiceHelper.now());
            reportTask.set("endtime", null);
            String taskNum = reportTask.getString("billno") == null ? "" : reportTask.getString("billno");
            LOGGER.info("task start " + taskNum);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{reportTask});
            return true;
        }
        reportTask.set("progress", (Object)BigDecimal.ZERO);
        reportTask.set("taskstatus", (Object)SalReportTaskStatusEnum.WAITING.getValue());
        reportTask.set("taskexp_tag", (Object)"");
        reportTask.set("taskexp", (Object)"");
        reportTask.set("starttime", (Object)TimeServiceHelper.now());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{reportTask});
        return false;
    }
}

