/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report.tpl;

import java.util.Arrays;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.sm.report.enums.SalReportTaskStatusEnum;
import kd.scmc.sm.report.helper.FilterHelper;

public abstract class AbstractSalRptTaskPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    protected abstract String[] getConditonControl();

    protected abstract String getContionTextControl();

    protected abstract String getContionTextFlex();

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.isFromSalTask()) {
            if (this.getConditonControl() != null && this.getConditonControl().length > 0) {
                this.getView().setVisible(Boolean.FALSE, this.getConditonControl());
            }
            if (this.getContionTextControl() != null || StringUtils.isNotEmpty((String)this.getContionTextControl())) {
                FormShowParameter showParam = this.getView().getFormShowParameter();
                Long srcbillid = (Long)showParam.getCustomParam("srcbillid");
                String selecties = String.join((CharSequence)",", Arrays.asList("billno", "conditiontext_tag"));
                DynamicObject reportTask = BusinessDataServiceHelper.loadSingle((Object)srcbillid, (String)"sm_reporttask", (String)selecties);
                String conditionText = reportTask.getString("conditiontext_tag");
                this.getModel().setValue(this.getContionTextControl(), (Object)conditionText);
            }
            this.lockID();
        } else if (StringUtils.isNotEmpty((String)this.getContionTextFlex())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{this.getContionTextFlex()});
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterInfo currentFilter = queryParam.getFilter();
        FormShowParameter showParam = this.getView().getFormShowParameter();
        Long mark = DB.genGlobalLongId();
        queryParam.getCustomParam().put("mark", String.valueOf(mark));
        this.getPageCache().put("mark", String.valueOf(mark));
        if (this.isFromSalTask()) {
            Long srcbillid = (Long)showParam.getCustomParam("srcbillid");
            String middlereport = (String)showParam.getCustomParam("middlereport");
            queryParam.getCustomParam().put("srcbillid", srcbillid);
            queryParam.getCustomParam().put("middlereport", middlereport);
            return;
        }
        queryParam.getCustomParam().remove("isEmpty");
        List<String> statusCon = Arrays.asList(SalReportTaskStatusEnum.SHUTDOWN.getValue(), SalReportTaskStatusEnum.EXCEPTION.getValue());
        QFilter userFilter = new QFilter("user", "=", (Object)RequestContext.get().getCurrUserId());
        QFilter statusFilter = new QFilter("taskstatus", "not in", statusCon);
        Map allTaskMap = BusinessDataServiceHelper.loadFromCache((String)"sm_reporttask", (QFilter[])new QFilter[]{userFilter, statusFilter});
        boolean existed = false;
        Set allTasks = allTaskMap.entrySet();
        Iterator allTaskIts = allTasks.iterator();
        String taskNum = "";
        while (allTaskIts.hasNext()) {
            Map.Entry taskEntry = allTaskIts.next();
            DynamicObject task = (DynamicObject)taskEntry.getValue();
            String condition = task.getString("conditionjson_tag");
            FilterInfo filterInfo = (FilterInfo)SerializationUtils.deSerializeFromBase64((String)condition);
            if (!FilterHelper.isEqual(filterInfo, currentFilter)) continue;
            taskNum = task.getString("billno");
            existed = true;
        }
        if (existed) {
            String message = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u67e5\u8be2\u6761\u4ef6\u7684\u67e5\u8be2\u4efb\u52a1\u201c%s\u201d\uff0c\u8bf7\u5728\u201c\u9500\u552e\u62a5\u8868\u67e5\u8be2\u4efb\u52a1\u201d\u9875\u9762\u67e5\u770b\u8fdb\u5ea6\u548c\u7ed3\u679c\u3002", (String)"AbstractSalRptTaskPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]);
            message = String.format(message, taskNum);
            this.getView().showTipNotification(message);
            queryParam.getCustomParam().put("isEmpty", "1");
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        Object taskNum;
        String mark = this.getPageCache().get("mark");
        if (mark != null && (taskNum = AppCache.get((String)"REPORT_APPCACHE").get(mark, Object.class)) instanceof String) {
            String message = ResManager.loadKDString((String)"\u672c\u6b21\u67e5\u8be2\u8d85\u8fc7\u5b9e\u65f6\u67e5\u8be2\u671f\u95f4\u6216\u5355\u636e\u91cf\u9650\u5b9a\u503c\uff0c\u5df2\u8f6c\u4e3a\u9500\u552e\u62a5\u8868\u4efb\u52a1\u201c%s\u201d\uff0c\u7a0d\u540e\u53ef\u5728\u201c\u9500\u552e\u62a5\u8868\u67e5\u8be2\u4efb\u52a1\u201d\u9875\u9762\u67e5\u770b\u8fdb\u5ea6\u548c\u7ed3\u679c\u3002", (String)"AbstractSalRptTaskPlugin_0", (String)"scmc-sm-report", (Object[])new Object[0]);
            message = String.format(message, taskNum);
            this.getView().showTipNotification(message);
            AppCache.get((String)"REPORT_APPCACHE").remove(mark);
        }
        super.afterQuery(queryParam);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormShowParameter showParam = this.getView().getFormShowParameter();
        Long srcbillid = (Long)showParam.getCustomParam("srcbillid");
        String middlereport = (String)showParam.getCustomParam("middlereport");
        if (srcbillid != null && middlereport != null && "kd.bos.form.operate.formop.Reset".equals(args.getSource().getClass().getName())) {
            args.setCancel(true);
        }
    }

    protected boolean isFromSalTask() {
        FormShowParameter showParam = this.getView().getFormShowParameter();
        Long srcbillid = (Long)showParam.getCustomParam("srcbillid");
        String middlereport = (String)showParam.getCustomParam("middlereport");
        return srcbillid != null && middlereport != null;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.releaseID();
    }

    private void lockID() {
        FormShowParameter showParam = this.getView().getFormShowParameter();
        Long srcbillid = (Long)showParam.getCustomParam("srcbillid");
        String IDKey = String.valueOf(srcbillid) + ",";
        String lockIDs = (String)AppCache.get((String)"REPORT_APPCACHE").get("REPORT_ID", String.class);
        if (StringUtils.isNotEmpty((String)lockIDs)) {
            lockIDs = lockIDs.replace(IDKey, "");
            lockIDs = lockIDs + IDKey;
            AppCache.get((String)"REPORT_APPCACHE").put("REPORT_ID", (Object)lockIDs);
        } else {
            AppCache.get((String)"REPORT_APPCACHE").put("REPORT_ID", (Object)IDKey);
        }
    }

    private void releaseID() {
        FormShowParameter showParam = this.getView().getFormShowParameter();
        Long srcbillid = (Long)showParam.getCustomParam("srcbillid");
        String IDKey = String.valueOf(srcbillid) + ",";
        String lockIDs = (String)AppCache.get((String)"REPORT_APPCACHE").get("REPORT_ID", String.class);
        if (StringUtils.isNotEmpty((String)lockIDs)) {
            lockIDs = lockIDs.replaceAll(IDKey, "");
            AppCache.get((String)"REPORT_APPCACHE").put("REPORT_ID", (Object)lockIDs);
        }
    }
}

