/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.report.tpl;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.input.OrmInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.MapFunction;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.scmc.sm.report.enums.SalReportTaskStatusEnum;
import kd.scmc.sm.report.helper.SalGrossProfitRptHelper;
import kd.scmc.sm.report.helper.SalRptTaskHelper;
import kd.scmc.sm.report.salgrossprofit.SalGrossProfitSumRowFunction;
import kd.scmc.sm.report.salgrossprofit.SalRowSumPlan;
import kd.scmc.sm.report.salgrossprofit.SalRptAddSumRowFunc;
import kd.scmc.sm.report.thread.SalReportTaskRunnable;

public abstract class AbstractSalRptTaskQuery
extends AbstractReportListDataPlugin {
    private static final Log log = LogFactory.getLog(AbstractSalRptTaskQuery.class);

    public abstract String getMidResultEntity();

    public abstract String getReportView();

    public abstract String getResultSelector();

    public abstract String getResultSort(ReportQueryParam var1);

    public abstract String getTaskRunningClass();

    protected abstract List<String> getConditionKey(ReportQueryParam var1);

    public abstract DataSet queryResult(ReportQueryParam var1, Object var2) throws Throwable;

    public DataSet query(ReportQueryParam queryParam, Object arg1) throws Throwable {
        if ("1".equals(queryParam.getCustomParam().get("isEmpty"))) {
            return this.getEmptyResult();
        }
        if (queryParam.getCustomParam().get("srcbillid") != null && queryParam.getCustomParam().get("middlereport") != null) {
            Long srcbillid = (Long)queryParam.getCustomParam().get("srcbillid");
            String middlereport = (String)queryParam.getCustomParam().get("middlereport");
            JobSession profitSession = AlgoX.createSession((String)"AbstractSalRptTaskQuery");
            OrmInput profitInput = new OrmInput("AbstractSalRptTaskQuery", middlereport, this.getResultSelector(), new QFilter[]{new QFilter("reporttask", "=", (Object)srcbillid)});
            DataSetX profitDataSetX = profitSession.fromInput((Input)profitInput);
            profitDataSetX = profitDataSetX.orderBy(new String[]{this.getResultSort(queryParam)});
            profitDataSetX = profitDataSetX.addFields(new Field[]{new Field("linetype", (DataType)DataType.StringType)}, new Object[]{""});
            String text = ResManager.loadKDString((String)"\u603b\u8ba1\u884c", (String)"AbstractSalRptTaskQuery_0", (String)"scmc-sm-report", (Object[])new Object[0]);
            SalRowSumPlan rowSumPlan = new SalRowSumPlan(text, null, SalGrossProfitRptHelper.getSumFields());
            SalRptAddSumRowFunc sumFunc = new SalRptAddSumRowFunc(profitDataSetX.getRowMeta(), rowSumPlan);
            profitDataSetX = profitDataSetX.reduceGroup((GroupReduceFunction)sumFunc);
            int typeIdx = profitDataSetX.getRowMeta().getFieldIndex("linetype", false);
            profitDataSetX = profitDataSetX.map((MapFunction)new SalGrossProfitSumRowFunction(typeIdx));
            DataSetOutput profitOutput = new DataSetOutput(profitDataSetX.getRowMeta());
            String profitOutPutId = profitOutput.getId();
            profitDataSetX.output((Output)profitOutput);
            profitSession.commit(3600, TimeUnit.SECONDS);
            DataSet profitDataSet = profitSession.readDataSet(profitOutPutId);
            return profitDataSet;
        }
        return this.queryResult(queryParam, arg1);
    }

    protected SalReportTaskRunnable initRunnable(ReportQueryParam queryParam, DynamicObject reportTask, Object argObj) {
        try {
            SalReportTaskRunnable taskRunnable = (SalReportTaskRunnable)TypesContainer.getOrRegisterSingletonInstance((String)this.getTaskRunningClass());
            taskRunnable.setReportTaskID((Long)reportTask.getPkValue());
            taskRunnable.setQueryParam(queryParam);
            return taskRunnable;
        }
        catch (Exception e) {
            String message = ResManager.loadKDString((String)"\u521b\u5efa\u62a5\u8868\u4efb\u52a1\u201c%s\u201d\u7684\u6267\u884c\u7c7b\u5931\u8d25\u3002", (String)"SalRptTaskHelper_1", (String)"scmc-sm-report", (Object[])new Object[0]);
            message = String.format(message, reportTask.getString("billno") == null ? "" : reportTask.getString("billno"));
            throw new KDBizException(message);
        }
    }

    protected DataSet getEmptyResult() {
        DataSet midresult = QueryServiceHelper.queryDataSet((String)"AbstractSalReportXQuery", (String)this.getMidResultEntity(), (String)this.getResultSelector(), (QFilter[])new QFilter[]{QFilter.of((String)"1=-1", (Object[])new Object[0])}, null);
        return midresult;
    }

    protected DynamicObject initReportTask(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        Long id = DBServiceHelper.genGlobalLongId();
        MainEntityType taskType = EntityMetadataCache.getDataEntityType((String)"sm_reporttask");
        DynamicObject reportTask = new DynamicObject((DynamicObjectType)taskType);
        reportTask.set("ID", (Object)id);
        String taskNo = CodeRuleServiceHelper.getNumber((String)"sm_reporttask", (DynamicObject)reportTask, null);
        reportTask.set("billno", (Object)taskNo);
        reportTask.set("user", (Object)RequestContext.get().getCurrUserId());
        reportTask.set("starttime", (Object)TimeServiceHelper.now());
        reportTask.set("middlereport", (Object)this.getMidResultEntity());
        reportTask.set("taskclass", (Object)this.getTaskRunningClass());
        reportTask.set("report", (Object)this.getReportView());
        MainEntityType reportType = EntityMetadataCache.getDataEntityType((String)this.getReportView());
        reportTask.set("reportname", (Object)reportType.getDisplayName().getLocaleValue());
        String conditionText = this.getConditionText(queryParam, reportType);
        reportTask.set("conditiontext_tag", (Object)conditionText);
        if (conditionText.length() > 255) {
            reportTask.set("conditiontext", (Object)new StringBuilder(conditionText.substring(0, 245)).append("\n").append("......"));
        } else {
            reportTask.set("conditiontext", (Object)conditionText);
        }
        reportTask.set("progress", (Object)BigDecimal.ZERO);
        reportTask.set("taskstatus", (Object)SalReportTaskStatusEnum.WAITING.getValue());
        reportTask.set("conditionjson_tag", (Object)SerializationUtils.serializeToBase64((Object)filterInfo));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{reportTask});
        return reportTask;
    }

    protected void returnTaskNumber(ReportQueryParam queryParam, DynamicObject reportTask) {
        Object test = queryParam.getCustomParam().get("mark");
        if (test != null) {
            AppCache.get((String)"REPORT_APPCACHE").put(String.valueOf(test), (Object)reportTask.getString("billno"));
        }
    }

    protected void excuteTask(ReportQueryParam queryParam, Object argObj) {
        DynamicObject reportTask = this.initReportTask(queryParam);
        this.runTask(queryParam, reportTask, argObj);
        this.returnTaskNumber(queryParam, reportTask);
    }

    protected void runTask(ReportQueryParam queryParam, DynamicObject reportTask, Object argObj) {
        boolean isExistRunningTask = SalRptTaskHelper.isExistsRunningTask().isRunning();
        if (!isExistRunningTask) {
            SalReportTaskRunnable logRunnable = this.initRunnable(queryParam, reportTask, argObj);
            ThreadPools.executeOnce((String)((Object)((Object)this)).getClass().getName(), (Runnable)logRunnable, (OperationContext)new OperationContext());
        }
    }

    private String getConditionText(ReportQueryParam queryParam, MainEntityType reportType) {
        FilterInfo filterInfo = queryParam.getFilter();
        List<String> conditonKeys = this.getConditionKey(queryParam);
        Map allFileds = reportType.getAllFields();
        ArrayList<String> contionTexts = new ArrayList<String>(16);
        for (String conditionKey : conditonKeys) {
            StringBuilder description;
            block23: {
                IDataEntityProperty property = (IDataEntityProperty)allFileds.get(conditionKey);
                String displayName = property.getDisplayName().getLocaleValue();
                FilterItemInfo filterItemInfo = filterInfo.getFilterItem(property.getName());
                Object value = filterItemInfo.getValue();
                if (value == null) continue;
                description = new StringBuilder();
                if (property instanceof DateProp) {
                    SimpleDateFormat dateFormate = new SimpleDateFormat("yyyy-MM-dd");
                    String dateStr = dateFormate.format(value);
                    description.append(displayName).append(" = ").append(dateStr);
                } else if (property instanceof MulBasedataProp) {
                    DynamicObjectCollection dcs = (DynamicObjectCollection)value;
                    ArrayList<String> valueStrs = new ArrayList<String>();
                    MulBasedataProp mulBasedataProp = (MulBasedataProp)property;
                    String baseEntityId = mulBasedataProp.getBaseEntityId();
                    for (DynamicObject ob : dcs) {
                        try {
                            String valueStr;
                            if ("bd_operator".equals(baseEntityId)) {
                                valueStr = ob.getLocaleString("operatorname").getLocaleValue();
                                valueStrs.add(valueStr);
                                continue;
                            }
                            valueStr = ob.getLocaleString("name").getLocaleValue();
                            valueStrs.add(valueStr);
                        }
                        catch (Exception exception) {}
                    }
                    description.append(displayName).append(" in ").append('(').append(String.join((CharSequence)",", valueStrs)).append(')');
                } else if (property instanceof BasedataProp) {
                    DynamicObject ob = (DynamicObject)value;
                    BasedataProp basedataProp = (BasedataProp)property;
                    String baseEntityId = basedataProp.getBaseEntityId();
                    try {
                        String valueStr;
                        if ("bd_operator".equals(baseEntityId)) {
                            valueStr = ob.getLocaleString("operatorname").getLocaleValue();
                            description.append(displayName).append(" = ").append(valueStr);
                            break block23;
                        }
                        valueStr = ob.getLocaleString("name").getLocaleValue();
                        description.append(displayName).append(" = ").append(valueStr);
                    }
                    catch (Exception valueStr) {}
                } else if (property instanceof BooleanProp) {
                    description.append(displayName).append(" = ").append(value);
                } else if (property instanceof MulComboProp) {
                    ArrayList<String> valueStrs = new ArrayList<String>();
                    String comboValue = (String)value;
                    String[] comboValues = comboValue.split(",");
                    List valueMapItems = ((MulComboProp)property).getComboItems();
                    block6: for (String combo : comboValues) {
                        if (!StringUtils.isNotEmpty((String)combo)) continue;
                        for (ValueMapItem item : valueMapItems) {
                            if (!combo.equals(item.getValue())) continue;
                            valueStrs.add(item.getName().getLocaleValue());
                            continue block6;
                        }
                    }
                    description.append(displayName).append(" in ").append('(').append(String.join((CharSequence)",", valueStrs)).append(')');
                } else if (property instanceof ComboProp) {
                    String combo = (String)value;
                    List valueMapItems = ((ComboProp)property).getComboItems();
                    if (StringUtils.isNotEmpty((String)combo)) {
                        for (ValueMapItem item : valueMapItems) {
                            if (!combo.equals(item.getValue())) continue;
                            description.append(displayName).append(" = ").append(item.getName().getLocaleValue());
                            break;
                        }
                    }
                }
            }
            contionTexts.add(description.toString());
        }
        String conditionText = String.join((CharSequence)"\n", contionTexts);
        return conditionText;
    }
}

