/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.botp.defvalue;

import java.util.Map;
import kd.bd.sbd.enums.OperatorGrpTypeEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.sm.business.helper.BillTplHelper;
import kd.scmc.sm.business.helper.BillTypeParameterHelper;
import kd.scmc.sm.business.helper.CustomerConvertInitHelper;
import kd.scmc.sm.business.helper.OrgHelper;
import kd.scmc.sm.enums.EnableStatusEnum;
import kd.scmc.sm.util.CommonUtils;

public class Bill2DeliverNoticeDefValueConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log log = LogFactory.getLog(Bill2DeliverNoticeDefValueConvertPlugin.class);

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(this.getTgtMainType().toString());
        if (entitys == null || entitys.length < 1) {
            return;
        }
        this.setDefaultValue(entitys);
        this.processAmount4BotpConvert(entitys);
    }

    private void processAmount4BotpConvert(ExtendedDataEntity[] entitys) {
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject bill = entity.getDataEntity();
            BillTplHelper.processAmount4BotpConvert((DynamicObject)bill);
        }
    }

    private void setDefaultValue(ExtendedDataEntity[] entitys) {
        DynamicObject bill = entitys[0].getDataEntity();
        DynamicObject billType = bill.getDynamicObject("billtype");
        DynamicObject billTypeParam = BillTypeParameterHelper.getBillTypeParameter((String)"sm_delivernotice", (long)((Long)billType.getPkValue()));
        DynamicObject bizType = billTypeParam.getDynamicObject("biztype");
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject targetObject = entity.getDataEntity();
            if (targetObject.get("biztype") == null) {
                targetObject.set("biztype", (Object)bizType);
            }
            if (targetObject.getDynamicObject("deliverorg") != null) {
                DynamicObject nowDeliverPattern;
                Long deliverOrg = (Long)targetObject.getDynamicObject("deliverorg").getPkValue();
                long userID = UserServiceHelper.getCurrentUserId();
                String operatorGrpType = OperatorGrpTypeEnum.INVENTORYGRP.getValue();
                QFilter qFilter01 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)deliverOrg);
                QFilter qFilter02 = new QFilter("operatorgrouptype", "=", (Object)operatorGrpType);
                QFilter qFilter03 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
                Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (QFilter[])new QFilter[]{qFilter01, qFilter02, qFilter03});
                if (map.size() != 0) {
                    QFilter qFilter11 = new QFilter("operatorgrpid", "in", map.keySet());
                    QFilter qFilter12 = new QFilter("operatorid", "=", (Object)userID);
                    QFilter qFilter13 = new QFilter("invalid", "=", (Object)Boolean.FALSE);
                    DynamicObject operator = BusinessDataServiceHelper.loadSingle((String)"bd_operator", (String)"operatorid,operatorid.phone,operatornumber,operatorname,operatorgrpid,opergrpnumber,opergrpname,opergrptype", (QFilter[])new QFilter[]{qFilter11, qFilter12, qFilter13});
                    if (!CommonUtils.isNull((Object)operator)) {
                        targetObject.set("deliveroperator", (Object)operator);
                        this.setRefObj(targetObject, operator.getLong("operatorgrpid"), "invgroup");
                        this.setRefObj(targetObject, UserServiceHelper.getUserMainOrgId((long)userID), "deliverdept");
                    } else {
                        targetObject.set("deliveroperator", null);
                        targetObject.set("invgroup", null);
                        targetObject.set("deliverdept", null);
                    }
                }
                if ((nowDeliverPattern = targetObject.getDynamicObject("deliverpattern")) == null) {
                    BasedataProp bdp = (BasedataProp)this.getTgtMainType().findProperty("deliverpattern");
                    QFilter qFilter = new QFilter("number", "=", (Object)"deliver");
                    DynamicObject deliverPattern = BusinessDataServiceHelper.loadSingleFromCache((String)bdp.getComplexType((Object)targetObject).getName(), (String)"id,number,name", (QFilter[])new QFilter[]{qFilter});
                    targetObject.set("deliverpattern", (Object)deliverPattern);
                }
                targetObject.set("ispush", (Object)Boolean.TRUE);
                DynamicObjectCollection entrys = targetObject.getDynamicObjectCollection("billentry");
                long inspectOrgID = OrgHelper.getDefaultOrgRelation((String)"", (String)"06", (Long)deliverOrg, (String)"toorg");
                DynamicObject inspectOrgDO = null;
                if (inspectOrgID > 0L) {
                    inspectOrgDO = BusinessDataServiceHelper.loadSingleFromCache((Object)inspectOrgID, (String)"bos_org");
                }
                for (int i = 0; i < entrys.size(); ++i) {
                    DynamicObject row = (DynamicObject)entrys.get(i);
                    row.set("deliverqtydown", row.get("qty"));
                    row.set("deliverqtyup", row.get("qty"));
                    row.set("inspectorg", (Object)inspectOrgDO);
                }
            }
            CustomerConvertInitHelper.setDefaultCustomerValue((DynamicObject)targetObject, (String)"customer");
        }
    }

    private void setRefObj(DynamicObject targetObject, Long refObjID, String property) {
        BasedataProp bdp = (BasedataProp)this.getTgtMainType().findProperty(property);
        DynamicObject refObj = BusinessDataServiceHelper.loadSingleFromCache((Object)refObjID, (DynamicObjectType)((DynamicObjectType)bdp.getComplexType((Object)targetObject)));
        targetObject.set(property, (Object)refObj);
    }
}

