/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pms.formplugin.adjust;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.sbd.enums.EnableStatusEnum;
import kd.bd.sbd.enums.StatusEnum;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.pricemodel.business.helper.adjust.PriceAdjustHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.adjust.PriceBatchAdjustInfo;
import kd.mpscmm.msbd.pricemodel.common.enums.adjust.AdjustFlagEnum;
import kd.scmc.pms.business.helper.PriceTplHelper;

public class SalePriceAdjustPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
EntryGridBindDataListener {
    public static Log logger = LogFactory.getLog(SalePriceAdjustPlugin.class);
    public static final String TAXRATE_FILTER = "taxrate_filter";
    public static final String ENABLE_LOT = "enable_lot";

    public void registerListener(EventObject e) {
        BasedataEdit customerEdit;
        BasedataEdit unit;
        BasedataEdit materialEdit;
        Toolbar toolbar;
        super.registerListener(e);
        Toolbar check = (Toolbar)this.getView().getControl("advcontoolbarap");
        check.addItemClickListener((ItemClickListener)this);
        BasedataEdit taxrateid = (BasedataEdit)this.getView().getControl("adjtaxrateid");
        if (taxrateid != null) {
            taxrateid.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((toolbar = (Toolbar)this.getView().getControl("tb_entry")) != null) {
            toolbar.addItemClickListener((ItemClickListener)this);
        }
        if ((materialEdit = (BasedataEdit)this.getView().getControl("material")) != null) {
            materialEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((unit = (BasedataEdit)this.getView().getControl("unit")) != null) {
            unit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((customerEdit = (BasedataEdit)this.getView().getControl("customer")) != null) {
            customerEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        String keyName = e.getEntryProp().getName();
        IDataModel model = this.getModel();
        switch (keyName) {
            case "customerentryentity": {
                for (RowDataEntity rowDataEntity : rowDataEntities) {
                    int rowIndex = rowDataEntity.getRowIndex();
                    model.setValue("cusadjustflag", (Object)AdjustFlagEnum.NEW.getValue(), rowIndex);
                }
                break;
            }
            case "priceentryentity": {
                for (RowDataEntity rowDataEntity : rowDataEntities) {
                    int rowIndex = rowDataEntity.getRowIndex();
                    model.setValue("adjustflag", (Object)AdjustFlagEnum.NEW.getValue(), rowIndex);
                }
                this.setLotEnable(Arrays.asList(rowDataEntities));
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object applyMaterial = this.getModel().getValue("applymaterial");
        Object applyCustomer = this.getModel().getValue("applycustomer");
        this.setMaterialVisible(applyMaterial.toString());
        this.setCustomerVisible(applyCustomer.toString());
        Boolean istax = (Boolean)this.getModel().getValue("istax");
        this.setPriceMustInput(istax);
        this.queryTaxrate();
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        IDataModel bill = this.getModel();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("priceentryentity");
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (key) {
            case "adjtaxrateid": {
                String taxrate_filter = this.getPageCache().get(TAXRATE_FILTER);
                taxrate_filter = taxrate_filter.substring(1, taxrate_filter.length() - 1);
                if (StringUtils.isNotEmpty((String)taxrate_filter)) {
                    String[] taxrateIds = taxrate_filter.split("_");
                    ArrayList<Long> taxrateIdList = new ArrayList<Long>(taxrateIds.length);
                    for (String id : taxrateIds) {
                        if (id == null || "".equals(id)) continue;
                        taxrateIdList.add(Long.valueOf(id));
                    }
                    QFilter filter = new QFilter("id", "in", taxrateIdList);
                    showParameter.getListFilterParameter().setFilter(filter);
                    break;
                }
                QFilter filter = QFilter.of((String)"1=-1", (Object[])new Object[0]);
                showParameter.getListFilterParameter().setFilter(filter);
                break;
            }
            case "unit": {
                DynamicObject material = (DynamicObject)bill.getValue("material", rowIndex);
                if (material == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u4fe1\u606f\u3002", (String)"SalesPricePlugin_3", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                DynamicObject masterMaterial = material.getDynamicObject("masterid");
                DynamicObject baseUnit = (DynamicObject)bill.getValue("baseunit", rowIndex);
                Long srcmuId = baseUnit == null ? Long.valueOf(0L) : (Long)baseUnit.getPkValue();
                Long masterMaterialId = (Long)masterMaterial.getPkValue();
                List unitIds = BaseDataServiceHelper.getAssistMUListResult((Long)masterMaterialId, (Long)srcmuId, (String)"1");
                QFilter qFilter = new QFilter("id", "in", (Object)unitIds);
                showParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("priceentryentity");
        if (entryGrid != null) {
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        this.setLotEnable(e.getRows());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("STOP".equals(this.getPageCache().get("STOP"))) {
            return;
        }
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        int row = e.getChangeSet()[0].getRowIndex();
        switch (propName) {
            case "adjtaxrateid": {
                for (int i = 0; i < valueSet.length; ++i) {
                    int rowIndex = valueSet[i].getRowIndex();
                    this.changeTaxRateID(newValue, rowIndex);
                    PriceAdjustHelper.caclPrice((int)rowIndex, (IDataModel)this.getModel());
                }
                break;
            }
            case "adjprice": 
            case "adjpriceandtax": {
                for (int i = 0; i < valueSet.length; ++i) {
                    int rowIndex = valueSet[i].getRowIndex();
                    PriceAdjustHelper.caclPrice((int)rowIndex, (IDataModel)this.getModel());
                }
                break;
            }
            case "materialgroup": {
                this.applyMaterialGroupNoChange((DynamicObject)newValue, row);
                break;
            }
            case "material": {
                this.applyMaterialNoChange((DynamicObject)newValue, row);
                RowDataEntity rowDataEntity = new RowDataEntity(row, this.getModel().getEntryRowEntity("priceentryentity", row));
                this.setLotEnable(Collections.singletonList(rowDataEntity));
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent e) {
        super.itemClick(e);
        String itemKey = e.getItemKey();
        IDataModel model = this.getModel();
        DynamicObjectCollection customerentryentitites = model.getEntryEntity("customerentryentity");
        EntryGrid grid = (EntryGrid)this.getView().getControl("customerentryentity");
        int[] rows = grid.getSelectRows();
        switch (itemKey) {
            case "cancel": {
                if (rows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"SalePriceAdjustPlugin_0", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    return;
                }
                Iterator it = customerentryentitites.iterator();
                Set rowSet = Arrays.stream(rows).boxed().collect(Collectors.toSet());
                int i = 0;
                while (it.hasNext()) {
                    DynamicObject customerentr = (DynamicObject)it.next();
                    if (rowSet.contains(i)) {
                        String cusadjustflagA = customerentr.getString("cusadjustflag");
                        if (AdjustFlagEnum.RETAIN.getValue().equals(cusadjustflagA)) {
                            customerentr.set("cusadjustflag", (Object)AdjustFlagEnum.CANCEL.getValue());
                        }
                        if (AdjustFlagEnum.NEW.getValue().equals(cusadjustflagA)) {
                            it.remove();
                        }
                    }
                    ++i;
                }
                this.getView().updateView("customerentryentity");
                break;
            }
            case "retain": {
                if (rows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"SalePriceAdjustPlugin_0", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                }
                for (int row : rows) {
                    DynamicObject customerentry = (DynamicObject)customerentryentitites.get(row);
                    Object cusadjustflagC = customerentry.get("cusadjustflag");
                    if (!cusadjustflagC.equals(AdjustFlagEnum.CANCEL.getValue())) continue;
                    model.setValue("cusadjustflag", (Object)AdjustFlagEnum.RETAIN.getValue(), row);
                }
                break;
            }
            case "batchadjust": {
                DynamicObjectCollection priceEntry = model.getEntryEntity("priceentryentity");
                if (priceEntry == null || priceEntry.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8c03\u6574\u660e\u7ec6\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SalePriceAdjustPlugin_1", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashMap map = new HashMap(priceEntry.size());
                for (int j = 0; j < priceEntry.size(); ++j) {
                    DynamicObject entry = (DynamicObject)priceEntry.get(j);
                    HashMap<String, BigDecimal> filed = new HashMap<String, BigDecimal>(8);
                    filed.put("adjprice", entry.getBigDecimal("adjprice"));
                    filed.put("adjpriceandtax", entry.getBigDecimal("adjpriceandtax"));
                    filed.put("adjpricefloor", entry.getBigDecimal("adjpricefloor"));
                    filed.put("adjpriceceiling", entry.getBigDecimal("adjpriceceiling"));
                    map.put(j, filed);
                }
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId("sm_batchadjustment");
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "batchadjust"));
                fsp.setCustomParams(map);
                this.getView().showForm(fsp);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("batchadjust".equals(actionId)) {
            int i;
            Map returnMap = (Map)e.getReturnData();
            if (returnMap == null) {
                return;
            }
            String scope = (String)returnMap.get("radiogroup");
            PriceBatchAdjustInfo adjustInFo = (PriceBatchAdjustInfo)returnMap.get("batchadjustinfo");
            int count = this.getModel().getEntryRowCount("priceentryentity");
            EntryGrid entryGrid = (EntryGrid)this.getControl("priceentryentity");
            int[] rows = entryGrid.getSelectRows();
            if ("ALL".equals(scope)) {
                rows = new int[count];
                for (i = 0; i < count; ++i) {
                    rows[i] = i;
                }
            }
            PriceAdjustHelper.caclAdjustResult(Collections.singletonList(adjustInFo), (DynamicObject)this.getModel().getDataEntity(true), (int[])rows);
            for (i = 0; i < rows.length; ++i) {
                String field = adjustInFo.getField();
                this.getView().updateView(field, rows[i]);
                this.getView().updateView("adjpriceandtax", rows[i]);
                this.getView().updateView("adjprice", rows[i]);
                this.getView().updateView("taxrate", rows[i]);
            }
        }
    }

    private void changeTaxRateID(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        if (newValue instanceof DynamicObject) {
            DynamicObject adjtaxRateID = (DynamicObject)newValue;
            model.setValue("taxrate", adjtaxRateID.get("taxrate"), rowIndex);
        } else {
            model.setValue("taxrate", (Object)0, rowIndex);
        }
    }

    private void setPriceMustInput(Boolean istax) {
        AmountEdit adjPriceAndTaxControl = (AmountEdit)this.getView().getControl("adjpriceandtax");
        AmountEdit adjPriceControl = (AmountEdit)this.getView().getControl("adjprice");
        if (istax.booleanValue()) {
            adjPriceAndTaxControl.setMustInput(true);
            adjPriceControl.setMustInput(false);
        } else {
            adjPriceAndTaxControl.setMustInput(false);
            adjPriceControl.setMustInput(true);
        }
    }

    private void setMaterialVisible(String newValue) {
        BasedataEdit materialControl = (BasedataEdit)this.getView().getControl("material");
        BasedataEdit materialGroupControl = (BasedataEdit)this.getView().getControl("materialgroup");
        BasedataEdit unitControl = (BasedataEdit)this.getView().getControl("unit");
        if (newValue != null && "A".equals(newValue)) {
            materialControl.setMustInput(true);
            unitControl.setMustInput(true);
            materialGroupControl.setMustInput(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"materialgroup"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"materialgroupname"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"material"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"materialname"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"model"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"auxpty"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"lotnumber"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"unit"});
        }
        if (newValue != null && "B".equals(newValue)) {
            materialGroupControl.setMustInput(true);
            unitControl.setMustInput(false);
            materialControl.setMustInput(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"material"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"materialname"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"model"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"auxpty"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"lotnumber"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"unit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"baseunit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"materialgroup"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"materialgroupname"});
        }
    }

    private void setCustomerVisible(String newValue) {
        if (newValue != null && "B".equals(newValue)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"cus_entry"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"customer"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"customername"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"customergroup"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"customergroupname"});
        }
        if (newValue != null && "C".equals(newValue)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"customer"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"customername"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"customergroup"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"customergroupname"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"cus_entry"});
        }
    }

    private void applyMaterialGroupNoChange(DynamicObject material, int row) {
        this.getPageCache().put("STOP", "STOP");
        this.getModel().setValue("taxrate", null, row);
        this.getModel().setValue("adjprice", null, row);
        this.getModel().setValue("adjpricefloor", null, row);
        this.getModel().setValue("adjpriceceiling", null, row);
        this.getModel().setValue("adjtaxrateid", null, row);
        this.getModel().setValue("adjpriceandtax", null, row);
        this.getPageCache().put("STOP", null);
    }

    private void queryTaxrate() {
        Date bizTime = (Date)this.getModel().getValue("createtime");
        List taxratelist = PriceTplHelper.getTaxRateFilter((Date)bizTime);
        if (taxratelist.size() > 0) {
            this.getPageCache().put(TAXRATE_FILTER, SerializationUtils.toJsonString((Object)String.join((CharSequence)"_", taxratelist)));
        }
    }

    private void setLotEnable(List<RowDataEntity> currencyRows) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (currencyRows.size() == 0 || org == null) {
            return;
        }
        HashMap<String, Boolean> lotCache = new HashMap();
        String lotCacheStr = this.getPageCache().get(ENABLE_LOT);
        if (StringUtils.isNotEmpty((String)lotCacheStr)) {
            lotCache = (Map)SerializationUtils.fromJsonString((String)lotCacheStr, Map.class);
        }
        HashSet<Long> materialSets = new HashSet<Long>();
        for (RowDataEntity row : currencyRows) {
            DynamicObject material;
            Long materialID;
            DynamicObject entryInfo = row.getDataEntity();
            if (entryInfo.getDynamicObject("material") == null || lotCache.containsKey(this.getLotCacheKey(materialID = (Long)(material = entryInfo.getDynamicObject("material").getDynamicObject("masterid")).getPkValue(), org.getPkValue()))) continue;
            materialSets.add(materialID);
        }
        if (materialSets.size() > 0) {
            List invOrgs = OrgUnitServiceHelper.getAllToOrg((String)"03", (String)"05", (Long)((Long)org.getPkValue()));
            invOrgs.add((Long)org.getPkValue());
            this.getLotCache(materialSets, invOrgs, lotCache);
        }
        for (RowDataEntity row : currencyRows) {
            int rowIndex = row.getRowIndex();
            DynamicObject entryInfo = row.getDataEntity();
            if (entryInfo.getDynamicObject("material") != null) {
                DynamicObject material = entryInfo.getDynamicObject("material").getDynamicObject("masterid");
                Boolean enablelot = (Boolean)lotCache.get(this.getLotCacheKey(material.getPkValue(), org.getPkValue()));
                if (!enablelot.booleanValue()) {
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"lotnumber"});
                    continue;
                }
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"lotnumber"});
                continue;
            }
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"lotnumber"});
        }
        this.getPageCache().put(ENABLE_LOT, SerializationUtils.toJsonString(lotCache));
    }

    private String getLotCacheKey(Object materialID, Object salOrgID) {
        return String.valueOf(materialID) + "-" + new StringBuilder(String.valueOf(salOrgID));
    }

    private void getLotCache(Set<Long> materialSets, List<Long> invOrgs, Map<String, Boolean> lotCache) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        QFilter materialFilter = new QFilter("masterid.id", "in", materialSets);
        QFilter orgFilter = new QFilter("org.id", "in", invOrgs);
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        Map result = BusinessDataServiceHelper.loadFromCache((String)"bd_materialinventoryinfo", (String)"enablelot,masterid", (QFilter[])new QFilter[]{orgFilter, materialFilter, statusFilter, enableFilter});
        HashSet<Long> materialIDs = new HashSet<Long>();
        Set entrySet = result.entrySet();
        for (Map.Entry entry : entrySet) {
            DynamicObject materialInvInfo = (DynamicObject)entry.getValue();
            Boolean enableLot = materialInvInfo.getBoolean("enablelot");
            if (!enableLot.booleanValue()) continue;
            materialIDs.add((Long)materialInvInfo.getDynamicObject("masterid").getPkValue());
        }
        materialSets.forEach(m -> {
            String cacheKey = this.getLotCacheKey(m, org.getPkValue());
            lotCache.put(cacheKey, Boolean.FALSE);
        });
        materialIDs.forEach(m -> {
            String cacheKey = this.getLotCacheKey(m, org.getPkValue());
            lotCache.put(cacheKey, Boolean.TRUE);
        });
    }

    private void applyMaterialNoChange(DynamicObject material, int row) {
        this.getPageCache().put("STOP", "STOP");
        this.getModel().setValue("taxrate", null, row);
        this.getModel().setValue("auxpty", null, row);
        this.getModel().setValue("adjprice", null, row);
        this.getModel().setValue("baseunit", null, row);
        this.getModel().setValue("adjpricefloor", null, row);
        this.getModel().setValue("adjpriceceiling", null, row);
        this.getModel().setValue("lotnumber", null, row);
        this.getModel().setValue("adjtaxrateid", null, row);
        this.getModel().setValue("adjpriceandtax", null, row);
        this.getModel().setValue("unit", null, row);
        if (material != null) {
            DynamicObject masterMaterial = material.getDynamicObject("masterid");
            if (masterMaterial.getDynamicObject("baseunit") != null) {
                this.getModel().setValue("baseunit", masterMaterial.getDynamicObject("baseunit").getPkValue(), row);
            }
            if (material.getDynamicObject("salesunit") != null) {
                this.getModel().setValue("unit", material.getDynamicObject("salesunit").getPkValue(), row);
            }
            String taxrate_filter = this.getPageCache().get(TAXRATE_FILTER);
            String[] taxrateIds = (taxrate_filter = taxrate_filter.substring(1, taxrate_filter.length() - 1)).split("_");
            if (taxrateIds.length > 0) {
                DynamicObject taxRate = (DynamicObject)material.get("masterid.taxrate");
                Long taxRateId = Long.valueOf("0");
                if (taxRate != null) {
                    taxRateId = taxRate.getLong("masterid");
                }
                if (Arrays.asList(taxrateIds).contains(taxRateId.toString())) {
                    DynamicObject taxrate = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_taxrate", (String)"taxrate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taxRateId)});
                    this.getModel().setValue("taxrate", (Object)taxrate.getBigDecimal("taxrate"), row);
                    this.getModel().setValue("adjtaxrateid", (Object)taxRateId, row);
                } else {
                    String applycustomer = (String)this.getModel().getValue("applycustomer");
                    if ("B".equals(applycustomer)) {
                        DynamicObjectCollection customers = this.getModel().getEntryEntity("customerentryentity");
                        HashSet<Long> isSet = new HashSet<Long>();
                        for (DynamicObject customer : customers) {
                            Long id;
                            DynamicObject c = (DynamicObject)customer.get("customer");
                            if (c == null || (id = (Long)c.get("taxrate.id")) == null || Long.valueOf("0").equals(id) || !Arrays.asList(taxrateIds).contains(id.toString())) continue;
                            isSet.add(id);
                        }
                        if (isSet.size() == 1) {
                            taxRateId = (Long)isSet.iterator().next();
                            this.getModel().setValue("adjtaxrateid", (Object)taxRateId, row);
                            DynamicObject customerTaxrate = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_taxrate", (String)"taxrate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taxRateId)});
                            this.getModel().setValue("taxrate", customerTaxrate.get("taxrate"), row);
                        }
                    }
                }
            }
        }
        this.getPageCache().put("STOP", null);
    }
}

