/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pms.formplugin.adjust;

import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.log.api.AppLogInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.mpscmm.msbd.business.helper.OperateLogHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.adjust.PriceAdjustHelper;
import kd.mpscmm.msbd.pricemodel.common.enums.adjust.AdjustModelEnum;
import kd.scmc.pms.business.helper.CurrencyHelper;
import kd.scmc.pms.consts.SalesPriceAdjustConst;
import kd.scmc.pms.consts.SalesPriceAdjustEntryConst;
import kd.scmc.pms.utils.CommonUtils;
import kd.scmc.sm.business.helper.RowOPHelper;
import org.apache.commons.lang3.StringUtils;

public class SalePriceBatchAdjustPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String[] QFILTER_FIELDS = new String[]{"org", "pricelisttype", "group", "customerentryentity.customer", "customerentryentity.customergroup", "priceentryentity.material", "priceentryentity.materialgroup", "currency"};

    public void registerListener(EventObject e) {
        BasedataEdit currencyEdit;
        BasedataEdit customerGroupEdit;
        BasedataEdit customerEdit;
        BasedataEdit materialGroupEdit;
        super.registerListener(e);
        BasedataEdit materialEdit = (BasedataEdit)this.getView().getControl("material");
        if (materialEdit != null) {
            materialEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((materialGroupEdit = (BasedataEdit)this.getView().getControl("materialgroup")) != null) {
            materialGroupEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((customerEdit = (BasedataEdit)this.getView().getControl("customer")) != null) {
            customerEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((customerGroupEdit = (BasedataEdit)this.getView().getControl("customergroup")) != null) {
            customerGroupEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((currencyEdit = (BasedataEdit)this.getView().getControl("currency")) != null) {
            currencyEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject currency;
        String formId = this.getView().getFormShowParameter().getFormId();
        Long orgid = this.getHasPermissionOrg(formId, OrgViewTypeEnum.IS_SALE.getViewType());
        this.getModel().setValue("org", (Object)orgid);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        if (this.getModel().getValue("currency") == null && (currency = CurrencyHelper.getCurrency((Long)((Long)org.getPkValue()))) != null) {
            this.getModel().setValue("currency", currency.getPkValue());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject customer = (DynamicObject)this.getModel().getValue("customer");
        DynamicObject customerGroup = (DynamicObject)this.getModel().getValue("customergroup");
        DynamicObject material = (DynamicObject)this.getModel().getValue("material");
        DynamicObject materialGroup = (DynamicObject)this.getModel().getValue("materialgroup");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalePriceBatchAdjustPlugin_0", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        switch (key) {
            case "customer": {
                if (customerGroup == null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5ba2\u6237\u548c\u5ba2\u6237\u5206\u7c7b\u4e0d\u80fd\u540c\u65f6\u7ef4\u62a4\u503c\u3002", (String)"SalePriceBatchAdjustPlugin_1", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            case "customergroup": {
                if (customer == null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5ba2\u6237\u548c\u5ba2\u6237\u5206\u7c7b\u4e0d\u80fd\u540c\u65f6\u7ef4\u62a4\u503c\u3002", (String)"SalePriceBatchAdjustPlugin_1", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            case "material": {
                if (materialGroup == null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7269\u6599\u548c\u7269\u6599\u5206\u7c7b\u4e0d\u80fd\u540c\u65f6\u7ef4\u62a4\u503c\u3002", (String)"SalePriceBatchAdjustPlugin_2", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            case "materialgroup": {
                if (material == null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7269\u6599\u548c\u7269\u6599\u5206\u7c7b\u4e0d\u80fd\u540c\u65f6\u7ef4\u62a4\u503c\u3002", (String)"SalePriceBatchAdjustPlugin_2", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String keyName = e.getOperateKey();
        IDataModel model = this.getModel();
        DynamicObject bill = model.getDataEntity();
        if ("execute".equals(keyName) && e.getOperationResult().isSuccess()) {
            QFilter filter = PriceAdjustHelper.getQFilter((DynamicObject)bill, (String[])QFILTER_FIELDS);
            DynamicObjectCollection DynamicObjectCol = QueryServiceHelper.query((String)"sm_salepricelist", (String)"id,priceentryentity.id", (QFilter[])new QFilter[]{filter});
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("execute", (IFormPlugin)this);
            if (DynamicObjectCol.size() == 0) {
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u9700\u8981\u6279\u91cf\u8c03\u6574\u7684\u6570\u636e\u3002", (String)"SalePriceBatchAdjustPlugin_8", (String)"scmc-sm-formplugin", (Object[])new Object[0]), new Object[0]), MessageBoxOptions.OK);
                return;
            }
            if (DynamicObjectCol.size() > 500000) {
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u67e5\u627e\u5230\u7684\u6570\u636e\u91cf\u592a\u5927\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u8fc7\u6ee4\u6761\u4ef6\uff0c\u7f29\u5c0f\u8303\u56f4\u540e\u518d\u8fdb\u884c\u67e5\u627e\u3002", (String)"SalePriceBatchAdjustPlugin_11", (String)"scmc-sm-formplugin", (Object[])new Object[0]), new Object[0]), MessageBoxOptions.OK);
            } else {
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5df2\u627e\u5230%d\u884c\u6570\u636e\uff0c\u70b9\u51fb\u201c\u786e\u5b9a\u201d\u5c06\u6279\u91cf\u751f\u6210\u57fa\u4ef7\u8c03\u6574\u5355\u3002", (String)"SalePriceBatchAdjustPlugin_7", (String)"scmc-sm-formplugin", (Object[])new Object[0]), DynamicObjectCol.size()), MessageBoxOptions.OKCancel, confirmCallBackListener);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("STOP".equals(this.getPageCache().get("STOP"))) {
            return;
        }
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        IFormView view = this.getView();
        if ("org".equals(propName)) {
            if (newValue != null) {
                DynamicObject oldOrg = (DynamicObject)oldValue;
                if (oldOrg == null) {
                    DynamicObject org = (DynamicObject)newValue;
                    DynamicObject currency = CurrencyHelper.getCurrency((Long)((Long)org.getPkValue()));
                    if (currency != null) {
                        this.getModel().setValue("currency", currency.getPkValue());
                    }
                    return;
                }
                this.getPageCache().put("org", String.valueOf(oldOrg.getPkValue()));
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("org", (IFormPlugin)this);
                view.showConfirm(ResManager.loadKDString((String)"\u7ec4\u7ec7\u53d8\u5316\uff0c\u5c06\u6e05\u7a7a\u8fc7\u6ee4\u6761\u4ef6\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"SalePriceBatchAdjustPlugin_3", (String)"scmc-sm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
            } else {
                this.getModel().setValue("customer", null);
                this.getModel().setValue("customergroup", null);
                this.getModel().setValue("material", null);
                this.getModel().setValue("materialgroup", null);
                this.getModel().setValue("currency", null);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String key;
        super.confirmCallBack(evt);
        switch (key = evt.getCallBackId()) {
            case "org": {
                this.getPageCache().put("STOP", "STOP");
                if (evt.getResult() == MessageBoxResult.Yes) {
                    this.getModel().setValue("customer", null);
                    this.getModel().setValue("customergroup", null);
                    this.getModel().setValue("material", null);
                    this.getModel().setValue("materialgroup", null);
                    DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                    DynamicObject currency = CurrencyHelper.getCurrency((Long)((Long)org.getPkValue()));
                    if (currency != null) {
                        this.getModel().setValue("currency", currency.getPkValue());
                    }
                } else {
                    String org = this.getPageCache().get("org");
                    this.getModel().setValue("org", (Object)org);
                }
                this.getPageCache().put("STOP", null);
                break;
            }
            case "execute": {
                if (evt.getResult() != MessageBoxResult.Yes) break;
                this.batchGenAdjustBill();
            }
        }
    }

    private void batchGenAdjustBill() {
        DynamicObject material;
        DynamicObject bill = this.getModel().getDataEntity(true);
        QFilter filter = PriceAdjustHelper.getQFilter((DynamicObject)bill, (String[])QFILTER_FIELDS);
        DynamicObject[] priceBills = BusinessDataServiceHelper.load((String)"sm_salepricelist", (String)this.getSelectProperties(), (QFilter[])new QFilter[]{filter});
        if (priceBills.length == 0) {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u51710\u6761\u6570\u636e\uff0c\u6210\u529f0\u6761\uff0c\u5931\u8d250\u6761\u3002", (String)"SalePriceBatchAdjustPlugin_9", (String)"scmc-sm-formplugin", (Object[])new Object[0]), new Object[0]), MessageBoxOptions.OK);
        }
        HashMap<String, Object> cusMap = new HashMap<String, Object>(8);
        cusMap.put("entityid", "sm_salepriceadjust");
        cusMap.put("changemode", AdjustModelEnum.BATCH.getValue());
        cusMap.put("bills", priceBills);
        cusMap.put("headfield", SalesPriceAdjustConst.HEAD_FIELD);
        cusMap.put("cusfield", SalesPriceAdjustEntryConst.CUSTOME_ENTRY_FIELD);
        cusMap.put("pricefield", SalesPriceAdjustEntryConst.PRICE_ENTRY_FIELD);
        DynamicObject dynamicObject = material = bill.getDynamicObject("material") == null ? bill.getDynamicObject("materialgroup") : bill.getDynamicObject("material");
        if (material != null) {
            cusMap.put("material", material.getPkValue());
        }
        PriceAdjustHelper.batchGenAdjustBill(cusMap, (DynamicObject)bill, (IFormView)this.getView());
        if (cusMap.get("adjustresult") != null) {
            String opName = RowOPHelper.getOpName((String)"sm_basebatchadjustment", (String)"execute");
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (Boolean.TRUE.equals(cusMap.get("adjustresult"))) {
                String successMsg = ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f", (String)"SalePriceBatchAdjustPlugin_10", (String)"scmc-sm-formplugin", (Object[])new Object[0]);
                AppLogInfo logInfo = OperateLogHelper.buildAppLogInfo((Long)Long.valueOf(RequestContext.get().getUserId()), (String)"pms", (String)"sm_basebatchadjustment", (Long)(org != null ? Long.valueOf(org.getLong("id")) : null), (Date)TimeServiceHelper.now(), (String)opName, (String)successMsg);
                OperateLogHelper.saveAppLog(Collections.singletonList(logInfo));
            } else {
                String failMsg = ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25", (String)"SalePriceBatchAdjustPlugin_12", (String)"scmc-sm-formplugin", (Object[])new Object[0]);
                AppLogInfo logInfo = OperateLogHelper.buildAppLogInfo((Long)Long.valueOf(RequestContext.get().getUserId()), (String)"pms", (String)"sm_basebatchadjustment", (Long)(org != null ? Long.valueOf(org.getLong("id")) : null), (Date)TimeServiceHelper.now(), (String)opName, (String)failMsg);
                OperateLogHelper.saveAppLog(Collections.singletonList(logInfo));
            }
        }
    }

    private String getSelectProperties() {
        String head = StringUtils.join((Object[])SalesPriceAdjustConst.HEAD_FIELD, (String)",");
        String cusEntry = StringUtils.join((Object[])SalesPriceAdjustEntryConst.CUSTOME_ENTRY_FILTER_FIELD, (String)",");
        String priceEntry = StringUtils.join((Object[])SalesPriceAdjustEntryConst.PRICE_ENTRY_FILTER_FIELD, (String)",");
        return StringUtils.joinWith((String)",", (Object[])new Object[]{head, cusEntry, priceEntry});
    }

    private Long getHasPermissionOrg(String entityName, String orgViewType) {
        List hasPermissionOrgs = OrgViewServiceHelper.getAllPermissionOrgs((String)entityName, (String)orgViewType);
        if (CommonUtils.isNull((Object)hasPermissionOrgs)) {
            return null;
        }
        long orgId = RequestContext.get().getOrgId();
        for (Map tempOrg : hasPermissionOrgs) {
            Long id = Long.valueOf((String)tempOrg.get("id"));
            if (!id.equals(orgId)) continue;
            return id;
        }
        return Long.valueOf((String)((Map)hasPermissionOrgs.get(0)).get("id"));
    }
}

