/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pms.formplugin.price;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.common.enums.BillCreTypeEnum;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pms.business.helper.BillImportHelper;
import kd.scmc.pms.business.helper.OrgHelper;
import kd.scmc.pms.business.helper.SalePriceListHelper;

public class SalePriceListImportPlugin
extends AbstractFormPlugin {
    private Map<String, Object> tempCache = new HashMap<String, Object>(8);
    private static final String HAS_PERMISSION_ORG = "hasPermissionOrg";
    private static final String IMPORT_PROP = "importprop";
    private static final String UNDERLINE = "_";
    private static final String ID = "id";
    private static final String BOS_ORG = "bos_org";

    public void initImportData(InitImportDataEventArgs e) {
        List sourceDataList = e.getSourceDataList();
        if (sourceDataList.isEmpty()) {
            return;
        }
        IPageCache pageCache = this.getPageCache();
        BillImportHelper.billCreTypeFlag((IPageCache)pageCache, (List)sourceDataList);
        IDataModel model = (IDataModel)e.getSource();
        List hasPermissionOrg = (List)this.tempCache.get(HAS_PERMISSION_ORG);
        if (hasPermissionOrg == null) {
            hasPermissionOrg = OrgHelper.getHasPermissionOrg((String)model.getDataEntityType().getName(), (String)"03");
            this.tempCache.put(HAS_PERMISSION_ORG, hasPermissionOrg);
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Object tempOrg;
        Map propMap;
        String billcretype = this.getPageCache().get("billcretype");
        if (!BillImportHelper.isImport((String)billcretype) && !BillImportHelper.isApi((String)billcretype)) {
            return;
        }
        Map data = e.getSourceData();
        if (data == null) {
            return;
        }
        DynamicObject org = this.getBaseDataFromCache(data, "org", BOS_ORG, null, null);
        if (org == null) {
            return;
        }
        List hasPermissionOrg = (List)this.tempCache.get(HAS_PERMISSION_ORG);
        if (!(hasPermissionOrg != null && hasPermissionOrg.contains(org.getPkValue()) || (propMap = BillImportHelper.format4ImportAndApi(tempOrg = data.get("org"))) == null)) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u9500\u552e\u7ec4\u7ec7\u201c%1$s\u201d\u4e0d\u5728\u7528\u6237\u6743\u9650\u8303\u56f4\u5185\u3002", (String)"SalePriceListImportPlugin_0", (String)"scmc-sm-formplugin", (Object[])new Object[0]), propMap.get(propMap.get(IMPORT_PROP))));
            e.setFireAfterImportData(false);
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        IDataModel model = this.getModel();
        String cachedBillCreType = this.getPageCache().get("billcretype");
        if (BillImportHelper.isApi((String)cachedBillCreType) || BillImportHelper.isImport((String)cachedBillCreType)) {
            DynamicObject bill = model.getDataEntity(true);
            String billCreType = bill.getString("billcretype");
            if (CommonUtils.isNull((Object)billCreType)) {
                bill.set("billcretype", (Object)BillCreTypeEnum.IMPORTNEW.getValue());
            }
            SalePriceListHelper.completeBillInfo((DynamicObject)bill);
        }
    }

    private DynamicObject getBaseDataFromCache(Map<String, Object> sourceData, String propName, String propEntityName, String select, QFilter[] qFilters) {
        if (sourceData == null) {
            return null;
        }
        Map propMap = BillImportHelper.format4ImportAndApi((Object)sourceData.get(propName));
        if (propMap != null) {
            String importProp = (String)propMap.get(IMPORT_PROP);
            DynamicObject value = (DynamicObject)this.tempCache.get(propName + UNDERLINE + propMap.get(importProp));
            if (value == null && !ID.equals(importProp)) {
                if (select == null) {
                    select = ID;
                }
                if (qFilters == null) {
                    qFilters = new QFilter[]{new QFilter(importProp, "=", (Object)((String)propMap.get(importProp)))};
                }
                value = BusinessDataServiceHelper.loadSingleFromCache((String)propEntityName, (String)select, (QFilter[])qFilters);
            }
            return value;
        }
        return null;
    }
}

