/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pms.formplugin.price;

import java.math.BigDecimal;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.sbd.enums.EnableStatusEnum;
import kd.bd.sbd.enums.StatusEnum;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.pms.business.helper.CurrencyHelper;
import kd.scmc.pms.business.helper.PriceTplHelper;
import kd.scmc.pms.business.helper.SalesStairPriceHelper;
import kd.scmc.sm.business.helper.BillImportHelper;

public class SalePriceListPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
EntryGridBindDataListener,
RowClickEventListener,
HyperLinkClickListener {
    public static final String TAXRATE_FILTER = "taxrate_filter";
    public static final String ENABLE_LOT = "enable_lot";
    public static final String ENABLE_LOT_MANAGE = "enable_lot_manage";
    private static final String SWITCHAPPLYMATERIA = "switchApplyMaterial";
    private static final String SWITCHAPPLYCUSTOMER = "switchApplyCustomer";
    private static final String ISSTAIRPRICE = "isstairprice";
    private static final String OPPARAM_AFTERCONFIRM = "afterconfirm";

    public void registerListener(EventObject e) {
        BasedataEdit customerEdit;
        BasedataEdit taxrateid;
        BasedataEdit unit;
        super.registerListener(e);
        BasedataEdit materialEdit = (BasedataEdit)this.getView().getControl("material");
        if (materialEdit != null) {
            materialEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((unit = (BasedataEdit)this.getView().getControl("unit")) != null) {
            unit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((taxrateid = (BasedataEdit)this.getView().getControl("taxrateid")) != null) {
            taxrateid.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((customerEdit = (BasedataEdit)this.getView().getControl("customer")) != null) {
            customerEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addItemClickListeners(new String[]{ISSTAIRPRICE});
        Toolbar check = (Toolbar)this.getView().getControl("stairtoolbarap");
        check.addItemClickListener((ItemClickListener)this);
        EntryGrid priceEntryEntity = (EntryGrid)this.getView().getControl("priceentryentity");
        if (priceEntryEntity != null) {
            priceEntryEntity.addRowClickListener((RowClickEventListener)this);
        }
        Toolbar entry = (Toolbar)this.getView().getControl("tb_entry");
        entry.addItemClickListener((ItemClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("priceentryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        if ("adjustbillno".equals(e.getFieldName())) {
            int row = this.getModel().getEntryCurrentRowIndex("priceentryentity");
            Object adjustbillid = this.getModel().getValue("adjustbillid", row);
            BillShowParameter fsp = new BillShowParameter();
            fsp.setFormId("sm_salepriceadjust");
            fsp.setPkId(adjustbillid);
            fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            fsp.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)fsp);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        IDataModel bill = this.getModel();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("priceentryentity");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalePriceListPlugin_0", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        switch (key) {
            case "unit": {
                DynamicObject material = (DynamicObject)bill.getValue("material", rowIndex);
                if (material == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u7f16\u7801\u3002", (String)"SalePriceListPlugin_1", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                DynamicObject masterMaterial = material.getDynamicObject("masterid");
                DynamicObject baseUnit = (DynamicObject)bill.getValue("baseunit", rowIndex);
                Long srcmuId = baseUnit == null ? Long.valueOf(0L) : (Long)baseUnit.getPkValue();
                Long masterMaterialId = (Long)masterMaterial.getPkValue();
                List unitIds = BaseDataServiceHelper.getAssistMUListResult((Long)masterMaterialId, (Long)srcmuId, (String)"1");
                QFilter qFilter = new QFilter("id", "in", (Object)unitIds);
                showParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
            case "taxrateid": {
                String taxrate_filter = this.getPageCache().get(TAXRATE_FILTER);
                taxrate_filter = taxrate_filter.substring(1, taxrate_filter.length() - 1);
                if (StringUtils.isNotEmpty((String)taxrate_filter)) {
                    String[] taxrateIds = taxrate_filter.split("_");
                    ArrayList<Long> taxrateIdList = new ArrayList<Long>(taxrateIds.length);
                    for (String id : taxrateIds) {
                        if (id == null || "".equals(id)) continue;
                        taxrateIdList.add(Long.valueOf(id));
                    }
                    QFilter filter = new QFilter("id", "in", taxrateIdList);
                    showParameter.getListFilterParameter().setFilter(filter);
                    break;
                }
                QFilter filter = QFilter.of((String)"1=-1", (Object[])new Object[0]);
                showParameter.getListFilterParameter().setFilter(filter);
                break;
            }
            case "material": {
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "changematerial");
                showParameter.setCloseCallBack(closeCallBack);
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject currency;
        String billcretype = this.getPageCache().get("billcretype");
        if (!BillImportHelper.isManual((String)billcretype)) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        if (this.getModel().getValue("currency") == null && (currency = CurrencyHelper.getCurrency((Long)((Long)org.getPkValue()))) != null) {
            this.getModel().setValue("currency", currency.getPkValue());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        FormOperate operate;
        String key;
        super.beforeDoOperation(e);
        if (e.getSource() instanceof FormOperate && "adjust".equals(key = (operate = (FormOperate)e.getSource()).getOperateKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("priceentryentity");
            int[] rows = entryGrid.getSelectRows();
            if (rows.length > 0) {
                StringBuilder rowStr = new StringBuilder(String.valueOf(rows[0]));
                for (int i = 1; i < rows.length; ++i) {
                    rowStr.append(',').append(String.valueOf(rows[i]));
                }
                operate.getOption().setVariableValue("selectRows", rowStr.toString());
            } else {
                String number = (String)this.getModel().getValue("number");
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u9700\u8981\u8c03\u4ef7\u7684\u4ef7\u683c\u660e\u7ec6\u3002", (String)"SalesPricePlugin_5", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String pkId;
        FormOperate operate;
        String key;
        super.afterDoOperation(e);
        if (e.getSource() instanceof FormOperate && "adjust".equals(key = (operate = (FormOperate)e.getSource()).getOperateKey()) && operate.getOption().getVariables().containsKey("adjustBillId") && !StringUtils.isBlank((String)(pkId = operate.getOption().getVariableValue("adjustBillId")))) {
            BillShowParameter fsp = new BillShowParameter();
            fsp.setFormId("sm_salepriceadjust");
            fsp.setPkId((Object)pkId);
            fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)fsp);
        }
    }

    public void beforeBindData(EventObject e) {
        EntryGrid entryGrid;
        super.beforeBindData(e);
        DateEdit fieldEdit = (DateEdit)this.getView().getControl("expirydate");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date d = sdf.parse("2099-12-31", new ParsePosition(0));
        if (fieldEdit != null) {
            fieldEdit.setMaxDate(d);
        }
        if ((entryGrid = (EntryGrid)this.getView().getControl("priceentryentity")) != null) {
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
        this.updataStairToolBarap(Boolean.FALSE);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object applyMaterial = this.getModel().getValue("applymaterial");
        Object applyCustomer = this.getModel().getValue("applycustomer");
        this.setMaterialVisible(applyMaterial.toString());
        this.setCustomerVisible(applyCustomer.toString());
        Boolean istax = (Boolean)this.getModel().getValue("istax");
        this.setPriceMustInput(istax);
        this.queryTaxrate();
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        if (row < 0) {
            this.updataStairToolBarap(Boolean.FALSE);
            return;
        }
        IDataModel model = this.getModel();
        DynamicObjectCollection priceentryentitys = model.getEntryEntity("priceentryentity");
        DynamicObject priceentryentity = (DynamicObject)priceentryentitys.get(row);
        this.updataStairToolBarap((Boolean)priceentryentity.get(ISSTAIRPRICE));
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        this.setLotEnable(e.getRows());
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        String keyName = e.getEntryProp().getName();
        IDataModel model = this.getModel();
        switch (keyName) {
            case "salstairprice": {
                for (RowDataEntity rowDataEntity : rowDataEntities) {
                    DynamicObject unit = ((DynamicObject)model.getEntryEntity("salstairprice").getParent()).getDynamicObject("unit");
                    int rowIndex = rowDataEntity.getRowIndex();
                    if (unit != null) {
                        model.setValue("unitid", (Object)unit, rowIndex);
                    }
                    if (rowIndex == 0) {
                        model.setValue("stairqtystart", (Object)BigDecimal.ZERO, 0);
                    }
                    if (rowIndex == 0) continue;
                    model.setValue("stairqtystart", model.getValue("stairqtyend", rowIndex - 1), rowIndex);
                }
                model.updateCache();
                break;
            }
            case "priceentryentity": {
                DynamicObjectCollection priceEntryEntities = model.getEntryEntity("priceentryentity");
                int row = this.getModel().getEntryCurrentRowIndex("priceentryentity");
                DynamicObject priceEntryEntity = (DynamicObject)priceEntryEntities.get(row);
                if (priceEntryEntity.getBoolean(ISSTAIRPRICE)) {
                    this.updataStairToolBarap(Boolean.TRUE);
                    break;
                }
                this.updataStairToolBarap(Boolean.FALSE);
                this.getModel().deleteEntryData("salstairprice");
                this.setLotEnable(Arrays.asList(rowDataEntities));
                break;
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String keyName = e.getEntryProp().getName();
        IDataModel model = this.getModel();
        switch (keyName) {
            case "priceentryentity": {
                DynamicObjectCollection priceentryentitys = model.getEntryEntity("priceentryentity");
                if (priceentryentitys.size() != 0) {
                    int row = this.getModel().getEntryCurrentRowIndex("priceentryentity");
                    DynamicObject priceentryentity = (DynamicObject)priceentryentitys.get(row);
                    this.updataStairToolBarap((Boolean)priceentryentity.get(ISSTAIRPRICE));
                    break;
                }
                this.updataStairToolBarap(Boolean.FALSE);
                break;
            }
        }
    }

    private void updataStairToolBarap(Boolean flag) {
        this.getView().setEnable(flag, new String[]{"staircheck", "stairaddrow", "stairinsertrow", "stairdeletrow"});
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        String itemKey = e.getItemKey();
        IDataModel model = this.getModel();
        DynamicObjectCollection purStairPrices = (DynamicObjectCollection)model.getValue("salstairprice");
        switch (itemKey) {
            case "staircheck": {
                if (purStairPrices.size() > 1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9636\u68af\u4ef7\u683c\u5206\u5f55\u81f3\u5c11\u97002\u884c\u6570\u636e\u3002", (String)"SalePriceListPlugin_2", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
    }

    public void itemClick(ItemClickEvent e) {
        super.itemClick(e);
        String itemKey = e.getItemKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        switch (itemKey) {
            case "isstairprice": {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(ISSTAIRPRICE, (IFormPlugin)this);
                view.showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u4f1a\u6e05\u7a7a\u9636\u68af\u4ef7\u683c\u6570\u636e\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"SalePriceListPlugin_3", (String)"scmc-sm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNoCancel, confirmCallBackListener);
                break;
            }
            case "staircheck": {
                DynamicObject priceEntryEntity = (DynamicObject)((DynamicObjectCollection)model.getValue("salstairprice")).getParent();
                BigDecimal minPrice = priceEntryEntity.getBigDecimal("pricefloor");
                BigDecimal maxPrice = priceEntryEntity.getBigDecimal("priceceiling");
                DynamicObjectCollection salesStairPrices = (DynamicObjectCollection)model.getValue("salstairprice");
                int checkStairPrice = SalesStairPriceHelper.getCheckStairPrice((BigDecimal)minPrice, (BigDecimal)maxPrice, (DynamicObjectCollection)salesStairPrices);
                view.updateView("salstairprice");
                if (checkStairPrice != 0) {
                    String msg = SalesStairPriceHelper.getDetailMsg((int)checkStairPrice);
                    view.showErrorNotification(msg);
                    break;
                }
                view.showSuccessNotification(ResManager.loadKDString((String)"\u672a\u53d1\u73b0\u9519\u8bef\u3002", (String)"SalePriceListPlugin_5", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "bar_addrow": {
                this.updataStairToolBarap(Boolean.FALSE);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String billcretype = this.getPageCache().get("billcretype");
        if (!BillImportHelper.isManual((String)billcretype)) {
            return;
        }
        if ("STOP".equals(this.getPageCache().get("STOP"))) {
            return;
        }
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int row = e.getChangeSet()[0].getRowIndex();
        IDataModel model = this.getModel();
        DynamicObjectCollection salStairPrices = (DynamicObjectCollection)model.getValue("salstairprice");
        DynamicObject dataEntity = e.getChangeSet()[0].getDataEntity();
        switch (propName) {
            case "applymaterial": {
                this.getPageCache().put("applyMaterialOldValue", oldValue.toString());
                this.applyMaterialChange(newValue);
                break;
            }
            case "applycustomer": {
                this.getPageCache().put("applyCustomerOldValue", oldValue.toString());
                this.applyCustomerChange((String)oldValue, (String)newValue);
                break;
            }
            case "istax": {
                this.applyIsTaxChanged((Boolean)newValue);
                break;
            }
            case "material": {
                this.applyMaterialNoChange((DynamicObject)newValue, row, salStairPrices);
                if (this.getPageCache().get(ENABLE_LOT_MANAGE) == null) {
                    RowDataEntity rowDataEntity = new RowDataEntity(row, this.getModel().getEntryRowEntity("priceentryentity", row));
                    this.setLotEnable(Collections.singletonList(rowDataEntity));
                }
                if (newValue != null) break;
                DynamicObjectCollection stairPriceEntities = model.getEntryEntity("salstairprice");
                for (DynamicObject stairPriceEntity : stairPriceEntities) {
                    stairPriceEntity.set("unitid", null);
                }
                this.getView().updateView("salstairprice");
                break;
            }
            case "materialgroup": {
                this.applyMaterialGroupNoChange((DynamicObject)newValue, row);
                break;
            }
            case "taxrateid": {
                for (ChangeData data : valueSet) {
                    int rowIndex = data.getRowIndex();
                    this.changeTaxRateID(newValue, rowIndex);
                    this.calculatePrice(rowIndex);
                }
                break;
            }
            case "price": 
            case "priceandtax": {
                for (ChangeData changeData : valueSet) {
                    int rowIndex = changeData.getRowIndex();
                    this.calculatePrice(rowIndex);
                }
                break;
            }
            case "unit": {
                DynamicObject unit = dataEntity.getDynamicObject("unit");
                if (salStairPrices.size() == 0) break;
                if (unit == null) {
                    for (int i = 0; i < salStairPrices.size(); ++i) {
                        model.setValue("unitid", null, i);
                    }
                } else {
                    for (int i = 0; i < salStairPrices.size(); ++i) {
                        model.setValue("unitid", (Object)unit, i);
                    }
                }
                break;
            }
            case "pricelisttype": {
                DynamicObject priceListType = dataEntity.getDynamicObject("pricelisttype");
                if (priceListType == null) {
                    return;
                }
                if (priceListType.getBoolean("isstair")) {
                    model.setValue("isstair", (Object)Boolean.TRUE);
                    break;
                }
                if (((Boolean)model.getValue("isstair")).booleanValue()) break;
                model.setValue("isstair", (Object)Boolean.FALSE);
                break;
            }
            case "isstair": {
                this.isStairChange((Boolean)newValue);
                break;
            }
            case "isstairprice": {
                this.isStairPriceChange((Boolean)newValue, salStairPrices, propName);
                break;
            }
        }
    }

    private void isStairChange(Boolean newValue) {
        if (newValue != null && newValue.booleanValue()) {
            this.updataStairToolBarap(Boolean.FALSE);
        }
        if (newValue != null && !newValue.booleanValue()) {
            DynamicObjectCollection priceEntryEntities = this.getModel().getEntryEntity("priceentryentity");
            boolean isError = false;
            for (DynamicObject priceEntryEntity : priceEntryEntities) {
                Boolean isStairPrice = (Boolean)priceEntryEntity.get(ISSTAIRPRICE);
                if (!isStairPrice.booleanValue()) continue;
                isError = true;
                break;
            }
            if (isError) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u6709\u884c\u5747\u4e0d\u7ef4\u62a4\u9636\u68af\u4ef7\u683c\u65f6\uff0c\u5141\u8bb8\u4fee\u6539\u4e3a\u5426\u3002", (String)"SalePriceListPlugin_6", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("isstair", (Object)Boolean.TRUE);
                this.updataStairToolBarap(Boolean.TRUE);
            } else {
                this.updataStairToolBarap(Boolean.FALSE);
            }
        }
    }

    private void isStairPriceChange(Boolean newValue, DynamicObjectCollection salStairPrices, String propName) {
        if (newValue != null && newValue.booleanValue()) {
            this.updataStairToolBarap(Boolean.TRUE);
            if (salStairPrices.size() == 0) {
                this.getModel().insertEntryRow("salstairprice", 1);
                this.getView().updateView("salstairprice");
            }
        } else {
            this.updataStairToolBarap(Boolean.FALSE);
            if (salStairPrices.size() != 0) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(propName, (IFormPlugin)this);
                String confirmTip = ResManager.loadKDString((String)"\u5207\u6362\u4f1a\u6e05\u7a7a\u9636\u68af\u4ef7\u683c\u6570\u636e\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"SalePriceListPlugin_3", (String)"scmc-sm-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            }
        }
    }

    private void changeTaxRateID(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        if (newValue instanceof DynamicObject) {
            DynamicObject taxRateID = (DynamicObject)newValue;
            model.setValue("taxrate", taxRateID.get("taxrate"), rowIndex);
        } else {
            model.setValue("taxrate", (Object)0, rowIndex);
        }
    }

    private void applyMaterialGroupNoChange(DynamicObject material, int row) {
        this.getPageCache().put("STOP", "STOP");
        this.getModel().setValue("taxrate", null, row);
        this.getModel().setValue("price", null, row);
        this.getModel().setValue("unitpriceqty", null, row);
        this.getModel().setValue("pricefloor", null, row);
        this.getModel().setValue("priceceiling", null, row);
        this.getModel().setValue("taxrateid", null, row);
        this.getModel().setValue("priceandtax", null, row);
        this.getPageCache().put("STOP", null);
    }

    private void applyMaterialNoChange(DynamicObject material, int row, DynamicObjectCollection salStairPrices) {
        this.getPageCache().put("STOP", "STOP");
        this.getModel().setValue("taxrate", null, row);
        this.getModel().setValue("auxpty", null, row);
        this.getModel().setValue("price", null, row);
        this.getModel().setValue("unitpriceqty", null, row);
        this.getModel().setValue("baseunit", null, row);
        this.getModel().setValue("pricefloor", null, row);
        this.getModel().setValue("priceceiling", null, row);
        this.getModel().setValue("lotnumber", null, row);
        this.getModel().setValue("taxrateid", null, row);
        this.getModel().setValue("priceandtax", null, row);
        this.getModel().setValue("unit", null, row);
        if (material != null) {
            DynamicObject masterMaterial = material.getDynamicObject("masterid");
            if (masterMaterial.getDynamicObject("baseunit") != null) {
                this.getModel().setValue("baseunit", masterMaterial.getDynamicObject("baseunit").getPkValue(), row);
            }
            if (material.getDynamicObject("salesunit") != null) {
                this.getModel().setValue("unit", material.getDynamicObject("salesunit").getPkValue(), row);
                if (salStairPrices.size() != 0) {
                    for (int i = 0; i < salStairPrices.size(); ++i) {
                        this.getModel().setValue("unitid", material.getDynamicObject("salesunit").getPkValue(), i);
                    }
                }
            }
            this.getModel().setValue("unitpriceqty", (Object)1, row);
            String taxrate_filter = this.getPageCache().get(TAXRATE_FILTER);
            taxrate_filter = taxrate_filter.substring(1, taxrate_filter.length() - 1);
            String[] taxrateIds = taxrate_filter.split("_");
            if (taxrateIds.length > 0) {
                DynamicObject taxRate = (DynamicObject)material.get("masterid.taxrate");
                Long taxRateId = Long.valueOf("0");
                if (taxRate != null) {
                    taxRateId = taxRate.getLong("masterid");
                }
                if (Arrays.asList(taxrateIds).contains(taxRateId.toString())) {
                    DynamicObject taxrate = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_taxrate", (String)"taxrate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taxRateId)});
                    this.getModel().setValue("taxrate", (Object)taxrate.getBigDecimal("taxrate"), row);
                    this.getModel().setValue("taxrateid", (Object)taxRateId, row);
                } else {
                    String applycustomer = (String)this.getModel().getValue("applycustomer");
                    if ("B".equals(applycustomer)) {
                        DynamicObjectCollection customers = this.getModel().getEntryEntity("customerentryentity");
                        HashSet<Long> isSet = new HashSet<Long>();
                        for (DynamicObject customer : customers) {
                            Long id;
                            DynamicObject c = (DynamicObject)customer.get("customer");
                            if (c == null || (id = (Long)c.get("taxrate.id")) == null || Long.valueOf("0").equals(id) || !Arrays.asList(taxrateIds).contains(id.toString())) continue;
                            isSet.add(id);
                        }
                        if (isSet.size() == 1) {
                            taxRateId = (Long)isSet.iterator().next();
                            this.getModel().setValue("taxrateid", (Object)taxRateId, row);
                            DynamicObject customerTaxrate = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_taxrate", (String)"taxrate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taxRateId)});
                            this.getModel().setValue("taxrate", customerTaxrate.get("taxrate"), row);
                        }
                    }
                }
            }
        }
        this.getPageCache().put("STOP", null);
    }

    private void applyIsTaxChanged(Boolean newValue) {
        this.setPriceMustInput(newValue);
    }

    private void setPriceMustInput(Boolean istax) {
        AmountEdit priceAndTaxControl = (AmountEdit)this.getView().getControl("priceandtax");
        AmountEdit priceControl = (AmountEdit)this.getView().getControl("price");
        if (istax.booleanValue()) {
            priceAndTaxControl.setMustInput(true);
            priceControl.setMustInput(false);
        } else {
            priceAndTaxControl.setMustInput(false);
            priceControl.setMustInput(true);
        }
    }

    private void applyMaterialChange(Object newValue) {
        DynamicObjectCollection priceEntry = this.getModel().getEntryEntity("priceentryentity");
        if (priceEntry != null && priceEntry.size() > 0) {
            ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener(SWITCHAPPLYMATERIA, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u9002\u7528\u7269\u6599\u65b9\u5f0f\u540e\uff0c\u4ef7\u683c\u660e\u7ec6\u6570\u636e\u5c06\u88ab\u6e05\u7a7a\uff0c\u662f\u5426\u7ee7\u7eed\u4fee\u6539\uff1f", (String)"SalePriceListPlugin_7", (String)"scmc-sm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBack);
        } else {
            this.setMaterialVisible((String)newValue);
            this.getModel().createNewEntryRow("priceentryentity");
        }
    }

    private void applyCustomerChange(String oldValue, String newValue) {
        DynamicObjectCollection customerEntry = this.getModel().getEntryEntity("customerentryentity");
        if (customerEntry != null && customerEntry.size() > 0) {
            ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener(SWITCHAPPLYCUSTOMER, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u9002\u7528\u5ba2\u6237\u65b9\u5f0f\u540e\uff0c\u5ba2\u6237\u660e\u7ec6\u6570\u636e\u5c06\u88ab\u6e05\u7a7a\uff0c\u662f\u5426\u7ee7\u7eed\u4fee\u6539\uff1f", (String)"SalePriceListPlugin_8", (String)"scmc-sm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBack);
        } else {
            this.setCustomerVisible(newValue);
            this.getModel().createNewEntryRow("customerentryentity");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String key;
        super.confirmCallBack(evt);
        switch (key = evt.getCallBackId()) {
            case "switchApplyMaterial": {
                String newValue = this.getModel().getValue("applymaterial").toString();
                if ("Yes".equals(evt.getResultValue())) {
                    this.setMaterialVisible(newValue);
                    this.getModel().deleteEntryData("priceentryentity");
                    this.getModel().deleteEntryData("salstairprice");
                    this.getModel().createNewEntryRow("priceentryentity");
                    break;
                }
                String value = this.getPageCache().get("applyMaterialOldValue");
                this.getModel().getDataEntity().set("applymaterial", (Object)value);
                this.getView().updateView("applymaterial");
                break;
            }
            case "switchApplyCustomer": {
                String cusNewValue = this.getModel().getValue("applycustomer").toString();
                if ("Yes".equals(evt.getResultValue())) {
                    this.setCustomerVisible(cusNewValue);
                    this.getModel().deleteEntryData("customerentryentity");
                    this.getModel().createNewEntryRow("customerentryentity");
                    break;
                }
                String value = this.getPageCache().get("applyCustomerOldValue");
                this.getModel().getDataEntity().set("applycustomer", (Object)value);
                this.getView().updateView("applycustomer");
                break;
            }
            case "isstairprice": {
                if (evt.getResult() == MessageBoxResult.Yes) {
                    OperateOption operateOption = OperateOption.create();
                    operateOption.setVariableValue(OPPARAM_AFTERCONFIRM, "true");
                    this.getModel().setValue(ISSTAIRPRICE, (Object)Boolean.FALSE);
                    this.getModel().deleteEntryData("salstairprice");
                    break;
                }
                this.getModel().setValue(ISSTAIRPRICE, (Object)Boolean.TRUE);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object result = closedCallBackEvent.getReturnData();
        if (result != null && "changematerial".equals(closedCallBackEvent.getActionId())) {
            int i;
            this.getPageCache().put(ENABLE_LOT_MANAGE, "1");
            ListSelectedRowCollection rowColl = (ListSelectedRowCollection)result;
            AbstractGrid entry = (AbstractGrid)this.getControl("priceentryentity");
            int foucsRow = entry.getEntryState().getFocusRow();
            ListSelectedRow selectRow = rowColl.get(0);
            this.getModel().setValue("material", selectRow.getPrimaryKeyValue(), foucsRow);
            if (rowColl.size() > 1) {
                Boolean entryCorssPage = (Boolean)SystemParamServiceHelper.getBillParameter((String)"sm_salepricelist", (String)"bosentryserverfiltersort");
                if (entryCorssPage.booleanValue()) {
                    this.getModel().appendEntryRow("priceentryentity", foucsRow, rowColl.size() - 1);
                } else {
                    EntryProp entryProp = (EntryProp)this.getModel().getProperty("priceentryentity");
                    DynamicObjectCollection addNews = new DynamicObjectCollection();
                    for (int i2 = 1; i2 < rowColl.size(); ++i2) {
                        DynamicObject newInsertObj = new DynamicObject(entryProp.getDynamicCollectionItemPropertyType());
                        addNews.add((Object)newInsertObj);
                    }
                    this.getModel().batchInsertEntryRow(entryProp, foucsRow + 1, addNews);
                }
                for (i = 1; i < rowColl.size(); ++i) {
                    selectRow = rowColl.get(i);
                    this.getModel().setValue("material", selectRow.getPrimaryKeyValue(), foucsRow + i);
                }
            }
            ArrayList<RowDataEntity> rows = new ArrayList<RowDataEntity>(rowColl.size());
            for (i = 0; i < rowColl.size(); ++i) {
                RowDataEntity rowDataEntity = new RowDataEntity(foucsRow + i, this.getModel().getEntryRowEntity("priceentryentity", foucsRow + i));
                rows.add(rowDataEntity);
            }
            this.setLotEnable(rows);
            this.getPageCache().remove(ENABLE_LOT_MANAGE);
        }
    }

    private void setMaterialVisible(String newValue) {
        BasedataEdit materialControl = (BasedataEdit)this.getView().getControl("material");
        BasedataEdit materialGroupControl = (BasedataEdit)this.getView().getControl("materialgroup");
        BasedataEdit unitControl = (BasedataEdit)this.getView().getControl("unit");
        if (newValue != null && "A".equals(newValue)) {
            materialControl.setMustInput(true);
            unitControl.setMustInput(true);
            materialGroupControl.setMustInput(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"materialgroup"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"materialgroupname"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"material"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"materialname"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"model"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"auxpty"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"lotnumber"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"unit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"qtyfrom"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"qtyto"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"unitpriceqty"});
        }
        if (newValue != null && "B".equals(newValue)) {
            materialGroupControl.setMustInput(true);
            unitControl.setMustInput(false);
            materialControl.setMustInput(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"material"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"materialname"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"model"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"auxpty"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"lotnumber"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"unit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"qtyfrom"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"qtyto"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"baseunit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"materialgroup"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"materialgroupname"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"unitpriceqty"});
        }
    }

    private void setCustomerVisible(String newValue) {
        if (newValue != null && "B".equals(newValue)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"cus_entry"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"customer"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"customername"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"customergroup"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"customergroupname"});
        }
        if (newValue != null && "C".equals(newValue)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"customer"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"customername"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"customergroup"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"customergroupname"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"cus_entry"});
        }
    }

    private void calculatePrice(int rowIndex) {
        int precision = 10;
        BigDecimal price = (BigDecimal)this.getModel().getValue("price", rowIndex);
        BigDecimal priceAndTax = (BigDecimal)this.getModel().getValue("priceandtax", rowIndex);
        BigDecimal taxRate = (BigDecimal)this.getModel().getValue("taxrate", rowIndex);
        if (taxRate == null) {
            return;
        }
        taxRate = taxRate.divide(new BigDecimal(100));
        Boolean istax = (Boolean)this.getModel().getValue("istax");
        if (istax.booleanValue()) {
            if (priceAndTax != null) {
                price = priceAndTax.divide(BigDecimal.ONE.add(taxRate), precision, 4);
                this.getModel().setValue("price", (Object)price, rowIndex);
            }
        } else if (price != null) {
            priceAndTax = price.multiply(BigDecimal.ONE.add(taxRate));
            this.getModel().setValue("priceandtax", (Object)priceAndTax, rowIndex);
        }
    }

    private void queryTaxrate() {
        Date bizTime = (Date)this.getModel().getValue("createtime");
        List taxratelist = PriceTplHelper.getTaxRateFilter((Date)bizTime);
        if (taxratelist.size() > 0) {
            this.getPageCache().put(TAXRATE_FILTER, SerializationUtils.toJsonString((Object)String.join((CharSequence)"_", taxratelist)));
        }
    }

    private void setLotEnable(List<RowDataEntity> currencyRows) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (currencyRows.size() == 0 || org == null) {
            return;
        }
        HashMap<String, Boolean> lotCache = new HashMap();
        String lotCacheStr = this.getPageCache().get(ENABLE_LOT);
        if (StringUtils.isNotEmpty((String)lotCacheStr)) {
            lotCache = (Map)SerializationUtils.fromJsonString((String)lotCacheStr, Map.class);
        }
        HashSet<Long> materialSets = new HashSet<Long>();
        for (RowDataEntity row : currencyRows) {
            DynamicObject entryInfo = row.getDataEntity();
            if (entryInfo.getDynamicObject("material") == null) continue;
            DynamicObject material = entryInfo.getDynamicObject("material").getDynamicObject("masterid");
            if (material != null) {
                Long materialID = (Long)material.getPkValue();
                if (lotCache.containsKey(this.getLotCacheKey(materialID, org.getPkValue()))) continue;
                materialSets.add(materialID);
                continue;
            }
            int seq = entryInfo.getInt("seq");
            String message = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7269\u6599\u4e3b\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u6570\u636e\u5b8c\u6574\u6027\u3002", (String)"SalePriceListPlugin_9", (String)"scmc-sm-formplugin", (Object[])new Object[0]), seq);
            this.getView().showTipNotification(message);
        }
        if (materialSets.size() > 0) {
            List invOrgs = OrgUnitServiceHelper.getAllToOrg((String)"03", (String)"05", (Long)((Long)org.getPkValue()));
            invOrgs.add((Long)org.getPkValue());
            this.getLotCache(materialSets, invOrgs, lotCache);
        }
        for (RowDataEntity row : currencyRows) {
            int rowIndex = row.getRowIndex();
            DynamicObject entryInfo = row.getDataEntity();
            if (entryInfo.getDynamicObject("material") != null) {
                DynamicObject material = entryInfo.getDynamicObject("material").getDynamicObject("masterid");
                if (material == null || org == null) continue;
                Boolean enablelot = (Boolean)lotCache.get(this.getLotCacheKey(material.getPkValue(), org.getPkValue()));
                if (enablelot != null && !enablelot.booleanValue()) {
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"lotnumber"});
                    continue;
                }
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"lotnumber"});
                continue;
            }
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"lotnumber"});
        }
        this.getPageCache().put(ENABLE_LOT, SerializationUtils.toJsonString(lotCache));
    }

    private String getLotCacheKey(Object materialID, Object salOrgID) {
        return String.valueOf(materialID) + "-" + new StringBuilder(String.valueOf(salOrgID));
    }

    private void getLotCache(Set<Long> materialSets, List<Long> invOrgs, Map<String, Boolean> lotCache) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        QFilter materialFilter = new QFilter("masterid.id", "in", materialSets);
        QFilter orgFilter = new QFilter("org.id", "in", invOrgs);
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        Map result = BusinessDataServiceHelper.loadFromCache((String)"bd_materialinventoryinfo", (String)"enablelot,masterid", (QFilter[])new QFilter[]{orgFilter, materialFilter, statusFilter, enableFilter});
        HashSet<Long> materialIDs = new HashSet<Long>();
        Set entrySet = result.entrySet();
        for (Map.Entry entry : entrySet) {
            DynamicObject materialInvInfo = (DynamicObject)entry.getValue();
            Boolean enableLot = materialInvInfo.getBoolean("enablelot");
            if (!enableLot.booleanValue()) continue;
            materialIDs.add((Long)materialInvInfo.getDynamicObject("masterid").getPkValue());
        }
        materialSets.forEach(m -> {
            String cacheKey = this.getLotCacheKey(m, org.getPkValue());
            lotCache.put(cacheKey, Boolean.FALSE);
        });
        materialIDs.forEach(m -> {
            String cacheKey = this.getLotCacheKey(m, org.getPkValue());
            lotCache.put(cacheKey, Boolean.TRUE);
        });
    }
}

