/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.agency;

import java.util.Objects;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class AgencyRecordListPlugin
extends AbstractListPlugin {
    public void billListHyperLinkClick(HyperLinkClickArgs e) {
        super.billListHyperLinkClick(e);
        String fieldName = e.getFieldName();
        if ("billno".equalsIgnoreCase(fieldName)) {
            e.setCancel(true);
            BillListHyperLinkClickEvent evt = (BillListHyperLinkClickEvent)e.getHyperLinkClickEvent();
            ListSelectedRow curRow = evt.getCurrentRow();
            this.showBill(curRow);
        }
    }

    private void showBill(ListSelectedRow row) {
        if (row == null) {
            return;
        }
        Object entryID = row.getEntryPrimaryKeyValue();
        if (entryID == null || Objects.equals(0L, entryID)) {
            return;
        }
        QFilter q = new QFilter("entry.id", "=", entryID);
        DynamicObject res = QueryServiceHelper.queryOne((String)"sm_wfrecord", (String)"entry.billtype, entry.billid", (QFilter[])new QFilter[]{q});
        if (res == null) {
            return;
        }
        BillShowParameter bs = new BillShowParameter();
        bs.setFormId(res.getString("entry.billtype"));
        bs.setPkId(res.get("entry.billid"));
        bs.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        bs.setBillStatus(BillOperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)bs);
    }
}

